/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.container;

import java.util.logging.Logger;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.PortableServer.ForwardRequest;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;
import org.omg.PortableServer.ServantActivator;

public class ComponentServantManager
extends LocalObject
implements ServantActivator {
    private Logger m_logger;
    private boolean DEBUG = false;
    private volatile boolean receivedEtherealizeCall;

    public ComponentServantManager(Logger logger) {
        this.m_logger = logger;
    }

    public Servant incarnate(byte[] oid, POA adapter) throws ForwardRequest {
        throw new OBJECT_NOT_EXIST();
    }

    public synchronized void etherealize(byte[] oid, POA adapter, Servant serv, boolean cleanup_in_progress, boolean remaining_activations) {
        if (this.DEBUG) {
            this.m_logger.info("ComponentServantManager#etherealize called for servant class = '" + serv.getClass().getName() + "'; rem.actions=" + remaining_activations);
        }
        if (!remaining_activations) {
            if (this.DEBUG) {
                this.logStackTrace("Callstack for ServantActivator#etherealize");
            }
            this.receivedEtherealizeCall = true;
            ((Object)((Object)this)).notifyAll();
        }
    }

    public synchronized void resetWaitForEtherealize() {
        this.receivedEtherealizeCall = false;
    }

    public synchronized boolean waitForEtherealize(int maxWaitMillis) {
        if (this.DEBUG) {
            this.m_logger.info("will wait for component etherealization...");
        }
        long startedWaitingTime = System.currentTimeMillis();
        long remainingWaitTime = maxWaitMillis;
        while (!this.receivedEtherealizeCall && remainingWaitTime > 0L) {
            try {
                ((Object)((Object)this)).wait(remainingWaitTime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            remainingWaitTime = (long)maxWaitMillis - (System.currentTimeMillis() - startedWaitingTime);
        }
        if (this.receivedEtherealizeCall && this.DEBUG) {
            this.m_logger.info("received component etherealization notification.");
        }
        return this.receivedEtherealizeCall;
    }

    private void logStackTrace(String msg) {
        if (this.DEBUG) {
            Exception fakeEx = new Exception("stacktrace fake ex");
            StackTraceElement[] trace = fakeEx.getStackTrace();
            msg = msg + "\n";
            for (int i = 1; i < trace.length; ++i) {
                msg = msg + "\tat " + trace[i] + '\n';
            }
            this.m_logger.info(msg);
        }
    }
}

