/*
 * Decompiled with CFR 0.152.
 */
package skyview.process.imagefinder;

import java.util.Arrays;
import skyview.executive.Settings;
import skyview.geometry.Transformer;
import skyview.process.ImageFinder;
import skyview.survey.Image;
import skyview.survey.ParsingTermination;

public class Checker
extends ImageFinder {
    protected double[] t2 = new double[2];
    protected double[] t3 = new double[3];
    private static boolean dataStatus = false;
    protected boolean[] imageUsed;
    protected Transformer fromOut;
    protected int pixelCount = 0;
    protected int rectCount = 0;
    protected Image output;
    protected Image[] input;
    protected boolean checkNaNs = false;
    protected boolean cornersOnly = false;
    public static final int UNCHECKED = -1;
    public static final int NO_COVERAGE = -2;
    public static final int NON_PHYSICAL = -3;
    public static final int CONSUMED = -4;
    public static final int SPLIT_X = -16;
    public static final int SPLIT_Y = -32;
    public static final int SPLIT_XY = -48;
    protected int[] img;

    public static boolean getStatus() {
        return dataStatus;
    }

    @Override
    public int[] findImages(Image[] input, Image output) {
        int np = output.getWidth() * output.getHeight();
        this.imageUsed = new boolean[input.length];
        this.input = input;
        try {
            int maxDelta;
            try {
                this.fromOut = output.getTransformer().inverse();
            }
            catch (Exception e) {
                throw new Error("In findImages: Unexpected transformation error:" + e);
            }
            this.output = output;
            this.checkNaNs = Settings.has("checknans");
            this.cornersOnly = Settings.has("cornersonly");
            if (this.checkNaNs) {
                for (int i = 0; i < input.length; ++i) {
                    input[i].validate();
                }
            }
            this.img = new int[np];
            Arrays.fill(this.img, -1);
            double sin = input[0].getWCS().getScale();
            double sout = output.getWCS().getScale();
            int nx = input[0].getWidth();
            int ny = input[0].getHeight();
            if (ny < nx) {
                nx = ny;
            }
            if ((maxDelta = (int)((double)nx * sin / (2.0 * sout))) < 1) {
                maxDelta = 1;
            }
            boolean[] valid = new boolean[input.length];
            Arrays.fill(valid, true);
            int mx = output.getWidth();
            int my = output.getHeight();
            for (int i = 0; i < mx; i += maxDelta) {
                for (int j = 0; j < my; j += maxDelta) {
                    int jp;
                    int ip = i + maxDelta - 1;
                    if (ip >= mx) {
                        ip = mx - 1;
                    }
                    if ((jp = j + maxDelta - 1) >= my) {
                        jp = my - 1;
                    }
                    this.checkRectangle(valid, i, ip, j, jp, mx);
                }
            }
            int count = 0;
            for (int i = 0; i < input.length; ++i) {
                if (!this.imageUsed[i]) continue;
                ++count;
            }
            dataStatus = false;
        }
        catch (ParsingTermination pt) {
            dataStatus = true;
        }
        return this.img;
    }

    @Override
    public void setStrict(boolean flag) {
    }

    private void checkRectangle(boolean[] valid, int x0, int x1, int y0, int y1, int mx) {
        ++this.rectCount;
        if (this.rectCount > 5000 && this.rectCount % 1000 == 0) {
            System.err.println("  FindImage-Pixels found:" + this.pixelCount + " of " + this.img.length + "   Rectangles:" + this.rectCount + "    " + 100 * this.pixelCount / this.img.length + "% complete");
        }
        int p00 = x0 + y0 * mx;
        int p01 = x1 + y0 * mx;
        int p10 = x0 + y1 * mx;
        int p11 = x1 + y1 * mx;
        boolean[] newValid = new boolean[valid.length];
        int dx = x1 - x0 + 1;
        int dy = y1 - y0 + 1;
        int match = this.cornerMatch(new int[]{p00, p01, p10, p11}, valid, newValid);
        if (dx < 2 && dy < 2) {
            return;
        }
        boolean recurse = false;
        if (match <= -16) {
            recurse = true;
            if (match == -16) {
                dx = (dx + 1) / 2;
            } else if (match == -32) {
                dy = (dy + 1) / 2;
            } else {
                dx = (dx + 1) / 2;
                dy = (dy + 1) / 2;
            }
        }
        if (!recurse && !this.cornersOnly) {
            if (this.edgeOff(match, p00, p01, 1, newValid) || this.edgeOff(match, p10, p11, 1, newValid)) {
                dx = (dx + 1) / 2;
                recurse = true;
            } else if (this.edgeOff(match, p00, p10, mx, newValid) || this.edgeOff(match, p01, p11, mx, newValid)) {
                dy = (dy + 1) / 2;
                recurse = true;
            }
        }
        if (recurse) {
            for (int px = x0; px <= x1; px += dx) {
                for (int py = y0; py <= y1; py += dy) {
                    int pye;
                    int pxe = px + dx - 1;
                    if (pxe > x1) {
                        pxe = x1;
                    }
                    if ((pye = py + dy - 1) > y1) {
                        pye = y1;
                    }
                    this.checkRectangle(newValid, px, pxe, py, pye, mx);
                }
            }
        } else {
            for (int j = y0; j <= y1; ++j) {
                for (int i = x0; i <= x1; ++i) {
                    int offset = i + j * mx;
                    if (this.img[offset] == -1) {
                        ++this.pixelCount;
                    }
                    this.img[i + j * mx] = match;
                }
            }
        }
    }

    protected boolean edgeOff(int match, int p0, int pe, int dp, boolean[] valid) {
        boolean val = false;
        for (int p = p0; p <= pe; p += dp) {
            if (this.bestFit(p, valid) == match) continue;
            val = true;
            break;
        }
        return val;
    }

    protected int cornerMatch(int[] corners, boolean[] valid, boolean[] newValid) {
        for (int i = 0; i < this.input.length; ++i) {
            if (!valid[i]) continue;
            int xside = 0;
            int yside = 0;
            int nx = this.input[i].getWidth();
            int ny = this.input[i].getHeight();
            for (int j = 0; j < corners.length; ++j) {
                this.t2 = this.getImage(this.input[i], this.getCelest(corners[j]));
                if (this.t2[0] < 0.0) {
                    --xside;
                }
                if (this.t2[0] > (double)nx) {
                    ++xside;
                }
                if (this.t2[1] < 0.0) {
                    --yside;
                }
                if (!(this.t2[1] > (double)ny)) continue;
                ++yside;
            }
            if (Math.abs(xside) == 4 || Math.abs(yside) == 4) continue;
            newValid[i] = true;
        }
        int[] best = new int[corners.length];
        for (int j = 0; j < corners.length; ++j) {
            best[j] = this.bestFit(corners[j], valid);
        }
        int match = best[0];
        for (int i = 1; i < best.length; ++i) {
            if (match == best[i]) continue;
            if (best[0] == best[1] && best[2] == best[3]) {
                return -32;
            }
            if (best[0] == best[2] && best[1] == best[3]) {
                return -16;
            }
            return -48;
        }
        return match;
    }

    protected double[] getCelest(int pix) {
        double[] tp = this.output.getCenter(pix);
        this.fromOut.transform(tp, this.t3);
        return this.t3;
    }

    protected double minDist(double x, double y, double a, double b) {
        return Math.min(Math.min(x, a - x), Math.min(y, b - y));
    }

    protected double[] getImage(Image img, double[] inp) {
        img.getTransformer().transform(inp, this.t2);
        return this.t2;
    }

    protected int bestFit(int pix, boolean[] valid) {
        int val = this.img[pix];
        if (val != -1) {
            return val;
        }
        ++this.pixelCount;
        this.t3 = this.getCelest(pix);
        double mx = -1.0;
        int best = -2;
        if (Double.isNaN(this.t3[0])) {
            this.img[pix] = -3;
            return -3;
        }
        for (int i = 0; i < this.input.length; ++i) {
            int py;
            int px;
            int ny;
            if (!valid[i]) continue;
            this.t2 = this.getImage(this.input[i], this.t3);
            double tx = this.t2[0];
            double ty = this.t2[1];
            int nx = this.input[i].getWidth();
            double mn = this.minDist(tx, ty, nx, ny = this.input[i].getHeight());
            if (!(mn >= 0.0) || this.checkNaNs && Double.isNaN(this.input[i].getData((px = (int)tx) + nx * (py = (int)ty)))) continue;
            if (this.criterion(mn, i) > mx) {
                mx = this.criterion(mn, i);
                best = i;
            }
            throw new ParsingTermination();
        }
        if (best >= 0) {
            this.imageUsed[best] = true;
        }
        this.img[pix] = best;
        return best;
    }

    protected double criterion(double mn, int i) {
        return mn;
    }

    private void printOut(int[] arr, int mx) {
        int off = 0;
        while (off < arr.length) {
            if (arr[off] < 0) {
                System.err.print(" " + arr[off]);
            } else {
                System.err.print("  " + arr[off]);
            }
            if (++off % mx != 0) continue;
            System.err.println("");
        }
    }
}

