/*
 * Decompiled with CFR 0.152.
 */
package skyview.survey;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.regex.Pattern;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;
import skyview.executive.Settings;
import skyview.survey.ParsingTermination;
import skyview.survey.Survey;
import skyview.survey.SurveyFinder;
import skyview.survey.Util;
import skyview.survey.XMLSurvey;

public class XMLSurveyFinder
implements SurveyFinder {
    private static String defaultSurveyManifest = "survey.manifest";
    private FilenameFilter filter = new FilenameFilter(){

        @Override
        public boolean accept(File file, String name) {
            return name.endsWith(".xml") || name.endsWith(".XML");
        }
    };
    private HashMap<String, String> hash = new HashMap();

    public XMLSurveyFinder() {
        this.getSurveysFromManifest();
        this.getSurveysFromRoot();
        this.getSurveysFromUser();
    }

    protected void getSurveysFromRoot() {
        String[] roots;
        for (String root : roots = Settings.getArray("xmlroot")) {
            String[] match;
            File f = new File(root);
            for (String survey : match = f.list(this.filter)) {
                this.process(root + "/" + survey);
            }
        }
    }

    protected void getSurveysFromUser() {
        String userSurveys = Settings.get("surveyxml");
        if (userSurveys != null) {
            Pattern comma = Pattern.compile(",");
            String[] surveys = comma.split(userSurveys);
            for (int i = 0; i < surveys.length; ++i) {
                this.process(surveys[i]);
            }
        }
    }

    protected void getSurveysFromManifest() {
        try {
            String survey;
            InputStream is;
            String manifest = Settings.get("surveymanifest");
            if (manifest == null) {
                manifest = defaultSurveyManifest;
            }
            if ((is = Util.getResourceOrFile(manifest)) == null) {
                return;
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            while ((survey = br.readLine()) != null) {
                if ((survey = survey.trim()).length() == 0 || survey.charAt(0) == '#') continue;
                this.process(survey);
            }
        }
        catch (Exception e) {
            System.err.println("Error loading surveys from manifest: " + e + "\n Processing continues");
        }
    }

    @Override
    public Survey find(String shortName) {
        String fileName = this.findFile(shortName);
        if (fileName == null) {
            return null;
        }
        return new XMLSurvey(fileName);
    }

    public String findFile(String shortName) {
        return this.hash.get(shortName.toLowerCase());
    }

    private void process(String name) {
        try {
            InputStream is = Util.getResourceOrFile(name);
            is = new BufferedInputStream(is);
            SAXParser sp = SAXParserFactory.newInstance().newSAXParser();
            sp.parse(new InputSource(is), (DefaultHandler)new NameCallBack(name));
            is.close();
        }
        catch (ParsingTermination e) {
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new Error("Unexpected exception parsing file: " + name + " in SurveyFinder:" + e);
        }
    }

    @Override
    public String[] getSurveys() {
        return this.hash.keySet().toArray(new String[0]);
    }

    private class NameCallBack
    extends DefaultHandler {
        private StringBuffer buf;
        private boolean active = false;
        String fileName;
        Pattern pat = Pattern.compile(",");

        NameCallBack(String file) {
            this.fileName = file;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attrib) {
            if (qName.equals("ShortName")) {
                this.active = true;
                this.buf = new StringBuffer();
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            if (qName.equals("ShortName")) {
                String[] names;
                String name = new String(this.buf).trim();
                for (String cName : names = this.pat.split(name)) {
                    cName = cName.trim();
                    XMLSurveyFinder.this.hash.put(cName.toLowerCase(), this.fileName);
                }
                throw new ParsingTermination();
            }
        }

        @Override
        public void characters(char[] arr, int start, int len) {
            if (this.active) {
                this.buf.append(arr, start, len);
            }
        }
    }
}

