/*
 * Decompiled with CFR 0.152.
 */
package skyview.util;

import skyview.util.Scaler;
import skyview.util.Utilities;

public class LogScaler
extends Scaler {
    private boolean scaleNegative = false;
    private double smallestPositive = -1.0;
    private double scale;
    private double min;

    public LogScaler() {
    }

    public LogScaler(double minVal, double maxVal, int minOutput, int maxOutput, boolean scaleNegative) {
        super(minVal, maxVal, minOutput, maxOutput);
        this.scaleNegative = scaleNegative;
    }

    @Override
    protected void prepareScaling(double[] c) {
        if (this.scaleNegative && this.getMinVal() < 0.0) {
            double delta;
            int i;
            int[] greaterThanZero = Utilities.whereInArray(c, ">", 0.0);
            if (greaterThanZero.length > 0) {
                this.smallestPositive = c[greaterThanZero[0]];
                for (i = 0; i < greaterThanZero.length; ++i) {
                    if (!(c[greaterThanZero[i]] < this.smallestPositive)) continue;
                    this.smallestPositive = c[greaterThanZero[i]];
                }
                delta = this.smallestPositive - this.getMinVal();
            } else {
                delta = -this.getMinVal() + 0.01 * (this.getMaxVal() - this.getMinVal());
            }
            i = 0;
            while (i < c.length) {
                int n = i++;
                c[n] = c[n] + delta;
            }
            this.setMaxVal(this.getMaxVal() + delta);
            this.setMinVal(this.getMinVal() + delta);
        }
        double smallestPositive = 1.0E300;
        if (this.getMinVal() <= 0.0) {
            for (int i = 0; i < c.length; ++i) {
                if (!(c[i] < smallestPositive)) continue;
                smallestPositive = c[i];
            }
        } else {
            smallestPositive = this.getMinVal();
        }
        this.min = smallestPositive;
        if (smallestPositive > 0.0 && smallestPositive < this.getMaxVal()) {
            this.scale = (double)(this.getMaxOutput() - this.getMinOutput()) / Math.log(this.getMaxVal() - Math.log(smallestPositive));
        }
    }

    @Override
    protected byte scale(double val) {
        if (val <= this.min) {
            return (byte)this.getMinOutput();
        }
        return (byte)((Math.log(val) - Math.log(this.min)) * this.scale + (double)this.getMinOutput());
    }
}

