/*
 * Decompiled with CFR 0.152.
 */
package skyview.util;

import nom.tam.fits.Fits;
import nom.tam.fits.Header;
import skyview.geometry.Converter;
import skyview.geometry.CoordinateSystem;
import skyview.geometry.Util;
import skyview.geometry.WCS;

public class PixelCoords {
    public static void main(String[] args) throws Exception {
        String file = args[0];
        String xs = args[1];
        String ys = args[2];
        double[] pixels = new double[]{Double.parseDouble(xs), Double.parseDouble(ys)};
        Fits f = new Fits(file);
        Header h = f.readHDU().getHeader();
        WCS w = new WCS(h);
        CoordinateSystem csys = w.getCoordinateSystem();
        Converter cnv = new Converter();
        if (csys.getRotater() != null) {
            cnv.add(csys.getRotater().inverse());
        }
        if (csys.getSphereDistorter() != null) {
            cnv.add(csys.getSphereDistorter().inverse());
        }
        cnv.add(w);
        cnv.printElements();
        double[] unit = cnv.inverse().transform(pixels);
        double[] coords = Util.coord(unit);
        System.out.println("Coordinates:" + Math.toDegrees(coords[0]) + ", " + Math.toDegrees(coords[1]));
    }
}

