/*
 * Decompiled with CFR 0.152.
 */
package org.prevayler.implementation;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

final class ByteCountStream
extends FileOutputStream {
    private long bytesWritten;

    public ByteCountStream(File file) throws IOException {
        super(file);
    }

    public void flush() throws IOException {
        super.flush();
        this.getFD().sync();
    }

    public void write(byte[] byArray) throws IOException {
        super.write(byArray);
        this.bytesWritten += (long)byArray.length;
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        super.write(byArray, n, n2);
        this.bytesWritten += (long)n2;
    }

    public void write(int n) throws IOException {
        super.write(n);
        ++this.bytesWritten;
    }

    public long bytesWritten() {
        return this.bytesWritten;
    }
}

