/*
 * Decompiled with CFR 0.152.
 */
package org.prevayler.implementation;

import java.io.EOFException;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Arrays;
import org.prevayler.implementation.NumberFileCreator;

class NumberFileFinder {
    private File directory;
    private File lastSnapshot;
    private long fileNumber;
    private NumberFileCreator fileCreator;

    public NumberFileFinder(String string) throws IOException {
        this.directory = new File(string);
        if (!this.directory.exists() && !this.directory.mkdirs()) {
            throw new IOException("Directory doesn't exist and could not be created: " + string);
        }
        if (!this.directory.isDirectory()) {
            throw new IllegalArgumentException("Path exists but is not a directory: " + string);
        }
        this.init();
    }

    public File lastSnapshot() {
        return this.lastSnapshot;
    }

    public File nextPendingLog() throws EOFException {
        File file = new File(this.directory, NumberFileCreator.LOG_FORMAT.format(this.fileNumber + 1L));
        if (!file.exists()) {
            this.fileCreator = new NumberFileCreator(this.directory, this.fileNumber + 1L);
            throw new EOFException();
        }
        ++this.fileNumber;
        return file;
    }

    public NumberFileCreator fileCreator() {
        return this.fileCreator;
    }

    private void init() throws IOException {
        this.findLastSnapshot();
        this.fileNumber = this.lastSnapshot == null ? 0L : this.number(this.lastSnapshot);
    }

    private long number(File file) throws NumberFormatException {
        String string = file.getName();
        if (!string.endsWith(".snapshot")) {
            throw new NumberFormatException();
        }
        return Long.parseLong(string.substring(0, string.indexOf(46)));
    }

    private void findLastSnapshot() throws IOException {
        Object[] objectArray = this.directory.listFiles(new SnapshotFilter());
        if (objectArray == null) {
            throw new IOException("Error reading file list from directory " + this.directory);
        }
        Arrays.sort(objectArray);
        this.lastSnapshot = objectArray.length > 0 ? objectArray[objectArray.length - 1] : null;
    }

    private class SnapshotFilter
    implements FileFilter {
        private SnapshotFilter() {
        }

        public boolean accept(File file) {
            try {
                NumberFileFinder.this.number(file);
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            return true;
        }
    }
}

