/*
 * Decompiled with CFR 0.152.
 */
package alma.observatorycharacteristics.capabilities;

import alma.observatorycharacteristics.configuration.Frequency;
import alma.observatorycharacteristics.configuration.FrequencyList;
import alma.observatorycharacteristics.configuration.OTTime;
import alma.observatorycharacteristics.configuration.PrincipalALMAArrayType;
import alma.obsprep.bo.enumerations.Array;
import alma.valuetypes.Angle;
import alma.valuetypes.Time;
import java.util.List;
import java.util.stream.Collectors;

public class OTConfigurationHelper {
    public static PrincipalALMAArrayType mapPrincipalArray(Array array) {
        switch (array) {
            case ARRAY_12M: {
                return PrincipalALMAArrayType.TWELVE_M;
            }
            case ARRAY_7M: {
                return PrincipalALMAArrayType.ACA_7_M;
            }
            case ARRAY_TP: {
                return PrincipalALMAArrayType.TP;
            }
        }
        throw new IllegalArgumentException("Unknown array type " + (Object)((Object)array));
    }

    public static Array mapPrincipalArray(PrincipalALMAArrayType principalALMAArrayType) {
        switch (principalALMAArrayType) {
            case TWELVE_M: {
                return Array.ARRAY_12M;
            }
            case ACA_7_M: {
                return Array.ARRAY_7M;
            }
            case TP: {
                return Array.ARRAY_TP;
            }
        }
        throw new IllegalArgumentException("Unknown array type " + (Object)((Object)principalALMAArrayType));
    }

    public static List<alma.valuetypes.Frequency> getFrequencyList(FrequencyList frequencyList) {
        if (frequencyList == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: frequencyList");
        }
        return frequencyList.getFrequency().stream().map(frequency -> alma.valuetypes.Frequency.createFrequency((double)frequency.getValue(), (String)frequency.getUnit().value())).collect(Collectors.toList());
    }

    public static Angle getAngle(alma.observatorycharacteristics.configuration.Angle angle) {
        if (angle == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: angle");
        }
        return Angle.createAngle((double)angle.getValue(), (String)angle.getUnit().value());
    }

    public static alma.valuetypes.Frequency getFrequency(Frequency frequency) {
        if (frequency == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: angle");
        }
        return alma.valuetypes.Frequency.createFrequency((double)frequency.getValue(), (String)frequency.getUnit().value());
    }

    public static Time getTime(OTTime oTTime) {
        if (oTTime == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: time");
        }
        return Time.createTime((double)oTTime.getValue(), (String)oTTime.getUnit().value());
    }

    public static String[] getFrequencyListAsStr(List<alma.valuetypes.Frequency> list, String string) {
        return (String[])list.stream().map(frequency -> Double.toString(frequency.getContentInUnits(string))).toArray(String[]::new);
    }
}

