/*
 * Decompiled with CFR 0.152.
 */
package alma.observatorycharacteristics.policies;

import alma.hla.runtime.obsprep.util.Log;
import alma.observatorycharacteristics.capabilities.OTConfigurationHelper;
import alma.observatorycharacteristics.configuration.ArrayConfigurationType;
import alma.observatorycharacteristics.configuration.DataRateLimitType;
import alma.observatorycharacteristics.configuration.OTConfiguration;
import alma.observatorycharacteristics.configuration.OTXMLConfigurationReader;
import alma.observatorycharacteristics.configuration.ScienceKeywordGroup;
import alma.observatorycharacteristics.configuration.ScienceKeywords;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.valuetypes.Angle;
import alma.valuetypes.Time;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBException;
import org.apache.commons.lang3.StringUtils;

public class AlmaPolicies {
    private static AlmaPolicies almaPoliciesSingleton = null;
    private Time nominalSBExecutionLength;
    private Time tpNominalTPSBLength;
    private Time itosForSolarSource;
    private Time tpMaxTOSPerSB;
    private String cycleNumber;
    private String ddtCycleNumber;
    private Time minTimeOnSrc;
    private int maxAbstractWords;
    private int maxScienceCasePages;
    private int maxAbstractCharacters;
    private int maxTextAreaCharacters;
    private int maxJustificationTextCharacters;
    private int minJustificationTextCharacters;
    private int maxTuningsPerGoal;
    private int maxNoOfPointings;
    private int warningNoOfPointings;
    private int maxScienceGoals;
    private int maxSourcesPerScienceGoal;
    private Angle maxConeDiameter;
    private Angle maxConeDiameterLongBaseline;
    private double max12mDataRateMBPS;
    private double warning12mDataRateMBPS;
    private Time minTimeOnSourcePerSBExecution;
    private Time maxStandardProposalTime;
    private Time minTimeForPolarizationSG;
    private Time minAdvisedTimeMargin;
    private double nominalTotalToScienceRatio;
    private double nominalTotalToScienceRatioWithMultipleTunings;
    private double nominalTotalToScienceRationWithFullPolarization;
    private double nominalTotalToScienceRatioForACA7mSB;
    private Map<String, String[]> scienceKeywordGroups = new HashMap<String, String[]>();
    private Map<String, String> scienceKeywordCodes = new HashMap<String, String>();
    public static final File ALMA_POLICIES_PROPERTIES_FOLDER = new File("alma/observatorycharacteristics/policies");
    private Angle maxSeparationOfPointingFromSourceCoordinate;
    private boolean isTJValidationRequired = true;
    private boolean isSourceParametersRequired = true;
    private Time minLargeProgramTimeNoSACA;
    private Time minLargeProgramTimeWithSACA;
    private int maxScienceCasePagesForLargeProgram;
    private OTConfiguration.TelescopePolicies telescopePolicies;
    private String[] scienceCodes;
    private String[] scienceCategories;
    private String[] proposalTypes;
    private String[] proposalCodes;
    private String[] observatoryTypes;
    private String[] observatoryCodes;
    private String telescope = System.getProperty("Telescope", "Cycle6");
    private double instantaneous12mDataRateMBPS;

    private AlmaPolicies() throws InvalidObsProgramParametersException {
        try {
            this.telescopePolicies = OTXMLConfigurationReader.getInstance().getOTConfiguration().getTelescopePolicies();
        }
        catch (OTXMLConfigurationReader.InvalidOTCOnfigurationException | JAXBException throwable) {
            throw new RuntimeException("Unable to parse the " + this.telescope + "OTConfiguration.xml file " + throwable.getMessage());
        }
        this.maxScienceCasePagesForLargeProgram = this.telescopePolicies.getMaxScienceCasePagesLargeProgram().intValue();
        this.maxSeparationOfPointingFromSourceCoordinate = OTConfigurationHelper.getAngle(this.telescopePolicies.getMaxPointingSeparationFromSourceCoordinate());
        this.minLargeProgramTimeNoSACA = OTConfigurationHelper.getTime(this.telescopePolicies.getMinLargeProgramTimeNoSACA());
        this.minLargeProgramTimeWithSACA = OTConfigurationHelper.getTime(this.telescopePolicies.getMinLargeProgramTimeWithSACA());
        this.nominalSBExecutionLength = OTConfigurationHelper.getTime(this.telescopePolicies.getNominalSBLength());
        this.tpNominalTPSBLength = OTConfigurationHelper.getTime(this.telescopePolicies.getTPNominalSBLength());
        this.cycleNumber = this.telescopePolicies.getCycleNumber();
        this.tpMaxTOSPerSB = OTConfigurationHelper.getTime(this.telescopePolicies.getTPMaxTOSPerSB());
        this.itosForSolarSource = OTConfigurationHelper.getTime(this.telescopePolicies.getIntegrationTimeForSolarSource());
        this.ddtCycleNumber = this.telescopePolicies.getDDTCycleNumber();
        this.minTimeOnSourcePerSBExecution = OTConfigurationHelper.getTime(this.telescopePolicies.getMinTimeOnSourcePerSB());
        this.nominalTotalToScienceRatio = this.telescopePolicies.getNominalTotalToScienceRatio();
        this.nominalTotalToScienceRatioWithMultipleTunings = this.telescopePolicies.getNominalTotalToScienceRatioForMultipleTunings();
        this.nominalTotalToScienceRationWithFullPolarization = this.telescopePolicies.getNominalTotalToScienceRatioForFullPolarization();
        this.nominalTotalToScienceRatioForACA7mSB = this.telescopePolicies.getNominalTotalToScienceRatioForACA7M();
        this.minTimeOnSrc = OTConfigurationHelper.getTime(this.telescopePolicies.getMinTimeOnSource());
        this.maxAbstractWords = this.telescopePolicies.getMaxWordsInAbstract().intValue();
        this.maxTuningsPerGoal = this.telescopePolicies.getMaxTuningsPerScienceGoal().intValue();
        this.maxScienceCasePages = this.telescopePolicies.getMaxScienceCasePages().intValue();
        this.maxAbstractCharacters = this.telescopePolicies.getMaxCharactersInAbstract().intValue();
        this.maxTextAreaCharacters = this.telescopePolicies.getMaxTextAreaCharacters().intValue();
        this.maxJustificationTextCharacters = this.telescopePolicies.getMaxCharactersInTJField().intValue();
        this.minJustificationTextCharacters = this.telescopePolicies.getMinCharactersInTJField().intValue();
        this.maxNoOfPointings = this.telescopePolicies.getMaxNoOfPointings().intValue();
        this.warningNoOfPointings = this.telescopePolicies.getWarningNoOfPointings().intValue();
        this.maxSourcesPerScienceGoal = this.telescopePolicies.getMaxSourcesPerScienceGoal().intValue();
        this.maxScienceGoals = this.telescopePolicies.getMaxScienceGoals().intValue();
        List<OTConfiguration.TelescopePolicies.DataRateConstraints.DataRateConstraint> list = this.telescopePolicies.getDataRateConstraints().getDataRateConstraint();
        List list2 = list.stream().filter(dataRateConstraint -> dataRateConstraint.getLimit().equals((Object)DataRateLimitType.ABSOLUTE) && dataRateConstraint.getArray().equals((Object)ArrayConfigurationType.TWELVE_M)).collect(Collectors.toList());
        List list3 = list.stream().filter(dataRateConstraint -> dataRateConstraint.getLimit().equals((Object)DataRateLimitType.WARNING) && dataRateConstraint.getArray().equals((Object)ArrayConfigurationType.TWELVE_M)).collect(Collectors.toList());
        List list4 = list.stream().filter(dataRateConstraint -> dataRateConstraint.getLimit().equals((Object)DataRateLimitType.INSTANTANEOUS) && dataRateConstraint.getArray().equals((Object)ArrayConfigurationType.TWELVE_M)).collect(Collectors.toList());
        if (list2.size() != 1) {
            Log.logger(AlmaPolicies.class).warning("Only one absolute data rate limit should be specified for the 12-m array");
            throw new RuntimeException("Only one absolute data rate limit should be specified for the 12-m array");
        }
        if (list3.size() != 1) {
            Log.logger(AlmaPolicies.class).warning("Only one warning data rate limit should be specified for the 12-m array");
            throw new RuntimeException("Only one warning data rate limit should be specified for the 12-m array");
        }
        if (list4.size() != 1) {
            Log.logger(AlmaPolicies.class).warning("Only one instantaneous data rate limit should be specified for the 12-m array");
            throw new RuntimeException("Only one instantaneous data rate limit should be specified for the 12-m array");
        }
        this.max12mDataRateMBPS = ((OTConfiguration.TelescopePolicies.DataRateConstraints.DataRateConstraint)list2.get(0)).getDataRateMBPS();
        this.warning12mDataRateMBPS = ((OTConfiguration.TelescopePolicies.DataRateConstraints.DataRateConstraint)list3.get(0)).getDataRateMBPS();
        this.instantaneous12mDataRateMBPS = ((OTConfiguration.TelescopePolicies.DataRateConstraints.DataRateConstraint)list4.get(0)).getDataRateMBPS();
        this.maxConeDiameter = OTConfigurationHelper.getAngle(this.telescopePolicies.getMaxConeDiameter());
        this.maxConeDiameterLongBaseline = OTConfigurationHelper.getAngle(this.telescopePolicies.getMaxConeDiameterLongBaseline());
        this.maxStandardProposalTime = OTConfigurationHelper.getTime(this.telescopePolicies.getMaxTimeOfStandardProject());
        this.minTimeForPolarizationSG = OTConfigurationHelper.getTime(this.telescopePolicies.getMinTimeForPolarisationSG());
        this.minAdvisedTimeMargin = OTConfigurationHelper.getTime(this.telescopePolicies.getMinAdvisedTimeMargin());
        this.isTJValidationRequired = this.telescopePolicies.isTJRequired();
        this.isSourceParametersRequired = this.telescopePolicies.isSourceParametersRequired();
        this.scienceCategories = (String[])this.telescopePolicies.getScienceCategories().getScienceCategory().stream().map(scienceCategory -> scienceCategory.getCategory()).toArray(String[]::new);
        this.scienceCodes = (String[])this.telescopePolicies.getScienceCategories().getScienceCategory().stream().map(scienceCategory -> scienceCategory.getIndex().toString()).toArray(String[]::new);
        if (this.scienceCategories == null || this.scienceCategories.length == 0) {
            throw new RuntimeException("Science categories is empty");
        }
        if (this.scienceCodes == null || this.scienceCodes.length == 0) {
            throw new RuntimeException("Science code is empty");
        }
        this.proposalCodes = (String[])this.telescopePolicies.getStandardProposalTypes().getProposalType().stream().map(proposalType -> proposalType.getCode().toString()).toArray(String[]::new);
        this.proposalTypes = (String[])this.telescopePolicies.getStandardProposalTypes().getProposalType().stream().map(proposalType -> proposalType.getDescription()).toArray(String[]::new);
        if (this.proposalTypes == null || this.proposalTypes.length == 0) {
            throw new RuntimeException("Proposal types is empty");
        }
        if (this.proposalCodes == null || this.proposalCodes.length == 0) {
            throw new RuntimeException("Proposal codes is empty");
        }
        this.observatoryTypes = (String[])this.telescopePolicies.getObservatoryProposalTypes().getProposalType().stream().map(proposalType -> proposalType.getDescription()).toArray(String[]::new);
        this.observatoryCodes = (String[])this.telescopePolicies.getObservatoryProposalTypes().getProposalType().stream().map(proposalType -> proposalType.getCode().toString()).toArray(String[]::new);
        if (this.observatoryCodes == null || this.observatoryCodes.length == 0) {
            throw new RuntimeException("Observatory proposal codes is empty");
        }
        if (this.observatoryTypes == null || this.observatoryTypes.length == 0) {
            throw new RuntimeException("Observatory proposal types is empty");
        }
        for (ScienceKeywordGroup scienceKeywordGroup : this.telescopePolicies.getScienceKeywords().getScienceGroup()) {
            String string = scienceKeywordGroup.getGroup().toString();
            for (ScienceKeywords scienceKeywords2 : scienceKeywordGroup.getKeyword()) {
                this.scienceKeywordCodes.put(scienceKeywords2.getKeyword(), string + scienceKeywords2.getCode());
            }
            this.scienceKeywordGroups.put(string, (String[])scienceKeywordGroup.getKeyword().stream().map(scienceKeywords -> scienceKeywords.getKeyword()).toArray(String[]::new));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AlmaPolicies getInstance() {
        if (almaPoliciesSingleton != null) return almaPoliciesSingleton;
        Class<AlmaPolicies> clazz = AlmaPolicies.class;
        synchronized (AlmaPolicies.class) {
            if (almaPoliciesSingleton != null) return almaPoliciesSingleton;
            try {
                almaPoliciesSingleton = new AlmaPolicies();
            }
            catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                Log.logger(AlmaPolicies.class).log(Level.WARNING, "", (Throwable)invalidObsProgramParametersException);
                throw new RuntimeException(invalidObsProgramParametersException);
            }
            return almaPoliciesSingleton;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void refreshPolicies() {
        if (almaPoliciesSingleton == null) return;
        Class<AlmaPolicies> clazz = AlmaPolicies.class;
        synchronized (AlmaPolicies.class) {
            if (almaPoliciesSingleton == null) return;
            almaPoliciesSingleton = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public Time getNominalSbLength() {
        return this.nominalSBExecutionLength.deepCopy();
    }

    public Time getTPNominalSbLength() {
        return this.tpNominalTPSBLength.deepCopy();
    }

    public String getCycleNumber() {
        return this.getCommandLineCycleNumber(this.cycleNumber, "ot.cyclenumber");
    }

    public Time getMinTimeOnSourcePerSB() {
        return this.minTimeOnSourcePerSBExecution.deepCopy();
    }

    public Time getMinimumTimeOnSrc() {
        return this.minTimeOnSrc.deepCopy();
    }

    public String getDDTCycleNumber() {
        return this.getCommandLineCycleNumber(this.ddtCycleNumber, "ot.ddtcyclenumber");
    }

    String getCommandLineCycleNumber(String string, String string2) {
        String string3 = string;
        if (System.getProperty(string2) != null) {
            String string4 = StringUtils.trimToEmpty((String)System.getProperty(string2));
            if (!string4.matches("\\w\\w\\w\\w\\.\\w")) {
                Log.logger(AlmaPolicies.class).warning("-D" + string2 + " value should have the format aaaa.n and use alphanumeric characters only : " + string4);
                System.exit(1);
            }
            string3 = string4;
        }
        return string3;
    }

    public Time getMaxStandardProposalTime() {
        return this.maxStandardProposalTime.deepCopy();
    }

    public int getMaxAbstractWords() {
        return this.maxAbstractWords;
    }

    public int getMaxScienceCasePages() {
        return this.maxScienceCasePages;
    }

    public int getMaxLargeProgramScienceCasePages() {
        return this.maxScienceCasePagesForLargeProgram;
    }

    public int getMaxAbstractCharacters() {
        return this.maxAbstractCharacters;
    }

    public int getMaxTextAreaCharacters() {
        return this.maxTextAreaCharacters;
    }

    public int getMaxTechnicalJustificationTextCharacters() {
        return this.maxJustificationTextCharacters;
    }

    public int getMinTechnicalJustificationTextCharacters() {
        return this.minJustificationTextCharacters;
    }

    public Time getMinTimeForPolarisationSB() {
        return this.minTimeForPolarizationSG.deepCopy();
    }

    public Time getMinAdvisedTimeMargin() {
        return this.minAdvisedTimeMargin.deepCopy();
    }

    public int getMaxRetuningsPerGoal() {
        return this.maxTuningsPerGoal;
    }

    public int getMaxNumberPointings() {
        return this.maxNoOfPointings;
    }

    public int getWarningNumberPointings() {
        return this.warningNoOfPointings;
    }

    public int getMaxScienceGoals() {
        return this.maxScienceGoals;
    }

    public int getMaxSourcesPerGoal() {
        return this.maxSourcesPerScienceGoal;
    }

    public double getMax12MDataRateMBPS() {
        return this.max12mDataRateMBPS;
    }

    public double getWarningDataRateMBPS() {
        return this.warning12mDataRateMBPS;
    }

    public Angle getMaxConeDiameter() {
        return this.maxConeDiameter.deepCopy();
    }

    public Angle getMaxConeDiameterLongBaseline() {
        return this.maxConeDiameterLongBaseline.deepCopy();
    }

    public double getNominalTotalToScienceRatio() {
        return this.nominalTotalToScienceRatio;
    }

    public double getNominalTotalToScienceMultipleTuningsRatio() {
        return this.nominalTotalToScienceRatioWithMultipleTunings;
    }

    public String[] getScientificCategories() {
        return this.scienceCategories;
    }

    public String[] getProposalTypes() {
        return this.proposalTypes;
    }

    public String[] getKnownScientificCategories() {
        return this.getScientificCategories();
    }

    public String[] getScienceKeywords(String string) {
        return this.scienceKeywordGroups.get(string);
    }

    public String getScienceKeywordCode(String string) {
        return this.scienceKeywordCodes.get(string);
    }

    public String[] getScienceCodes() {
        return this.scienceCodes;
    }

    public String getScienceCodeForCategory(String string) {
        for (int i = 0; i < this.scienceCategories.length; ++i) {
            if (!this.scienceCategories[i].equals(string)) continue;
            return this.scienceCodes[i];
        }
        return "00";
    }

    public String getScienceCategoryForCode(String string) {
        String string2 = "Illegal Category";
        for (int i = 0; i < this.scienceCodes.length; ++i) {
            if (!this.scienceCodes[i].equals(string)) continue;
            return this.scienceCategories[i];
        }
        return string2;
    }

    public String[] getKnownProposalTypes() {
        return this.getProposalTypes();
    }

    public String getCodeForProposalType(String string) {
        for (int i = 0; i < this.proposalTypes.length; ++i) {
            if (!this.proposalTypes[i].equals(string)) continue;
            return this.proposalCodes[i];
        }
        throw new IllegalArgumentException("No code associated with the project type " + string + " found");
    }

    public String getCodeForObservatoryType(String string) {
        String string2 = "?";
        for (int i = 0; i < this.observatoryTypes.length; ++i) {
            if (!this.observatoryTypes[i].equals(string)) continue;
            return this.observatoryCodes[i];
        }
        return string2;
    }

    public String getProposalTypeForCode(String string) {
        for (int i = 0; i < this.proposalCodes.length; ++i) {
            if (!this.proposalCodes[i].equals(string)) continue;
            return this.proposalTypes[i];
        }
        throw new IllegalArgumentException("Unable to locate proposal type for code " + string);
    }

    public String[] getObservatoryTypes() {
        return this.observatoryTypes;
    }

    public double getNominalTotalToSciencePolarizationRatio() {
        return this.nominalTotalToScienceRationWithFullPolarization;
    }

    public double getNominalTotalToScienceACA7MRatio() {
        return this.nominalTotalToScienceRatioForACA7mSB;
    }

    public boolean getIsTechnicalJustificationRequired() {
        return this.isTJValidationRequired;
    }

    public boolean getIsSourceParametersRequired() {
        return this.isSourceParametersRequired;
    }

    public Time getMinLargeProgramTimeNoACA() {
        return this.minLargeProgramTimeNoSACA.deepCopy();
    }

    public Angle getMaxSeparationFromSourceCoordinate() {
        return this.maxSeparationOfPointingFromSourceCoordinate.deepCopy();
    }

    public Time getMinLargeProgramTimeWithSACA() {
        return this.minLargeProgramTimeWithSACA.deepCopy();
    }

    public double getInstantaneous12mDataRateMBPS() {
        return this.instantaneous12mDataRateMBPS;
    }

    public Time getTpMaxTOSPerSB() {
        return this.tpMaxTOSPerSB.deepCopy();
    }

    public Time getItosForSolarSource() {
        return this.itosForSolarSource.deepCopy();
    }
}

