/*
 * Decompiled with CFR 0.152.
 */
package alma.observatorycharacteristics.site;

import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.util.MiscUtils;
import alma.valuetypes.Latitude;
import alma.valuetypes.Longitude;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import java.util.regex.Pattern;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SiteCharacteristics {
    private static final File SITE_CHARACTERISTICS_PROPERTIES_FOLDER = new File("alma/observatorycharacteristics/site");
    private static final String SITE_CHARACTERISTICS_PROPERTIES_NAME = "SiteCharacteristics.properties";
    private static SiteCharacteristics sc = null;
    static String property;
    private String OBSERVATORY_NAME;
    private Latitude OBSERVATORY_LATITUDE;
    private Longitude OBSERVATORY_LONGITUDE;
    private Latitude OBSERVATORY_DECLINATION_LIMIT;
    private String[] ACS_MANAGER_LIST;
    private static ArrayList<ChangeListener> listeners;

    private SiteCharacteristics() throws InvalidObsProgramParametersException {
        Properties properties = SiteCharacteristics.getSiteCharacteristics();
        property = properties.getProperty("OBSERVATORY_NAME");
        if (property == null) {
            throw new InvalidObsProgramParametersException("Property OBSERVATORY_NAME undefined");
        }
        this.OBSERVATORY_NAME = property;
        property = properties.getProperty("OBSERVATORY_LATITUDE");
        if (property == null) {
            throw new InvalidObsProgramParametersException("Property OBSERVATORY_LATITUDE undefined");
        }
        double d = Double.parseDouble(property);
        this.OBSERVATORY_LATITUDE = Latitude.createLatitude();
        this.OBSERVATORY_LATITUDE.setContent(d);
        this.OBSERVATORY_LATITUDE.setUnitToDefault();
        property = properties.getProperty("OBSERVATORY_LONGITUDE");
        if (property == null) {
            throw new InvalidObsProgramParametersException("Property OBSERVATORY_LONGITUDE undefined");
        }
        double d2 = Double.parseDouble(property);
        this.OBSERVATORY_LONGITUDE = Longitude.createLongitude();
        this.OBSERVATORY_LONGITUDE.setContent(d2);
        this.OBSERVATORY_LONGITUDE.setUnitToDefault();
        property = properties.getProperty("ACS_MANAGER_LIST");
        if (property == null) {
            throw new InvalidObsProgramParametersException("Property ACS_MANAGER_LIST undefined");
        }
        Pattern pattern = Pattern.compile("[,\\s]+");
        this.ACS_MANAGER_LIST = pattern.split(property);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SiteCharacteristics getInstance() {
        if (sc == null) {
            try {
                Class<SiteCharacteristics> clazz = SiteCharacteristics.class;
                synchronized (SiteCharacteristics.class) {
                    if (sc == null) {
                        sc = new SiteCharacteristics();
                    }
                    // ** MonitorExit[var0] (shouldn't be in output)
                }
            }
            catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                Log.logger(SiteCharacteristics.class).log(Level.WARNING, "", (Throwable)invalidObsProgramParametersException);
            }
        }
        {
            return sc;
        }
    }

    public static void refreshCharacteristics() {
        sc = null;
        ChangeEvent changeEvent = new ChangeEvent(SiteCharacteristics.class);
        for (ChangeListener changeListener : listeners) {
            changeListener.stateChanged(changeEvent);
        }
    }

    public Latitude getObsLatitude() {
        return this.OBSERVATORY_LATITUDE;
    }

    public Longitude getObsLongitude() {
        return this.OBSERVATORY_LONGITUDE;
    }

    public String getObsName() {
        return this.OBSERVATORY_NAME;
    }

    public String[] getAcsManagerList() {
        return this.ACS_MANAGER_LIST;
    }

    private static Properties getSiteCharacteristics() {
        Properties properties = new Properties();
        String string = System.getProperty("Telescope", "ESALMA");
        try {
            InputStream inputStream = MiscUtils.findResource(SITE_CHARACTERISTICS_PROPERTIES_FOLDER, string + SITE_CHARACTERISTICS_PROPERTIES_NAME).openStream();
            properties.load(inputStream);
        }
        catch (Exception exception) {
            Log.logger(SiteCharacteristics.class).warning("Error accessing " + string + SITE_CHARACTERISTICS_PROPERTIES_NAME + " file: " + exception.getMessage());
            exception.printStackTrace(System.err);
        }
        return properties;
    }

    public static void addChangeListener(ChangeListener changeListener) {
        listeners.add(changeListener);
    }

    static {
        listeners = new ArrayList();
    }
}

