/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo;

import alma.obsprep.bo.annotations.ObservingFrequency;
import alma.valuetypes.Frequency;
import alma.valuetypes.Velocity;

public class DefaultObservingFrequency
implements ObservingFrequency {
    private Frequency inputFrequency;
    private Velocity sourceVelocity;
    private ObservingFrequency.FrequencyType frequencyType;

    public DefaultObservingFrequency() {
        this(Frequency.createFrequency(), Velocity.createVelocity());
    }

    public DefaultObservingFrequency(Frequency frequency, Velocity velocity) {
        this(frequency, velocity, ObservingFrequency.FrequencyType.SKY_FREQUENCY);
    }

    public DefaultObservingFrequency(Frequency frequency, Velocity velocity, ObservingFrequency.FrequencyType frequencyType) {
        this.inputFrequency = frequency;
        this.sourceVelocity = velocity;
        this.frequencyType = frequencyType;
    }

    @Override
    public Frequency getInputFrequency() {
        return this.inputFrequency;
    }

    @Override
    public void setInputFrequency(Frequency frequency) {
        this.inputFrequency = frequency;
    }

    @Override
    public Velocity getSourceVelocity() {
        return this.sourceVelocity;
    }

    @Override
    public void setSourceVelocity(Velocity velocity) {
        this.sourceVelocity = velocity;
    }

    @Override
    public ObservingFrequency.FrequencyType getInputType() {
        return this.frequencyType;
    }

    @Override
    public void setInputType(ObservingFrequency.FrequencyType frequencyType) {
        this.frequencyType = frequencyType;
    }

    @Override
    public Frequency getRestFrequency() {
        if (this.frequencyType == ObservingFrequency.FrequencyType.SKY_FREQUENCY) {
            return this.sourceVelocity.reverseShift(this.inputFrequency);
        }
        return this.inputFrequency.deepCopy();
    }

    @Override
    public Frequency getSkyFrequency() {
        if (this.frequencyType == ObservingFrequency.FrequencyType.SKY_FREQUENCY) {
            return this.inputFrequency.deepCopy();
        }
        return this.sourceVelocity.dopplerShift(this.inputFrequency);
    }

    @Override
    public void setTargetIndex(int n) {
    }
}

