/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo;

import alma.entities.commonentity.EntityT;
import alma.hla.runtime.obsprep.bo.Entity;
import alma.hla.runtime.obsprep.bo.EntityIDFactory;
import alma.hla.runtime.obsprep.bo.EntityPart;
import alma.hla.runtime.obsprep.util.CannotAssignIdException;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.ot.persistence.ImpexFactory;
import alma.obsprep.ot.persistence.ProjectResetListener;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public class EntityIdFactoryImpl
extends EntityIDFactory
implements ProjectResetListener {
    private static Set<String> entityPartIdsAssigned = new HashSet<String>(100);
    Log.Logger logger = Log.logger((Object)this);
    private UidGenerator uidGen = this.fakeUidGen = new FakeUIdGenerator();
    private static Random random = new Random();
    private static final String PREFIXv1 = "entityId_";
    private static final String PREFIXv2 = "fakeuid://";
    private static final String prepared = "fakeuid://X127/X" + random.nextInt(100000000) + "/X";
    private static final AtomicInteger c = new AtomicInteger();
    private UidGenerator fakeUidGen;

    public void destroy() {
    }

    public String assignUniqueEntityId(Entity entity) {
        try {
            String string = this.uidGen.generate();
            EntityT entityT = entity.getmCastorEntity();
            entityT.setEntityId(string);
            entityT.setEntityIdEncrypted("-- id encryption not implemented --");
            if (this.logger.finer()) {
                this.logger.finer("assigned UID " + string + " to " + entity);
            }
            return string;
        }
        catch (Exception exception) {
            throw new CannotAssignIdException("could not assign UID to " + entity + " due to " + exception, (Throwable)exception);
        }
    }

    public String assignEntityPartId(EntityPart entityPart) throws CannotAssignIdException {
        try {
            int n = System.identityHashCode(entityPart);
            String string = "X" + n;
            if (entityPartIdsAssigned.contains(string)) {
                n += random.nextInt(32768);
            }
            entityPartIdsAssigned.add(string);
            entityPart.setEntityPartId(string);
            return string;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new CannotAssignIdException("could not assign EntityPart-Id to " + entityPart, (Throwable)exception);
        }
    }

    public void useUidGenerator(UidGenerator uidGenerator) {
        if (uidGenerator == null) {
            uidGenerator = this.fakeUidGen;
        }
        this.uidGen = uidGenerator;
    }

    public static boolean isOnTheFlyId(String string) {
        return string.startsWith(PREFIXv2) || string.startsWith(PREFIXv1);
    }

    private String createOnTheFlyId() {
        return prepared + c.incrementAndGet();
    }

    @Override
    public void projectDocumentReset(ObsProject obsProject, ImpexFactory.WorkingPersistenceData workingPersistenceData) {
        entityPartIdsAssigned = new HashSet<String>(100);
    }

    private class FakeUIdGenerator
    implements UidGenerator {
        private FakeUIdGenerator() {
        }

        @Override
        public String generate() {
            return EntityIdFactoryImpl.this.createOnTheFlyId();
        }
    }

    public static interface UidGenerator {
        public String generate() throws Exception;
    }
}

