/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo;

import alma.obsprep.bo.annotations.ObservingFrequency;
import alma.obsprep.bo.obsproject.ScienceSpectralWindow;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.valuetypes.Frequency;
import alma.valuetypes.Velocity;

public class SingleContinuumObservingFrequency
implements ObservingFrequency {
    private static final int NUM_BASEBANDS = 4;
    private SpectralSetupParameters ssp;
    private Frequency inputFrequency;
    private ObservingFrequency.FrequencyType inputType;
    private int targetIndex = 0;

    public SingleContinuumObservingFrequency(SpectralSetupParameters spectralSetupParameters) {
        this.ssp = spectralSetupParameters;
        this.inputFrequency = spectralSetupParameters.getSingleContinuumFrequency().deepCopy();
        this.inputType = spectralSetupParameters.getScienceSpectralWindowCount(0) > 0 ? (spectralSetupParameters.getScienceSpectralWindow(0, 0).getIsSkyFrequency() ? ObservingFrequency.FrequencyType.SKY_FREQUENCY : ObservingFrequency.FrequencyType.REST_FREQUENCY) : ObservingFrequency.FrequencyType.SKY_FREQUENCY;
    }

    private boolean getIsSkyFrequency() {
        try {
            return this.inputType == ObservingFrequency.FrequencyType.SKY_FREQUENCY;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    public ScienceSpectralWindow getScienceSpectralWindow(int n) {
        return this.ssp.getScienceSpectralWindow(n);
    }

    public ScienceSpectralWindow getScienceSpectralWindow(int n, int n2) {
        return this.ssp.getScienceSpectralWindow(n, n2);
    }

    public SpectralSetupParameters getSpectralSetupParameters() {
        return this.ssp;
    }

    @Override
    public Frequency getInputFrequency() {
        return this.inputFrequency;
    }

    @Override
    public ObservingFrequency.FrequencyType getInputType() {
        if (this.getIsSkyFrequency()) {
            return ObservingFrequency.FrequencyType.SKY_FREQUENCY;
        }
        return ObservingFrequency.FrequencyType.REST_FREQUENCY;
    }

    @Override
    public Frequency getRestFrequency() {
        Frequency frequency = this.getInputFrequency();
        if (this.getInputType() == ObservingFrequency.FrequencyType.SKY_FREQUENCY) {
            return this.getSourceVelocity().reverseShift(frequency);
        }
        return frequency.deepCopy();
    }

    @Override
    public Frequency getSkyFrequency() {
        Frequency frequency = this.getInputFrequency();
        if (this.getInputType() == ObservingFrequency.FrequencyType.SKY_FREQUENCY) {
            return frequency.deepCopy();
        }
        return this.getSourceVelocity().dopplerShift(frequency);
    }

    @Override
    public Velocity getSourceVelocity() {
        try {
            TargetParameters targetParameters = this.ssp.getScienceGoal().getTargetParameters(this.targetIndex);
            return targetParameters.getSourceVelocity();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return Velocity.createVelocity();
        }
        catch (NullPointerException nullPointerException) {
            return Velocity.createVelocity();
        }
    }

    @Override
    public void setInputFrequency(Frequency frequency) {
        this.inputFrequency = frequency.deepCopy();
    }

    private void setScienceSpectralWindowInputType(boolean bl) {
        for (int i = 0; i < 4; ++i) {
            int n = this.ssp.getScienceSpectralWindowCount(i);
            for (int j = 0; j < n; ++j) {
                this.ssp.getScienceSpectralWindow(i, j).setIsSkyFrequency(bl);
            }
        }
    }

    @Override
    public void setInputType(ObservingFrequency.FrequencyType frequencyType) {
        this.inputType = frequencyType;
        this.updateSpectralWindowsForContinuum();
    }

    @Override
    public void setSourceVelocity(Velocity velocity) {
        throw new RuntimeException("This should not be used");
    }

    @Override
    public void setTargetIndex(int n) {
        if (this.targetIndex != n) {
            this.targetIndex = n;
        }
    }

    private void updateSpectralWindowsForContinuum() {
        try {
            this.ssp.updateSingleContinuumWindows(this.getInputFrequency(), this.getSourceVelocity(), this.getInputType(), this.ssp.getCorrPolarization());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

