/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.bo.Entity;
import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnitMap;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.observatorycharacteristics.capabilities.AlmaCapabilities;
import alma.observatorycharacteristics.policies.AlmaPolicies;
import alma.observatorycharacteristics.site.SiteCharacteristics;
import alma.obsprep.bo.BOInfo;
import alma.obsprep.bo.BOIntrospector;
import alma.obsprep.bo.BOPropertyDescriptor;
import alma.obsprep.bo.enumerations.CorrelatorType;
import alma.obsprep.bo.obsproject.AbstractScienceGoal;
import alma.obsprep.bo.obsproject.AbstractScienceSpectralWindow;
import alma.obsprep.bo.obsproject.Circle;
import alma.obsprep.bo.obsproject.DataProcessingParameters;
import alma.obsprep.bo.obsproject.Ellipse;
import alma.obsprep.bo.obsproject.ObsProgram;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.obsproject.ObsUnit;
import alma.obsprep.bo.obsproject.ObsUnitSet;
import alma.obsprep.bo.obsproject.OpticalPointingScienceGoal;
import alma.obsprep.bo.obsproject.Polygon;
import alma.obsprep.bo.obsproject.Rectangle;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.ScienceSpectralWindow;
import alma.obsprep.bo.obsproject.SpectralScan;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.bo.schedblock.AbstractBaseBandConfig;
import alma.obsprep.bo.schedblock.AbstractCorrelatorConfiguration;
import alma.obsprep.bo.schedblock.AmplitudeCalParameters;
import alma.obsprep.bo.schedblock.BLCorrelatorConfiguration;
import alma.obsprep.bo.schedblock.BLSpectralWindow;
import alma.obsprep.bo.schedblock.BandpassCalParameters;
import alma.obsprep.bo.schedblock.ChannelAverageRegion;
import alma.obsprep.bo.schedblock.FieldPattern;
import alma.obsprep.bo.schedblock.FieldSource;
import alma.obsprep.bo.schedblock.FillPattern;
import alma.obsprep.bo.schedblock.FocusCalParameters;
import alma.obsprep.bo.schedblock.FrequencySetup;
import alma.obsprep.bo.schedblock.PhaseCalParameters;
import alma.obsprep.bo.schedblock.PointingCalParameters;
import alma.obsprep.bo.schedblock.PointingPattern;
import alma.obsprep.bo.schedblock.PolarizationCalParameters;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.bo.schedblock.RectanglePattern;
import alma.obsprep.bo.schedblock.Reference;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.ScienceParameters;
import alma.obsprep.bo.schedblock.SourceProperty;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.defaulters.CircularDependencyException;
import alma.obsprep.guiutil.mvc.View;
import alma.obsprep.ot.persistence.ImpexFactory;
import alma.obsprep.ot.valdef.obsproposal.ObsProposalValidator;
import alma.obsprep.ot.valdef.schedblock.DefReceiverType;
import alma.obsprep.services.calibration.CalObsProperties;
import alma.obsprep.services.experts.Configuration;
import alma.obsprep.services.experts.ReceiverExpert;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.SchedBlockWorker;
import alma.obsprep.services.generator.refactored.ScienceGoalSchedBlockGenerator;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGeneratorTemplate;
import alma.obsprep.util.MiscUtils;
import alma.valuetypes.Angle;
import alma.valuetypes.Frequency;
import alma.valuetypes.Latitude;
import alma.valuetypes.Longitude;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.Time;
import alma.valuetypes.UserFrequency;
import alma.valuetypes.Velocity;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.IntrospectionException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Filter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import junit.framework.Assert;
import org.apache.commons.lang3.StringUtils;

public class TestUtilities {
    private static int counter_ = -1;
    private static Counter spCounter = new Counter(0, 4, 1);
    private static Counter prCounter = new Counter(1, 5, 1);
    private static Counter bbcCounter = new Counter(0, SpectralSpec.maxBaseBandCount(), 1);
    private static Counter cabCounter = new Counter(1, AbstractBaseBandConfig.maxChannelAverageRegionCount(), 2);
    private static Counter subCounter = new Counter(0, AbstractBaseBandConfig.maxSpectralWindowCount(), 3);
    private static Counter recbCounter = new Counter(0, FrequencySetup.getKnownReceiverBandList().length - 2, 1);
    private static Counter recfCounter = new Counter(0, FrequencySetup.getKnownReceiverBandList().length, 1);
    private static Counter camCounter = new Counter(0, AbstractCorrelatorConfiguration.getKnownCAMList().length - 1, 1);
    private static Counter apcCounter = new Counter(0, AbstractCorrelatorConfiguration.getKnownAPCDataSetsList().length - 1, 1);
    private static Counter tgtCounter = new Counter(1000000, 1);
    private static Counter anyCounter = new Counter(1000000, 1);
    private static Counter srCounter = new Counter(1, 4, 1);
    private static Counter bwCounter = new Counter(1, 8, 1);
    private static Counter fuCounter = null;
    private static Object[] fu = null;
    private static Counter sauCounter = null;
    private static Object[] sau = null;
    private static Counter flCounter = null;
    private static Object[] fl = null;
    private static Counter latCounter = null;
    private static Object[] lat = null;
    private static Counter lonCounter = null;
    private static Object[] lon = null;
    private static Counter speedCounter = null;
    private static Object[] speed = null;
    private static Counter temperatureCounter = null;
    private static Object[] temperature = null;
    private static Counter sensitivityCounter = null;
    private static Object[] sensitivity = null;
    private static Counter refCounter = null;
    private static Object[] ref = null;
    private static Counter sysCounter = null;
    private static Object[] sys = null;
    private static Counter itsCounter = null;
    private static Object[] its = null;
    private static Counter itrCounter = null;
    private static Object[] itr = null;
    private static Counter prjCounter = null;
    private static Object[] prj = null;
    private static Counter lenCounter = null;
    private static Object[] len = null;
    private static List<Prune> pruneBasic = Arrays.asList(new Prune("\\s+([\\w:]+=\"[^\"]*\")", " $1"));
    public static List<Prune> pruneEntityIds = Arrays.asList(new Prune(" entityId=\\S+", ""), new Prune(" entityPartId=\\S+", ""));
    private static LogFilter logfilter = new LogFilter();
    private static String telescope = null;

    public static OpticalPointingScienceGoal generateOPW(String string) {
        OpticalPointingScienceGoal opticalPointingScienceGoal = OpticalPointingScienceGoal.createOpticalPointingScienceGoal();
        opticalPointingScienceGoal.setSchedBlockName(string);
        return opticalPointingScienceGoal;
    }

    public static ScienceGoal generateSFW(int n, int n2, int n3) {
        ScienceGoal scienceGoal = ScienceGoal.createScienceGoal();
        TestUtilities.fill(scienceGoal, n, n2, n3);
        return scienceGoal;
    }

    public static TargetParameters generateSFTarget() {
        TargetParameters targetParameters = TargetParameters.createTargetParameters();
        TestUtilities.fill(targetParameters);
        return targetParameters;
    }

    public static SpectralSetupParameters generateSFSpectral(int n, int n2, int n3) {
        SpectralSetupParameters spectralSetupParameters = SpectralSetupParameters.createSpectralSetupParameters();
        TestUtilities.fill(spectralSetupParameters, n, n2, n3);
        if (n2 > 0 || n + n2 + n3 > 1) {
            spectralSetupParameters.setType(SpectralSetupParameters.TYPE_FULL);
        } else if (n == 1) {
            spectralSetupParameters.setType(SpectralSetupParameters.TYPE_CONTINUUM);
        } else {
            spectralSetupParameters.setType(SpectralSetupParameters.TYPE_SCAN);
        }
        return spectralSetupParameters;
    }

    public static ScienceSpectralWindow generateSpectralLine() {
        ScienceSpectralWindow scienceSpectralWindow = ScienceSpectralWindow.createScienceSpectralWindow();
        TestUtilities.fill(scienceSpectralWindow);
        return scienceSpectralWindow;
    }

    public static SpectralScan generateSpectralScan() {
        SpectralScan spectralScan = SpectralScan.createSpectralScan();
        TestUtilities.fill(spectralScan);
        return spectralScan;
    }

    public static File getTestDirectory() {
        return new File(TestUtilities.getBaseDirectory(), "test");
    }

    public static File getBaseDirectory() {
        File file = MiscUtils.getBaseDirectory();
        if (file == null) {
            File file2 = new File(System.getProperty("user.dir"));
            throw new RuntimeException("can't figure out base directory. you are here: " + file2);
        }
        return file;
    }

    public static File getValidProjectsDirectory() {
        File file = TestUtilities.getBaseDirectory();
        if (file.getName().contains("ObservingTool")) {
            return new File(file, "test/alma/obsprep/testbed/validprojects");
        }
        return new File(file, "../ObservingTool/test/alma/obsprep/testbed/validprojects");
    }

    public static File getProjectsDirectory() {
        File file = TestUtilities.getBaseDirectory();
        if (file.getName().contains("ObservingTool")) {
            return new File(file, "test/alma/obsprep/testbed/projects");
        }
        return new File(file, "../ObservingTool/test/alma/obsprep/testbed/projects");
    }

    public static ObsProject importStandardLibrary() {
        TestUtilities.suppressLogs(ImpexFactory.class, Level.INFO, null);
        String string = "config/OTStandardLibrary.aot";
        URL uRL = MiscUtils.findResource(null, string);
        if (uRL == null) {
            uRL = MiscUtils.findResource(null, "../" + string);
        }
        ObsProject obsProject = null;
        try {
            obsProject = ImpexFactory.importObsProject(uRL);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return obsProject;
    }

    public static Circle createCircle(String string, double d, double d2, double d3) {
        Circle circle = Circle.createCircle();
        Latitude latitude = Latitude.createLatitude();
        Longitude longitude = Longitude.createLongitude();
        Angle angle = Angle.createAngle();
        SkyCoordinates skyCoordinates = SkyCoordinates.createSkyCoordinates();
        longitude.setName(string + "_long");
        longitude.setUnit(longitude.defaultUnit());
        longitude.setContent(d);
        latitude.setName(string + "_lat");
        latitude.setUnitToDefault();
        latitude.setContent(d2);
        angle.setName(string + "_radius");
        angle.setUnitToDefault();
        angle.setContent(d3);
        circle.setName(string);
        circle.setRadius(angle);
        skyCoordinates.setLatitude(latitude);
        skyCoordinates.setLongitude(longitude);
        circle.setCentre(skyCoordinates);
        return circle;
    }

    public static Rectangle createRectangle(String string, double d, double d2, double d3, double d4, double d5) {
        Rectangle rectangle = Rectangle.createRectangle();
        Latitude latitude = Latitude.createLatitude();
        Longitude longitude = Longitude.createLongitude();
        Angle angle = Angle.createAngle();
        Angle angle2 = Angle.createAngle();
        Angle angle3 = Angle.createAngle();
        longitude.setName(string + "_lat");
        longitude.setUnit(longitude.defaultUnit());
        longitude.setContent(d);
        latitude.setName(string + "_long");
        latitude.setUnitToDefault();
        latitude.setContent(d2);
        angle.setName(string + "_width");
        angle.setUnitToDefault();
        angle.setContent(d3);
        angle2.setName(string + "_hieght");
        angle2.setUnitToDefault();
        angle2.setContent(d4);
        angle3.setName(string + "_angle");
        angle3.setUnitToDefault();
        angle3.setContent(d5);
        rectangle.setName(string);
        rectangle.getCentre().setLongitude(longitude);
        rectangle.getCentre().setLatitude(latitude);
        rectangle.setLong(angle);
        rectangle.setShort(angle2);
        rectangle.setPALong(angle3);
        return rectangle;
    }

    public static Ellipse createEllipse(String string, double d, double d2, double d3, double d4, double d5) {
        Ellipse ellipse = Ellipse.createEllipse();
        Latitude latitude = Latitude.createLatitude();
        Longitude longitude = Longitude.createLongitude();
        Angle angle = Angle.createAngle();
        Angle angle2 = Angle.createAngle();
        Angle angle3 = Angle.createAngle();
        longitude.setName(string + "_lat");
        longitude.setUnit(longitude.defaultUnit());
        longitude.setContent(d);
        latitude.setName(string + "_long");
        latitude.setUnitToDefault();
        latitude.setContent(d2);
        angle.setName(string + "_major");
        angle.setUnitToDefault();
        angle.setContent(d3);
        angle2.setName(string + "_minor");
        angle2.setUnitToDefault();
        angle2.setContent(d4);
        angle3.setName(string + "_angle");
        angle3.setUnitToDefault();
        angle3.setContent(d5);
        ellipse.setName(string);
        ellipse.getCentre().setLongitude(longitude);
        ellipse.getCentre().setLatitude(latitude);
        ellipse.setSemiMajor(angle);
        ellipse.setSemiMinor(angle2);
        ellipse.setPAMajor(angle3);
        return ellipse;
    }

    public static Polygon createPolygon(String string, double d, double d2, double d3, int n) {
        Polygon polygon = Polygon.createPolygon();
        Latitude latitude = Latitude.createLatitude();
        Longitude longitude = Longitude.createLongitude();
        double d4 = d3 / 3600.0;
        double d5 = d4 / 15.0;
        longitude.setName(string + "_lat");
        longitude.setUnit(longitude.defaultUnit());
        longitude.setContent(d);
        latitude.setName(string + "_long");
        latitude.setUnitToDefault();
        latitude.setContent(d2);
        for (int i = 0; i < n; ++i) {
            Latitude latitude2 = Latitude.createLatitude();
            Longitude longitude2 = Longitude.createLongitude();
            SkyCoordinates skyCoordinates = SkyCoordinates.createSkyCoordinates();
            double d6 = (double)(2 * i) * Math.PI / (double)n;
            latitude2.setContent(longitude.getContent() + d5 * Math.cos(d6));
            longitude2.setContent(latitude.getContent() + d4 * Math.sin(d6));
            skyCoordinates.setLatitude(latitude2);
            skyCoordinates.setLongitude(longitude2);
            polygon.addPoint(i, skyCoordinates);
        }
        polygon.setName(string);
        return polygon;
    }

    public static void fill(ObsUnit obsUnit, String string, ObsProject obsProject) {
        obsUnit.setName(string);
        obsUnit.setObsProject(obsProject);
    }

    private static String frequencyUnit() {
        if (fuCounter == null) {
            fu = UnitMap.getFrequencyUnits().getUnitsSorted();
            fuCounter = new Counter(0, fu.length - 1, 1);
        }
        int n = fuCounter.next();
        return (String)fu[n];
    }

    private static String AngleUnit() {
        if (sauCounter == null) {
            sau = UnitMap.getAngleUnits().getUnitsSorted();
            sauCounter = new Counter(0, sau.length - 1, 1);
        }
        int n = sauCounter.next();
        return (String)sau[n];
    }

    private static String fluxUnit() {
        if (flCounter == null) {
            fl = UnitMap.getFluxUnits().getUnitsSorted();
            flCounter = new Counter(0, fl.length - 1, 1);
        }
        int n = flCounter.next();
        return (String)fl[n];
    }

    private static String latitudeUnit() {
        if (latCounter == null) {
            lat = UnitMap.getLatitudeUnits().getUnitsSorted();
            latCounter = new Counter(0, lat.length - 1, 1);
        }
        int n = latCounter.next();
        return (String)lat[n];
    }

    private static String longitudeUnit() {
        if (lonCounter == null) {
            lon = UnitMap.getLongitudeUnits().getUnitsSorted();
            lonCounter = new Counter(0, lon.length - 1, 1);
        }
        int n = lonCounter.next();
        return (String)lon[n];
    }

    private static String speedUnit() {
        if (speedCounter == null) {
            speed = UnitMap.getSpeedUnits().getUnitsSorted();
            speedCounter = new Counter(0, speed.length - 1, 1);
        }
        int n = speedCounter.next();
        return (String)speed[n];
    }

    private static String temperatureUnit() {
        if (temperatureCounter == null) {
            temperature = UnitMap.getTemperatureUnits().getUnitsSorted();
            temperatureCounter = new Counter(0, temperature.length - 1, 1);
        }
        int n = temperatureCounter.next();
        return (String)temperature[n];
    }

    private static String sensitivityUnit() {
        if (sensitivityCounter == null) {
            sensitivity = UnitMap.getSensitivityUnits().getUnitsSorted();
            sensitivityCounter = new Counter(0, sensitivity.length - 1, 1);
        }
        int n = sensitivityCounter.next();
        return (String)sensitivity[n];
    }

    private static String referenceSystem() {
        if (refCounter == null) {
            ref = Velocity.getKnownReferenceSystemList();
            refCounter = new Counter(0, ref.length - 1, 1);
        }
        int n = refCounter.next();
        return (String)ref[n];
    }

    private static String systemType() {
        if (sysCounter == null) {
            sys = SkyCoordinates.getKnownSystemList();
            sysCounter = new Counter(0, sys.length - 1, 1);
        }
        int n = sysCounter.next();
        return (String)sys[n];
    }

    private static String intTimeSourceUnit() {
        if (itsCounter == null) {
            its = UnitMap.getIntTimeSourceUnits().getUnitsSorted();
            itsCounter = new Counter(0, its.length - 1, 1);
        }
        int n = itsCounter.next();
        return (String)its[n];
    }

    private static String intTimeReferenceUnit() {
        if (itrCounter == null) {
            itr = UnitMap.getIntTimeReferenceUnits().getUnitsSorted();
            itrCounter = new Counter(0, itr.length - 1, 1);
        }
        int n = itrCounter.next();
        return (String)itr[n];
    }

    private static String projectType() {
        if (prjCounter == null) {
            prj = DataProcessingParameters.getKnownProjectTypeList();
            prjCounter = new Counter(0, prj.length - 1, 1);
        }
        int n = prjCounter.next();
        return (String)prj[n];
    }

    private static String lengthUnit() {
        if (lenCounter == null) {
            len = UnitMap.getLengthUnits().getUnitsSorted();
            lenCounter = new Counter(0, len.length - 1, 1);
        }
        int n = lenCounter.next();
        return (String)len[n];
    }

    private static Frequency observableFrequency(boolean bl) {
        String string = bl ? ReceiverBand.getKnownReceiverBandNames()[recbCounter.next()] : ReceiverBand.getKnownReceiverBandNames()[recbCounter.last()];
        ReceiverBand receiverBand = ReceiverBand.getReceiverBand(string);
        int n = recfCounter.next() + 1;
        int n2 = recfCounter.size() + 1;
        double d = receiverBand.getRFMin();
        double d2 = receiverBand.getRFMax() - d;
        Log.logger(TestUtilities.class).finest(String.format("observableFrequency(%n\tBand %s, %d/%d, %f + %f = %f)", receiverBand, n, n2, d, d2 * (double)n / (double)n2, d + d2 * (double)n / (double)n2));
        return Frequency.createFrequencyGHZ(d + d2 * (double)n / (double)n2);
    }

    private static Frequency observableFrequency() {
        return TestUtilities.observableFrequency(true);
    }

    private static UserFrequency spectralResolution() {
        return UserFrequency.createUserFrequencyGHZ(0.5 * (double)srCounter.next());
    }

    private static UserFrequency bandwidth() {
        return UserFrequency.createUserFrequencyGHZ(0.25 * (double)bwCounter.next());
    }

    public static void fill(SpectralSpec spectralSpec) {
        FrequencySetup frequencySetup = FrequencySetup.createFrequencySetup();
        Frequency frequency = Frequency.createFrequency();
        frequencySetup.setReceiverBand(FrequencySetup.getKnownReceiverBandList()[recbCounter.next()]);
        frequencySetup.setTransitionName(anyCounter.nextString());
        frequency.setContent(anyCounter.next());
        frequency.setUnit(TestUtilities.frequencyUnit());
        frequencySetup.setRestFrequency(frequency);
        spectralSpec.setFrequencySetup(frequencySetup);
        BLCorrelatorConfiguration bLCorrelatorConfiguration = BLCorrelatorConfiguration.createBLCorrelatorConfiguration();
        bLCorrelatorConfiguration.setAPCDataSets(AbstractCorrelatorConfiguration.getKnownAPCDataSetsList()[apcCounter.next()]);
        bLCorrelatorConfiguration.setCAM(AbstractCorrelatorConfiguration.getKnownCAMList()[camCounter.next()]);
        spectralSpec.setCorrelatorConfiguration((AbstractCorrelatorConfiguration)((Object)bLCorrelatorConfiguration));
        for (int i = bbcCounter.next(); i > 0; --i) {
            AbstractBaseBandConfig abstractBaseBandConfig = spectralSpec.addNewBaseBand().getBaseBandConfig();
            for (int j = subCounter.next(); j > 0; --j) {
                BLSpectralWindow bLSpectralWindow = BLSpectralWindow.createBLSpectralWindow();
                Frequency frequency2 = Frequency.createFrequency();
                frequency2.setContent(anyCounter.next());
                frequency2.setUnit(TestUtilities.frequencyUnit());
                bLSpectralWindow.setCenterFrequency(frequency2);
                bLSpectralWindow.setSpectralAveragingFactor(anyCounter.next());
                abstractBaseBandConfig.addSpectralWindow(bLSpectralWindow);
                for (int k = cabCounter.next(); k > 0; --k) {
                    ChannelAverageRegion channelAverageRegion = ChannelAverageRegion.createChannelAverageRegion();
                    channelAverageRegion.setStartChannel(anyCounter.next());
                    channelAverageRegion.setNumberChannels(anyCounter.next());
                    bLSpectralWindow.addChannelAverageRegion(channelAverageRegion);
                }
            }
        }
    }

    public static void fill(SourceProperty sourceProperty) {
        sourceProperty.getSourceFrequency().setContent(anyCounter.next());
        sourceProperty.getSourceFrequency().setUnit(TestUtilities.frequencyUnit());
        sourceProperty.getSourceFluxI().setContent(anyCounter.next());
        sourceProperty.getSourceFluxI().setUnit(TestUtilities.fluxUnit());
        sourceProperty.getSourceFluxQ().setContent(anyCounter.next());
        sourceProperty.getSourceFluxQ().setUnit(TestUtilities.fluxUnit());
        sourceProperty.getSourceFluxU().setContent(anyCounter.next());
        sourceProperty.getSourceFluxU().setUnit(TestUtilities.fluxUnit());
        sourceProperty.getSourceFluxV().setContent(anyCounter.next());
        sourceProperty.getSourceFluxV().setUnit(TestUtilities.fluxUnit());
        sourceProperty.getSourceDiameter().setContent(anyCounter.next());
        sourceProperty.getSourceDiameter().setUnit(TestUtilities.AngleUnit());
    }

    public static void fillFieldSource(FieldSource fieldSource, int n, int n2) {
        TestUtilities.fill(fieldSource, n);
        SkyCoordinates skyCoordinates = SkyCoordinates.createSkyCoordinates();
        Reference reference = Reference.createReference();
        Time time = Time.createTime();
        Time time2 = Time.createTime();
        TestUtilities.fill(skyCoordinates);
        time.setContent(anyCounter.next());
        time.setUnit(TestUtilities.intTimeReferenceUnit());
        time2.setContent(anyCounter.next());
        time2.setUnit(TestUtilities.intTimeSourceUnit());
        reference.setReferenceCoordinates(skyCoordinates);
        reference.setIntegrationTime(time);
        reference.setCycleTime(time2);
        fieldSource.addReference(reference);
        fieldSource.addReference(reference.deepCopy());
        if (n2 < 0) {
            for (int i = 1; i < -n2; ++i) {
                PointingPattern pointingPattern = PointingPattern.createPointingPattern();
                skyCoordinates = SkyCoordinates.createSkyCoordinates();
                TestUtilities.fill(skyCoordinates);
                pointingPattern.addPhaseCenterCoordinates(skyCoordinates);
                skyCoordinates = SkyCoordinates.createSkyCoordinates();
                TestUtilities.fill(skyCoordinates);
                pointingPattern.addPhaseCenterCoordinates(skyCoordinates);
                pointingPattern.setType(FieldPattern.TYPE_POINT);
                fieldSource.setFieldPattern((FieldPattern)((Object)pointingPattern));
            }
        } else {
            for (int i = 1; i <= n2; ++i) {
                PointingPattern pointingPattern = PointingPattern.createPointingPattern();
                skyCoordinates = SkyCoordinates.createSkyCoordinates();
                TestUtilities.fill(skyCoordinates);
                pointingPattern.addPhaseCenterCoordinates(skyCoordinates);
                skyCoordinates = SkyCoordinates.createSkyCoordinates();
                TestUtilities.fill(skyCoordinates);
                pointingPattern.addPhaseCenterCoordinates(skyCoordinates);
                pointingPattern.setType(FieldPattern.TYPE_POINT);
                fieldSource.setFieldPattern((FieldPattern)((Object)pointingPattern));
            }
        }
    }

    public static void fill(SkyCoordinates skyCoordinates) {
        skyCoordinates.getLatitude().setContent(anyCounter.next());
        skyCoordinates.getLatitude().setUnit(TestUtilities.latitudeUnit());
        skyCoordinates.getLongitude().setContent(anyCounter.next());
        skyCoordinates.getLongitude().setUnit(TestUtilities.longitudeUnit());
        skyCoordinates.setSystem(TestUtilities.systemType());
    }

    public static void fillVelocity(Velocity velocity) {
        velocity.getCenterVelocity().setContent(anyCounter.next());
        velocity.getCenterVelocity().setUnit(TestUtilities.speedUnit());
        velocity.setReferenceSystem(TestUtilities.referenceSystem());
    }

    public static void fill(FieldSource fieldSource, int n) {
        fieldSource.setSourceName("Source " + tgtCounter.next());
        TestUtilities.fill(fieldSource.getSourceCoordinates());
        Velocity velocity = Velocity.createVelocity();
        TestUtilities.fillVelocity(velocity);
        fieldSource.setSourceVelocity(velocity);
        for (int i = 0; i < n; ++i) {
            SourceProperty sourceProperty = SourceProperty.createSourceProperty();
            TestUtilities.fill(sourceProperty);
            fieldSource.addSourceProperty(sourceProperty);
        }
    }

    public static void fill(Target target, int n, int n2) {
        SchedBlock schedBlock = target.getSchedBlock();
        FieldSource fieldSource = schedBlock.createFieldSource();
        TestUtilities.fillFieldSource(fieldSource, n, n2);
        target.setFieldSource(fieldSource);
        SpectralSpec spectralSpec = schedBlock.createSpectralSpec();
        TestUtilities.fill(spectralSpec);
        target.setSpectralSpec(spectralSpec);
    }

    public static void fill(SchedBlock schedBlock, String string, int n, ObsProject obsProject) {
        Object object;
        String string2;
        int n2 = 1;
        TestUtilities.fill((ObsUnit)((Object)schedBlock), "SB " + string, obsProject);
        schedBlock.getPreconditions().getWeatherConstraints().getMaxPWVC().setUnit(TestUtilities.lengthUnit());
        while (n >= 1000000) {
            string2 = string + "_Obs" + n2;
            Target target = schedBlock.createTarget();
            object = schedBlock.createScienceParameters();
            object.setName(string2);
            target.addScienceParameters((ScienceParameters)((Object)object));
            TestUtilities.fill(target, spCounter.next(), prCounter.next());
            n -= 1000000;
            ++n2;
        }
        while (n >= 100000) {
            string2 = string + "_PhC" + n2;
            Target target = schedBlock.createTarget();
            object = schedBlock.createPhaseCalParameters();
            object.setName(string2);
            target.addPhaseCalParameters((PhaseCalParameters)((Object)object));
            TestUtilities.fill(target, spCounter.next(), -prCounter.next());
            n -= 100000;
            ++n2;
        }
        while (n >= 10000) {
            string2 = string + "_PoC" + n2;
            Target target = schedBlock.createTarget();
            object = schedBlock.createPointingCalParameters();
            object.setName(string2);
            target.addPointingCalParameters((PointingCalParameters)((Object)object));
            TestUtilities.fill(target, spCounter.next(), -prCounter.next());
            n -= 10000;
            ++n2;
        }
        while (n >= 1000) {
            string2 = string + "_AmC" + n2;
            Target target = schedBlock.createTarget();
            object = schedBlock.createAmplitudeCalParameters();
            object.setName(string2);
            target.addAmplitudeCalParameters((AmplitudeCalParameters)((Object)object));
            TestUtilities.fill(target, spCounter.next(), -prCounter.next());
            n -= 1000;
            ++n2;
        }
        while (n >= 100) {
            string2 = string + "_PlC" + n2;
            Target target = schedBlock.createTarget();
            object = schedBlock.createPolarizationCalParameters();
            object.setName(string2);
            target.addPolarizationCalParameters((PolarizationCalParameters)((Object)object));
            TestUtilities.fill(target, spCounter.next(), -prCounter.next());
            n -= 100;
            ++n2;
        }
        while (n >= 10) {
            string2 = string + "_FoC" + n2;
            Target target = schedBlock.createTarget();
            object = schedBlock.createFocusCalParameters();
            object.setName(string2);
            target.addFocusCalParameters((FocusCalParameters)((Object)object));
            TestUtilities.fill(target, spCounter.next(), -prCounter.next());
            n -= 10;
            ++n2;
        }
        while (n >= 1) {
            string2 = string + "_BaC" + n2;
            Target target = schedBlock.createTarget();
            object = schedBlock.createBandpassCalParameters();
            object.setName(string2);
            target.addBandpassCalParameters((BandpassCalParameters)((Object)object));
            TestUtilities.fill(target, spCounter.next(), -prCounter.next());
            --n;
            ++n2;
        }
    }

    public static void fill(ObsUnitSet obsUnitSet, String string, Collection collection, ObsProject obsProject) {
        TestUtilities.fill((ObsUnit)((Object)obsUnitSet), "OUS " + string, obsProject);
        TestUtilities.fill(obsUnitSet.getDataProcessingParameters());
        Iterator iterator = collection.iterator();
        int n = 1;
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e.getClass() == Integer.class) {
                int n2 = (Integer)e;
                for (int i = 1; i <= n2; ++i) {
                    int n3 = (Integer)iterator.next();
                    SchedBlock schedBlock = TestUtilities.generateSB(string + "_" + i, n3, obsProject);
                    obsUnitSet.addSchedBlock(schedBlock);
                }
                continue;
            }
            ObsUnitSet obsUnitSet2 = TestUtilities.generateOUS(string + "_" + n, (Collection)e, obsProject);
            ++n;
            obsUnitSet.addObsUnitSet(obsUnitSet2);
        }
    }

    public static void fillLibraryExample(ObsUnitSet obsUnitSet, String string, Collection collection, ObsProject obsProject) {
        TestUtilities.fill((ObsUnit)((Object)obsUnitSet), "Template " + string, obsProject);
        TestUtilities.fill(obsUnitSet.getDataProcessingParameters());
        Iterator iterator = collection.iterator();
        int n = 1;
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e.getClass() == Integer.class) {
                int n2 = (Integer)e;
                for (int i = 1; i <= n2; ++i) {
                    int n3 = (Integer)iterator.next();
                    SchedBlock schedBlock = TestUtilities.generateSB("ExampleMode_" + i, n3, obsProject);
                    obsUnitSet.addSchedBlock(schedBlock);
                }
                continue;
            }
            String string2 = "ExampleMode_" + n;
            if (n == 2) {
                string2 = "SingleFieldMap";
            }
            ObsUnitSet obsUnitSet2 = TestUtilities.generateOUSLibrary(string2, (Collection)e, obsProject);
            ++n;
            obsUnitSet.addObsUnitSet(obsUnitSet2);
        }
    }

    private static void fill(ScienceGoal scienceGoal, int n, int n2, int n3) {
        scienceGoal.setTargetParameters(TestUtilities.generateSFTarget());
        scienceGoal.setSpectralSetupParameters(TestUtilities.generateSFSpectral(n, n2, n3));
    }

    private static void fill(TargetParameters targetParameters) {
    }

    private static void fill(SpectralSetupParameters spectralSetupParameters, int n, int n2, int n3) {
        while (n2-- > 0) {
            spectralSetupParameters.addAbstractScienceSpectralWindow((AbstractScienceSpectralWindow)((Object)TestUtilities.generateSpectralLine()));
        }
        while (n3-- > 0) {
            spectralSetupParameters.addAbstractScienceSpectralWindow((AbstractScienceSpectralWindow)((Object)TestUtilities.generateSpectralScan()));
        }
    }

    private static void fill(ScienceSpectralWindow scienceSpectralWindow) {
        scienceSpectralWindow.setCenterFrequency(TestUtilities.observableFrequency());
        scienceSpectralWindow.setTransitionName("t_" + anyCounter.nextString());
        scienceSpectralWindow.setBandWidth(TestUtilities.bandwidth());
        scienceSpectralWindow.setSpectralResolution(TestUtilities.spectralResolution());
    }

    private static void fill(SpectralScan spectralScan) {
        spectralScan.setStartFrequency(TestUtilities.observableFrequency());
        spectralScan.setEndFrequency(TestUtilities.observableFrequency(false));
    }

    private static void fill(DataProcessingParameters dataProcessingParameters) {
        dataProcessingParameters.getAngularResolution().setContent(anyCounter.next());
        dataProcessingParameters.getAngularResolution().setUnit(TestUtilities.AngleUnit());
        TestUtilities.fillVelocity(dataProcessingParameters.getVelocityResolution());
        dataProcessingParameters.getTBSensitivityGoal().setContent(anyCounter.next());
        dataProcessingParameters.getTBSensitivityGoal().setUnit(TestUtilities.temperatureUnit());
        dataProcessingParameters.getRMSGoal().setContent(anyCounter.next());
        dataProcessingParameters.getRMSGoal().setUnit(TestUtilities.sensitivityUnit());
        dataProcessingParameters.setProjectType(TestUtilities.projectType());
    }

    public static void fill(ObsProgram obsProgram, String string, Collection collection, ObsProject obsProject) {
        TestUtilities.fill(obsProgram.getObsPlan(), string, collection, obsProject);
    }

    public static void fillLibraryExample(ObsProgram obsProgram, String string, Collection collection, ObsProject obsProject) {
        TestUtilities.fillLibraryExample(obsProgram.getObsPlan(), string, collection, obsProject);
    }

    public static SchedBlock generateSB(String string, int n, ObsProject obsProject) {
        SchedBlock schedBlock = null;
        schedBlock = SchedBlock.createSchedBlock();
        TestUtilities.fill(schedBlock, string, n, obsProject);
        return schedBlock;
    }

    public static ObsUnitSet generateOUS(String string, Collection collection, ObsProject obsProject) {
        ObsUnitSet obsUnitSet = null;
        obsUnitSet = ObsUnitSet.createObsUnitSet();
        TestUtilities.fill(obsUnitSet, string, collection, obsProject);
        return obsUnitSet;
    }

    public static ObsUnitSet generateOUSLibrary(String string, Collection collection, ObsProject obsProject) {
        ObsUnitSet obsUnitSet = null;
        obsUnitSet = ObsUnitSet.createObsUnitSet();
        TestUtilities.fillLibraryExample(obsUnitSet, string, collection, obsProject);
        return obsUnitSet;
    }

    public static void print(ObsProgram obsProgram) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("BEGIN ObsProgram(");
        stringBuffer.append(obsProgram.getName());
        stringBuffer.append(")\n");
        stringBuffer.append("END ObsProgram(");
        stringBuffer.append(obsProgram.getName());
        stringBuffer.append(")\n");
        Log.logger(TestUtilities.class).info(stringBuffer.toString());
    }

    public static void print(ObsUnitSet obsUnitSet, String string, StringBuffer stringBuffer) throws UnknownEntityException {
        stringBuffer.append(string);
        stringBuffer.append("BEGIN ObsUnitSet(");
        stringBuffer.append(obsUnitSet.getName());
        stringBuffer.append(")\n");
        SchedBlock[] schedBlockArray = obsUnitSet.getSchedBlock();
        for (int i = 0; i < schedBlockArray.length; ++i) {
            TestUtilities.print(schedBlockArray[i], string + "   ", stringBuffer);
        }
        stringBuffer.append(string);
        stringBuffer.append("END ObsUnitSet(");
        stringBuffer.append(obsUnitSet.getName());
        stringBuffer.append(")\n");
    }

    public static void print(SchedBlock schedBlock, String string, StringBuffer stringBuffer) {
    }

    public static void print(Target target, String string, StringBuffer stringBuffer) {
        stringBuffer.append(string);
        stringBuffer.append("BEGIN Target(");
        stringBuffer.append(target.getName());
        stringBuffer.append(")\n");
        stringBuffer.append(string);
        TestUtilities.print(target.getSpectralSpec(), string + "   ", stringBuffer);
        TestUtilities.print(target.getFieldSource(), string + "   ", stringBuffer);
        TestUtilities.print(target.getFieldSource().getFieldPattern(), string + "   ", stringBuffer);
        stringBuffer.append(string);
        stringBuffer.append("END Target(");
        stringBuffer.append(target.getName());
        stringBuffer.append(")\n");
        Log.logger(TestUtilities.class).info(stringBuffer.toString());
    }

    public static void print(SpectralSpec spectralSpec, String string, StringBuffer stringBuffer) {
        stringBuffer.append(string);
        stringBuffer.append("SpectralSpec(");
        stringBuffer.append(spectralSpec.getName());
        stringBuffer.append(")\n");
    }

    public static void print(FieldPattern fieldPattern, String string, StringBuffer stringBuffer) {
        stringBuffer.append(string);
        stringBuffer.append("BEGIN FieldPattern(");
        stringBuffer.append(fieldPattern.getName());
        stringBuffer.append(")\n");
        if (fieldPattern instanceof FillPattern) {
            stringBuffer.append(string);
            stringBuffer.append("-- Phase Centre\n");
            TestUtilities.print(((FillPattern)((Object)fieldPattern)).getPatternCenterCoordinates(), string + "   ", stringBuffer);
        }
        if (fieldPattern instanceof RectanglePattern) {
            stringBuffer.append(string);
            stringBuffer.append("-- Phase Centre\n");
            TestUtilities.print(((RectanglePattern)((Object)fieldPattern)).getPatternCenterCoordinates(), string + "   ", stringBuffer);
        }
        if (fieldPattern instanceof PointingPattern) {
            for (int i = 0; i < ((PointingPattern)((Object)fieldPattern)).getPhaseCenterCoordinatesCount(); ++i) {
                stringBuffer.append(string);
                stringBuffer.append("-- Pointing " + i + "\n");
                TestUtilities.print(((PointingPattern)((Object)fieldPattern)).getPhaseCenterCoordinates()[i], string + "   ", stringBuffer);
            }
        }
        stringBuffer.append(string);
        stringBuffer.append("-- Type = ");
        stringBuffer.append(fieldPattern.getType());
        stringBuffer.append("\n");
        stringBuffer.append(string);
        stringBuffer.append("END FieldPattern(");
        stringBuffer.append(fieldPattern.getName());
        stringBuffer.append(")\n");
    }

    public static void print(FieldSource fieldSource, String string, StringBuffer stringBuffer) {
        stringBuffer.append(string);
        stringBuffer.append("BEGIN FieldSource(");
        stringBuffer.append(fieldSource.getName());
        stringBuffer.append(")\n");
        stringBuffer.append(string);
        stringBuffer.append("-- Source Name = ");
        stringBuffer.append(fieldSource.getSourceName());
        stringBuffer.append("\n");
        stringBuffer.append(string);
        stringBuffer.append("-- SourceCoordinates\n");
        TestUtilities.print(fieldSource.getSourceCoordinates(), string + "   ", stringBuffer);
        stringBuffer.append(string);
        stringBuffer.append("-- SourceVelocity\n");
        TestUtilities.print(fieldSource.getSourceVelocity(), string + "   ", stringBuffer);
        stringBuffer.append(string);
        stringBuffer.append("-- SourceEphemeris = ");
        stringBuffer.append(fieldSource.getSourceEphemeris());
        stringBuffer.append("\n");
        stringBuffer.append(string);
        stringBuffer.append("-- PMRA\n");
        TestUtilities.print((ValueUnitPair)fieldSource.getPMRA(), string + "   ", stringBuffer);
        stringBuffer.append(string);
        stringBuffer.append("-- PMDec\n");
        TestUtilities.print((ValueUnitPair)fieldSource.getPMDec(), string + "   ", stringBuffer);
        stringBuffer.append(string);
        stringBuffer.append("-- NonSiderealMotion = ");
        stringBuffer.append(fieldSource.getNonSiderealMotion());
        stringBuffer.append("\n");
        stringBuffer.append(string);
        stringBuffer.append("-- SolarSytemObject = ");
        stringBuffer.append(fieldSource.getSolarSystemObject());
        stringBuffer.append("\n");
        stringBuffer.append(string);
        stringBuffer.append("-- Source Properties\n");
        int n = fieldSource.getSourcePropertyCount();
        for (int i = 0; i < n; ++i) {
            SourceProperty sourceProperty = fieldSource.getSourceProperty(i);
            TestUtilities.print(sourceProperty, string + "   ", stringBuffer);
        }
        stringBuffer.append(string);
        stringBuffer.append("END FieldSource(");
        stringBuffer.append(fieldSource.getName());
        stringBuffer.append(")\n");
        Log.logger(TestUtilities.class).info(stringBuffer.toString());
    }

    public static void print(SourceProperty sourceProperty, String string, StringBuffer stringBuffer) {
        stringBuffer.append(string);
        stringBuffer.append("BEGIN SourceProperty(");
        stringBuffer.append(sourceProperty.getName());
        stringBuffer.append(")\n");
        stringBuffer.append(string);
        stringBuffer.append("-- Source Diameter = ");
        stringBuffer.append((Object)sourceProperty.getSourceDiameter());
        stringBuffer.append("\n");
        stringBuffer.append(string);
        stringBuffer.append("-- Source Flux I = ");
        stringBuffer.append((Object)sourceProperty.getSourceFluxI());
        stringBuffer.append("\n");
        stringBuffer.append(string);
        stringBuffer.append("-- Source Flux Q = ");
        stringBuffer.append((Object)sourceProperty.getSourceFluxQ());
        stringBuffer.append("\n");
        stringBuffer.append(string);
        stringBuffer.append("-- Source Flux U = ");
        stringBuffer.append((Object)sourceProperty.getSourceFluxU());
        stringBuffer.append("\n");
        stringBuffer.append(string);
        stringBuffer.append("-- Source Flux V = ");
        stringBuffer.append((Object)sourceProperty.getSourceFluxV());
        stringBuffer.append("\n");
        stringBuffer.append(string);
        stringBuffer.append("-- Source Frequency = ");
        stringBuffer.append((Object)sourceProperty.getSourceFrequency());
        stringBuffer.append("\n");
        stringBuffer.append(string);
        stringBuffer.append("END SourceProperty(");
        stringBuffer.append(sourceProperty.getName());
        stringBuffer.append(")\n");
    }

    public static void print(SkyCoordinates skyCoordinates, String string, StringBuffer stringBuffer) {
        stringBuffer.append(string);
        stringBuffer.append("SkyCoordinates[" + skyCoordinates.getType() + "]");
        stringBuffer.append("\n");
    }

    public static void print(Velocity velocity, String string, StringBuffer stringBuffer) {
        stringBuffer.append(string);
        stringBuffer.append("-- Centre velocity = ");
        stringBuffer.append((Object)velocity.getCenterVelocity());
        stringBuffer.append("\n");
        stringBuffer.append(string);
        stringBuffer.append("-- Reference System = ");
        stringBuffer.append(velocity.getReferenceSystem());
        stringBuffer.append("\n");
    }

    public static void print(ValueUnitPair valueUnitPair, String string, StringBuffer stringBuffer) {
        stringBuffer.append(string);
        stringBuffer.append("ValueUnitPair(");
        stringBuffer.append(valueUnitPair.getContent());
        stringBuffer.append(" ");
        stringBuffer.append(valueUnitPair.getUnit());
        stringBuffer.append(")\n");
    }

    public static void print(Rectangle rectangle, String string, StringBuffer stringBuffer) {
        stringBuffer.append(string);
        stringBuffer.append("BEGIN Rectangle_SB(");
        stringBuffer.append(rectangle.getName());
        stringBuffer.append(")\n");
        stringBuffer.append(string);
        stringBuffer.append("END Rectangle_SB(");
        stringBuffer.append(rectangle.getName());
        stringBuffer.append(")\n");
    }

    public static void print(RectanglePattern rectanglePattern, String string, StringBuffer stringBuffer) {
        stringBuffer.append(string);
        stringBuffer.append("BEGIN Rectangle_SB(");
        stringBuffer.append(rectanglePattern.getName());
        stringBuffer.append(")\n");
        stringBuffer.append(string);
        stringBuffer.append("END Rectangle_SB(");
        stringBuffer.append(rectanglePattern.getName());
        stringBuffer.append(")\n");
    }

    public static String toString(Collection<?> collection) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "";
        stringBuffer.append("[");
        for (Object obj : collection) {
            stringBuffer.append(string);
            stringBuffer.append(obj).append("(@").append(obj.hashCode()).append(")");
            string = ", ";
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public static int newNumber() {
        return ++counter_;
    }

    public static boolean newBoolean() {
        return (++counter_ & 1) == 0;
    }

    public static String newString() {
        return ":" + TestUtilities.newNumber() + ":";
    }

    public static void populate(AbstractDoubleWithUnit abstractDoubleWithUnit) {
        abstractDoubleWithUnit.setName(TestUtilities.newString());
        abstractDoubleWithUnit.setContent((double)TestUtilities.newNumber());
    }

    public static void populate(DataProcessingParameters dataProcessingParameters) {
        String[] stringArray = new String[]{DataProcessingParameters.PROJECTTYPE_CONTINUUM, DataProcessingParameters.PROJECTTYPE_POLARIZATION, DataProcessingParameters.PROJECTTYPE_OTHER};
        dataProcessingParameters.setProjectType(stringArray[TestUtilities.newNumber() % stringArray.length]);
    }

    public static void populate(AbstractBaseBandConfig abstractBaseBandConfig) {
    }

    public static void populate(Velocity velocity) {
        if (velocity.getReferenceSystem() == null) {
            velocity.setReferenceSystem(Velocity.REFERENCESYSTEM_LSRK);
        }
    }

    public static boolean equalEntities(Entity entity, Entity entity2) {
        return entity.getEntityID().equals(entity2.getEntityID());
    }

    private static void pruneDbg(String string) {
    }

    public static String pruneXml(String string, List<Prune> ... listArray) {
        string = StringUtils.remove((String)string, (String)"\n");
        string = StringUtils.replace((String)string, (String)">", (String)">\n", (int)-1);
        for (Prune prune : pruneBasic) {
            string = prune.pattern.matcher(string).replaceAll(prune.replacement);
        }
        for (List<Prune> list : listArray) {
            for (Prune prune : list) {
                string = prune.pattern.matcher(string).replaceAll(prune.replacement);
            }
        }
        return string;
    }

    public static void assertEqualsXml(String string, BusinessObject businessObject, BusinessObject businessObject2, List<Prune> ... listArray) {
        TestUtilities.assertEqualsXml(string, businessObject.toXml(), businessObject2.toXml(), listArray);
    }

    public static void assertEqualsXml(String string, String string2, String string3, List<Prune> ... listArray) {
        String string4 = TestUtilities.pruneXml(string2, listArray);
        String string5 = TestUtilities.pruneXml(string3, listArray);
        Assert.assertEquals((String)string, (String)string4, (String)string5);
    }

    public static void assertEqualsIgnoreOrder(Collection<?> collection, Collection<?> collection2) {
        Assert.assertEquals((int)collection.size(), (int)collection2.size());
        Assert.assertTrue((boolean)collection.containsAll(collection2));
        Assert.assertTrue((boolean)collection2.containsAll(collection));
    }

    public static void populate(BusinessObject businessObject) throws Exception {
        BOInfo bOInfo = null;
        try {
            bOInfo = BOIntrospector.getBOInfo(businessObject.getClass());
        }
        catch (IntrospectionException introspectionException) {
            introspectionException.printStackTrace();
            throw new RuntimeException(introspectionException);
        }
        Method[] methodArray = TestUtilities.getSetters(bOInfo);
        Object[] objectArray = new Object[1];
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            Class<?> clazz = method.getParameterTypes()[0];
            if (clazz == Boolean.TYPE) {
                objectArray[0] = new Boolean(TestUtilities.newBoolean());
            } else if (clazz.isPrimitive()) {
                objectArray[0] = new Integer(TestUtilities.newNumber());
            } else {
                if (clazz != String.class) continue;
                objectArray[0] = TestUtilities.newString();
            }
            if (Modifier.isStatic(method.getModifiers())) continue;
            try {
                method.invoke((Object)businessObject, objectArray);
                continue;
            }
            catch (InvocationTargetException invocationTargetException) {
                if (invocationTargetException.getCause() instanceof IllegalArgumentException) {
                    try {
                        method.invoke((Object)businessObject, TestUtilities.getKnownItem(businessObject, bOInfo.getProperties()[i].getName()));
                        continue;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                    }
                    catch (InvocationTargetException invocationTargetException2) {
                        // empty catch block
                    }
                    System.out.println("TestUtilities: sorry, i'm not smart enough to make up a mock-value for " + businessObject.getClass().getSimpleName() + "#" + method.getName());
                    continue;
                }
                invocationTargetException.printStackTrace(System.err);
            }
        }
    }

    private static String getKnownItem(BusinessObject businessObject, String string) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String string2 = BOPropertyDescriptor.makeMethodName("getKnown", string) + "List";
        Method method = businessObject.getClass().getMethod(string2, null);
        String[] stringArray = (String[])method.invoke((Object)businessObject, (Object[])null);
        int n = TestUtilities.newNumber() % stringArray.length;
        return stringArray[n];
    }

    private static void populateVUP(ValueUnitPair valueUnitPair) throws Exception {
        Class<?> clazz = valueUnitPair.getClass();
        Method method = null;
        String string = null;
        try {
            string = "getKnownUnitList";
            method = clazz.getMethod(string, null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return;
        }
        String[] stringArray = (String[])method.invoke(clazz, (Object[])null);
        int n = TestUtilities.newNumber() % stringArray.length;
        valueUnitPair.setUnit(stringArray[n]);
        valueUnitPair.setContent((double)counter_);
    }

    public static void yaPopulate(BusinessObject businessObject) throws Exception {
        BOPropertyDescriptor[] bOPropertyDescriptorArray;
        BOInfo bOInfo = null;
        try {
            bOInfo = BOIntrospector.getBOInfo(businessObject.getClass());
        }
        catch (IntrospectionException introspectionException) {
            introspectionException.printStackTrace();
            throw new RuntimeException(introspectionException);
        }
        for (BOPropertyDescriptor bOPropertyDescriptor : bOPropertyDescriptorArray = bOInfo.getProperties()) {
            BusinessObject businessObject2;
            Method method;
            Class<?> clazz = bOPropertyDescriptor.getPropertyType();
            if (AbstractDoubleWithUnit.class.isAssignableFrom(clazz)) {
                method = bOPropertyDescriptor.getReadMethod();
                TestUtilities.populateVUP((ValueUnitPair)method.invoke((Object)businessObject, (Object[])null));
                continue;
            }
            if (BusinessObject.class.isAssignableFrom(clazz)) {
                method = bOPropertyDescriptor.getReadMethod();
                if (method.getReturnType().isArray() || (businessObject2 = (BusinessObject)method.invoke((Object)businessObject, (Object[])null)) == null) continue;
                TestUtilities.populate(businessObject2);
                continue;
            }
            if (clazz == String.class) {
                method = bOPropertyDescriptor.getWriteMethod();
                try {
                    method.invoke((Object)businessObject, TestUtilities.newString());
                }
                catch (InvocationTargetException invocationTargetException) {
                    try {
                        String string = TestUtilities.getKnownItem(businessObject, bOPropertyDescriptor.getName());
                        method.invoke((Object)businessObject, string);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        System.out.println("TestUtilities : sorry, i'm not smart enough to make up a mock-value for " + bOPropertyDescriptor.getPropertyType().getSimpleName() + "," + bOPropertyDescriptor.getWriteMethod().getName());
                        System.out.println(noSuchMethodException.getClass().getSimpleName() + " : bo = " + businessObject + ", message = " + noSuchMethodException.getMessage());
                    }
                }
                continue;
            }
            if (bOPropertyDescriptor.isPrimitive()) {
                businessObject2 = new Object[1];
                if (clazz == Boolean.TYPE) {
                    businessObject2[0] = Boolean.valueOf(TestUtilities.newNumber() % 2 == 0);
                } else if (clazz == Integer.TYPE || clazz == Double.TYPE) {
                    businessObject2[0] = Integer.valueOf(TestUtilities.newNumber());
                }
                method = bOPropertyDescriptor.getWriteMethod();
                method.invoke((Object)businessObject, (Object[])businessObject2);
                continue;
            }
            System.out.println("TestUtilities[ya2] : sorry, i'm not smart enough to make up a mock-value for " + bOPropertyDescriptor.getPropertyType().getSimpleName() + "," + bOPropertyDescriptor.getWriteMethod().getName());
        }
    }

    private static Method[] getSetters(BOInfo bOInfo) {
        Vector<Method> vector = new Vector<Method>();
        BOPropertyDescriptor[] bOPropertyDescriptorArray = bOInfo.getProperties();
        for (int i = 0; i < bOPropertyDescriptorArray.length; ++i) {
            BOPropertyDescriptor bOPropertyDescriptor = bOPropertyDescriptorArray[i];
            vector.add(bOPropertyDescriptor.getWriteMethod());
        }
        Method[] methodArray = vector.toArray(new Method[0]);
        return methodArray;
    }

    public static String getCanonicalPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException iOException) {
            return file.getAbsolutePath();
        }
    }

    public static boolean isBusinessObject(Object object) {
        return TestUtilities.isBusinessObject(object.getClass());
    }

    public static boolean isBusinessObject(Class<?> clazz) {
        return BusinessObject.class.isAssignableFrom(clazz);
    }

    public static boolean isEntity(Class<?> clazz) {
        return Entity.class.isAssignableFrom(clazz);
    }

    public static void sleep(int n) {
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    public static void displayFrame(JComponent jComponent, boolean bl) {
        JFrame jFrame = new JFrame("TestUtilities");
        int n = bl ? 3 : 2;
        jFrame.setDefaultCloseOperation(n);
        jFrame.add(jComponent);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public static void pressEnterToContinue() {
        System.out.println("Press <Enter> to continue");
        try {
            while (System.in.read() != 13) {
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static boolean isHeadless() {
        try {
            Toolkit.getDefaultToolkit();
            return false;
        }
        catch (Throwable throwable) {
            return true;
        }
    }

    public static ObsProject makeObsProject() {
        ObsProject obsProject = ObsProject.createObsProject();
        ObsProgram obsProgram = ObsProgram.createObsProgram();
        ObsProposal obsProposal = ObsProposal.createObsProposal();
        obsProject.setObsProgram(obsProgram);
        obsProject.setObsProposal(obsProposal);
        return obsProject;
    }

    public static ObsProject makeObsProjectWithSBs(int n, int n2) {
        ObsProject obsProject = TestUtilities.makeObsProject();
        ObsUnitSet obsUnitSet = ObsUnitSet.createObsUnitSet();
        for (int i = 0; i < n; ++i) {
            ObsUnitSet obsUnitSet2 = ObsUnitSet.createObsUnitSet();
            obsUnitSet.addObsUnitSet(i, obsUnitSet2);
            for (int j = 0; j < n2; ++j) {
                SchedBlock schedBlock = SchedBlock.createSchedBlock();
                obsUnitSet2.addSchedBlock(schedBlock);
            }
        }
        obsProject.getObsProgram().setObsPlan(obsUnitSet);
        return obsProject;
    }

    public static SpectralSpec getNewSpectralSpec(CorrelatorType correlatorType) {
        SpectralSpec spectralSpec;
        SchedBlock schedBlock = SchedBlock.createSchedBlock();
        switch (correlatorType) {
            case ACA: {
                spectralSpec = SpectralSpec.createSpectralSpecWithACACorrelatorConfiguration();
                break;
            }
            case BL: {
                spectralSpec = SpectralSpec.createSpectralSpecWithBLCorrelatorConfiguration();
                break;
            }
            default: {
                throw new RuntimeException("Unexpected CorrType : " + (Object)((Object)correlatorType));
            }
        }
        schedBlock.addSpectralSpec(spectralSpec);
        try {
            new DefReceiverType(spectralSpec, null);
        }
        catch (CircularDependencyException circularDependencyException) {
            circularDependencyException.printStackTrace();
        }
        return spectralSpec;
    }

    public static String checkCompleteness(BusinessObject businessObject) {
        return TestUtilities.checkCompleteness(businessObject, null);
    }

    public static String checkCompleteness(BusinessObject businessObject, String[] stringArray) {
        BOInfo bOInfo = null;
        try {
            bOInfo = BOIntrospector.getBOInfo(businessObject.getClass());
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
        BOPropertyDescriptor[] bOPropertyDescriptorArray = bOInfo.getProperties();
        for (int i = 0; i < bOPropertyDescriptorArray.length; ++i) {
            Object object;
            BOPropertyDescriptor bOPropertyDescriptor = bOPropertyDescriptorArray[i];
            if (bOPropertyDescriptor.isPrimitive()) continue;
            if (stringArray != null) {
                boolean bl = false;
                for (int j = 0; j < stringArray.length; ++j) {
                    if (!stringArray[j].equals(bOPropertyDescriptor.getName())) continue;
                    bl = true;
                }
                if (bl) continue;
            }
            Method method = bOPropertyDescriptor.getReadMethod();
            String string = method.getName();
            try {
                object = method.invoke((Object)businessObject, (Object[])null);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                String string2 = string + "(): " + exception;
                return string2;
            }
            if (object != null) continue;
            String string3 = businessObject.getClass().getName() + "." + string + "() returned null";
            return string3;
        }
        return null;
    }

    public static void suppressLogs(Class<?> clazz, Level level, String string) {
        logfilter.add(clazz.getName(), level, string);
        ((Logger)Log.logger(clazz)).setFilter(logfilter);
    }

    public static void suppressLogsReset() {
        logfilter.reset();
    }

    public static String setSystemProperty(String string, String string2) {
        if (string2 == null) {
            return System.clearProperty(string);
        }
        return System.setProperty(string, string2);
    }

    public static void setTelescopeToALMA() {
        telescope = TestUtilities.setTelescopeTo("ALMA");
    }

    public static void revertTelescope() {
        TestUtilities.setTelescopeTo(telescope);
    }

    public static String setTelescopeTo(String string) {
        boolean bl;
        String string2 = System.getProperty("Telescope");
        boolean bl2 = string == null ? string2 == null : (bl = string.equals(string2));
        if (!bl) {
            TestUtilities.setSystemProperty("Telescope", string);
            SiteCharacteristics.refreshCharacteristics();
            AlmaCapabilities.refreshCapabilities();
            ReceiverExpert.refresh();
            AlmaPolicies.refreshPolicies();
            ObsProposalValidator.refreshLimits();
            CalObsProperties.refresh();
            Configuration.refreshArrayConfigurations();
        }
        return string2;
    }

    public static void runTestApp(View view, int n, int n2) {
        JFrame jFrame = new JFrame(view.getClass().getSimpleName());
        if (n > 0 && n2 > 0) {
            jFrame.setPreferredSize(new Dimension(n, n2));
        }
        jFrame.setDefaultCloseOperation(3);
        Container container = jFrame.getContentPane();
        container.setLayout(new BoxLayout(container, 3));
        container.add(new JScrollPane(view));
        JButton jButton = new JButton("DebugPrint");
        class DebugPrintButtonListener
        implements ActionListener {
            Object document;

            public DebugPrintButtonListener(Object object) {
                this.document = object;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                System.out.println(this.document.toString());
            }
        }
        jButton.addActionListener(new DebugPrintButtonListener(view.getModel().getDocument()));
        container.add(jButton);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public static void runTestApp(View view) {
        TestUtilities.runTestApp(view, -1, -1);
    }

    public static ObsProject loadProjectFile(String string) throws UnableToLoadProjectException {
        Object object;
        File file = TestUtilities.getProjectsDirectory();
        URL uRL = null;
        try {
            object = new File(file + "/" + string);
            uRL = ((File)object).toURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            throw new UnableToLoadProjectException("Project " + string + " could not be loaded : ", malformedURLException);
        }
        object = null;
        try {
            object = ImpexFactory.importObsProject(uRL, false);
        }
        catch (Exception exception) {
            throw new UnableToLoadProjectException("Project " + string + " could not be loaded : ", exception);
        }
        return object;
    }

    public static ScienceGoal loadProjectAndGetScienceGoal(String string, int n) throws UnableToFetchScienceGoalException {
        ObsProject obsProject;
        try {
            obsProject = TestUtilities.loadProjectFile(string);
        }
        catch (UnableToLoadProjectException unableToLoadProjectException) {
            throw new UnableToFetchScienceGoalException(unableToLoadProjectException);
        }
        ScienceGoal scienceGoal = TestUtilities.getScienceGoalFromObsProject(obsProject, n);
        assert (scienceGoal != null);
        return scienceGoal;
    }

    public static ScienceGoal getScienceGoalFromObsProject(ObsProject obsProject, int n) throws UnableToFetchScienceGoalException {
        ScienceGoal scienceGoal = null;
        if (obsProject == null) {
            throw new IllegalArgumentException("obsProject is null");
        }
        if (n < 0) {
            throw new IllegalArgumentException("scienceGoalIndex must be a positive integer");
        }
        try {
            if (obsProject.getObsProposal().getAbstractScienceGoalCount() > 0 && n < obsProject.getObsProposal().getAbstractScienceGoalCount()) {
                if (!(obsProject.getObsProposal().getAbstractScienceGoal()[n] instanceof ScienceGoal)) {
                    throw new UnableToFetchScienceGoalException("Unable to find science goal in project");
                }
                scienceGoal = (ScienceGoal)((Object)obsProject.getObsProposal().getAbstractScienceGoal()[n]);
            }
        }
        catch (UnknownEntityException unknownEntityException) {
            // empty catch block
        }
        if (scienceGoal == null && obsProject.getObsProgram().getAbstractScienceGoalCount() > 0 && n < obsProject.getObsProgram().getAbstractScienceGoalCount()) {
            if (!(obsProject.getObsProgram().getAbstractScienceGoal()[n] instanceof ScienceGoal)) {
                throw new UnableToFetchScienceGoalException("Unable to find science goal in obs program");
            }
            scienceGoal = (ScienceGoal)((Object)obsProject.getObsProgram().getAbstractScienceGoal()[n]);
        }
        if (scienceGoal == null) {
            throw new UnableToFetchScienceGoalException("Unable to find requested science goal with index " + n + " in project");
        }
        return scienceGoal;
    }

    public static ObsProject loadProjectAndGenerateAllSBs(String string, Boolean bl) throws UnableToLoadProjectException {
        int n;
        Object object;
        File file = TestUtilities.getProjectsDirectory();
        URL uRL = null;
        try {
            object = new File(file + "/" + string);
            uRL = ((File)object).toURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            throw new UnableToLoadProjectException("Unable to open the test file ", malformedURLException);
        }
        object = null;
        try {
            object = ImpexFactory.importObsProject(uRL, false);
        }
        catch (Exception exception) {
            throw new UnableToLoadProjectException("Unable to open test file : ", exception);
        }
        ScienceGoal scienceGoal = null;
        try {
            n = bl != false ? object.getObsProgram().getAbstractScienceGoalCount() : object.getObsProposal().getAbstractScienceGoalCount();
        }
        catch (UnknownEntityException unknownEntityException) {
            throw new UnableToLoadProjectException("Unable to determine the number of science goals in the project");
        }
        for (int i = 0; i < n; ++i) {
            if (bl.booleanValue()) {
                scienceGoal = (ScienceGoal)((Object)object.getObsProgram().getAbstractScienceGoal()[i]);
            } else {
                try {
                    scienceGoal = (ScienceGoal)((Object)object.getObsProposal().getAbstractScienceGoal()[i]);
                }
                catch (UnknownEntityException unknownEntityException) {
                    throw new UnableToLoadProjectException("Unable to access the science goal : " + unknownEntityException.getMessage());
                }
            }
            scienceGoal.setObsUnitSet(ObsUnitSet.createObsUnitSet());
            ScienceGoalSchedBlockGenerator scienceGoalSchedBlockGenerator = new ScienceGoalSchedBlockGenerator(scienceGoal, scienceGoal.getObsUnitSet(), false);
            try {
                scienceGoalSchedBlockGenerator.generate();
                continue;
            }
            catch (WizardSBGenerationException wizardSBGenerationException) {
                throw new UnableToLoadProjectException("Unable to generate SBs : " + wizardSBGenerationException.getMessage());
            }
        }
        return object;
    }

    public static ObsProject loadProjectAndGenerateSB(String string, Boolean bl, int n) throws UnableToLoadProjectException {
        Object object;
        File file = TestUtilities.getProjectsDirectory();
        URL uRL = null;
        try {
            object = new File(file + "/" + string);
            uRL = ((File)object).toURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            throw new UnableToLoadProjectException("Unable to open the test file ", malformedURLException);
        }
        object = null;
        try {
            object = ImpexFactory.importObsProject(uRL, false);
        }
        catch (Exception exception) {
            throw new UnableToLoadProjectException("Unable to open test file : ", exception);
        }
        ScienceGoal scienceGoal = null;
        if (!bl.booleanValue()) {
            try {
                if (!(object.getObsProposal().getAbstractScienceGoal()[n] instanceof ScienceGoal)) {
                    throw new UnableToLoadProjectException("Unable to find science goal in project");
                }
            }
            catch (UnknownEntityException unknownEntityException) {
                throw new UnableToLoadProjectException("Unable to locate science goal in project");
            }
            try {
                scienceGoal = (ScienceGoal)((Object)object.getObsProposal().getAbstractScienceGoal()[n]);
            }
            catch (UnknownEntityException unknownEntityException) {
                throw new UnableToLoadProjectException("Unable to access the science goal : " + unknownEntityException.getMessage());
            }
            finally {
                if (scienceGoal == null) {
                    // empty if block
                }
            }
        }
        if (!(object.getObsProgram().getAbstractScienceGoal()[n] instanceof ScienceGoal)) {
            throw new UnableToLoadProjectException("Unable to find science goal in project");
        }
        scienceGoal = (ScienceGoal)((Object)object.getObsProgram().getAbstractScienceGoal()[n]);
        scienceGoal.setObsUnitSet(ObsUnitSet.createObsUnitSet());
        ScienceGoalSchedBlockGenerator scienceGoalSchedBlockGenerator = new ScienceGoalSchedBlockGenerator(scienceGoal, scienceGoal.getObsUnitSet(), false);
        try {
            scienceGoalSchedBlockGenerator.generate();
        }
        catch (WizardSBGenerationException wizardSBGenerationException) {
            throw new UnableToLoadProjectException("Unable to generate SBs : " + wizardSBGenerationException.getMessage());
        }
        return object;
    }

    public static void generateSBs(ObsProgram obsProgram, int n) throws UnableToGenerateSBException {
        if (obsProgram == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: obsProgram");
        }
        AbstractScienceGoal abstractScienceGoal = obsProgram.getAbstractScienceGoal(n);
        assert (abstractScienceGoal instanceof ScienceGoal);
        ScienceGoal scienceGoal = (ScienceGoal)((Object)abstractScienceGoal);
        scienceGoal.setObsUnitSet(ObsUnitSet.createObsUnitSet());
        ScienceGoalSchedBlockGenerator scienceGoalSchedBlockGenerator = new ScienceGoalSchedBlockGenerator(scienceGoal, scienceGoal.getObsUnitSet(), false);
        try {
            scienceGoalSchedBlockGenerator.generate();
        }
        catch (WizardSBGenerationException wizardSBGenerationException) {
            throw new UnableToGenerateSBException(wizardSBGenerationException);
        }
    }

    public static SchedBlock getSBFromObsProgram(ObsProgram obsProgram, int n, SBGeneratorTemplate.SchedBlockType schedBlockType) throws SchedBlockWorker.SBNotFoundException {
        AbstractScienceGoal abstractScienceGoal = obsProgram.getAbstractScienceGoal(n);
        assert (abstractScienceGoal instanceof ScienceGoal);
        ScienceGoal scienceGoal = (ScienceGoal)((Object)abstractScienceGoal);
        return SchedBlockWorker.findSBUnderScienceGoal(scienceGoal, schedBlockType);
    }

    private static class LogFilter
    implements Filter {
        ArrayList<Pattern> patterns = new ArrayList();

        private LogFilter() {
        }

        void add(String string, Level level, String string2) {
            Pattern pattern = new Pattern();
            pattern.level = level;
            pattern.cName = string;
            pattern.mName = string2;
            this.patterns.add(pattern);
        }

        void reset() {
            String string = "";
            for (Pattern pattern : this.patterns) {
                if (pattern.hitcount <= 0) continue;
                string = string + "\n  " + pattern.hitcount + " message(s) from class " + pattern.cName;
            }
            if (string.length() > 0) {
                System.out.println("Note: log messages from code under test were suppressed during this test:" + string);
            }
            this.patterns.clear();
        }

        @Override
        public boolean isLoggable(LogRecord logRecord) {
            for (Pattern pattern : this.patterns) {
                boolean bl;
                boolean bl2 = pattern.level == null ? true : pattern.level.intValue() >= logRecord.getLevel().intValue();
                boolean bl3 = bl = logRecord.getSourceClassName() == null ? false : logRecord.getSourceClassName().startsWith(pattern.cName);
                boolean bl4 = pattern.mName == null ? true : (logRecord.getSourceMethodName() == null ? false : logRecord.getSourceMethodName().startsWith(pattern.mName));
                if (!(bl2 & bl & bl4)) continue;
                ++pattern.hitcount;
                return false;
            }
            return true;
        }

        class Pattern {
            Level level;
            String cName;
            String mName;
            int hitcount;

            Pattern() {
            }
        }
    }

    public static class RepeatSequence
    implements Iterable<Repeat>,
    Iterator<Repeat> {
        private int left;
        private Repeat s;

        private RepeatSequence(int n) {
            this.left = n;
        }

        @Override
        public Iterator<Repeat> iterator() {
            this.s = new Repeat();
            return this;
        }

        @Override
        public boolean hasNext() {
            return !this.s.stop && this.left > 0;
        }

        @Override
        public Repeat next() {
            TestUtilities.sleep(1000);
            --this.left;
            return this.s;
        }

        @Override
        public void remove() {
        }
    }

    public static class Repeat {
        public boolean stop;

        public static RepeatSequence seconds(int n) {
            return new RepeatSequence(n);
        }
    }

    public static class Prune {
        private Pattern pattern;
        private String replacement;

        public Prune(String string, String string2) {
            this.pattern = Pattern.compile(string);
            this.replacement = string2;
        }
    }

    private static class Counter {
        private int min;
        private int max;
        private int step;
        private int count;

        public Counter(int n, int n2, int n3) {
            this.min = n;
            this.max = n2;
            this.step = n3;
            this.count = n2;
        }

        public Counter(int n, int n2) {
            this(1, n, n2);
        }

        public int next() {
            this.count += this.step;
            if (this.count > this.max) {
                this.count = this.min;
            }
            return this.count;
        }

        public int last() {
            return this.count;
        }

        public String nextString() {
            return String.valueOf(this.next());
        }

        public int size() {
            return (this.max + this.step - this.min) / this.step;
        }
    }

    public static class UnableToFetchScienceGoalException
    extends Exception {
        public UnableToFetchScienceGoalException(String string) {
            super(string);
        }

        public UnableToFetchScienceGoalException(Exception exception) {
            super(exception);
        }
    }

    public static class UnableToLoadProjectException
    extends Exception {
        public UnableToLoadProjectException(String string, Exception exception) {
            super(string, exception);
        }

        public UnableToLoadProjectException(String string) {
            super(string);
        }
    }

    public static class UnableToGenerateSBException
    extends Exception {
        public UnableToGenerateSBException(WizardSBGenerationException wizardSBGenerationException) {
        }
    }
}

