/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.enumerations;

import alma.observatorycharacteristics.capabilities.AlmaCapabilities;
import alma.obsprep.bo.enumerations.Antenna;
import alma.obsprep.bo.enumerations.ArrayType;
import alma.obsprep.bo.enumerations.CorrelatorType;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.data.ControlBlockData;
import alma.obsprep.bo.schedblock.AbstractCorrelatorConfiguration;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.valuetypes.Frequency;
import alma.valuetypes.Length;
import alma.valuetypes.UserAngle;

public enum Array {
    ARRAY_12M("12m Array      ", ControlBlockData.ARRAYREQUESTED_TWELVE_M, Antenna.ANTENNA_12M, ArrayType.INTERFEROMETRY, CorrelatorType.BL),
    ARRAY_7M("ACA 7m Array   ", ControlBlockData.ARRAYREQUESTED_SEVEN_M, Antenna.ANTENNA_7M, ArrayType.INTERFEROMETRY, CorrelatorType.ACA),
    ARRAY_TP("ACA Total Power", ControlBlockData.ARRAYREQUESTED_TP_ARRAY, Antenna.ANTENNA_12M, ArrayType.SINGLEDISH, CorrelatorType.ACA);

    public final String label;
    public final String name;
    public final Antenna antenna;
    public final ArrayType type;
    public final CorrelatorType correlator;
    public static final double ACA7M_BASELINE_M = 30.0;
    public static final double ACA7M_BASELINE_MIN = 8.9;

    private Array(String string2, String string3, Antenna antenna, ArrayType arrayType, CorrelatorType correlatorType) {
        this.label = string2;
        this.name = string3;
        this.antenna = antenna;
        this.type = arrayType;
        this.correlator = correlatorType;
    }

    public static Array getArray(String string) {
        for (Array array : Array.values()) {
            if (!array.label.equals(string) && !array.name.equals(string)) continue;
            return array;
        }
        return null;
    }

    public int getNominalNumberOfAntennas() {
        return AlmaCapabilities.getInstance().getNominalNumAntennas(this);
    }

    public int getNumberAntennas(AbstractCorrelatorConfiguration abstractCorrelatorConfiguration) {
        return AlmaCapabilities.getInstance().getNumAntennas(this, abstractCorrelatorConfiguration);
    }

    public int getNumberAntennas(SpectralSetupParameters spectralSetupParameters) {
        return AlmaCapabilities.getInstance().getNumAntennas(this, spectralSetupParameters);
    }

    public int getNumberAntennasForDataRates(SpectralSetupParameters spectralSetupParameters) throws ReceiverBand.ReceiverNotFoundException {
        return AlmaCapabilities.getInstance().getNumAntennasForDataRates(this, spectralSetupParameters);
    }

    public boolean isInterferometry() {
        return this.type.isInterferometry();
    }

    public String toString() {
        return this.label;
    }

    public static UserAngle syntheticBeamsize(Frequency frequency, Length length) {
        return UserAngle.arcAngle(frequency.getWavelength(), length);
    }

    public static Array getArray(String string, String string2) {
        if (Array.getArray(string) == null && Array.getArray(string2) == null) {
            return null;
        }
        if (Array.getArray(string) == null && Array.getArray(string2) != null) {
            return Array.getArray(string2);
        }
        if (Array.getArray(string) != null && Array.getArray(string2) == null) {
            return Array.getArray(string);
        }
        if (Array.getArray(string) == Array.getArray(string2)) {
            return Array.getArray(string);
        }
        return null;
    }

    public int getNumberAntennasForDataRates(AbstractCorrelatorConfiguration abstractCorrelatorConfiguration) throws ReceiverBand.ReceiverNotFoundException {
        return AlmaCapabilities.getInstance().getNumAntennasForDataRates(this, abstractCorrelatorConfiguration);
    }
}

