/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.enumerations;

import alma.obsprep.bo.enumerations.Array;
import alma.obsprep.bo.obsproject.data.ControlBlockData;
import alma.obsprep.bo.schedblock.AbstractCorrelatorConfiguration;
import alma.obsprep.bo.schedblock.ReceiverBand;

public enum ArrayRequested {
    TWELVE_M(ControlBlockData.ARRAYREQUESTED_TWELVE_M, 50),
    SEVEN_M(ControlBlockData.ARRAYREQUESTED_SEVEN_M, 12),
    TP_ARRAY(ControlBlockData.ARRAYREQUESTED_TP_ARRAY, 4),
    ACA(ControlBlockData.ARRAYREQUESTED_ACA, 16);

    private String name;
    private int maxAntennas;

    private ArrayRequested(String string2, int n2) {
        this.name = string2;
        this.maxAntennas = n2;
    }

    public static ArrayRequested getArrayRequested(String string) {
        for (ArrayRequested arrayRequested : ArrayRequested.values()) {
            if (!arrayRequested.name.equals(string)) continue;
            return arrayRequested;
        }
        return null;
    }

    public int getNumAntennas(AbstractCorrelatorConfiguration abstractCorrelatorConfiguration) {
        if (this == ACA) {
            return SEVEN_M.getNumAntennas(abstractCorrelatorConfiguration) + TP_ARRAY.getNumAntennas(abstractCorrelatorConfiguration);
        }
        return Array.getArray(this.name).getNumberAntennas(abstractCorrelatorConfiguration);
    }

    public int getNumAntennasForDataRates(AbstractCorrelatorConfiguration abstractCorrelatorConfiguration) throws ReceiverBand.ReceiverNotFoundException {
        if (this == ACA) {
            return SEVEN_M.getNumAntennasForDataRates(abstractCorrelatorConfiguration) + TP_ARRAY.getNumAntennasForDataRates(abstractCorrelatorConfiguration);
        }
        return Array.getArray(this.name).getNumberAntennasForDataRates(abstractCorrelatorConfiguration);
    }

    public int getMaxAntennas() {
        return this.maxAntennas;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this == ACA ? this.name : Array.getArray(this.name).toString();
    }
}

