/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.enumerations;

import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.schedblock.AbstractSpectralWindow;
import alma.obsprep.bo.schedblock.ConfigModeDecoder;

public enum CorrPolarization {
    SINGLE_X("XX", 1, 1, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, AbstractSpectralWindow.POLNPRODUCTS_XX, SpectralSetupParameters.POLARISATION_SINGLE_X, "Correlator delivers XX"),
    SINGLE_Y("YY", 1, 1, ConfigModeDecoder.ePolarization.POLZ_SINGLE_Y, AbstractSpectralWindow.POLNPRODUCTS_YY, SpectralSetupParameters.POLARISATION_SINGLE_Y, "Correlator delivers YY"),
    DOUBLE("DUAL", 2, 2, ConfigModeDecoder.ePolarization.POLZ_DOUBLE, AbstractSpectralWindow.POLNPRODUCTS_XX_YY, SpectralSetupParameters.POLARISATION_DOUBLE, "Correlator delivers XX and YY - usually required"),
    FULL("FULL", 4, 2, ConfigModeDecoder.ePolarization.POLZ_FULL, AbstractSpectralWindow.POLNPRODUCTS_XX_YY_XY_YX, SpectralSetupParameters.POLARISATION_FULL, "<html>Correlator delivers XX, YY, XY and YX - allows polarization images to be made.</html>");

    public String label;
    private int polnCount;
    private int polnObsCount;
    public final ConfigModeDecoder.ePolarization epolarization;
    public final String polnProducts;
    public final String polarization;
    public final String tooltip;

    private CorrPolarization(String string2, int n2, int n3, ConfigModeDecoder.ePolarization ePolarization2, String string3, String string4, String string5) {
        this.label = string2;
        this.polnCount = n2;
        this.polnObsCount = n3;
        this.epolarization = ePolarization2;
        this.polnProducts = string3;
        this.polarization = string4;
        this.tooltip = string5;
    }

    public int getProductsCount() {
        return this.polnCount;
    }

    public int getObsCount() {
        return this.polnObsCount;
    }

    public static CorrPolarization getCorrPolarization(String string) {
        for (CorrPolarization corrPolarization : CorrPolarization.values()) {
            if (!corrPolarization.epolarization.name().equals(string) && !corrPolarization.label.equals(string) && !corrPolarization.polnProducts.equals(string) && !corrPolarization.polarization.equals(string)) continue;
            return corrPolarization;
        }
        return null;
    }

    public static CorrPolarization getCorrPolarization(ConfigModeDecoder.ePolarization ePolarization2) {
        for (CorrPolarization corrPolarization : CorrPolarization.values()) {
            if (corrPolarization.epolarization != ePolarization2) continue;
            return corrPolarization;
        }
        return null;
    }

    public static String[] getLabels() {
        String[] stringArray = new String[CorrPolarization.values().length];
        int n = 0;
        for (CorrPolarization corrPolarization : CorrPolarization.values()) {
            stringArray[n++] = corrPolarization.label;
        }
        return stringArray;
    }

    public static String[] getTooltips() {
        String[] stringArray = new String[CorrPolarization.values().length];
        int n = 0;
        for (CorrPolarization corrPolarization : CorrPolarization.values()) {
            stringArray[n++] = corrPolarization.tooltip;
        }
        return stringArray;
    }
}

