/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.enumerations;

import alma.obsprep.bo.schedblock.SpectralSpec;
import java.util.HashMap;
import java.util.Map;

public enum SideBandUse {
    SIDEBANDUSE_NONE("NONE", 0),
    SIDEBANDUSE_LSB("LSB", 1),
    SIDEBANDUSE_USB("USB", 2),
    SIDEBANDUSE_BOTH("BOTH", 3);

    static Map<String, SideBandUse> map;
    private String label;
    private int status;

    private SideBandUse(String string2, int n2) {
        this.label = string2;
        this.status = n2;
    }

    public String toString() {
        return this.label;
    }

    public static SideBandUse getSideBandUse(String string) {
        return map.get(string);
    }

    public static SideBandUse getSideBandUse(boolean bl, boolean bl2) {
        int n = (bl ? SideBandUse.SIDEBANDUSE_LSB.status : 0) | (bl2 ? SideBandUse.SIDEBANDUSE_USB.status : 0);
        return SideBandUse.values()[n];
    }

    public SideBandUse enableLSB(boolean bl) {
        return SideBandUse.values()[this.status & SideBandUse.SIDEBANDUSE_USB.status | (bl ? SideBandUse.SIDEBANDUSE_LSB.status : 0)];
    }

    public SideBandUse enableUSB(boolean bl) {
        return SideBandUse.values()[this.status & SideBandUse.SIDEBANDUSE_LSB.status | (bl ? SideBandUse.SIDEBANDUSE_USB.status : 0)];
    }

    public SideBandUse switchSideBand() {
        switch (this) {
            case SIDEBANDUSE_LSB: 
            case SIDEBANDUSE_USB: {
                return SideBandUse.values()[~this.status & SideBandUse.SIDEBANDUSE_BOTH.status];
            }
        }
        return this;
    }

    public boolean usesLSB() {
        return (this.status & SideBandUse.SIDEBANDUSE_LSB.status) > 0;
    }

    public boolean usesUSB() {
        return (this.status & SideBandUse.SIDEBANDUSE_USB.status) > 0;
    }

    public boolean uses(SpectralSpec.SideBand sideBand) {
        return sideBand == SpectralSpec.SideBand.LSB ? this.usesLSB() : this.usesUSB();
    }

    static {
        map = new HashMap<String, SideBandUse>();
        map.put("NONE", SIDEBANDUSE_NONE);
        map.put("LSB", SIDEBANDUSE_LSB);
        map.put("USB", SIDEBANDUSE_USB);
        map.put("BOTH", SIDEBANDUSE_BOTH);
    }
}

