/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.enumerations;

import alma.observatorycharacteristics.capabilities.AlmaCapabilities;
import alma.obsprep.obstooluserprefs.types.TelescopeType;
import java.util.ArrayList;

public enum Telescope {
    ATF(TelescopeType.ATF, "A 2 antenna test facility at Magdalena", false),
    ALMA(TelescopeType.ALMA, "The full featured ALMA", true),
    ESALMA(TelescopeType.ESALMA, "Early Science ALMA", true),
    Cycle2(TelescopeType.CYCLE2, "Cycle2 ALMA", true),
    CSVALMA(TelescopeType.CSVALMA, "CSV ALMA", true),
    Cycle3(TelescopeType.CYCLE3, "Cycle3 ALMA", true),
    Cycle4(TelescopeType.CYCLE4, "Cycle4 ALMA", true),
    Cycle5(TelescopeType.CYCLE5, "Cycle5 ALMA", true),
    Cycle6(TelescopeType.CYCLE6, "Cycle6 ALMA", true);

    private final TelescopeType type;
    private final String description;
    private final boolean isValid;
    private static Telescope[] validTelescopes;

    private Telescope(TelescopeType telescopeType, String string2, boolean bl) {
        this.type = telescopeType;
        this.description = string2;
        this.isValid = bl;
    }

    public static boolean isOTConfiguredAs(Telescope telescope) {
        if (telescope == null) {
            throw new NullPointerException("Illegal argument - the argument telescope cannot be null");
        }
        String string = System.getProperty("Telescope");
        if (string == null) {
            throw new IllegalArgumentException("Illegal argument: currentTelescopeConfiguration (" + string + ") " + "did not pass the test: currentTelescopeConfiguration == null");
        }
        return string.equalsIgnoreCase(telescope.name());
    }

    public static Telescope getTelescopeSelection() {
        AlmaCapabilities almaCapabilities = AlmaCapabilities.getInstance();
        Telescope telescope = Telescope.getTelescope(almaCapabilities.getTelescope());
        return telescope;
    }

    public static Telescope getTelescope(TelescopeType telescopeType) {
        for (Telescope telescope : Telescope.values()) {
            if (!telescope.type.equals(telescopeType)) continue;
            return telescope;
        }
        throw new IllegalArgumentException("Unknown TelescopeType : " + telescopeType);
    }

    public static Telescope getTelescope(String string) {
        for (Telescope telescope : Telescope.values()) {
            if (!telescope.name().equals(string) && !telescope.getDescription().equals(string) && !telescope.getLabel().equals(string)) continue;
            return telescope;
        }
        throw new IllegalArgumentException("Can not identify telescope : " + string);
    }

    public static Telescope[] getValidTelescopes() {
        if (validTelescopes == null) {
            ArrayList<Telescope> arrayList = new ArrayList<Telescope>();
            for (Telescope telescope : Telescope.values()) {
                if (!telescope.isValid) continue;
                arrayList.add(telescope);
            }
            validTelescopes = arrayList.toArray(new Telescope[arrayList.size()]);
        }
        return validTelescopes;
    }

    public static String[] getValidTelescopeLabels() {
        Telescope[] telescopeArray = Telescope.getValidTelescopes();
        String[] stringArray = new String[telescopeArray.length];
        for (int i = 0; i < telescopeArray.length; ++i) {
            stringArray[i] = telescopeArray[i].getLabel();
        }
        return stringArray;
    }

    public TelescopeType getTelescopeType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public String getLabel() {
        return this.name() + " - " + this.getDescription();
    }

    public boolean isValidTelescope() {
        return this.isValid;
    }
}

