/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.obsproject;

import alma.entity.xmlbinding.obsproject.AbstractScienceSpectralWindowT;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.enumerations.CorrPolarization;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.data.AbstractScienceSpectralWindowData;
import alma.obsprep.util.Range;
import alma.valuetypes.Frequency;
import alma.valuetypes.UserFrequency;
import alma.valuetypes.Velocity;

public abstract class AbstractScienceSpectralWindow
extends AbstractScienceSpectralWindowData
implements Range<Frequency> {
    public static final String SPECTRALWINDOWTYPE_LINE = "line";
    public static final String SPECTRALWINDOWTYPE_CONTINUUM = "continuum";
    public static final String SPECTRALWINDOWTYPE_SINGLECONTINUUM = "continuum";
    public static final String SPECTRALWINDOWTYPE_SCAN = "scan";
    private boolean representative = false;
    boolean isRepresentativeBeforeWindowClear = false;

    public AbstractScienceSpectralWindow(AbstractScienceSpectralWindowT abstractScienceSpectralWindowT) {
        super(abstractScienceSpectralWindowT);
    }

    public SpectralSetupParameters getSpectralSetupParameters() {
        return (SpectralSetupParameters)this.getParent();
    }

    public abstract UserFrequency getBandWidth();

    public UserFrequency getBandwidth() {
        return this.range();
    }

    public abstract Frequency getCenterFrequency();

    public Frequency getSpectralResolution() {
        return null;
    }

    public int getNumberOfChannels() {
        UserFrequency userFrequency = this.getBandWidth();
        Frequency frequency = this.getSpectralResolution();
        if (userFrequency == null || frequency == null) {
            return 0;
        }
        return (int)Math.round(((Frequency)((Object)userFrequency)).getContentInMHz() / frequency.getContentInMHz());
    }

    public String getSpectralWindowType() {
        SpectralSetupParameters spectralSetupParameters = this.getSpectralSetupParameters();
        String string = spectralSetupParameters.getType();
        if (string.equals(SpectralSetupParameters.TYPE_CONTINUUM)) {
            return "continuum";
        }
        if (string.equals(SpectralSetupParameters.TYPE_SCAN)) {
            return SPECTRALWINDOWTYPE_SCAN;
        }
        if (string.equals(SpectralSetupParameters.TYPE_FULL)) {
            return SPECTRALWINDOWTYPE_LINE;
        }
        Log.logger((Object)this).warning("Unexpected SpectralType : " + string);
        return null;
    }

    public String getTransitionName() {
        return null;
    }

    public CorrPolarization getCorrPolarization() {
        return this.getSpectralSetupParameters().getCorrPolarization();
    }

    public boolean isRepresentative() {
        return this.representative;
    }

    public void setRepresentative(boolean bl) {
        this.representative = bl;
    }

    public String shortDescription() {
        return "";
    }

    @Override
    public Frequency max() {
        return (Frequency)this.getCenterFrequency().plus(this.getBandwidth().half());
    }

    @Override
    public Frequency min() {
        return (Frequency)this.getCenterFrequency().minus(this.getBandwidth().half());
    }

    @Override
    public Frequency mid() {
        return this.getCenterFrequency();
    }

    @Override
    public UserFrequency range() {
        return this.getBandWidth();
    }

    public Range<Frequency> getNativeFrequencyRange() {
        return this;
    }

    public Velocity getSourceVelocity() {
        SpectralSetupParameters spectralSetupParameters = (SpectralSetupParameters)this.getParent();
        if (spectralSetupParameters != null) {
            return spectralSetupParameters.getSourceVelocity();
        }
        return Velocity.createVelocity();
    }
}

