/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.obsproject;

import alma.entity.xmlbinding.obsproject.CalibrationTargetParametersT;
import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.observatorycharacteristics.capabilities.AlmaCapabilities;
import alma.observatorycharacteristics.site.SiteCharacteristics;
import alma.obsprep.bo.obsproject.CalibrationTargetProperties;
import alma.obsprep.bo.obsproject.GoalTargetParameters;
import alma.obsprep.bo.obsproject.TargetWithIntent;
import alma.obsprep.bo.obsproject.data.CalibrationTargetParametersData;
import alma.obsprep.services.generator.refactored.ObsType;
import alma.valuetypes.Angle;
import alma.valuetypes.Frequency;
import alma.valuetypes.Latitude;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.data.LatitudeData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CalibrationTargetParameters
extends CalibrationTargetParametersData
implements GoalTargetParameters,
TargetWithIntent {
    public CalibrationTargetParameters(CalibrationTargetParametersT calibrationTargetParametersT) {
        super(calibrationTargetParametersT);
    }

    public static CalibrationTargetParameters createCalibrationTargetParameters(String string) {
        List<String> list = Arrays.asList(CalibrationTargetParameters.getKnownIntendedUseList());
        if (!list.contains(string)) {
            throw new AssertionError((Object)(string + " is an unknown use for a calibrator"));
        }
        CalibrationTargetParameters calibrationTargetParameters = CalibrationTargetParameters.createCalibrationTargetParameters();
        calibrationTargetParameters.setIntendedUse(string);
        return calibrationTargetParameters;
    }

    public static List<String> getKnownSolarSystemCalibratorsList() {
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(CalibrationTargetParameters.getKnownSolarSystemObjectList()));
        arrayList.remove(SOLARSYSTEMOBJECT_EPHEMERIS);
        arrayList.remove(SOLARSYSTEMOBJECT_SUN);
        arrayList.remove(SOLARSYSTEMOBJECT_MOON);
        arrayList.remove(SOLARSYSTEMOBJECT_UNSPECIFIED);
        return arrayList;
    }

    protected void initAsNew() {
        this.setNonSiderealMotion(true);
        this.setSolarSystemObject(SOLARSYSTEMOBJECT_URANUS);
    }

    public CalibrationTargetProperties getClosestProperties(Frequency frequency) {
        int n = this.getCalibrationTargetPropertiesCount();
        switch (n) {
            case 0: {
                return null;
            }
            case 1: {
                return this.getCalibrationTargetProperties(0);
            }
        }
        CalibrationTargetProperties calibrationTargetProperties = this.getCalibrationTargetProperties(0);
        double d = Math.abs(((Frequency)calibrationTargetProperties.getFrequency().minus((AbstractDoubleWithUnit)frequency)).getContentInDefaultUnits());
        for (int i = 1; i < n; ++i) {
            CalibrationTargetProperties calibrationTargetProperties2 = this.getCalibrationTargetProperties(i);
            double d2 = Math.abs(((Frequency)calibrationTargetProperties2.getFrequency().minus((AbstractDoubleWithUnit)frequency)).getContentInDefaultUnits());
            if (!(d > d2)) continue;
            calibrationTargetProperties = calibrationTargetProperties2;
            d = d2;
        }
        return calibrationTargetProperties;
    }

    public boolean isMaxElevationNeverVisible() {
        AlmaCapabilities almaCapabilities = AlmaCapabilities.getInstance();
        Angle angle = almaCapabilities.getElLimit();
        double d = angle.getContentInUnits(Angle.UNIT_DEG);
        SiteCharacteristics siteCharacteristics = SiteCharacteristics.getInstance();
        Latitude latitude = siteCharacteristics.getObsLatitude();
        double d2 = 90.0 - d;
        SkyCoordinates skyCoordinates = this.getSourceCoordinates().getICRSSkyCoordinates();
        double d3 = Math.abs(skyCoordinates.getLatitude().getContentInUnits(LatitudeData.UNIT_DEG) - latitude.getContentInUnits(LatitudeData.UNIT_DEG));
        return d3 > d2;
    }

    @Override
    public ObsType getObsType() {
        return ObsType.getObsType(this);
    }
}

