/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.obsproject;

import alma.entity.xmlbinding.obsproject.ObsProjectRefT;
import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.bo.Copier;
import alma.hla.runtime.obsprep.bo.CopyException;
import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.hla.runtime.obsprep.bo.Referring;
import alma.hla.runtime.obsprep.interfaces.ModelStructureListener;
import alma.hla.runtime.obsprep.interfaces.ModelStructureNotifier;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.annotations.GUIScienceGoalAcceptor;
import alma.obsprep.bo.obsproject.AbstractScienceGoal;
import alma.obsprep.bo.obsproject.ObsProgram;
import alma.obsprep.bo.obsproject.ObsUnitSet;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.SubmissionRecord;
import alma.obsprep.bo.obsproject.data.ObsProjectData;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.ot.actions.RetrieveAsNewPerformer;
import alma.obsprep.services.sfi.SingleFieldScienceGoalModel;
import alma.scheduling.projectstatus.StatusBase;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public class ObsProject
extends ObsProjectData
implements ModelStructureNotifier,
GUIScienceGoalAcceptor {
    public static final String NOPROJECTCODEASSIGNED = "None Assigned";
    private final transient Vector<ModelStructureListener> listeners = new Vector();
    private volatile transient ModelStructureListener[] listeners_ro = new ModelStructureListener[0];

    public ObsProject(alma.entity.xmlbinding.obsproject.ObsProject obsProject) {
        super(obsProject);
    }

    protected void initAsNew() {
        super.initAsNew();
        this.setPI("");
        this.setProjectName("");
        this.setVersion("0");
        this.setManualMode(false);
        this.setSimulationMode(false);
        this.setIsCalibration(false);
        this.setIsCommissioning(false);
        this.setObsProgram(ObsProgram.createObsProgram());
        this.setObsProposal(null);
    }

    protected void initEntityReferencesFrom(IBusinessObject iBusinessObject, Copier copier) throws CopyException {
        super.initEntityReferencesFrom(iBusinessObject, copier);
        this.setProjectStatus(null);
        this.setStatus(STATUS_NEWPHASE2);
    }

    public ObsProjectRefT getReference() {
        ObsProjectRefT obsProjectRefT = super.getReference();
        obsProjectRefT.setDocumentVersion("1");
        return obsProjectRefT;
    }

    public String toTreeString(int n, boolean bl, boolean bl2) {
        String string = this.getProjectName();
        if (string.equals("")) {
            string = "Project";
        }
        return string;
    }

    public void setObsProposal(ObsProposal obsProposal) {
        super.setObsProposal(obsProposal);
        if (obsProposal != null) {
            obsProposal.setObsProject(this);
        }
    }

    public Object[][] getSubmissionRecordTable() {
        Object[][] objectArray = new String[this.getSubmissionRecordCount()][];
        for (int i = 0; i < objectArray.length; ++i) {
            SubmissionRecord submissionRecord = this.getSubmissionRecord(i);
            objectArray[objectArray.length - 1 - i] = new String[]{submissionRecord.getSubmissionTime(), submissionRecord.getSubmitter()};
        }
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModelStructureListener(ModelStructureListener modelStructureListener) {
        Vector<ModelStructureListener> vector = this.listeners;
        synchronized (vector) {
            this.listeners.add(modelStructureListener);
            Object[] objectArray = new ModelStructureListener[this.listeners.size()];
            this.listeners.copyInto(objectArray);
            this.listeners_ro = objectArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModelStructureListener(ModelStructureListener modelStructureListener) {
        Vector<ModelStructureListener> vector = this.listeners;
        synchronized (vector) {
            this.listeners.remove(modelStructureListener);
            Object[] objectArray = new ModelStructureListener[this.listeners.size()];
            this.listeners.copyInto(objectArray);
            this.listeners_ro = objectArray;
        }
    }

    public void fireBusinessObjectAddedTo(IBusinessObject iBusinessObject, IBusinessObject iBusinessObject2, Referring.By by, int n) {
        ModelStructureListener[] modelStructureListenerArray;
        for (ModelStructureListener modelStructureListener : modelStructureListenerArray = this.listeners_ro) {
            modelStructureListener.businessObjectAddedTo(iBusinessObject, iBusinessObject2, by, n);
        }
    }

    public void fireBusinessObjectRemovedFrom(IBusinessObject iBusinessObject, IBusinessObject iBusinessObject2, Referring.By by) {
        ModelStructureListener[] modelStructureListenerArray;
        for (ModelStructureListener modelStructureListener : modelStructureListenerArray = this.listeners_ro) {
            modelStructureListener.businessObjectRemovedFrom(iBusinessObject, iBusinessObject2, by);
        }
    }

    public ObsProgram placeToAdd() {
        return this.getObsProgram();
    }

    @Override
    public void removeScienceGoal(AbstractScienceGoal abstractScienceGoal) {
        this.placeToAdd().removeScienceGoal(abstractScienceGoal);
    }

    public ObsUnitSet findObsUnitSetById(String string) {
        ObsProgram obsProgram = this.getObsProgram();
        return obsProgram.findObsUnitSetById(string);
    }

    public Iterator<BusinessObject> findAllBusinessObjects() {
        HashSet<BusinessObject> hashSet = new HashSet<BusinessObject>();
        this.findAllBusinessObjects((BusinessObject)this, hashSet);
        return hashSet.iterator();
    }

    private void findAllBusinessObjects(BusinessObject businessObject, Set<BusinessObject> set) {
        if (businessObject == null || businessObject instanceof StatusBase) {
            return;
        }
        if (set.contains(businessObject)) {
            return;
        }
        set.add(businessObject);
        List list = businessObject.associatedObjects();
        for (BusinessObject businessObject2 : list) {
            this.findAllBusinessObjects(businessObject2, set);
        }
    }

    public static Collection<String> getCsvStates() {
        return ImmutableSet.of((Object)STATUS_CSVREADY, (Object)STATUS_CSVRUNNING, (Object)STATUS_CSVSUSPENDED);
    }

    public static Collection<String> getOperationalStates() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(Arrays.asList(ObsProject.getKnownStatusList()));
        hashSet.removeAll(ObsProject.getCsvStates());
        return hashSet;
    }

    public static Collection<String> getSubmittableStates() {
        return ImmutableList.of((Object)STATUS_NEWPHASE1, (Object)STATUS_NEWPHASE2, (Object)STATUS_APPROVED, (Object)STATUS_BROKEN);
    }

    public static Collection<String> getPIP1SGEditableStates() {
        return ImmutableList.of((Object)STATUS_NEWPHASE1, (Object)STATUS_PHASE1SUBMITTED);
    }

    public boolean isProjectWithStatus(String ... stringArray) {
        if (stringArray == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: statii");
        }
        boolean bl = false;
        String string = this.getStatus();
        for (String string2 : stringArray) {
            if (!string.equals(string2)) continue;
            return true;
        }
        return bl;
    }

    public void resetTimeConstrainedFlagWhenNoVisitsDefined() {
        ArrayList<AbstractScienceGoal> arrayList = new ArrayList<AbstractScienceGoal>();
        try {
            if (this.getObsProposal() != null) {
                arrayList = new ArrayList<AbstractScienceGoal>(Arrays.asList(this.getObsProposal().getAbstractScienceGoal()));
            }
            if (this.getObsProgram() != null) {
                arrayList.addAll(Arrays.asList(this.getObsProgram().getAbstractScienceGoal()));
            }
        }
        catch (UnknownEntityException unknownEntityException) {
            return;
        }
        for (AbstractScienceGoal abstractScienceGoal : arrayList) {
            ScienceGoal scienceGoal;
            PerformanceParameters performanceParameters;
            if (!(abstractScienceGoal instanceof ScienceGoal) || !(performanceParameters = (scienceGoal = (ScienceGoal)((Object)abstractScienceGoal)).getPerformanceParameters()).getIsTimeConstrained() || !performanceParameters.getTimingConstraintsType().equals(PerformanceParameters.TIMINGCONSTRAINTSTYPE_NONE)) continue;
            performanceParameters.setIsTimeConstrained(false);
        }
    }

    private void resetNonStandardObservingModes() {
        ObsProposal obsProposal = null;
        try {
            obsProposal = this.getObsProposal();
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(RetrieveAsNewPerformer.class).warning("No obsProposal found when expected");
            return;
        }
        if (obsProposal == null) {
            Log.logger(RetrieveAsNewPerformer.class).warning("No obsProposal found when expected");
            return;
        }
        ArrayList<AbstractScienceGoal> arrayList = new ArrayList<AbstractScienceGoal>(Arrays.asList(obsProposal.getAbstractScienceGoal()));
        ObsProgram obsProgram = this.getObsProgram();
        if (obsProgram != null) {
            arrayList.addAll(Arrays.asList(obsProgram.getAbstractScienceGoal()));
        }
        for (AbstractScienceGoal abstractScienceGoal : arrayList) {
            ScienceGoal scienceGoal = (ScienceGoal)((Object)abstractScienceGoal);
            try {
                EnumSet<SingleFieldScienceGoalModel.NonStandardMode> enumSet = SingleFieldScienceGoalModel.establishNonStandardObservingModes(scienceGoal);
                scienceGoal.setMode(enumSet.isEmpty() ? ScienceGoal.MODE_STANDARD : ScienceGoal.MODE_OTHER);
            }
            catch (SingleFieldScienceGoalModel.UnableToDetermineObservingModesException unableToDetermineObservingModesException) {
                Log.logger(RetrieveAsNewPerformer.class).warning("Unable to determine standard modes: " + unableToDetermineObservingModesException.getMessage());
            }
        }
    }

    public void resetAfterImport() {
        this.resetTimeConstrainedFlagWhenNoVisitsDefined();
        this.resetNonStandardObservingModes();
    }
}

