/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.obsproject;

import alma.entity.xmlbinding.obsproject.ObsProjectRefT;
import alma.entity.xmlbinding.obsproject.ObsUnitSetT;
import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.bo.Copier;
import alma.hla.runtime.obsprep.bo.CopyException;
import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.annotations.ObsUnitSetComponent;
import alma.obsprep.bo.obsproject.AbstractScienceGoal;
import alma.obsprep.bo.obsproject.ObsPhase;
import alma.obsprep.bo.obsproject.ObsProgram;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.obsproject.data.ObsUnitSetData;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.ot.boEditors.AbstractWizard;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.valuetypes.Time;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class ObsUnitSet
extends ObsUnitSetData
implements ObsUnitSetComponent {
    private static final char[] NAME_INDEX_CHARACTERS = "abcdefghijklmnopqrstuvwxyz".toCharArray();
    private AbstractScienceGoal generatingScienceGoal = null;
    private boolean haveSearchedForScienceGoal = false;
    public static final Set<String> DELETABLE_STATES = ImmutableSet.of((Object)STATUS_NEWPHASE1, (Object)STATUS_NEWPHASE2, (Object)STATUS_PHASE1SUBMITTED, (Object)STATUS_PHASE2SUBMITTED);
    public static final Set<String> SB_REGENERATION_STATES = ImmutableSet.of((Object)STATUS_NEWPHASE1, (Object)STATUS_NEWPHASE2, (Object)STATUS_PHASE1SUBMITTED, (Object)STATUS_PHASE2SUBMITTED, (Object)STATUS_READY);

    public ObsUnitSet(ObsUnitSetT obsUnitSetT) {
        super(obsUnitSetT);
    }

    protected void initAsNew() {
        super.initAsNew();
        this.getObsUnitControl();
        this.getUnitDependencies();
        this.getDataProcessingParameters();
        this.getNote();
        this.getFlowControl();
        this.setName("ObsUnitSet");
        this.setScienceProcessingScript("");
    }

    protected void initEntityReferencesFrom(IBusinessObject iBusinessObject, Copier copier) throws CopyException {
        super.initEntityReferencesFrom(iBusinessObject, copier);
        this.setOUSStatus(null);
        this.setStatus(STATUS_NEWPHASE2);
    }

    public String toTreeString(int n, boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toTreeString(n, bl, bl2));
        if (!bl2) {
            stringBuffer.append(' ');
            stringBuffer.append(this.briefDescription());
        }
        return stringBuffer.toString();
    }

    public String briefDescription() {
        int n = this.getObsUnitSetCount();
        int n2 = this.getSchedBlockCount();
        StringBuffer stringBuffer = new StringBuffer();
        if (n == 0 && n2 == 0) {
            stringBuffer.append("(empty)");
        } else {
            String string = "(";
            if (n != 0) {
                stringBuffer.append(string);
                string = ", ";
                stringBuffer.append(n);
                stringBuffer.append(" OUS");
                if (n != 1) {
                    stringBuffer.append('s');
                }
            }
            if (n2 != 0) {
                stringBuffer.append(string);
                string = ", ";
                stringBuffer.append(n2);
                stringBuffer.append(" SB");
                if (n2 != 1) {
                    stringBuffer.append('s');
                }
            }
            stringBuffer.append(')');
        }
        return stringBuffer.toString();
    }

    public List<ObsUnitSet> findObsUnitSets() {
        ArrayList<ObsUnitSet> arrayList = new ArrayList<ObsUnitSet>(20);
        this.findObsUnitSets0(arrayList);
        return arrayList;
    }

    private void findObsUnitSets0(List<ObsUnitSet> list) {
        list.add(this);
        for (ObsUnitSet obsUnitSet : this.getObsUnitSet()) {
            obsUnitSet.findObsUnitSets0(list);
        }
    }

    public boolean contains(SchedBlock schedBlock) {
        try {
            return Arrays.asList(this.getSchedBlock()).contains(schedBlock);
        }
        catch (UnknownEntityException unknownEntityException) {
            return false;
        }
    }

    public List<SchedBlock> findSchedBlocks() throws UnknownEntityException {
        ArrayList<SchedBlock> arrayList = new ArrayList<SchedBlock>();
        for (ObsUnitSet obsUnitSet : this.findObsUnitSets()) {
            arrayList.addAll(Arrays.asList(obsUnitSet.getSchedBlock()));
        }
        return arrayList;
    }

    public ObsUnitSet findObsUnitSetByName(String string) {
        for (ObsUnitSet obsUnitSet : this.findObsUnitSets()) {
            if (!string.equals(obsUnitSet.getName())) continue;
            return obsUnitSet;
        }
        return null;
    }

    public ObsUnitSet findObsUnitSetById(String string) {
        for (ObsUnitSet obsUnitSet : this.findObsUnitSets()) {
            if (!string.equals(obsUnitSet.getEntityPartId())) continue;
            return obsUnitSet;
        }
        return null;
    }

    public int indexOf(ObsUnitSet obsUnitSet) throws NoSuchElementException {
        int n = Arrays.asList(this.getObsUnitSet()).indexOf(obsUnitSet);
        if (n == -1) {
            throw new NoSuchElementException("Cannot find ObsUnitSet " + obsUnitSet);
        }
        return n;
    }

    private AbstractScienceGoal findGeneratingScienceGoal() {
        ObsProject obsProject = this.findProject();
        if (obsProject != null) {
            ObsProposal obsProposal = null;
            try {
                obsProposal = obsProject.getObsProposal();
            }
            catch (UnknownEntityException unknownEntityException) {
                unknownEntityException.printStackTrace();
            }
            if (obsProposal != null) {
                for (AbstractScienceGoal abstractScienceGoal : obsProposal.getAbstractScienceGoal()) {
                    if (abstractScienceGoal.getObsUnitSet() != this) continue;
                    return abstractScienceGoal;
                }
            }
            ObsProgram obsProgram = obsProject.getObsProgram();
            for (AbstractScienceGoal abstractScienceGoal : obsProgram.getAbstractScienceGoal()) {
                if (abstractScienceGoal.getObsUnitSet() != this) continue;
                return abstractScienceGoal;
            }
        }
        return null;
    }

    public AbstractScienceGoal getGeneratingScienceGoal() {
        if (!this.haveSearchedForScienceGoal) {
            this.generatingScienceGoal = this.findGeneratingScienceGoal();
            this.haveSearchedForScienceGoal = true;
        }
        return this.generatingScienceGoal;
    }

    @Override
    public ObsUnitSet getContainingObsUnitSet() {
        return this;
    }

    public boolean addSchedBlock(int n, SchedBlock schedBlock) {
        boolean bl = super.addSchedBlock(n, schedBlock);
        if (bl) {
            try {
                schedBlock.setObsProject(this.getObsProject());
            }
            catch (UnknownEntityException unknownEntityException) {
                Log.logger((Object)this).warning("Cannot getObsProject for " + this + ": " + unknownEntityException.getLocalizedMessage());
            }
        }
        return bl;
    }

    public boolean addObsUnitSet(int n, ObsUnitSet obsUnitSet) {
        boolean bl = super.addObsUnitSet(n, obsUnitSet);
        if (bl) {
            try {
                obsUnitSet.setObsProject(this.getObsProject());
            }
            catch (UnknownEntityException unknownEntityException) {
                Log.logger((Object)this).warning("Cannot getObsProject for " + this + ": " + unknownEntityException.getLocalizedMessage());
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return bl;
    }

    public boolean removeObsUnitSet(ObsUnitSet obsUnitSet) {
        boolean bl = super.removeObsUnitSet(obsUnitSet);
        if (bl) {
            obsUnitSet.setObsProject(null);
        }
        return bl;
    }

    public void setObsProject(ObsProject obsProject) {
        try {
            super.setObsProject(obsProject);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        for (ObsUnitSet obsUnitSetComponent : this.getObsUnitSet()) {
            obsUnitSetComponent.setObsProject(obsProject);
        }
        try {
            for (ObsUnitSetComponent obsUnitSetComponent : this.getSchedBlock()) {
                obsUnitSetComponent.setObsProject(obsProject);
            }
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger((Object)this).warning("Cannot setObsProject for " + this + ": " + unknownEntityException.getLocalizedMessage());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public boolean isDeletable() {
        if (!DELETABLE_STATES.contains(this.getStatus())) {
            return false;
        }
        return !this.isOUSContainsCancelledSB(this);
    }

    public boolean isSBRegenerationPossible() {
        if (!SB_REGENERATION_STATES.contains(this.getStatus())) {
            return false;
        }
        return !this.isOUSContainsCancelledSB(this);
    }

    private boolean isOUSContainsCancelledSB(ObsUnitSet obsUnitSet) {
        if (obsUnitSet.getStatus().equals(STATUS_CANCELED)) {
            return true;
        }
        try {
            for (SchedBlock obsUnitSetComponent : obsUnitSet.getSchedBlock()) {
                if (!obsUnitSetComponent.getStatus().equals(STATUS_CANCELED)) continue;
                return true;
            }
        }
        catch (UnknownEntityException unknownEntityException) {
            throw new WizardSBGenerationException("Unable to find SBs" + unknownEntityException.getMessage());
        }
        for (ObsUnitSetComponent obsUnitSetComponent : obsUnitSet.getObsUnitSet()) {
            if (!this.isOUSContainsCancelledSB((ObsUnitSet)obsUnitSetComponent)) continue;
            return true;
        }
        return false;
    }

    public ObsProjectRefT getReference() {
        ObsProjectRefT obsProjectRefT;
        ObsProjectRefT obsProjectRefT2 = new ObsProjectRefT();
        try {
            ObsProject obsProject = this.getObsProject();
            if (obsProject == null) {
                return null;
            }
            obsProjectRefT = this.getObsProject().getReference();
        }
        catch (UnknownEntityException unknownEntityException) {
            return null;
        }
        obsProjectRefT2.setEntityId(obsProjectRefT.getEntityId());
        obsProjectRefT2.setEntityTypeName(obsProjectRefT.getEntityTypeName());
        obsProjectRefT2.setDocumentVersion(obsProjectRefT.getDocumentVersion());
        obsProjectRefT2.setPartId(this.getEntityPartId());
        return obsProjectRefT2;
    }

    public Time calcMaxTime() {
        Time time = Time.createTime((double)0.0, (String)Time.UNIT_MIN);
        try {
            if (this.getSchedBlockCount() > 0) {
                for (SchedBlock schedBlock : this.getSchedBlock()) {
                    time = (Time)time.plus((AbstractDoubleWithUnit)schedBlock.getSchedBlockControl().calcMaxTime());
                }
            } else {
                for (ObsUnitSet obsUnitSet : this.getObsUnitSet()) {
                    time = (Time)time.plus((AbstractDoubleWithUnit)obsUnitSet.calcMaxTime());
                }
            }
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger((Object)this).warning("Cannot find SchedBlock in " + this + ": " + unknownEntityException.getLocalizedMessage());
        }
        return time;
    }

    public Time calcEstimatedTime() {
        Time time = Time.createTime((double)0.0, (String)Time.UNIT_MIN);
        try {
            if (this.getSchedBlockCount() > 0) {
                for (SchedBlock schedBlock : this.getSchedBlock()) {
                    time = (Time)time.plus((AbstractDoubleWithUnit)schedBlock.getSchedBlockControl().calcEstimatedTime());
                }
            } else {
                for (ObsUnitSet obsUnitSet : this.getObsUnitSet()) {
                    time = (Time)time.plus((AbstractDoubleWithUnit)obsUnitSet.calcEstimatedTime());
                }
            }
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger((Object)this).warning("Cannot find SchedBlock in " + this + ": " + unknownEntityException.getLocalizedMessage());
        }
        return time;
    }

    public int calcAggregatedExecutionCount() {
        int n = 0;
        try {
            if (this.getSchedBlockCount() > 0) {
                for (SchedBlock schedBlock : this.getSchedBlock()) {
                    n += schedBlock.getSchedBlockControl().getExecutionCount();
                }
            } else {
                for (ObsUnitSet obsUnitSet : this.getObsUnitSet()) {
                    n += obsUnitSet.calcAggregatedExecutionCount();
                }
            }
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger((Object)this).warning("Cannot find SchedBlock in " + this + ": " + unknownEntityException.getLocalizedMessage());
        }
        return n;
    }

    public void ensureSBNamesAreUnique(List<AbstractScienceGoal> list) {
        if (list == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: scienceGoalsForWhichSBsWereGenerated");
        }
        if (list.size() == 0) {
            return;
        }
        if (list.size() == 1) {
            this.ensureSBNameGeneratedFromSingleScienceGoalSBGenerationIsUnique(list.get(0));
        } else {
            this.ensureSBNamesFromMultipleScienceGoalSBGenerationAreUnique(list);
        }
    }

    private void ensureSBNamesFromMultipleScienceGoalSBGenerationAreUnique(List<AbstractScienceGoal> list) {
        if (list == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: scienceGoalsForWhichSBsWereGenerated");
        }
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        try {
            for (AbstractScienceGoal abstractScienceGoal : list) {
                List<SchedBlock> list2 = this.findRootSchedBlocks(abstractScienceGoal);
                for (SchedBlock schedBlock : list2) {
                    if (schedBlock.isRenameable()) continue;
                    this.storeSBNameInMap(hashMap, schedBlock.getName());
                }
                for (SchedBlock schedBlock : list2) {
                    if (!schedBlock.isRenameable()) continue;
                    String string = this.createUniqueSBName(hashMap, schedBlock);
                    schedBlock.setName(string);
                    this.storeSBNameInMap(hashMap, string);
                    Log.logger((Object)this).info("New SB name is :" + string);
                }
            }
        }
        catch (UnknownEntityException unknownEntityException) {
            unknownEntityException.printStackTrace();
        }
    }

    private List<SchedBlock> findRootSchedBlocks(AbstractScienceGoal abstractScienceGoal) throws UnknownEntityException {
        List<Object> list = new ArrayList();
        ObsUnitSet obsUnitSet = abstractScienceGoal.gettrueObsUnitSet();
        if (obsUnitSet != null) {
            list = obsUnitSet.findSchedBlocks();
        } else {
            ObsPhase obsPhase = (ObsPhase)abstractScienceGoal.getParent();
            if (obsPhase instanceof ObsProposal) {
                ObsUnitSet obsUnitSet2 = AbstractWizard.getPlanForPhase1SBs((ObsProposal)((Object)obsPhase));
                list = obsUnitSet2.findSchedBlocks();
            } else {
                this.findSchedBlocks();
            }
        }
        return list;
    }

    private String createUniqueSBName(Map<String, Integer> map, SchedBlock schedBlock) {
        String string;
        int n;
        if (schedBlock == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: sb");
        }
        if (map == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: incidenceOfSBNameMap");
        }
        String string2 = schedBlock.generateName(schedBlock.getSbGenerationContext().getGoal());
        int n2 = 1;
        do {
            int n3 = n = map.containsKey(string = string2.replace("_1_", "_" + this.getUniqueIndexString(n2) + "_")) ? map.get(string) : 0;
            if (n == 0) continue;
            ++n2;
        } while (n != 0);
        assert (string != null);
        return string;
    }

    private void ensureSBNameGeneratedFromSingleScienceGoalSBGenerationIsUnique(AbstractScienceGoal abstractScienceGoal) {
        if (abstractScienceGoal == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: scienceGoalForWhichSBsWereGenerated");
        }
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        try {
            for (SchedBlock schedBlock : this.findSchedBlocks()) {
                this.storeSBNameInMap(hashMap, schedBlock.getName());
            }
            for (SchedBlock schedBlock : this.findRootSchedBlocks(abstractScienceGoal)) {
                if (!schedBlock.isRenameable()) continue;
                AbstractScienceGoal abstractScienceGoal2 = null;
                try {
                    abstractScienceGoal2 = schedBlock.getParentScienceGoal();
                }
                catch (SchedBlock.UnableToFindParentScienceGoalException unableToFindParentScienceGoalException) {
                    abstractScienceGoal2 = null;
                }
                String string = abstractScienceGoal.getName();
                if (!this.isPhaseOne(abstractScienceGoal) && (abstractScienceGoal2 == null || !abstractScienceGoal2.getName().equals(string))) continue;
                String string2 = this.createUniqueSBName(hashMap, schedBlock);
                Log.logger((Object)this).info("New SB name is :" + string2);
                schedBlock.setName(string2);
                this.storeSBNameInMap(hashMap, string2);
            }
        }
        catch (UnknownEntityException unknownEntityException) {
            unknownEntityException.printStackTrace();
        }
    }

    private boolean isPhaseOne(AbstractScienceGoal abstractScienceGoal) {
        return abstractScienceGoal.getParent() instanceof ObsProposal;
    }

    private int storeSBNameInMap(Map<String, Integer> map, String string) {
        if (map == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: incidenceOfSBNameMap");
        }
        int n = 1;
        if (map.containsKey(string)) {
            n = map.get(string) + 1;
        }
        map.put(string, n);
        return n;
    }

    private String getUniqueIndexString(int n) {
        int n2 = NAME_INDEX_CHARACTERS.length;
        int n3 = n % n2;
        int n4 = n / n2;
        if (n3 == 0) {
            n3 = n2;
            --n4;
        }
        if (n4 > 0) {
            return this.getUniqueIndexString(n4) + NAME_INDEX_CHARACTERS[n3 - 1];
        }
        return "" + NAME_INDEX_CHARACTERS[n - 1];
    }
}

