/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.obsproject;

import alma.entity.xmlbinding.obsproject.OpticalPointingScienceGoalT;
import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.obsproject.OpticalPointingTargetParameters;
import alma.obsprep.bo.obsproject.OpticalPointingTargetQueryParameters;
import alma.obsprep.bo.obsproject.data.OpticalPointingScienceGoalData;
import alma.obsprep.bo.schedblock.FieldSource;
import alma.obsprep.bo.schedblock.OpticalCameraSpec;
import alma.obsprep.bo.schedblock.OpticalPointingParameters;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.guiutil.mvc.InvalidCoordException;
import alma.obsprep.guiutil.mvc.OutOfRangeException;
import alma.obsprep.ot.boEditors.Wizard;
import alma.obsprep.ot.editors.misc.OpticalPointingScienceGoalSummaryTableColumns;
import alma.obsprep.ot.models.misc.SummaryTableColumns;
import alma.obsprep.ot.models.misc.SummaryTableRow;
import alma.obsprep.services.optical.OptPointWizard;
import alma.obsprep.util.Convert;
import alma.obsprep.util.Convert4dp;
import alma.obsprep.util.GUIUtilities;
import alma.obsprep.util.MiscUtils;
import alma.obsprep.util.VupRange;
import alma.obsprep.util.astro.AzElCalculator;
import alma.obsprep.util.astro.PointingCoordsConverter;
import alma.valuetypes.Angle;
import alma.valuetypes.AngularVelocity;
import alma.valuetypes.Latitude;
import alma.valuetypes.Longitude;
import alma.valuetypes.Magnitude;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.Time;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.Random;
import java.util.Vector;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class OpticalPointingScienceGoal
extends OpticalPointingScienceGoalData
implements TableModel {
    private SummaryTableColumns summaryTableColumns = new OpticalPointingScienceGoalSummaryTableColumns(this);
    private Log.Logger logger = Log.logger((Object)this);
    protected EventListenerList listenerList = new EventListenerList();
    static final int FIELD_RA = 0;
    static final int FIELD_DEC = 1;
    static final int FIELD_MAGNITUDE = 2;
    static final int FIELD_PMRA = 3;
    static final int FIELD_PMDEC = 4;
    static final int FIELD_PARALLAX = 5;
    static final int CANDIDATE_TARGET_RA = 0;
    static final int CANDIDATE_TARGET_DEC = 1;
    static final int CANDIDATE_TARGET_PMRA = 2;
    static final int CANDIDATE_TARGET_PMDEC = 3;
    static final int CANDIDATE_TARGET_MAGNITUDE = 4;
    static final int MAX_OPTICAL_POINTING_TARGETS = 500;
    private ArrayList<OpticalPointingTargetParameters> allTargetList;
    private static AzElCalculator converter = new AzElCalculator();

    public OpticalPointingScienceGoal(OpticalPointingScienceGoalT opticalPointingScienceGoalT) {
        super(opticalPointingScienceGoalT);
    }

    public void removeOpticalPointingTargetParameters(int n) {
        this.removeOpticalPointingTargetParameters(this.getOpticalPointingTargetParameters(n));
    }

    @Override
    public int getRowCount() {
        return this.getOpticalPointingTargetParametersCount();
    }

    @Override
    public int getColumnCount() {
        return 7;
    }

    @Override
    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                return "Name";
            }
            case 1: {
                return "RA";
            }
            case 2: {
                return "Dec";
            }
            case 3: {
                return "Proper Motion RA";
            }
            case 4: {
                return "Proper Motion Dec";
            }
            case 5: {
                return "Parallax";
            }
            case 6: {
                return "vMag";
            }
        }
        return "unknown";
    }

    @Override
    public Class<?> getColumnClass(int n) {
        switch (n) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return AngularVelocity.class;
            }
            case 4: {
                return AngularVelocity.class;
            }
            case 5: {
                return Angle.class;
            }
            case 6: {
                return Double.class;
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return true;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        OpticalPointingTargetParameters opticalPointingTargetParameters = this.getOpticalPointingTargetParameters(n);
        switch (n2) {
            case 0: {
                return opticalPointingTargetParameters.getSourceName();
            }
            case 1: {
                String string;
                Longitude longitude = opticalPointingTargetParameters.getSourceCoordinates().getLongitude();
                try {
                    string = Convert4dp.degToHHMMSS(longitude.getContentInUnits(Longitude.UNIT_DEG));
                }
                catch (OutOfRangeException outOfRangeException) {
                    string = outOfRangeException.getLocalizedMessage();
                }
                catch (InvalidCoordException invalidCoordException) {
                    string = invalidCoordException.getLocalizedMessage();
                }
                return string;
            }
            case 2: {
                String string;
                Latitude latitude = opticalPointingTargetParameters.getSourceCoordinates().getLatitude();
                try {
                    string = Convert.degToDDMMSS(latitude.getContentInUnits(Latitude.UNIT_DEG));
                }
                catch (OutOfRangeException outOfRangeException) {
                    string = outOfRangeException.getLocalizedMessage();
                }
                catch (InvalidCoordException invalidCoordException) {
                    string = invalidCoordException.getLocalizedMessage();
                }
                return string;
            }
            case 3: {
                return opticalPointingTargetParameters.getPmRA();
            }
            case 4: {
                return opticalPointingTargetParameters.getPmDec();
            }
            case 5: {
                return opticalPointingTargetParameters.getParallax();
            }
            case 6: {
                return opticalPointingTargetParameters.getVisibleMagnitude();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        OpticalPointingTargetParameters opticalPointingTargetParameters = this.getOpticalPointingTargetParameters(n);
        switch (n2) {
            case 0: {
                opticalPointingTargetParameters.setSourceName((String)object);
                return;
            }
            case 1: {
                Longitude longitude = opticalPointingTargetParameters.getSourceCoordinates().getLongitude();
                try {
                    longitude.setContent(Convert.HHMMSSToDeg((String)object));
                    longitude.setUnit(Longitude.UNIT_DEG);
                }
                catch (InvalidCoordException invalidCoordException) {
                    this.logger.warning("Invalid coordinate " + object + " - " + invalidCoordException.getLocalizedMessage());
                }
                catch (NumberFormatException numberFormatException) {
                    this.logger.warning("Invalid format " + object + " - " + numberFormatException.getLocalizedMessage());
                }
                return;
            }
            case 2: {
                Latitude latitude = opticalPointingTargetParameters.getSourceCoordinates().getLatitude();
                try {
                    latitude.setContent(Convert.DDMMSSToDeg((String)object));
                    latitude.setUnit(Latitude.UNIT_DEG);
                }
                catch (InvalidCoordException invalidCoordException) {
                    this.logger.warning("Invalid coordinate " + object + " - " + invalidCoordException.getLocalizedMessage());
                }
                catch (NumberFormatException numberFormatException) {
                    this.logger.warning("Invalid format " + object + " - " + numberFormatException.getLocalizedMessage());
                }
                return;
            }
            case 3: {
                AngularVelocity angularVelocity = (AngularVelocity)((Object)object);
                opticalPointingTargetParameters.getPmRA().setContent(angularVelocity.getContent());
                opticalPointingTargetParameters.getPmRA().setUnit(angularVelocity.getUnit());
                return;
            }
            case 4: {
                AngularVelocity angularVelocity = (AngularVelocity)((Object)object);
                opticalPointingTargetParameters.getPmDec().setContent(angularVelocity.getContent());
                opticalPointingTargetParameters.getPmDec().setUnit(angularVelocity.getUnit());
                return;
            }
            case 5: {
                Angle angle = (Angle)((Object)object);
                opticalPointingTargetParameters.getParallax().setContent(angle.getContent());
                opticalPointingTargetParameters.getParallax().setUnit(angle.getUnit());
                return;
            }
            case 6: {
                try {
                    opticalPointingTargetParameters.setVisibleMagnitude((Double)object);
                }
                catch (NumberFormatException numberFormatException) {
                    this.logger.warning("Invalid format " + object + " - " + numberFormatException.getLocalizedMessage());
                }
                return;
            }
        }
    }

    public SummaryTableRow getSummaryTableRow() {
        return this;
    }

    @Override
    public void addTableModelListener(TableModelListener tableModelListener) {
        this.listenerList.add(TableModelListener.class, tableModelListener);
    }

    @Override
    public void removeTableModelListener(TableModelListener tableModelListener) {
        this.listenerList.remove(TableModelListener.class, tableModelListener);
    }

    public TableModelListener[] getTableModelListeners() {
        return (TableModelListener[])this.listenerList.getListeners(TableModelListener.class);
    }

    public void fireTableDataChanged() {
        this.fireTableChanged(new TableModelEvent(this));
    }

    public void fireTableStructureChanged() {
        this.fireTableChanged(new TableModelEvent(this, -1));
    }

    public void fireTableRowsInserted(int n, int n2) {
        this.fireTableChanged(new TableModelEvent(this, n, n2, -1, 1));
    }

    public void fireTableRowsUpdated(int n, int n2) {
        this.fireTableChanged(new TableModelEvent(this, n, n2, -1, 0));
    }

    public void fireTableRowsDeleted(int n, int n2) {
        this.fireTableChanged(new TableModelEvent(this, n, n2, -1, -1));
    }

    public void fireTableCellUpdated(int n, int n2) {
        this.fireTableChanged(new TableModelEvent(this, n, n, n2));
    }

    public void fireTableChanged(TableModelEvent tableModelEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != TableModelListener.class) continue;
            ((TableModelListener)objectArray[i + 1]).tableChanged(tableModelEvent);
        }
    }

    public Collection<BusinessObject> instantiated() {
        Vector<BusinessObject> vector = new Vector<BusinessObject>();
        SchedBlock schedBlock = SchedBlock.createSchedBlock();
        schedBlock.setName(this.getSchedBlockName());
        for (int i = 0; i < this.getOpticalPointingTargetParametersCount(); ++i) {
            OpticalPointingTargetParameters opticalPointingTargetParameters = this.getOpticalPointingTargetParameters(i);
            SkyCoordinates skyCoordinates = opticalPointingTargetParameters.getSourceCoordinates();
            Target target = schedBlock.createTarget();
            OpticalPointingParameters opticalPointingParameters = schedBlock.createOpticalPointingParameters();
            opticalPointingParameters.setElevationLimit(this.getElevationLimit());
            opticalPointingParameters.setAntennaPositionTolerance(this.getAntennaPositionTolerance());
            opticalPointingParameters.setMinMagnitude(this.getMinMagnitude());
            opticalPointingParameters.setMaxMagnitude(this.getMaxMagnitude());
            target.addOpticalPointingParameters(opticalPointingParameters);
            FieldSource fieldSource = target.getFieldSource();
            fieldSource.getSourceCoordinates().getLongitude().setContent(skyCoordinates.getLongitude().getContent());
            fieldSource.getSourceCoordinates().getLatitude().setContent(skyCoordinates.getLatitude().getContent());
            fieldSource.setSourceName(opticalPointingTargetParameters.getSourceName());
            fieldSource.setPMRA(opticalPointingTargetParameters.getPmRA().deepCopy());
            fieldSource.setPMDec(opticalPointingTargetParameters.getPmDec().deepCopy());
            fieldSource.setParallax(opticalPointingTargetParameters.getParallax().deepCopy());
            fieldSource.setVisibleMagnitude(opticalPointingTargetParameters.getVisibleMagnitude());
            if (target.getOpticalCameraSpec() == null) {
                target.setOpticalCameraSpec(OpticalCameraSpec.createOpticalCameraSpec());
            }
            target.getOpticalCameraSpec().setFilter(this.getFilter());
            target.getOpticalCameraSpec().setMinIntegrationTime(this.getMinIntegrationTime());
            schedBlock.addTarget(target);
        }
        vector.add((BusinessObject)schedBlock);
        return vector;
    }

    public boolean getRandomizeOrder() {
        return this.getOpticalCameraControl().getRandomizeOrder();
    }

    public Magnitude getMaxMagnitude() {
        return this.getOpticalCameraControl().getMaxMagnitude();
    }

    public Magnitude getMinMagnitude() {
        return this.getOpticalCameraControl().getMinMagnitude();
    }

    public Angle getAntennaPositionTolerance() {
        return this.getOpticalCameraControl().getAntennaPositionTolerance();
    }

    public Angle getElevationLimit() {
        return this.getOpticalCameraControl().getElevationLimit();
    }

    private Time getMinIntegrationTime() {
        return this.getOpticalCameraSpec().getMinIntegrationTime();
    }

    public Time getSBMaximumTime() {
        return this.getOpticalCameraControl().getSBMaximumTime();
    }

    public String getFilter() {
        return this.getOpticalCameraSpec().getFilter();
    }

    protected String toTreeStringType() {
        return "Optical Pointing";
    }

    public Wizard getWizard() {
        if (this.wizard == null) {
            this.wizard = new OptPointWizard(this);
        }
        return this.wizard;
    }

    public SummaryTableColumns getSummaryTableColumns() {
        return this.summaryTableColumns;
    }

    public void loadTargetList(File file) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        while (this.getOpticalPointingTargetParametersCount() > 0) {
            this.removeOpticalPointingTargetParameters(0);
        }
        LineNumberReader lineNumberReader = this.preparedReader(file);
        String string = null;
        Vector<Double> vector = new Vector<Double>();
        OpticalPointingTargetParameters opticalPointingTargetParameters = null;
        while ((string = lineNumberReader.readLine()) != null) {
            if (!(string = string.trim()).equals("") && !string.startsWith("#")) {
                stringBuffer.setLength(0);
                vector.clear();
                String string2 = OpticalPointingScienceGoal.parseValues(string, vector, "\t", stringBuffer);
                if (stringBuffer.length() > 0) {
                    this.logger.warning("Errors while reading line " + lineNumberReader.getLineNumber() + " of target list file:\n" + stringBuffer.toString());
                } else {
                    opticalPointingTargetParameters = OpticalPointingTargetParameters.createOpticalPointingTargetParameters();
                    opticalPointingTargetParameters.setSourceName(string2);
                    opticalPointingTargetParameters.getSourceCoordinates().getLongitude().setContent(vector.get(0));
                    opticalPointingTargetParameters.getSourceCoordinates().getLongitude().setUnit(Longitude.UNIT_DEG);
                    opticalPointingTargetParameters.getSourceCoordinates().getLatitude().setContent(vector.get(1));
                    opticalPointingTargetParameters.getSourceCoordinates().getLatitude().setUnit(Latitude.UNIT_DEG);
                    opticalPointingTargetParameters.getPmRA().setContent(vector.get(3));
                    opticalPointingTargetParameters.getPmRA().setUnit(AngularVelocity.UNIT_MAS_YR);
                    opticalPointingTargetParameters.getPmDec().setContent(vector.get(4));
                    opticalPointingTargetParameters.getPmDec().setUnit(AngularVelocity.UNIT_MAS_YR);
                    opticalPointingTargetParameters.setVisibleMagnitude(vector.get(2));
                    try {
                        opticalPointingTargetParameters.getParallax().setContent(vector.get(5));
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        opticalPointingTargetParameters.getParallax().setContent(0.0);
                    }
                    opticalPointingTargetParameters.getParallax().setUnit(Angle.UNIT_MAS);
                    this.addOpticalPointingTargetParameters(opticalPointingTargetParameters);
                }
            }
            if (string != null) continue;
        }
        if ((n = this.getOpticalPointingTargetParametersCount()) == 1) {
            this.logger.info("1 optical pointing target read");
        } else {
            this.logger.info(n + " optical pointing targets read");
        }
        lineNumberReader.close();
    }

    public URL[] getTycho2FileURL() {
        String[] stringArray = new String[12];
        URL[] uRLArray = new URL[12];
        File file = new File(System.getProperty("otData.dir"));
        OpticalPointingTargetQueryParameters opticalPointingTargetQueryParameters = this.getOpticalPointingTargetQueryParameters();
        Magnitude magnitude = opticalPointingTargetQueryParameters.getMinMagnitude();
        Magnitude magnitude2 = opticalPointingTargetQueryParameters.getMaxMagnitude();
        if (Magnitude.isBrighter(magnitude2, Magnitude.createMagnitude(4.0))) {
            magnitude2 = Magnitude.createMagnitude(4.0);
        }
        int n = 0;
        for (int i = 4; i < 10; ++i) {
            Magnitude magnitude3 = Magnitude.createMagnitude(i);
            if ((!Magnitude.isFainterOrEqual(magnitude, magnitude3) || !Magnitude.isBrighter(magnitude, Magnitude.createMagnitude(i + 1))) && (!Magnitude.isBrighterOrEqual(magnitude, magnitude3) || !Magnitude.isFainterOrEqual(magnitude2, magnitude3))) continue;
            stringArray[n] = String.format("tycho2.%02d.dat", i);
            uRLArray[n] = MiscUtils.findResource(file, String.format("tycho2.%02d.dat", i));
            if (uRLArray[n] == null) {
                for (int j = 0; j < n; ++j) {
                    uRLArray[j] = null;
                }
                String string = MiscUtils.reportForFindResource();
                this.logger.warning("Catalogue file " + stringArray[n] + " not found.\n" + "Loaded resources:\n" + string);
                String string2 = "Error reading the Tycho Catalog. File " + stringArray[n] + " not found.\n\n" + "Please download the Tycho-2 Catalog for ALMA Optical Pointing\n" + "from <location to be added> if you wish to use this feature";
                GUIUtilities.error(null, string2);
            }
            ++n;
        }
        return uRLArray;
    }

    public boolean loadFilteredTargetList(URL[] uRLArray) throws IOException {
        int n;
        boolean bl = false;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        BufferedReader bufferedReader = null;
        int n3 = n = this.getOpticalPointingTargetQueryParameters().getSelectionFactor();
        while (this.getOpticalPointingTargetParametersCount() > 0) {
            this.removeOpticalPointingTargetParameters(0);
        }
        int n4 = 0;
        do {
            try {
                if (uRLArray[n4] == null) {
                    this.logger.warning("No catalogue file to read. Aborting.");
                    this.logger.info("No optical pointing targets read");
                    return bl;
                }
                bufferedReader = new BufferedReader(new InputStreamReader(uRLArray[n4].openStream()));
            }
            catch (IOException iOException) {
                this.logger.warning("Error reading catalogue file " + uRLArray[n4].toString());
                this.logger.info("No optical pointing targets read");
                return bl;
            }
            LineNumberReader lineNumberReader = new LineNumberReader(bufferedReader);
            String string = null;
            Vector<Double> vector = new Vector<Double>(5);
            vector.setSize(5);
            while ((string = lineNumberReader.readLine()) != null) {
                if (!(string = string.trim()).equals("") && !string.startsWith("#")) {
                    stringBuffer.setLength(0);
                    vector.clear();
                    String string2 = this.parseTycho2(string, vector, ",", stringBuffer);
                    if (!vector.isEmpty()) {
                        if (stringBuffer.length() > 0) {
                            this.logger.warning("Errors while reading line " + lineNumberReader.getLineNumber() + " of target list file:\n" + stringBuffer.toString());
                        } else if (this.filterIt(vector)) {
                            if (n3 == n) {
                                this.addOpticalPointingTargetParameters(this.buildOPTargetParameters(string2, vector));
                                n2 = this.getOpticalPointingTargetParametersCount();
                                n3 = 1;
                            } else {
                                ++n3;
                            }
                        }
                    }
                }
                if (string != null && n2 < 500) continue;
            }
            if (n2 > 0) {
                bl = true;
                if (n2 >= 500) {
                    String string3 = "The search yielded too many targets to display. Only the first 500 targets will be listed.\n";
                    String string4 = "To avoid bias in your selection YOU MUST narrow the selection criteria and reload the catalogue.";
                    this.logger.warning(string3 + string4);
                    GUIUtilities.warning(null, string3 + string4);
                    return bl;
                }
            }
            lineNumberReader.close();
        } while (uRLArray[++n4] != null);
        if (n2 == 1) {
            this.logger.info("1 optical pointing target read");
        } else {
            this.logger.info(n2 + " optical pointing targets read");
        }
        return bl;
    }

    private OpticalPointingTargetParameters buildOPTargetParameters(String string, Vector<Double> vector) {
        OpticalPointingTargetParameters opticalPointingTargetParameters = OpticalPointingTargetParameters.createOpticalPointingTargetParameters();
        opticalPointingTargetParameters.setSourceName(string);
        opticalPointingTargetParameters.getSourceCoordinates().getLongitude().setContent(vector.get(0));
        opticalPointingTargetParameters.getSourceCoordinates().getLongitude().setUnit(Longitude.UNIT_DEG);
        opticalPointingTargetParameters.getSourceCoordinates().getLatitude().setContent(vector.get(1));
        opticalPointingTargetParameters.getSourceCoordinates().getLatitude().setUnit(Latitude.UNIT_DEG);
        opticalPointingTargetParameters.getPmRA().setContent(vector.get(2));
        opticalPointingTargetParameters.getPmRA().setUnit(AngularVelocity.UNIT_MAS_YR);
        opticalPointingTargetParameters.getPmDec().setContent(vector.get(3));
        opticalPointingTargetParameters.getPmDec().setUnit(AngularVelocity.UNIT_MAS_YR);
        opticalPointingTargetParameters.setVisibleMagnitude(vector.get(4));
        opticalPointingTargetParameters.getParallax().setContent(0.0);
        opticalPointingTargetParameters.getParallax().setUnit(Angle.UNIT_MAS);
        return opticalPointingTargetParameters;
    }

    private LineNumberReader preparedReader(File file) throws IOException {
        String string;
        LineNumberReader lineNumberReader = new LineNumberReader(new FileReader(file));
        while ((string = lineNumberReader.readLine()) != null) {
            if (string.startsWith("--")) {
                return lineNumberReader;
            }
            if (string != null) continue;
        }
        lineNumberReader.close();
        lineNumberReader = new LineNumberReader(new FileReader(file));
        return lineNumberReader;
    }

    private String parseTycho2(String string, Vector<Double> vector, String string2, StringBuffer stringBuffer) {
        String[] stringArray = null;
        int n = 0;
        int n2 = 1;
        int n3 = 2;
        int n4 = 3;
        int n5 = 4;
        int n6 = 5;
        int n7 = 6;
        int n8 = 7;
        try {
            stringArray = string.split(string2);
        }
        catch (Exception exception) {
            stringBuffer.append("" + exception + "\n");
        }
        try {
            double d = this.getOpticalPointingTargetQueryParameters().getFieldMinSeparation().getContentInUnits(Angle.UNIT_ARCMIN);
            if (Double.parseDouble(stringArray[n8]) <= d) {
                this.logger.finest("Separation filter rejected " + string);
                vector.clear();
                return stringArray[n];
            }
        }
        catch (Exception exception) {
            vector.clear();
            stringBuffer.append("column " + n8 + ": " + exception + "\n");
            return stringArray[n];
        }
        try {
            vector.add(Double.parseDouble(stringArray[n2]));
        }
        catch (Exception exception) {
            vector.clear();
            stringBuffer.append("column " + n2 + ": " + exception + "\n");
            return stringArray[n];
        }
        try {
            vector.add(Double.parseDouble(stringArray[n3]));
        }
        catch (Exception exception) {
            vector.clear();
            stringBuffer.append("column " + n3 + ": " + exception + "\n");
            return stringArray[n];
        }
        try {
            vector.add(Double.parseDouble(stringArray[n4]));
        }
        catch (Exception exception) {
            vector.clear();
            stringBuffer.append("column " + n4 + ": " + exception + "\n");
            return stringArray[n];
        }
        try {
            vector.add(Double.parseDouble(stringArray[n5]));
        }
        catch (Exception exception) {
            vector.clear();
            stringBuffer.append("column " + n5 + ": " + exception + "\n");
            return stringArray[n];
        }
        try {
            vector.add(Double.parseDouble(stringArray[n6]));
        }
        catch (Exception exception) {
            vector.clear();
            stringBuffer.append("column " + n6 + ": " + exception + "\n");
            return stringArray[n];
        }
        return stringArray[n];
    }

    private static String parseValues(String string, Vector<Double> vector, String string2, StringBuffer stringBuffer) {
        String[] stringArray = null;
        try {
            stringArray = string.split(string2);
        }
        catch (Exception exception) {
            stringBuffer.append("" + exception + "\n");
        }
        int n = 1;
        try {
            try {
                vector.add(Double.parseDouble(stringArray[n]));
            }
            catch (NumberFormatException numberFormatException) {
                vector.add(Convert4dp.HHMMSSToDeg(stringArray[n]));
            }
        }
        catch (Exception exception) {
            stringBuffer.append("column " + n + ": " + exception + "\n");
        }
        ++n;
        try {
            try {
                vector.add(Double.parseDouble(stringArray[n]));
            }
            catch (NumberFormatException numberFormatException) {
                vector.add(Convert.DDMMSSToDeg(stringArray[n]));
            }
        }
        catch (Exception exception) {
            stringBuffer.append("column " + n + ": " + exception + "\n");
        }
        ++n;
        while (n < stringArray.length) {
            try {
                vector.add(Double.parseDouble(stringArray[n]));
            }
            catch (Exception exception) {
                stringBuffer.append("column " + n + ": " + exception + "\n");
            }
            ++n;
        }
        return stringArray[0];
    }

    public void saveToFile(File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(fileOutputStream));
        bufferedWriter.write("TYCID\tRaDe\tDeDeg\tVt\tPmRa\tPmDe\tParallax\n");
        bufferedWriter.write("----\n");
        int n = this.getOpticalPointingTargetParametersCount();
        for (int i = 0; i < n; ++i) {
            OpticalPointingTargetParameters opticalPointingTargetParameters = this.getOpticalPointingTargetParameters(i);
            String string = String.format("%s\t%12.8f\t%12.8f\t%6.3f\t%6.1f\t%6.1f\t", opticalPointingTargetParameters.getSourceName(), opticalPointingTargetParameters.getSourceCoordinates().getLongitude().getContentInUnits(Longitude.UNIT_DEG), opticalPointingTargetParameters.getSourceCoordinates().getLatitude().getContentInUnits(Latitude.UNIT_DEG), opticalPointingTargetParameters.getVisibleMagnitude(), opticalPointingTargetParameters.getPmRA().getContentInUnits(AngularVelocity.UNIT_MAS_YR), opticalPointingTargetParameters.getPmDec().getContentInUnits(AngularVelocity.UNIT_MAS_YR));
            if (opticalPointingTargetParameters.getParallax().getContent() != 0.0) {
                string = string + String.format("%5.2f", opticalPointingTargetParameters.getParallax().getContentInUnits(Angle.UNIT_MAS));
            }
            string = string + "\n";
            bufferedWriter.write(string);
        }
        bufferedWriter.close();
    }

    private void resetAllTargetList() {
        this.allTargetList = new ArrayList();
        for (int i = 0; i < this.getOpticalPointingTargetParametersCount(); ++i) {
            this.allTargetList.add(this.getOpticalPointingTargetParameters(i));
        }
    }

    private void deleteAllTarget() {
        while (this.getOpticalPointingTargetParametersCount() > 0) {
            this.removeOpticalPointingTargetParameters(0);
        }
    }

    public void undoFiltering() {
        if (this.allTargetList == null) {
            return;
        }
        this.deleteAllTarget();
        Iterator<OpticalPointingTargetParameters> iterator = this.allTargetList.iterator();
        while (iterator.hasNext()) {
            this.addOpticalPointingTargetParameters(iterator.next());
        }
        this.allTargetList = null;
    }

    public boolean canUndo() {
        return this.allTargetList != null;
    }

    public void filtering() {
        int n;
        this.resetAllTargetList();
        int n2 = this.getOpticalPointingTargetParametersCount();
        boolean[] blArray = new boolean[n2];
        for (n = 0; n < n2; ++n) {
            OpticalPointingTargetParameters opticalPointingTargetParameters = this.getOpticalPointingTargetParameters(n);
            blArray[n] = this.filterIt(opticalPointingTargetParameters);
        }
        for (n = n2 - 1; n >= 0; --n) {
            if (blArray[n]) continue;
            this.removeOpticalPointingTargetParameters(n);
        }
    }

    private boolean filterIt(OpticalPointingTargetParameters opticalPointingTargetParameters) {
        if (opticalPointingTargetParameters == null) {
            return false;
        }
        Vector<Double> vector = new Vector<Double>(5);
        vector.setSize(5);
        double d = opticalPointingTargetParameters.getSourceCoordinates().getLongitude().getContentInUnits(Longitude.UNIT_DEG);
        vector.setElementAt(d, 0);
        double d2 = opticalPointingTargetParameters.getSourceCoordinates().getLatitude().getContentInUnits(Latitude.UNIT_DEG);
        vector.setElementAt(d2, 1);
        double d3 = opticalPointingTargetParameters.getVisibleMagnitude();
        vector.setElementAt(d3, 4);
        double d4 = opticalPointingTargetParameters.getPmRA().getContentInUnits(AngularVelocity.UNIT_MAS_YR);
        vector.setElementAt(d4, 2);
        double d5 = opticalPointingTargetParameters.getPmDec().getContentInUnits(AngularVelocity.UNIT_MAS_YR);
        vector.setElementAt(d5, 3);
        if (!vector.isEmpty()) {
            return this.filterIt(vector);
        }
        return false;
    }

    private boolean filterIt(Vector<Double> vector) {
        if (vector == null) {
            return false;
        }
        OpticalPointingTargetQueryParameters opticalPointingTargetQueryParameters = this.getOpticalPointingTargetQueryParameters();
        double d = vector.get(0);
        if (opticalPointingTargetQueryParameters.getMinRA() > opticalPointingTargetQueryParameters.getMaxRA() ? d < opticalPointingTargetQueryParameters.getMinRA() && d > opticalPointingTargetQueryParameters.getMaxRA() : d < opticalPointingTargetQueryParameters.getMinRA() || d > opticalPointingTargetQueryParameters.getMaxRA()) {
            return false;
        }
        double d2 = vector.get(1);
        if (d2 < opticalPointingTargetQueryParameters.getMinDec() || d2 > opticalPointingTargetQueryParameters.getMaxDec()) {
            return false;
        }
        Magnitude magnitude = Magnitude.createMagnitude(vector.get(4));
        if (Magnitude.isBrighter(magnitude, opticalPointingTargetQueryParameters.getMinMagnitude()) || Magnitude.isFainter(magnitude, opticalPointingTargetQueryParameters.getMaxMagnitude())) {
            return false;
        }
        Calendar calendar = opticalPointingTargetQueryParameters.getLstCalendar();
        if (calendar != null) {
            VupRange<Angle> vupRange;
            Date date = converter.getDate(calendar.getTime());
            SkyCoordinates skyCoordinates = OpticalPointingScienceGoal.getAzEl(d, d2, date);
            Angle angle = Angle.createAngle();
            angle.setContent(skyCoordinates.getLongitude().getContentInUnits(Longitude.UNIT_DEG));
            angle.setUnit(Longitude.UNIT_DEG);
            Angle angle2 = Angle.createAngle();
            angle2.setContent(skyCoordinates.getLatitude().getContentInUnits(Latitude.UNIT_DEG));
            angle2.setUnit(Latitude.UNIT_DEG);
            if (opticalPointingTargetQueryParameters.getMinAzimuth().isGreaterThan((AbstractDoubleWithUnit)opticalPointingTargetQueryParameters.getMaxAzimuth()) ? angle.isLessThan((AbstractDoubleWithUnit)opticalPointingTargetQueryParameters.getMinAzimuth()) && angle.isGreaterThan((AbstractDoubleWithUnit)opticalPointingTargetQueryParameters.getMaxAzimuth()) : !(vupRange = new VupRange<Angle>(opticalPointingTargetQueryParameters.getMinAzimuth(), opticalPointingTargetQueryParameters.getMaxAzimuth())).inRange(angle)) {
                return false;
            }
            vupRange = new VupRange<Angle>(opticalPointingTargetQueryParameters.getMinElevation(), opticalPointingTargetQueryParameters.getMaxElevation());
            if (!vupRange.inRange(angle2)) {
                return false;
            }
        }
        return true;
    }

    public void randomFiltering(int n, boolean bl) {
        if (bl) {
            this.randomOrderFiltering(n);
        } else {
            this.randomFiltering(n);
        }
    }

    public void randomFiltering(int n) {
        int n2;
        int n3;
        this.resetAllTargetList();
        Random random = new Random();
        int n4 = this.getOpticalPointingTargetParametersCount();
        boolean[] blArray = new boolean[n4];
        if (n < n4 / 2) {
            for (n3 = 0; n3 < n4; ++n3) {
                blArray[n3] = false;
            }
            for (n3 = 0; n3 < n; ++n3) {
                while (blArray[n2 = (random.nextInt() & Integer.MAX_VALUE) % n4]) {
                }
                blArray[n2] = true;
            }
        } else {
            for (n3 = 0; n3 < n4; ++n3) {
                blArray[n3] = true;
            }
            for (n3 = 0; n3 < n4 - n; ++n3) {
                while (!blArray[n2 = (random.nextInt() & Integer.MAX_VALUE) % n4]) {
                }
                blArray[n2] = false;
            }
        }
        for (n3 = n4 - 1; n3 >= 0; --n3) {
            if (blArray[n3]) continue;
            this.removeOpticalPointingTargetParameters(n3);
        }
    }

    public void randomOrderFiltering(int n) {
        this.resetAllTargetList();
        Random random = new Random();
        ArrayList<OpticalPointingTargetParameters> arrayList = new ArrayList<OpticalPointingTargetParameters>();
        int n2 = this.getOpticalPointingTargetParametersCount();
        for (int i = 0; i < n && (n2 = this.getOpticalPointingTargetParametersCount()) != 0; ++i) {
            int n3 = (random.nextInt() & Integer.MAX_VALUE) % n2;
            OpticalPointingTargetParameters opticalPointingTargetParameters = this.getOpticalPointingTargetParameters(n3);
            arrayList.add(opticalPointingTargetParameters);
            this.removeOpticalPointingTargetParameters(opticalPointingTargetParameters);
        }
        this.deleteAllTarget();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            this.addOpticalPointingTargetParameters((OpticalPointingTargetParameters)((Object)iterator.next()));
        }
    }

    public void separationFiltering() {
        int n;
        this.resetAllTargetList();
        int n2 = this.getOpticalPointingTargetParametersCount();
        boolean[] blArray = new boolean[n2];
        for (int i = 0; i < n2; ++i) {
            blArray[i] = false;
        }
        OpticalPointingTargetParameters[] opticalPointingTargetParametersArray = (OpticalPointingTargetParameters[])this.getOpticalPointingTargetParameters().clone();
        Comparator<OpticalPointingTargetParameters> comparator = new Comparator<OpticalPointingTargetParameters>(){

            @Override
            public int compare(OpticalPointingTargetParameters opticalPointingTargetParameters, OpticalPointingTargetParameters opticalPointingTargetParameters2) {
                double d = opticalPointingTargetParameters.getSourceCoordinates().getLatitude().getContentInDefaultUnits();
                double d2 = opticalPointingTargetParameters2.getSourceCoordinates().getLatitude().getContentInDefaultUnits();
                return (int)Math.signum(d - d2);
            }
        };
        Arrays.sort(opticalPointingTargetParametersArray, comparator);
        double[] dArray = new double[n2];
        for (int i = 0; i < n2; ++i) {
            dArray[i] = opticalPointingTargetParametersArray[i].getSourceCoordinates().getLatitude().getContentInUnits(Latitude.UNIT_DEG) * 60.0;
        }
        double d = this.getOpticalPointingTargetQueryParameters().getListMinSeparation().getContentInUnits(Angle.UNIT_ARCMIN);
        PointingCoordsConverter pointingCoordsConverter = new PointingCoordsConverter();
        SkyCoordinates skyCoordinates = SkyCoordinates.createOffsetCoordinates();
        block2: for (n = 0; n < n2; ++n) {
            OpticalPointingTargetParameters opticalPointingTargetParameters = opticalPointingTargetParametersArray[n];
            double d2 = dArray[n];
            pointingCoordsConverter.setOrigin(opticalPointingTargetParameters.getSourceCoordinates());
            for (int i = n + 1; i < n2; ++i) {
                if (blArray[n] && blArray[i]) continue;
                OpticalPointingTargetParameters opticalPointingTargetParameters2 = opticalPointingTargetParametersArray[i];
                double d3 = dArray[i];
                double d4 = d3 - d2;
                if (d4 > d) continue block2;
                pointingCoordsConverter.absoluteToOffset(opticalPointingTargetParameters2.getSourceCoordinates(), skyCoordinates);
                double d5 = skyCoordinates.getLongitude().getContentInUnits(Longitude.UNIT_DEG);
                double d6 = skyCoordinates.getLatitude().getContentInUnits(Latitude.UNIT_DEG);
                double d7 = Math.sqrt(d5 * d5 + d6 * d6) * 60.0;
                if (!(d7 < d)) continue;
                blArray[i] = true;
                blArray[n] = true;
                if (!this.logger.finest()) continue;
                String string = "Filtered the pair of " + opticalPointingTargetParameters.getSourceName() + "[" + opticalPointingTargetParameters.getSourceCoordinates().getLongitude().getContentInDefaultUnits() + "," + opticalPointingTargetParameters.getSourceCoordinates().getLatitude().getContentInDefaultUnits() + "] and " + opticalPointingTargetParameters2.getSourceName() + "[" + opticalPointingTargetParameters2.getSourceCoordinates().getLongitude().getContentInDefaultUnits() + "," + opticalPointingTargetParameters2.getSourceCoordinates().getLatitude().getContentInDefaultUnits() + "], separation = " + d7 + "[arcmin]";
                this.logger.finest(string);
            }
        }
        for (n = 0; n < n2; ++n) {
            if (!blArray[n]) continue;
            this.removeOpticalPointingTargetParameters(opticalPointingTargetParametersArray[n]);
        }
    }

    public static Date getLst(Date date) {
        return converter.getLst(date);
    }

    public static SkyCoordinates getAzEl(double d, double d2, Date date) {
        return converter.getAzEl(d, d2, date);
    }
}

