/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.obsproject;

import alma.entity.xmlbinding.obsproject.ScienceGoalT;
import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.annotations.FieldTargetDocument;
import alma.obsprep.bo.annotations.FieldTargetPart;
import alma.obsprep.bo.annotations.SpatialDocument;
import alma.obsprep.bo.annotations.SpatialPartOfSpatialDocument;
import alma.obsprep.bo.annotations.SpatialPartOfSpectralSpecDocument;
import alma.obsprep.bo.annotations.SpectralSpecDocument;
import alma.obsprep.bo.annotations.SummaryTable;
import alma.obsprep.bo.enumerations.Array;
import alma.obsprep.bo.enumerations.Telescope;
import alma.obsprep.bo.obsproject.CalibratedAbstractScienceGoal;
import alma.obsprep.bo.obsproject.ExpectedProperties;
import alma.obsprep.bo.obsproject.Field;
import alma.obsprep.bo.obsproject.NonOverlappingBandwidthCalculator;
import alma.obsprep.bo.obsproject.ObsProgram;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.RepresentativeFrequencyChangeEvent;
import alma.obsprep.bo.obsproject.RepresentativeFrequencyListener;
import alma.obsprep.bo.obsproject.ScienceSpectralWindow;
import alma.obsprep.bo.obsproject.SpectralScan;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.obsproject.UnableToFindSolutionException;
import alma.obsprep.bo.obsproject.data.ScienceGoalData;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.ot.boEditors.Wizard;
import alma.obsprep.ot.editors.misc.ScienceGoalSummaryTableColumns;
import alma.obsprep.ot.models.misc.SummaryTableColumns;
import alma.obsprep.ot.models.misc.SummaryTableRow;
import alma.obsprep.ot.models.sciencegoals.SfiControlParameterModel;
import alma.obsprep.services.etc.ObservingTimeCalculator;
import alma.obsprep.services.etc.SourceNeverVisibleException;
import alma.obsprep.services.etc.editor.WaterVaporColumns;
import alma.obsprep.services.experts.ACANecessityEstimator;
import alma.obsprep.services.experts.Configuration;
import alma.obsprep.services.experts.InvalidConfigurationParametersException;
import alma.obsprep.services.experts.InvalidFrequencyException;
import alma.obsprep.services.experts.SchedBlockExpert;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.generator.ToBeSupportedException;
import alma.obsprep.services.generator.refactored.MinTuningsCalculator;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.sfi.SingleFieldWizard;
import alma.obsprep.services.summaryfeedback.VupComparator;
import alma.obsprep.util.FrequencyRange;
import alma.obsprep.util.MiscUtils;
import alma.obsprep.util.astro.SkyPoint;
import alma.valuetypes.Angle;
import alma.valuetypes.DataRate;
import alma.valuetypes.Flux;
import alma.valuetypes.Frequency;
import alma.valuetypes.Latitude;
import alma.valuetypes.Sensitivity;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.StorageVolume;
import alma.valuetypes.Time;
import alma.valuetypes.UserFrequency;
import alma.valuetypes.UserSensitivity;
import alma.valuetypes.Velocity;
import alma.valuetypes.data.SkyCoordinatesData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Vector;

public class ScienceGoal
extends ScienceGoalData
implements SpatialDocument,
FieldTargetDocument,
SpectralSpecDocument,
SpatialPartOfSpectralSpecDocument,
SummaryTable<SummaryTableRow>,
CalibratedAbstractScienceGoal {
    private static final int KEYTARGETPARAMETER = -1;
    private Optional<Collection<MinTuningsCalculator.TuningResult>> lo1Tunings = Optional.empty();
    private ScienceGoal parentScienceGoal;
    public static final String DEFAULT_NAME = "Science Goal";
    private SummaryTableColumns summaryTableColumns;
    private ObsProposal obsProposalParent = null;
    private Object schedblockExpert;
    private int lastKeyTargetParameterIndex = 0;
    private ObservingTimeCalculator timeCalculator = new ObservingTimeCalculator(this);
    private Integer clusterIndex = null;
    private ScienceGoalType scienceGoalType = ScienceGoalType.USERDEFINED;

    public ScienceGoal(ScienceGoalT scienceGoalT) {
        super(scienceGoalT);
        this.summaryTableColumns = new ScienceGoalSummaryTableColumns(this);
    }

    public synchronized ScienceGoal deepCopy() {
        ScienceGoal scienceGoal = super.deepCopy();
        scienceGoal.getSpectralSetupParameters().setRepresentativeFrequency(this.getSpectralSetupParameters().getRepresentativeFrequency().deepCopy());
        try {
            scienceGoal.setObsProposalParent(this.getObsProposal());
        }
        catch (UnknownEntityException unknownEntityException) {
            // empty catch block
        }
        scienceGoal.setParentScienceGoal(this);
        scienceGoal.updateLocalReference();
        return scienceGoal;
    }

    public synchronized void initAsNew() {
        super.initAsNew();
        this.setName(DEFAULT_NAME);
        this.updateLocalReference();
        this.setEstimatedTotalTime(Time.createTimeSec(0.0));
        this.getCalibrationSetupParameters();
    }

    public void setName(String string) {
        if (string == null || string.equals("")) {
            super.setName(DEFAULT_NAME);
        } else {
            super.setName(string);
        }
    }

    public boolean isPhase1ScienceGoal() {
        return this.getParent() instanceof ObsProposal;
    }

    public boolean isPhase2ScienceGoal() {
        return this.getParent() instanceof ObsProgram;
    }

    public boolean isPolarizationObservation() {
        return SpectralSetupParameters.POLARISATION_FULL.equals(this.getSpectralSetupParameters().getPolarisation());
    }

    public synchronized void updateLocalReference() {
        this.getSpectralSetupParameters().reattachReprFreqCentreFrequencyListeners();
        this.addRepresentativeFrequencyListener(this.getPerformanceParameters());
        for (TargetParameters targetParameters : this.getTargetParameters()) {
            this.addRepresentativeFrequencyListener(targetParameters);
            this.addRepresentativeFrequencyListener(targetParameters.getExpectedProperties());
            for (Field field : targetParameters.getField()) {
                if (!(field instanceof RepresentativeFrequencyListener)) continue;
                this.addRepresentativeFrequencyListener((RepresentativeFrequencyListener)((Object)field));
            }
            TargetParameters.attachSourceVelocityListeners(targetParameters);
        }
        this.getSpectralSetupParameters().reattachReprFreqListener();
    }

    public SummaryTableColumns getSummaryTableColumns() {
        return this.summaryTableColumns;
    }

    public Collection<BusinessObject> instantiated() {
        Vector<BusinessObject> vector = new Vector<BusinessObject>();
        return vector;
    }

    public ObsProposal getObsProposal() throws UnknownEntityException {
        BusinessObject businessObject = this.getParent();
        if (businessObject == null) {
            return this.obsProposalParent;
        }
        if (businessObject instanceof ObsProgram) {
            if ((businessObject = businessObject.getParent()) == null) {
                return null;
            }
            if (!(businessObject instanceof ObsProject)) {
                throw new RuntimeException("Unable to locate ObsProject associated with science goal");
            }
            ObsProject obsProject = (ObsProject)businessObject;
            return obsProject.getObsProposal();
        }
        if (businessObject instanceof ObsProposal) {
            return (ObsProposal)businessObject;
        }
        throw new RuntimeException("Unable to locate ObsProject associated with science goal");
    }

    public boolean isSpectralScan() {
        return this.getSpectralSetupParameters().isSpectralScan();
    }

    public boolean isSpectral() {
        return true;
    }

    public boolean isSpatial(String string) {
        return string.equals("Field Setup");
    }

    public boolean isSpectral(String string) {
        return string.equals("Spectral Setup");
    }

    public Wizard getWizard() {
        if (this.wizard == null) {
            this.wizard = new SingleFieldWizard(this);
        }
        return this.wizard;
    }

    public Object getSchedBlockExpert() {
        return this.schedblockExpert;
    }

    public synchronized void setSchedBlockExpert(Object object) {
        this.schedblockExpert = object;
    }

    @Override
    public SpatialPartOfSpatialDocument getSpatialPartOfSpatialDocument() {
        return this.getSoleTargetParameters();
    }

    @Override
    public Frequency getSingleFrequency() {
        return this.getRepresentativeFrequencyInSky();
    }

    @Override
    public String getSingleFrequencySource() {
        SpectralSetupParameters spectralSetupParameters = this.getSpectralSetupParameters();
        return spectralSetupParameters.getNameOrDefault() + ":representativeFrequency";
    }

    public Frequency getLO1Frequency() {
        return this.getSpectralSetupParameters().getLO1Frequency();
    }

    public Frequency getRestFrequency() {
        return this.getRepresentativeFrequency();
    }

    @Override
    public FieldTargetPart getFieldTargetPart() {
        return this.getSoleTargetParameters();
    }

    public String getFieldType() {
        String string = TargetParameters.TYPE_F_MULTIPLEPOINTS;
        if (this.getTargetParametersCount() > 0) {
            string = this.getTargetParameters(0).getType();
            for (TargetParameters targetParameters : this.getTargetParameters()) {
                if (targetParameters.getType().equals(string)) continue;
                String string2 = "mixed field type is not supported";
                Log.logger((Object)this).severe(string2);
                throw new RuntimeException(string2);
            }
        }
        return string;
    }

    public Frequency getRepresentativeFrequency() {
        SpectralSetupParameters spectralSetupParameters = this.getSpectralSetupParameters();
        Frequency frequency = spectralSetupParameters.gettrueRepresentativeFrequency();
        if (frequency == null || frequency.isZero()) {
            frequency = spectralSetupParameters.getSoleFrequency();
        }
        return frequency;
    }

    public Frequency getRepresentativeFrequencyInSky() {
        SpectralSetupParameters spectralSetupParameters = this.getSpectralSetupParameters();
        Frequency frequency = spectralSetupParameters.gettrueRepresentativeFrequency();
        if (frequency == null || frequency.isZero()) {
            frequency = spectralSetupParameters.getSoleFrequency();
        }
        if (spectralSetupParameters.isSingleContinuumSkyFrequency() || spectralSetupParameters.getSSPDerivedFromSpectralScanSetup().booleanValue() || spectralSetupParameters.isSpectralScan()) {
            return frequency;
        }
        return frequency.dopplerShifted(this.getSourceVelocity());
    }

    public Frequency getRepresentativeBandwidth() {
        PerformanceParameters performanceParameters = this.getPerformanceParameters();
        Frequency frequency = null;
        String string = performanceParameters.getDesiredSensitivityFrequencyMeasure();
        frequency = this.getSpectralSetupParameters().getDesiredSensitivityFrequencyWidth(string);
        return frequency;
    }

    public ReceiverBand getReceiverBand() {
        return this.getSpectralSetupParameters().getReceiverBand();
    }

    public TargetParameters getKeyTargetParameters() {
        TargetParameters[] targetParametersArray;
        if (this.getTargetParametersCount() == 0) {
            targetParametersArray = TargetParameters.createTargetParameters();
            this.addTargetParameters((TargetParameters)targetParametersArray);
            targetParametersArray.setIndex(-1);
        }
        if ((targetParametersArray = this.getTargetParameters()).length > this.lastKeyTargetParameterIndex && targetParametersArray[this.lastKeyTargetParameterIndex].getIndex() == -1) {
            return targetParametersArray[this.lastKeyTargetParameterIndex];
        }
        for (int i = 0; i < targetParametersArray.length; ++i) {
            if (targetParametersArray[i].getIndex() != -1) continue;
            this.lastKeyTargetParameterIndex = i;
            return targetParametersArray[i];
        }
        return this.getTargetParameters(0);
    }

    public int getKeyTargetParametersPosition() {
        if (this.getTargetParametersCount() == 0) {
            TargetParameters targetParameters = TargetParameters.createTargetParameters();
            this.addTargetParameters(targetParameters);
            return 0;
        }
        int n = 0;
        for (TargetParameters targetParameters : this.getTargetParameters()) {
            if (targetParameters.getIndex() == -1) {
                return n;
            }
            ++n;
        }
        return 0;
    }

    public synchronized void setKeyTargetParameters(int n) {
        if (this.getTargetParametersCount() == 0) {
            TargetParameters targetParameters = TargetParameters.createTargetParameters();
            this.addTargetParameters(targetParameters);
            targetParameters.setIndex(-1);
        }
        for (int i = 0; i < this.getTargetParametersCount(); ++i) {
            this.getTargetParameters(i).setIndex(0);
            if (i != n) continue;
            this.getTargetParameters(i).setIndex(-1);
        }
    }

    public TargetParameters getSoleTargetParameters() {
        if (this.getTargetParametersCount() == 0) {
            TargetParameters targetParameters = TargetParameters.createTargetParameters();
            this.addTargetParameters(targetParameters);
        }
        if (this.getTargetParametersCount() != 1) {
            // empty if block
        }
        return this.getTargetParameters(0);
    }

    public synchronized TargetParameters setTargetParameters(TargetParameters targetParameters) {
        if (this.getTargetParametersCount() > 1) {
            throw new RuntimeException("unexpected multiple TargetParameters");
        }
        if (this.getTargetParametersCount() == 0) {
            this.addTargetParameters(targetParameters);
        } else {
            this.clearTargetParameters();
            this.addTargetParameters(targetParameters);
        }
        return this.getTargetParameters(0);
    }

    public int indexOf(TargetParameters targetParameters) {
        TargetParameters[] targetParametersArray = this.getTargetParameters();
        for (int i = 0; i < targetParametersArray.length; ++i) {
            if (!targetParametersArray[i].matches(targetParameters)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Iterator<SummaryTableRow> iterator() {
        ArrayList<TargetParameters> arrayList = new ArrayList<TargetParameters>();
        arrayList.addAll(Arrays.asList(this.getTargetParameters()));
        return arrayList.iterator();
    }

    @Override
    public boolean expandsRow() {
        return true;
    }

    @Override
    public boolean isSummaryTableEditable() {
        return false;
    }

    @Override
    public boolean showsControlButtons() {
        return false;
    }

    public ObservingTimeCalculator getTimeCalculator() {
        return this.timeCalculator;
    }

    public int getNumberOf12mConfigurations() throws InvalidObsProgramParametersException {
        return this.timeCalculator.getNumberOfAntennaConfigurations(RequestedArray.TWELVE_M);
    }

    public Time getTotalRequestedTime(Array array) throws InvalidObsProgramParametersException {
        return this.timeCalculator.getRequestedTimeForAllConfigurations(array, true);
    }

    public Time getTotalRequestedTime(Array array, boolean bl) throws InvalidObsProgramParametersException {
        return this.timeCalculator.getRequestedTimeForAllConfigurations(array, bl);
    }

    public Time getTotalRequestedTimeCompact() throws InvalidObsProgramParametersException {
        Time time = this.timeCalculator.getTotalRequestedTime(Array.ARRAY_12M);
        return this.timeCalculator.getTimeForSecond12mCompactArray(time, true, false);
    }

    public Time getTotalOnSourceTime(Array array) throws InvalidObsProgramParametersException {
        return this.timeCalculator.getTotalOnSourceTime(array, true);
    }

    public Time getTotalTimeForScienceGoal() throws ObservingTimeCalculator.UnableToCalculateTimeEstimateException {
        return this.getTotalTimeForScienceGoal(false);
    }

    public Time getTotalTimeForScienceGoal(boolean bl) throws ObservingTimeCalculator.UnableToCalculateTimeEstimateException {
        return this.timeCalculator.getTotalTimeForScienceGoal(false, bl, false, true);
    }

    public Time getTotalTimeForSGWithoutACA(boolean bl) throws ObservingTimeCalculator.UnableToCalculateTimeEstimateException {
        return this.timeCalculator.getTotalTimeForScienceGoal(true, bl, false, true);
    }

    public Time getTotal12mExtendedTimeForSG() throws InvalidObsProgramParametersException {
        return this.timeCalculator.getOnTheoreticalOnSourceTimeForArray(Array.ARRAY_12M);
    }

    public Time getSinglePointOnSourceTime(Array array, TargetParameters targetParameters) throws InvalidObsProgramParametersException {
        return this.timeCalculator.getSinglePointOnSourceTime(array, targetParameters, true);
    }

    public Time getSinglePointOnSourceTimeFromSB(Array array) throws InvalidObsProgramParametersException, UnknownEntityException {
        TargetParameters targetParameters = this.getSoleTargetParameters();
        return this.timeCalculator.singlePointOnSourceTimeFromSB(targetParameters, array);
    }

    public Time getSinglePointOnSourceTimeFromSB(Array array, TargetParameters targetParameters) throws InvalidObsProgramParametersException {
        Time time = this.timeCalculator.getSinglePointOnSourceTime(array, targetParameters, true);
        try {
            time = this.timeCalculator.singlePointOnSourceTimeFromSB(targetParameters, array);
        }
        catch (UnknownEntityException unknownEntityException) {
            // empty catch block
        }
        return time;
    }

    public Sensitivity getSinglePointOnSourceSensitivity(Array array, Time time, TargetParameters targetParameters, ScienceSpectralWindow scienceSpectralWindow) throws InvalidFrequencyException, SourceNeverVisibleException {
        return this.timeCalculator.singlePointOnSourceSensitivity(array, time, targetParameters, scienceSpectralWindow);
    }

    public Sensitivity getSinglePointOnSourceSensitivity(Array array, Time time, TargetParameters targetParameters, Frequency frequency, Frequency frequency2) throws InvalidFrequencyException, SourceNeverVisibleException {
        return this.timeCalculator.singlePointOnSourceSensitivity(array, time, targetParameters, frequency, frequency2);
    }

    public Sensitivity getSinglePointOnSourceSensitivity(Array array, Frequency frequency, Frequency frequency2) throws InvalidObsProgramParametersException, InvalidFrequencyException, SourceNeverVisibleException {
        TargetParameters targetParameters = this.getSoleTargetParameters();
        Time time = this.calculateSinglePointOnSourceTimeArray(array, targetParameters);
        return this.timeCalculator.singlePointOnSourceSensitivity(array, time, targetParameters, frequency, frequency2);
    }

    public Sensitivity getSinglePointOnSourceSensitivity(Array array, Time time, Frequency frequency, Frequency frequency2) throws InvalidObsProgramParametersException, InvalidFrequencyException, SourceNeverVisibleException {
        TargetParameters targetParameters = this.getSoleTargetParameters();
        return this.timeCalculator.singlePointOnSourceSensitivity(array, time, targetParameters, frequency, frequency2);
    }

    public Sensitivity getSinglePointOnSourceSensitivity(Array array, Frequency frequency) throws InvalidObsProgramParametersException, InvalidFrequencyException, SourceNeverVisibleException {
        Time time = this.calculateOnSourceTimeArray(array);
        TargetParameters targetParameters = this.getSoleTargetParameters();
        return this.timeCalculator.singlePointOnSourceSensitivity(array, time, targetParameters, frequency);
    }

    public Sensitivity getSinglePointOnSourceSensitivity(Array array, Time time, TargetParameters targetParameters, Frequency frequency) throws InvalidFrequencyException, SourceNeverVisibleException {
        return this.timeCalculator.singlePointOnSourceSensitivity(array, time, targetParameters, frequency);
    }

    public DataRate getDataRate(Array array) throws ObservingTimeCalculator.UnableToDetermineInstantaneousDataRateException {
        return this.timeCalculator.getPeakDataRate(array, false);
    }

    public DataRate getAverageDataRate(Array array) {
        DataRate dataRate = DataRate.createDataRate();
        try {
            dataRate = this.timeCalculator.getAverageDataRate(array);
        }
        catch (ObservingTimeCalculator.UnableToDetermineInstantaneousDataRateException unableToDetermineInstantaneousDataRateException) {
            Log.logger(ScienceGoal.class).warning("Unable to determine the average data rate " + unableToDetermineInstantaneousDataRateException);
        }
        return dataRate;
    }

    public List<DataRate> getInstantaneousDataRates(RequestedArray requestedArray) throws ObservingTimeCalculator.UnableToDetermineInstantaneousDataRateException {
        return this.timeCalculator.getInstantaneousDataRates(requestedArray);
    }

    public StorageVolume getDataVolume(Array array) throws InvalidObsProgramParametersException, ToBeSupportedException {
        return this.timeCalculator.getDataVolume(array);
    }

    public int getRecommendedWVCIndex() {
        int n = 0;
        Frequency frequency = this.getRepresentativeFrequencyInSky();
        Optional<ReceiverBand> optional = Optional.ofNullable(this.getSpectralSetupParameters().getReceiverBand());
        for (TargetParameters targetParameters : this.getTargetParameters()) {
            SkyCoordinates skyCoordinates = targetParameters.getSourceCoordinates();
            Latitude latitude = null;
            latitude = skyCoordinates.getSystem().equals(SkyCoordinatesData.SYSTEM_ICRS) ? skyCoordinates.getLatitude() : skyCoordinates.getJ2000SkyCoordinates().getLatitude();
            n = Math.max(WaterVaporColumns.wvindexSelector(frequency, latitude, optional), n);
        }
        return n;
    }

    @Override
    public SpatialPartOfSpectralSpecDocument getSpatialPartOfSpectralSpecDocument() {
        return this.getSoleTargetParameters();
    }

    @Override
    public SpectralSpec getSpectralSpec() {
        return null;
    }

    @Override
    public Velocity getSourceVelocity() {
        return this.getSoleTargetParameters().getSourceVelocity();
    }

    public void addRepresentativeFrequencyListener(RepresentativeFrequencyListener representativeFrequencyListener) {
        this.getSpectralSetupParameters().addRepresentativeFrequencyListener(representativeFrequencyListener);
    }

    public boolean removeRepresentativeFrequencyListener(RepresentativeFrequencyListener representativeFrequencyListener) {
        return this.getSpectralSetupParameters().removeRepresentativeFrequencyListener(representativeFrequencyListener);
    }

    public void addTargetParameters(int n, TargetParameters targetParameters) throws IndexOutOfBoundsException {
        super.addTargetParameters(n, targetParameters);
        this.addRepresentativeFrequencyListener(targetParameters);
        targetParameters.representativeFrequencyUpdated(new RepresentativeFrequencyChangeEvent(this));
    }

    public boolean removeTargetParameters(TargetParameters targetParameters) {
        this.removeRepresentativeFrequencyListener(targetParameters);
        return super.removeTargetParameters(targetParameters);
    }

    public void setPerformanceParameters(PerformanceParameters performanceParameters) {
        PerformanceParameters performanceParameters2 = this.gettruePerformanceParameters();
        this.removeRepresentativeFrequencyListener(performanceParameters2);
        super.setPerformanceParameters(performanceParameters);
        this.addRepresentativeFrequencyListener(performanceParameters);
        Frequency frequency = this.getSpectralSetupParameters().getRepresentativeFrequency();
        performanceParameters.representativeFrequencyUpdated(new RepresentativeFrequencyChangeEvent((Object)frequency));
    }

    public ExpectedPropertiesElements collapseExpectedProperties() {
        ExpectedPropertiesElements expectedPropertiesElements = new ExpectedPropertiesElements();
        SpectralSetupParameters spectralSetupParameters = this.getSpectralSetupParameters();
        TargetParameters[] targetParametersArray = this.getTargetParameters();
        if (targetParametersArray.length == 0) {
            return expectedPropertiesElements;
        }
        TargetParameters targetParameters = targetParametersArray[0];
        Velocity velocity = targetParameters.getSourceVelocity();
        ExpectedProperties expectedProperties = targetParameters.getExpectedProperties();
        expectedPropertiesElements.velocity = velocity;
        expectedPropertiesElements.resolvedVelocity = spectralSetupParameters.getVelocityResolutionInSky(velocity);
        double d = expectedProperties.getExpectedLineWidth().getContentInUnits(UserFrequency.USERUNIT_KM_S);
        expectedPropertiesElements.expectedLineWidth = expectedProperties.getExpectedLineWidth();
        expectedPropertiesElements.resPerLineWidth = this.numberOfResolutionsPerLinewidth(d, spectralSetupParameters, velocity);
        expectedPropertiesElements.expectedPeakLineFluxDensity = expectedProperties.getExpectedPeakLineFluxDensity();
        expectedPropertiesElements.expectedPeakFluxDensity = expectedProperties.getExpectedPeakFluxDensity();
        expectedPropertiesElements.desiredLinePolarizationPercentage = MiscUtils.minClosestToZero(expectedProperties.getDesiredLinePolarizationPercentage(), expectedProperties.getDesiredLineCircularPolarizationPercentage());
        expectedPropertiesElements.desiredContPolarizationPercentage = MiscUtils.minClosestToZero(expectedProperties.getDesiredPolarizationPercentage(), expectedProperties.getDesiredCircularPolarizationPercentage());
        double d2 = expectedProperties.getExpectedPeakLineFluxDensity().getContentInDefaultUnits();
        expectedPropertiesElements.lowestPolLineFluxFactor = d2 * expectedPropertiesElements.desiredLinePolarizationPercentage;
        expectedPropertiesElements.lowestPolContFluxFactor = d2 * expectedPropertiesElements.desiredContPolarizationPercentage;
        PerformanceParameters performanceParameters = this.getPerformanceParameters();
        UserFrequency userFrequency = performanceParameters.getSensitivityFrequencyWidthAsUF();
        expectedPropertiesElements.bandwidthForLineRMS = expectedProperties.getExpectedLineWidth().deepCopy().divide(3.0);
        expectedPropertiesElements.aggregateBandwith = this.getAggregateBandwidthForTarget(targetParameters);
        expectedPropertiesElements.lineRms = this.calculateSensitivityForBandwidth(targetParameters, (Frequency)((Object)expectedPropertiesElements.bandwidthForLineRMS));
        expectedPropertiesElements.sensitivityForBW = this.calculateSensitivityForBandwidth(targetParameters, expectedPropertiesElements.aggregateBandwith);
        expectedPropertiesElements.bandwidthRms = this.calculateSensitivityForBandwidth(targetParameters, (Frequency)((Object)userFrequency));
        expectedPropertiesElements.dynamicRange = this.calculateDynamicRange(d, userFrequency, expectedPropertiesElements.expectedPeakFluxDensity, expectedPropertiesElements.lineRms, expectedPropertiesElements.bandwidthRms);
        Log.logger((Object)this).fine("Dynamic Range : " + expectedPropertiesElements.dynamicRange);
        for (int i = 1; i < targetParametersArray.length; ++i) {
            targetParameters = targetParametersArray[i];
            expectedProperties = targetParameters.getExpectedProperties();
            UserFrequency userFrequency2 = expectedProperties.getExpectedLineWidth().deepCopy().divide(3.0);
            UserSensitivity userSensitivity = this.calculateSensitivityForBandwidth(targetParameters, (Frequency)((Object)userFrequency2));
            Frequency frequency = this.getAggregateBandwidthForTarget(targetParameters);
            UserSensitivity userSensitivity2 = this.calculateSensitivityForBandwidth(targetParameters, frequency);
            UserSensitivity userSensitivity3 = this.calculateSensitivityForBandwidth(targetParameters, (Frequency)((Object)userFrequency));
            Flux flux = expectedProperties.getExpectedPeakFluxDensity();
            double d3 = this.calculateDynamicRange(d, userFrequency, flux, userSensitivity, userSensitivity3);
            Log.logger((Object)this).fine("Current Dynamic Range : " + d3);
            if (expectedPropertiesElements.dynamicRange < d3) {
                expectedPropertiesElements.dynamicRange = d3;
            }
            Log.logger((Object)this).fine("Largest Dynamic Range : " + expectedPropertiesElements.dynamicRange);
            if (expectedPropertiesElements.expectedPeakFluxDensity.getContentInDefaultUnits() > expectedProperties.getExpectedPeakFluxDensity().getContentInDefaultUnits()) {
                expectedPropertiesElements.expectedPeakFluxDensity = expectedProperties.getExpectedPeakFluxDensity();
            }
            if (expectedPropertiesElements.expectedPeakLineFluxDensity.getContentInDefaultUnits() > flux.getContentInDefaultUnits()) {
                expectedPropertiesElements.expectedPeakLineFluxDensity = expectedProperties.getExpectedPeakLineFluxDensity();
            }
            d = expectedProperties.getExpectedLineWidth().getContentInUnits(UserFrequency.USERUNIT_KM_S);
            velocity = targetParametersArray[i].getSourceVelocity();
            expectedPropertiesElements.resolvedVelocity = spectralSetupParameters.getVelocityResolutionInSky(velocity);
            double d4 = this.numberOfResolutionsPerLinewidth(d, expectedPropertiesElements.resolvedVelocity);
            if (expectedPropertiesElements.resPerLineWidth > d4 || expectedPropertiesElements.resPerLineWidth == d4 && d < expectedPropertiesElements.expectedLineWidth.getContentInUnits(UserFrequency.USERUNIT_KM_S)) {
                expectedPropertiesElements.expectedLineWidth = expectedProperties.getExpectedLineWidth();
                expectedPropertiesElements.resPerLineWidth = d4;
                expectedPropertiesElements.velocity = velocity;
                expectedPropertiesElements.lineRms = userSensitivity;
                expectedPropertiesElements.bandwidthForLineRMS = userFrequency2;
                expectedPropertiesElements.bandwidthRms = userSensitivity3;
            } else {
                expectedPropertiesElements.sensitivityForBW = userSensitivity2;
                expectedPropertiesElements.aggregateBandwith = frequency;
            }
            double d5 = MiscUtils.minClosestToZero(expectedProperties.getDesiredLinePolarizationPercentage(), expectedProperties.getDesiredLineCircularPolarizationPercentage());
            double d6 = MiscUtils.minClosestToZero(expectedProperties.getDesiredPolarizationPercentage(), expectedProperties.getDesiredCircularPolarizationPercentage());
            if (d5 != 0.0 && (expectedPropertiesElements.lowestPolLineFluxFactor == 0.0 || expectedPropertiesElements.lowestPolLineFluxFactor > d2 * d5)) {
                expectedPropertiesElements.desiredLinePolarizationPercentage = d5;
                expectedPropertiesElements.lowestPolLineFluxFactor = d2 * d5;
            }
            if (d6 == 0.0 || expectedPropertiesElements.lowestPolContFluxFactor != 0.0 && !(expectedPropertiesElements.lowestPolContFluxFactor > d2 * d6)) continue;
            expectedPropertiesElements.desiredContPolarizationPercentage = d6;
            expectedPropertiesElements.lowestPolContFluxFactor = d2 * d6;
        }
        return expectedPropertiesElements;
    }

    private double calculateDynamicRange(double d, UserFrequency userFrequency, Flux flux, UserSensitivity userSensitivity, UserSensitivity userSensitivity2) {
        SpectralSetupParameters spectralSetupParameters = this.getSpectralSetupParameters();
        double d2 = userFrequency.getContentInUnits(UserFrequency.USERUNIT_KM_S);
        if (spectralSetupParameters.isSingleContinuum() || d2 > 2.0 * d) {
            return flux.getContentInUnits(Sensitivity.UNIT_MJY) / userSensitivity.getContentInUnits(Sensitivity.UNIT_MJY);
        }
        Log.logger((Object)this).fine("using calculated RMS of " + userSensitivity2.getContentInUnits(Sensitivity.UNIT_MJY));
        return flux.getContentInUnits(Sensitivity.UNIT_MJY) / userSensitivity2.getContentInUnits(Sensitivity.UNIT_MJY);
    }

    private double numberOfResolutionsPerLinewidth(double d, double d2) {
        Double d3 = null;
        if (d2 != 0.0) {
            d3 = d / d2;
        }
        Log.logger((Object)this).finest("sum = linewidth " + d + " / resolution  :" + d2);
        return d3 == null ? 0.0 : d3;
    }

    public Time calculateSinglePointOnSourceTimeArray(Array array, TargetParameters targetParameters) throws InvalidObsProgramParametersException {
        Time time = Time.createTime();
        time = this.getSinglePointOnSourceTime(array, targetParameters);
        time.convertToUnit(Time.UNIT_H);
        return time;
    }

    public Time calculateOnSourceTimeArray(Array array) throws InvalidObsProgramParametersException {
        Time time = Time.createTime();
        time = this.getTotalOnSourceTime(array);
        time.convertToUnit(Time.UNIT_H);
        return time;
    }

    public Flux getMaxContinuumFlux() {
        ArrayList<Flux> arrayList = new ArrayList<Flux>();
        for (TargetParameters targetParameters : this.getTargetParameters()) {
            ExpectedProperties expectedProperties = targetParameters.getExpectedProperties();
            arrayList.add(expectedProperties.getExpectedPeakFluxDensity());
        }
        if (arrayList.size() == 0) {
            return Flux.createFlux();
        }
        VupComparator vupComparator = new VupComparator();
        Collections.sort(arrayList, vupComparator);
        return (Flux)((Object)arrayList.get(arrayList.size() - 1));
    }

    @Override
    public synchronized void setSpectralSetupParameters(SpectralSetupParameters spectralSetupParameters) {
        SpectralSetupParameters spectralSetupParameters2 = this.gettrueSpectralSetupParameters();
        if (spectralSetupParameters2 != null) {
            this.removeRepresentativeFrequencyListener(this.getPerformanceParameters());
            for (TargetParameters targetParameters : this.getTargetParameters()) {
                this.removeRepresentativeFrequencyListener(targetParameters);
                this.removeRepresentativeFrequencyListener(targetParameters.getExpectedProperties());
                for (Field field : targetParameters.getField()) {
                    if (!(field instanceof RepresentativeFrequencyListener)) continue;
                    this.removeRepresentativeFrequencyListener((RepresentativeFrequencyListener)((Object)field));
                }
            }
        }
        super.setSpectralSetupParameters(spectralSetupParameters);
        if (spectralSetupParameters == null) {
            return;
        }
        this.updateLocalReference();
        Frequency frequency = spectralSetupParameters.getRepresentativeFrequency();
        spectralSetupParameters.getRepresentativeFrequency().setContentAndUnit((ValueUnitPair)frequency);
    }

    public Time getOverheadTimes(EnumSet<ObservingTimeCalculator.Overheads> enumSet, Array array, TargetParameters targetParameters, boolean bl) throws InvalidObsProgramParametersException {
        return this.timeCalculator.getOverheadTimes(bl, enumSet, array, targetParameters);
    }

    private double numberOfResolutionsPerLinewidth(double d, SpectralSetupParameters spectralSetupParameters, Velocity velocity) {
        Double d2 = null;
        double d3 = spectralSetupParameters.getVelocityResolutionInSky(velocity);
        if (d3 != 0.0) {
            d2 = d / d3;
        }
        Log.logger((Object)this).finest("sum = linewidth " + d + " / resolution  :" + d3);
        return d2 == null ? 0.0 : d2;
    }

    public Integer getNumberOf12MAntennaConfigurations() throws InvalidObsProgramParametersException {
        PerformanceParameters performanceParameters = this.getPerformanceParameters();
        Frequency frequency = this.getRepresentativeFrequencyInSky();
        Configuration configuration = null;
        Integer n = 0;
        try {
            if (this.getObsProposal().isVLBI()) {
                return 1;
            }
        }
        catch (UnknownEntityException unknownEntityException) {
            return 1;
        }
        try {
            configuration = Configuration.getBestConfiguration(performanceParameters.getDesiredAngularResolution(), frequency, RequestedArray.TWELVE_M, this);
        }
        catch (InvalidConfigurationParametersException invalidConfigurationParametersException) {
            String string = "Cannot establish the best array configuration for a desired angular resolution of " + performanceParameters.getDesiredAngularResolution() + " with a rep. freq of " + (Object)((Object)frequency);
            Log.logger((Object)this).severe(string);
            throw new InvalidObsProgramParametersException(string);
        }
        Integer n2 = n;
        Integer n3 = n = Integer.valueOf(n + 1);
        if (Configuration.getIsSecondConfigurationRequired(configuration, performanceParameters.getDesiredLargestScale(), frequency, this)) {
            try {
                Configuration.getSecondCompactConfiguration(configuration);
                n2 = n;
                n3 = n = Integer.valueOf(n + 1);
            }
            catch (InvalidConfigurationParametersException invalidConfigurationParametersException) {
                // empty catch block
            }
        }
        return n;
    }

    public TargetParameters getTargetParameters(String string) throws UnableToFindTargetParametersException {
        if (string == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: sourceName");
        }
        for (TargetParameters targetParameters : this.getTargetParameters()) {
            if (!targetParameters.getSourceName().equals(string)) continue;
            return targetParameters;
        }
        throw new UnableToFindTargetParametersException("Target parameters for source " + string + " not found ");
    }

    public boolean isSolarScienceGoal() throws UnknownEntityException {
        return this.getScienceGoalMode().equals((Object)ScienceGoalMode.SOLAR);
    }

    public boolean isStandAloneACA() {
        ScienceGoalMode scienceGoalMode;
        try {
            scienceGoalMode = this.getScienceGoalMode();
        }
        catch (UnknownEntityException unknownEntityException) {
            throw new RuntimeException("Unable to determine if the ACA is in standalone mode");
        }
        return scienceGoalMode.equals((Object)ScienceGoalMode.STANDALONEACA);
    }

    public ScienceGoalMode getScienceGoalMode() throws UnknownEntityException {
        ObsProposal obsProposal = this.getObsProposal();
        if (obsProposal != null && obsProposal.getProposalTypeCode().equals("V")) {
            return ScienceGoalMode.STANDARD;
        }
        if (!(obsProposal == null || obsProposal.getProposalTypeCode().equals("T") && obsProposal.getProposalTypeCode().equals("V"))) {
            for (TargetParameters targetParameters : this.getTargetParameters()) {
                if (!targetParameters.getNonSiderealMotion() || targetParameters.getSolarSystemObject() != TargetParameters.SOLARSYSTEMOBJECT_SUN) continue;
                return ScienceGoalMode.SOLAR;
            }
        }
        if (this.getPerformanceParameters().isAngularResolutionModeSACA()) {
            return ScienceGoalMode.STANDALONEACA;
        }
        return ScienceGoalMode.STANDARD;
    }

    public List<SourcePoint> getAllSiderealSourceFieldCentres() {
        ArrayList<SourcePoint> arrayList = new ArrayList<SourcePoint>();
        for (TargetParameters targetParameters : this.getTargetParameters()) {
            SkyCoordinates skyCoordinates = targetParameters.getSourceCoordinates().getJ2000SkyCoordinates();
            if (targetParameters.getNonSiderealMotion()) continue;
            SkyPoint skyPoint = skyCoordinates.getAbsoluteSkyPointInICRSDeg();
            arrayList.add(new SourcePoint(targetParameters, skyPoint));
        }
        return arrayList;
    }

    public BusinessObject getParent() {
        Object object = super.getParent();
        if (object == null) {
            object = this.obsProposalParent;
        }
        return object;
    }

    public ObsProposal getObsProposalParent() {
        return this.obsProposalParent;
    }

    public void setObsProposalParent(ObsProposal obsProposal) {
        this.obsProposalParent = obsProposal;
    }

    public ScienceGoal getParentScienceGoal() {
        return this.parentScienceGoal;
    }

    public void setParentScienceGoal(ScienceGoal scienceGoal) {
        this.parentScienceGoal = scienceGoal;
    }

    public void setClusterIndex(int n) {
        this.clusterIndex = n;
    }

    public int getClusterIndex() throws NotClusteredScienceGoalException {
        if (this.clusterIndex == null) {
            throw new NotClusteredScienceGoalException();
        }
        return this.clusterIndex;
    }

    public ScienceGoalType getScienceGoalType() {
        return this.scienceGoalType;
    }

    public synchronized void setScienceGoalType(ScienceGoalType scienceGoalType) {
        this.scienceGoalType = scienceGoalType;
    }

    public void determineACAScheduling() {
        ScienceGoal.determineACAScheduling(this);
    }

    public static boolean determineACAScheduling(ScienceGoal scienceGoal) {
        Object object;
        if (scienceGoal == null) {
            return false;
        }
        PerformanceParameters performanceParameters = scienceGoal.getPerformanceParameters();
        if (performanceParameters == null) {
            return false;
        }
        boolean bl = true;
        boolean bl2 = false;
        SpectralSetupParameters spectralSetupParameters = scienceGoal.getSpectralSetupParameters();
        boolean bl3 = false;
        try {
            bl3 = scienceGoal.isSolarScienceGoal();
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(SfiControlParameterModel.class).warning("Unable to determine if science goal is solar : " + unknownEntityException.getMessage());
        }
        boolean bl4 = false;
        try {
            object = scienceGoal.getObsProposal();
            if (object == null) {
                return false;
            }
            bl4 = ((ObsProposal)((Object)object)).isVLBI();
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(SfiControlParameterModel.class).warning("Unable to determine if project is VLBI: " + unknownEntityException.getMessage());
        }
        if (bl4) {
            Log.logger(SfiControlParameterModel.class).fine("ACA is not scheduled for VLBI");
            bl = false;
            bl2 = false;
        } else if (bl3) {
            Log.logger(SfiControlParameterModel.class).fine("ACA is scheduled for solar");
            bl = true;
            bl2 = true;
        } else {
            if (spectralSetupParameters.isSpectralScan()) {
                bl = false;
            }
            if (spectralSetupParameters.isFullPolarisation().booleanValue() && !Telescope.isOTConfiguredAs(Telescope.CSVALMA)) {
                bl = false;
            }
            if (!scienceGoal.isStandAloneACA() && bl) {
                object = new ACANecessityEstimator(performanceParameters.getDesiredLargestScale(), (Angle)((Object)performanceParameters.getDesiredAngularResolution()), performanceParameters.getRepresentativeFrequencyWithSkyOffset());
                bl = ((ACANecessityEstimator)object).acaNecessity(scienceGoal);
            }
            if (bl) {
                bl2 = SchedBlockExpert.determineIfTPArrayIsToBeUsed(bl, scienceGoal);
            }
        }
        performanceParameters.setUseACA(bl);
        performanceParameters.setUseTP(bl2);
        Log.logger(SfiControlParameterModel.class).finer("ACA 7m: " + bl + " ACA TP : " + bl2);
        return performanceParameters.getUseACA() != bl || performanceParameters.getUseTP() != bl2;
    }

    public synchronized Optional<Collection<MinTuningsCalculator.TuningResult>> getLo1Tunings() {
        return this.lo1Tunings;
    }

    public synchronized void setLo1Tunings(Optional<Collection<MinTuningsCalculator.TuningResult>> optional) {
        this.lo1Tunings = optional;
    }

    public synchronized void clearLo1Tunings() {
        this.lo1Tunings = Optional.empty();
    }

    private UserSensitivity calculateSensitivityForBandwidth(TargetParameters targetParameters, Frequency frequency) {
        Object object;
        Object object2;
        Sensitivity sensitivity = Sensitivity.createSensitivity();
        SpectralSetupParameters spectralSetupParameters = this.getSpectralSetupParameters();
        Frequency frequency2 = spectralSetupParameters.getRepresentativeFrequencyWithSkyOffset().deepCopy();
        try {
            object2 = this.isStandAloneACA() ? Array.ARRAY_7M : Array.ARRAY_12M;
            object = this.timeCalculator.singlePointOnSourceTimeFromSB(targetParameters, (Array)((Object)object2));
            Log.logger((Object)this).fine("On source time is :" + object);
            if (frequency != null) {
                Frequency frequency3 = (Frequency)frequency.multiply(spectralSetupParameters.getPolarizationFactor());
                sensitivity = this.timeCalculator.singlePointOnSourceSensitivity((Array)((Object)object2), (Time)object, targetParameters, frequency2, frequency3);
            } else {
                sensitivity = this.timeCalculator.singlePointOnSourceSensitivity((Array)((Object)object2), (Time)object, targetParameters, frequency2);
            }
            Log.logger((Object)this).fine("lineSensitivity :" + (Object)((Object)sensitivity));
        }
        catch (UnknownEntityException | SourceNeverVisibleException | InvalidFrequencyException | InvalidObsProgramParametersException | NoSuchElementException throwable) {
            Log.logger((Object)this).finest("Incomplete info for calculating sensitivity : " + throwable.getMessage());
        }
        object2 = this.getPerformanceParameters();
        object = UserSensitivity.createUserSensitivity();
        ((UserSensitivity)object).setBeamsize((Angle)((Object)object2.getDesiredAngularResolution()));
        object.setContentAndUnit((ValueUnitPair)sensitivity);
        object.convertToUnit(((UserSensitivity)object).getFriendlyUnit());
        ((UserSensitivity)object).setObservingFrequency(frequency2);
        Log.logger((Object)this).fine("thisRms :" + object);
        return object;
    }

    Frequency getAggregateBandwidthForTarget(TargetParameters targetParameters) {
        SpectralSetupParameters spectralSetupParameters = this.getSpectralSetupParameters();
        String string = "Incomplete info for calculating aggregate bandwidth : ";
        Frequency frequency = NonOverlappingBandwidthCalculator.getCalculator(spectralSetupParameters, targetParameters).calculate();
        try {
            if (spectralSetupParameters.isSpectralScan()) {
                SpectralScan spectralScan = spectralSetupParameters.getSpectralScan();
                SpectralScan.SpectralScanTunings spectralScanTunings = spectralScan.getTunings();
                FrequencyRange frequencyRange = spectralScanTunings.getAchievedScanRange();
                frequency = (Frequency)((Object)frequencyRange.range());
            } else {
                frequency = spectralSetupParameters.getDesiredSensitivityFrequencyWidth(PerformanceParameters.DESIREDSENSITIVITYFREQUENCYMEASURE_AGGREGATEBANDWIDTH);
            }
        }
        catch (UnableToFindSolutionException unableToFindSolutionException) {
            Log.logger((Object)this).finest(string + unableToFindSolutionException.getMessage());
        }
        catch (SpectralScan.SpectralScanTunings.SpectralScanTuningException spectralScanTuningException) {
            Log.logger((Object)this).finest(string + spectralScanTuningException.getMessage());
        }
        return frequency;
    }

    public class ExpectedPropertiesElements {
        public double desiredContPolarizationPercentage = 0.0;
        public double desiredLinePolarizationPercentage = 0.0;
        public double resPerLineWidth;
        public Flux expectedPeakFluxDensity;
        public Flux expectedPeakLineFluxDensity;
        public UserFrequency expectedLineWidth;
        double bestFactor = 0.0;
        public double lowestPolLineFluxFactor = 0.0;
        public double lowestPolContFluxFactor = 0.0;
        public Velocity velocity = null;
        public double resolvedVelocity;
        public UserFrequency bandwidthForLineRMS;
        public UserSensitivity lineRms;
        public Frequency aggregateBandwith;
        public UserSensitivity sensitivityForBW;
        public UserSensitivity bandwidthRms;
        public double dynamicRange;

        public String toString() {
            return "ExpectedPropertiesElements [\n\t resPerLineWidth : " + this.resPerLineWidth + "\n\t desiredLinePolarizationPercentage : " + this.desiredLinePolarizationPercentage + "\n\t desiredPolarizationPercentage  : " + this.desiredContPolarizationPercentage + "\n\t peakFluxDensity  : " + (Object)((Object)this.expectedPeakFluxDensity) + "\n\t peakLineFluxDensity  : " + (Object)((Object)this.expectedPeakLineFluxDensity) + "\n\t expectedLineWidth : " + this.expectedLineWidth + "\n\t bestFactor : " + this.bestFactor + "\n\t lowestLinePolLineFluxFactor : " + this.lowestPolLineFluxFactor + "\n\t lowestContPolContFluxFactor : " + this.lowestPolContFluxFactor + "\n]";
        }
    }

    public static class UnableToFindTargetParametersException
    extends Exception {
        public UnableToFindTargetParametersException(String string) {
            super(string);
        }
    }

    public static class SourcePoint {
        private TargetParameters targetParameters;
        private SkyPoint skyPoint;

        public SourcePoint(TargetParameters targetParameters, SkyPoint skyPoint) {
            if (targetParameters == null) {
                throw new NullPointerException("Illegal argument - the argument targetParameters cannot be null");
            }
            if (skyPoint == null) {
                throw new NullPointerException("Illegal argument - the argument skyPoint cannot be null");
            }
            this.targetParameters = targetParameters;
            this.skyPoint = skyPoint;
        }

        public final TargetParameters getTargetParameters() {
            return this.targetParameters;
        }

        public final SkyPoint getSkyPoint() {
            return this.skyPoint;
        }
    }

    public class NotClusteredScienceGoalException
    extends Exception {
    }

    public static enum ScienceGoalMode {
        STANDARD,
        SOLAR,
        STANDALONEACA;

    }

    public static enum ScienceGoalType {
        TUNINGSPECIFIC,
        CLUSTER,
        USERDEFINED;

    }
}

