/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.obsproject;

import alma.obsprep.bo.obsproject.ScienceSpectralWindow;
import alma.obsprep.bo.schedblock.CorrConfigMode;
import alma.valuetypes.UserFrequency;

public class ScienceSpectralWindowFactory {
    public static ScienceSpectralWindow createScienceSpectralWindow(double d, String string, int n) {
        CorrConfigMode corrConfigMode = CorrConfigMode.getCorrConfigMode(n);
        double d2 = corrConfigMode.getNominalBandwidth().getContentInMHz();
        double d3 = corrConfigMode.getResolution().getContentInMHz();
        ScienceSpectralWindow scienceSpectralWindow = ScienceSpectralWindowFactory.createScienceSpectralWindow(d, string, d2, d3);
        scienceSpectralWindow.setCorrConfigMode(corrConfigMode);
        return scienceSpectralWindow;
    }

    public static ScienceSpectralWindow createScienceSpectralWindow(double d, String string, double d2, double d3) {
        ScienceSpectralWindow scienceSpectralWindow = ScienceSpectralWindow.createScienceSpectralWindow();
        scienceSpectralWindow.getCenterFrequency().setContentInGHz(d);
        scienceSpectralWindow.setTransitionName(string);
        UserFrequency userFrequency = UserFrequency.createUserFrequencyMHZ(d2);
        userFrequency.setObservingFrequency(scienceSpectralWindow.getCenterFrequency());
        scienceSpectralWindow.setBandWidth(userFrequency);
        userFrequency = UserFrequency.createUserFrequencyMHZ(d3);
        userFrequency.setObservingFrequency(scienceSpectralWindow.getCenterFrequency());
        scienceSpectralWindow.setSpectralResolution(userFrequency);
        return scienceSpectralWindow;
    }

    public static ScienceSpectralWindow createScienceSpectralWindow(double d, String string, double d2, int n) {
        return ScienceSpectralWindowFactory.createScienceSpectralWindow(d, string, d2, n, "FULL");
    }

    public static ScienceSpectralWindow createScienceSpectralWindow(double d, String string, double d2, int n, String string2) {
        ScienceSpectralWindow scienceSpectralWindow = ScienceSpectralWindow.createScienceSpectralWindow();
        scienceSpectralWindow.getCenterFrequency().setContentInGHz(d);
        scienceSpectralWindow.setTransitionName(string);
        scienceSpectralWindow.getBandWidth().setContentInMHz(d2);
        scienceSpectralWindow.getBandWidth().getObservingFrequency().setContentInGHz(d);
        scienceSpectralWindow.getSpectralResolution().setContentInMHz(d2 / (double)n);
        scienceSpectralWindow.getSpectralResolution().getObservingFrequency().setContentInGHz(d);
        scienceSpectralWindow.setGroupResourceUse(string2);
        scienceSpectralWindow.resetCorrConfigMode();
        return scienceSpectralWindow;
    }

    public static ScienceSpectralWindow createSingleContinuum() {
        ScienceSpectralWindow scienceSpectralWindow = ScienceSpectralWindow.createScienceSpectralWindow();
        scienceSpectralWindow.setTransitionName("Single Continuum");
        scienceSpectralWindow.setIsSkyFrequency(true);
        scienceSpectralWindow.setBandWidth(UserFrequency.createUserFrequency(ScienceSpectralWindow.getSingleContinuumBandwidth()));
        return scienceSpectralWindow;
    }

    public static ScienceSpectralWindow createSingleVLBIContinuumWindow() {
        ScienceSpectralWindow scienceSpectralWindow = ScienceSpectralWindow.createScienceSpectralWindow();
        scienceSpectralWindow.setTransitionName("Single Continuum");
        scienceSpectralWindow.setIsSkyFrequency(true);
        scienceSpectralWindow.getAdvancedWindowSetup().setSmoothingFactor(8);
        scienceSpectralWindow.setCorrConfigMode(52);
        scienceSpectralWindow.setBandWidth(UserFrequency.createUserFrequency(ScienceSpectralWindow.getSingleVLBIContinuumBandwidth()));
        return scienceSpectralWindow;
    }
}

