/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.obsproject;

import alma.entity.xmlbinding.obsproject.SpectralScanT;
import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.util.Log;
import alma.observatorycharacteristics.capabilities.AlmaCapabilities;
import alma.obsprep.bo.enumerations.CorrPolarization;
import alma.obsprep.bo.obsproject.AbstractScienceGoal;
import alma.obsprep.bo.obsproject.AbstractScienceSpectralWindow;
import alma.obsprep.bo.obsproject.ObservatoryGoal;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.ScienceSpectralWindow;
import alma.obsprep.bo.obsproject.ScienceSpectralWindowFactory;
import alma.obsprep.bo.obsproject.SpectralFeedback;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.UnableToFindSolutionException;
import alma.obsprep.bo.obsproject.data.SpectralScanData;
import alma.obsprep.bo.schedblock.CorrConfigMode;
import alma.obsprep.bo.schedblock.OTConfigModeDecoder;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.util.FrequencyRange;
import alma.valuetypes.Frequency;
import alma.valuetypes.Speed;
import alma.valuetypes.Velocity;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class SpectralScan
extends SpectralScanData {
    private static final Map<Integer, SpectralScanConfiguration> scanSpecificBandInfo = new HashMap<Integer, SpectralScanConfiguration>();
    private static final Map<Frequency, Frequency> tuningOverlap = new HashMap<Frequency, Frequency>();
    private SpectralFeedback spectralScanFeedback = null;
    private Integer numberOfTunings = 0;
    public static final Integer MAXTUNINGS;

    public SpectralFeedback getSpectralScanFeedback() {
        return this.spectralScanFeedback;
    }

    public SpectralScan(SpectralScanT spectralScanT) {
        super(spectralScanT);
    }

    public String shortDescription() {
        return "Scan";
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(((Object)((Object)this)).getClass().getSimpleName());
        stringBuffer.append("[");
        stringBuffer.append("name=" + this.getName());
        stringBuffer.append(",start=" + (Object)((Object)this.getStartFrequency()));
        stringBuffer.append(",end=" + (Object)((Object)this.getEndFrequency()));
        stringBuffer.append(",bandwidth=" + this.getBandWidth());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public Frequency getCenterFrequency() {
        return (Frequency)((Frequency)this.getStartFrequency().plus((AbstractDoubleWithUnit)this.getEndFrequency())).divide(2.0);
    }

    public FrequencyRange getRealisableScanRange() {
        SpectralScanTunings spectralScanTunings = null;
        FrequencyRange frequencyRange = null;
        try {
            spectralScanTunings = this.getTunings();
        }
        catch (UnableToFindSolutionException unableToFindSolutionException) {
            return null;
        }
        try {
            frequencyRange = spectralScanTunings.getAchievedScanRange();
        }
        catch (SpectralScanTunings.SpectralScanTuningException spectralScanTuningException) {
            return null;
        }
        return frequencyRange;
    }

    public SpectralScanTunings getTunings() throws UnableToFindSolutionException {
        return this.getTunings(this.getStartFrequency());
    }

    private SpectralScanTunings getTunings(Frequency frequency) throws UnableToFindSolutionException {
        SpectralScanTunings spectralScanTunings = new SpectralScanTunings();
        if (this.getParent() == null) {
            throw new UnableToFindSolutionException(SpectralScanErrors.NULLDOCUMENT, "No parent document");
        }
        this.spectralScanFeedback = null;
        if (this.spectralScanParametersValid()) {
            Object object;
            ReceiverBand receiverBand;
            FrequencyRange frequencyRange = new FrequencyRange(frequency, this.getEndFrequency());
            try {
                receiverBand = ReceiverBand.getReceiverBand(frequencyRange);
            }
            catch (ReceiverBand.ReceiverNotFoundException receiverNotFoundException) {
                this.spectralScanFeedback = new SpectralFeedback(SpectralFeedback.AdvisoryType.ERROR, "Unable to identify receiver band associated with scan range");
                throw new UnableToFindSolutionException(SpectralScanErrors.ILLEGALRECEIVERBAND, this.spectralScanFeedback.getMessage());
            }
            int n = receiverBand.getNumber();
            double d = -1.0;
            if (!scanSpecificBandInfo.containsKey(n)) {
                throw new UnableToFindSolutionException(SpectralScanErrors.SCANPARAMETERSINVALID, "Unable to determine the sideband gap");
            }
            d = scanSpecificBandInfo.get(n).getSidebandGap().getContentInDefaultUnits();
            assert (d != -1.0);
            double d2 = this.getEffectiveBandwidth().getContentInGHz();
            double d3 = this.getEndFrequency().getContentInGHz() - frequency.getContentInGHz();
            double d4 = this.getTuningOverlap().getContentInGHz();
            double d5 = (double)MAXTUNINGS.intValue() * (2.0 * d2 - d4);
            if (d4 > d2) {
                this.spectralScanFeedback = new SpectralFeedback(SpectralFeedback.AdvisoryType.ERROR, "Specified overlap is greater than the effective bandwidth");
                throw new UnableToFindSolutionException(SpectralScanErrors.SCANPARAMETERSINVALID, this.spectralScanFeedback.getMessage());
            }
            ArrayList<Frequency> arrayList = new ArrayList<Frequency>();
            ArrayList<Frequency> arrayList2 = new ArrayList<Frequency>();
            if (d2 < 1.5 || d3 < d5) {
                Log.logger(SpectralScan.class).finer("Single sideband case");
                Log.logger(SpectralScan.class).finer("effectiveBandWidth: " + d2);
                spectralScanTunings.setTwoSidebandScanSolution(false);
                Integer n2 = d2 > 1.5 && n < 9 ? Integer.valueOf(2) : Integer.valueOf(4);
                double d6 = (double)n2.intValue() * (d2 - d4);
                int n3 = (int)Math.ceil(d3 / d6);
                this.numberOfTunings = Math.min(MAXTUNINGS, n3);
                Log.logger(SpectralScan.class).finer("requiredNumberOfTunings: " + n3);
                for (int i = 0; i < n2 * this.numberOfTunings; ++i) {
                    Frequency frequency2;
                    Frequency frequency3;
                    if (i == 0 && (frequency3 = Frequency.createFrequencyGHZ(frequency.getContentInGHz() + d2 / 2.0)).isLessThan((AbstractDoubleWithUnit)(frequency2 = Frequency.createFrequencyGHZ(receiverBand.getRFMin() + this.getBandWidth().getContentInMHz() / 2.0 / 1000.0)))) {
                        frequency = (Frequency)frequency.plus(frequency2.minus((AbstractDoubleWithUnit)frequency3));
                    }
                    int n4 = i % n2;
                    frequency3 = Frequency.createFrequencyGHZ(frequency.getContentInGHz() + d2 / 2.0 + (d2 - d4) * (double)i);
                    Log.logger(SpectralScan.class).finer("SPW centreFrequency: " + (Object)((Object)frequency3));
                    arrayList.add(frequency3);
                    if (n4 != n2 - 1) continue;
                    spectralScanTunings.addTuning(arrayList);
                    arrayList = new ArrayList();
                }
            } else {
                int n5;
                double d7;
                double d8;
                Integer n6;
                Log.logger(SpectralScan.class).finer("Two sideband spectral scan solution scenario");
                Log.logger(SpectralScan.class).finer("effectiveBandWidth: " + d2);
                SpectralSetupParameters spectralSetupParameters = (SpectralSetupParameters)this.getParent();
                object = spectralSetupParameters.getReceiverBand();
                if (object == null) {
                    this.spectralScanFeedback = new SpectralFeedback(SpectralFeedback.AdvisoryType.ERROR, "Unable to identify receiver band associated with scan range");
                    throw new UnableToFindSolutionException(SpectralScanErrors.ILLEGALRECEIVERBAND, this.spectralScanFeedback.getMessage());
                }
                boolean bl = ReceiverBand.isReceiverBandInSet(object, new int[]{9, 10});
                if (bl) {
                    n6 = 8;
                    d8 = 4.0 * d2 - 3.0 * d4;
                    d7 = d + (8.0 - d8);
                } else {
                    n6 = 4;
                    d8 = 2.0 * d2 - d4;
                    d7 = d + (4.0 - d8);
                }
                double d9 = d8 - d4;
                int n7 = (int)Math.ceil(d7 / d8 + 1.0);
                double d10 = (double)n7 * d8 + d7 + d8;
                if (bl) {
                    if (d3 > d10) {
                        n5 = (int)Math.ceil((d3 - d10) / d9);
                        this.numberOfTunings = Math.min(MAXTUNINGS, n7 + n5);
                    } else {
                        this.numberOfTunings = n7;
                    }
                } else {
                    n5 = d3 > d10 ? 1 : 0;
                    this.numberOfTunings = n7 + n5;
                    this.numberOfTunings = Math.min(MAXTUNINGS, this.numberOfTunings);
                }
                for (n5 = 0; n5 < this.numberOfTunings; ++n5) {
                    Frequency frequency4;
                    Object object2;
                    if (n5 == 0 && (object2 = Frequency.createFrequencyGHZ(frequency.getContentInGHz() + d2 / 2.0)).isLessThan((AbstractDoubleWithUnit)(frequency4 = Frequency.createFrequencyGHZ(receiverBand.getRFMin() + this.getBandWidth().getContentInMHz() / 2.0 / 1000.0)))) {
                        frequency = (Frequency)frequency.plus(frequency4.minus((AbstractDoubleWithUnit)object2));
                    }
                    if (n6 == 4) {
                        arrayList.add(Frequency.createFrequencyGHZ(frequency.getContentInGHz() + d2 / 2.0 + d9 * (double)n5));
                        arrayList.add(Frequency.createFrequencyGHZ(arrayList.get(0).getContentInGHz() + d2 - d4));
                        arrayList.add(Frequency.createFrequencyGHZ(arrayList.get(0).getContentInGHz() + d + 4.0));
                        arrayList.add(Frequency.createFrequencyGHZ(arrayList.get(1).getContentInGHz() + d + 4.0));
                    } else if (n6 == 8) {
                        arrayList.add(Frequency.createFrequencyGHZ(frequency.getContentInGHz() + d2 / 2.0 + d9 * (double)n5));
                        arrayList.add(Frequency.createFrequencyGHZ(arrayList.get(0).getContentInGHz() + d2 - d4));
                        arrayList.add(Frequency.createFrequencyGHZ(arrayList.get(1).getContentInGHz() + d2 - d4));
                        arrayList.add(Frequency.createFrequencyGHZ(arrayList.get(2).getContentInGHz() + d2 - d4));
                        arrayList2.add(Frequency.createFrequencyGHZ(arrayList.get(0).getContentInGHz() + d + 8.0));
                        arrayList2.add(Frequency.createFrequencyGHZ(arrayList.get(1).getContentInGHz() + d + 8.0));
                        arrayList2.add(Frequency.createFrequencyGHZ(arrayList.get(2).getContentInGHz() + d + 8.0));
                        arrayList2.add(Frequency.createFrequencyGHZ(arrayList.get(3).getContentInGHz() + d + 8.0));
                        spectralScanTunings.addImageTuning(arrayList2);
                    }
                    if (Log.logger(SpectralScan.class).isLoggable(Level.FINEST)) {
                        object2 = arrayList.iterator();
                        while (object2.hasNext()) {
                            frequency4 = (Frequency)((Object)object2.next());
                            Log.logger(SpectralScan.class).finest("Tuning: " + n5 + " SPW central frequency: " + (Object)((Object)frequency4));
                        }
                    }
                    spectralScanTunings.addTuning(arrayList);
                    spectralScanTunings.setTwoSidebandScanSolution(true);
                    arrayList = new ArrayList();
                    arrayList2 = new ArrayList();
                }
            }
            Frequency frequency5 = null;
            try {
                frequency5 = spectralScanTunings.getImageTunings().isEmpty() ? spectralScanTunings.getTuning(spectralScanTunings.getNumberOfTunings() - 1).get(spectralScanTunings.getNumberOfSPWs() - 1) : spectralScanTunings.getImageTuning(spectralScanTunings.getNumberOfTunings() - 1).get(spectralScanTunings.getNumberOfSPWs() - 1);
            }
            catch (SpectralScanTunings.SpectralScanTuningException spectralScanTuningException) {
                throw new UnableToFindSolutionException(SpectralScanErrors.SCANPARAMETERSINVALID, "Unable to get tuning details");
            }
            if (frequency5.getContentInGHz() + d2 / 2.0 < this.getEndFrequency().getContentInGHz()) {
                this.spectralScanFeedback = new SpectralFeedback(SpectralFeedback.AdvisoryType.WARNING, "This scan requires more than " + MAXTUNINGS + " tunings to cover the frequency range specified, the achievable scan is narrower than requested");
            }
            if (frequency5.getContentInGHz() + d2 / 2.0 > receiverBand.getRFMax() - 0.11) {
                object = Frequency.createFrequencyGHZ(frequency.getContentInGHz() - 0.11 - (frequency5.getContentInGHz() + d2 / 2.0 - receiverBand.getRFMax()));
                return this.getTunings((Frequency)((Object)object));
            }
        } else {
            throw new UnableToFindSolutionException(SpectralScanErrors.SCANPARAMETERSINVALID, "Invalid scan parameters found");
        }
        return spectralScanTunings;
    }

    public Frequency getTuningOverlap() throws UnableToFindSolutionException {
        if (!tuningOverlap.containsKey(this.getBandwidth())) {
            throw new UnableToFindSolutionException(SpectralScanErrors.SCANPARAMETERSINVALID, "Unable to establPPish overlap");
        }
        Log.logger(SpectralScan.class).finest("Using tuning overlap: " + (Object)((Object)tuningOverlap.get(this.getBandwidth())) + " for BW " + this.getBandwidth());
        return tuningOverlap.get(this.getBandwidth()).deepCopy();
    }

    public boolean spectralScanParametersValid() {
        List<ReceiverBand> list = AlmaCapabilities.getInstance().getSpectralScanReceiverBands();
        if (list == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: spectralScanReceiverBands");
        }
        Frequency frequency = this.getStartFrequency().deepCopy();
        Frequency frequency2 = this.getEndFrequency().deepCopy();
        assert (frequency != null);
        assert (frequency2 != null);
        FrequencyRange frequencyRange = new FrequencyRange(frequency, frequency2);
        if (Math.round(this.getStartFrequency().getContentInGHz()) > 0L && Math.round(this.getEndFrequency().getContentInGHz()) > 0L) {
            ReceiverBand receiverBand;
            if (frequency.isGreaterThanOrEqualTo((AbstractDoubleWithUnit)frequency2)) {
                return false;
            }
            try {
                receiverBand = ReceiverBand.getReceiverBand(frequencyRange);
            }
            catch (ReceiverBand.ReceiverNotFoundException receiverNotFoundException) {
                return false;
            }
            if (receiverBand == null) {
                return false;
            }
            return list.contains(receiverBand);
        }
        return false;
    }

    public CorrConfigMode getCorrConfigMode() {
        OTConfigModeDecoder oTConfigModeDecoder = OTConfigModeDecoder.getInstance();
        CorrConfigMode corrConfigMode = null;
        SpectralSetupParameters spectralSetupParameters = (SpectralSetupParameters)this.getParent();
        CorrPolarization corrPolarization = CorrPolarization.getCorrPolarization(spectralSetupParameters.getPolarisation());
        Set<CorrConfigMode> set = oTConfigModeDecoder.findMode(corrPolarization, CorrConfigMode.getAllModes());
        Set<CorrConfigMode> set2 = oTConfigModeDecoder.findMode((Frequency)((Object)this.getBandWidth()), this.getSpectralResolution(), set, (Boolean)true, false);
        set2 = oTConfigModeDecoder.findMode((Frequency)((Object)this.getBandWidth()), this.getSpectralResolution(), set, (Boolean)true, false);
        corrConfigMode = set2.size() == 0 ? CorrConfigMode.INVALID_CORRCONFIGMODE : set2.toArray(new CorrConfigMode[1])[0];
        return corrConfigMode;
    }

    public void setSpectralAveraging(Integer n) {
        this.getAdvancedWindowSetup().setSmoothingFactor(n);
    }

    public void setSpectralAveraging(String string) {
        Integer n;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            Log.logger((Object)((Object)this)).info("Unable to convert spectral averaging value " + string + " to an integer");
            return;
        }
        this.setSpectralAveraging(n);
    }

    public Integer getSpectralAverageFactor() {
        return this.getAdvancedWindowSetup().getSmoothingFactor();
    }

    public Frequency getEffectiveBandwidth() {
        return this.getCorrConfigMode().getEffectiveBandwidth();
    }

    public static SpectralSetupParameters createSPWBasedSSPFromSpectralScanTuning(SpectralSetupParameters spectralSetupParameters, List<Frequency> list) throws UnableToFindSolutionException {
        SpectralSetupParameters spectralSetupParameters2 = spectralSetupParameters.deepCopy();
        AbstractScienceGoal abstractScienceGoal = (AbstractScienceGoal)spectralSetupParameters.getParent().deepCopy();
        Frequency frequency = spectralSetupParameters2.getRepresentativeFrequency().deepCopy();
        spectralSetupParameters2.setSSPDerivedFromSpectralScanSetup(true);
        spectralSetupParameters2.setNumberOfTuningsSSPDerivedFrom(spectralSetupParameters.getSpectralScan().getTunings().getNumberOfTunings());
        if (abstractScienceGoal instanceof ScienceGoal) {
            ((ScienceGoal)((Object)abstractScienceGoal)).setSpectralSetupParameters(spectralSetupParameters2);
        } else if (abstractScienceGoal instanceof ObservatoryGoal) {
            ((ObservatoryGoal)((Object)abstractScienceGoal)).setSpectralSetupParameters(spectralSetupParameters2);
        } else {
            throw new RuntimeException("Unable to determine subclass of AbstractScienceGoal");
        }
        spectralSetupParameters2.setSpectralType(SpectralSetupParameters.SpectralSetupTypeChoice.SPECTRALLINE);
        spectralSetupParameters2.clearAbstractScienceSpectralWindow();
        for (int i = 0; i < list.size(); ++i) {
            SpectralScan spectralScan = spectralSetupParameters.getSpectralScan();
            ScienceSpectralWindow scienceSpectralWindow = ScienceSpectralWindowFactory.createScienceSpectralWindow(list.get(i).getContentInGHz(), "Spec. Scan ", spectralScan.getBandwidth().getContentInMHz(), spectralScan.getSpectralResolution().getContentInMHz());
            scienceSpectralWindow.setAdvancedWindowSetup(spectralScan.getAdvancedWindowSetup().deepCopy());
            scienceSpectralWindow.resetCorrConfigMode();
            scienceSpectralWindow.setIsSkyFrequency(true);
            scienceSpectralWindow.setGroupIndex(i);
            spectralSetupParameters2.addAbstractScienceSpectralWindow((AbstractScienceSpectralWindow)((Object)scienceSpectralWindow));
        }
        spectralSetupParameters2.setRepresentativeFrequency(frequency);
        return spectralSetupParameters2;
    }

    Frequency getEffectiveResolution() {
        return this.getCorrConfigMode().getEffectiveResolution(this.getAdvancedWindowSetup());
    }

    double getVelocityResolutionInSky(Velocity velocity) {
        double d = 0.0;
        Frequency frequency = this.getEffectiveResolution();
        Frequency frequency2 = this.getCenterFrequency();
        if (!this.hasIsSkyFrequency() || !(!this.getIsSkyFrequency())) {
            frequency2 = velocity.dopplerShift(frequency2);
        }
        Speed speed = Speed.getSpeedResolution(frequency, frequency2);
        d = speed.getContentInUnits(Speed.UNIT_KM_S);
        return d;
    }

    public ReceiverBand getSpectralScanReceiverBand() throws ReceiverBand.ReceiverNotFoundException {
        ReceiverBand receiverBand = null;
        FrequencyRange frequencyRange = FrequencyRange.wholeRange((List<Frequency>)ImmutableList.of((Object)((Object)this.getStartFrequency()), (Object)((Object)this.getEndFrequency())));
        receiverBand = ReceiverBand.getReceiverBand(frequencyRange);
        if (receiverBand == null) {
            throw new ReceiverBand.ReceiverNotFoundException("Unable to determine spectral scan receiver band");
        }
        return receiverBand;
    }

    static {
        scanSpecificBandInfo.put(3, new SpectralScanConfiguration(Frequency.createFrequencyGHZ(8.0), Frequency.createFrequencyGHZ(24.75)));
        scanSpecificBandInfo.put(4, new SpectralScanConfiguration(Frequency.createFrequencyGHZ(8.0), Frequency.createFrequencyGHZ(24.75)));
        scanSpecificBandInfo.put(5, new SpectralScanConfiguration(Frequency.createFrequencyGHZ(8.0), Frequency.createFrequencyGHZ(24.75)));
        scanSpecificBandInfo.put(6, new SpectralScanConfiguration(Frequency.createFrequencyGHZ(12.0), Frequency.createFrequencyGHZ(31.75)));
        scanSpecificBandInfo.put(7, new SpectralScanConfiguration(Frequency.createFrequencyGHZ(8.0), Frequency.createFrequencyGHZ(24.75)));
        scanSpecificBandInfo.put(8, new SpectralScanConfiguration(Frequency.createFrequencyGHZ(8.0), Frequency.createFrequencyGHZ(24.75)));
        scanSpecificBandInfo.put(9, new SpectralScanConfiguration(Frequency.createFrequencyGHZ(8.0), Frequency.createFrequencyGHZ(38.5)));
        scanSpecificBandInfo.put(10, new SpectralScanConfiguration(Frequency.createFrequencyGHZ(8.0), Frequency.createFrequencyGHZ(38.5)));
        tuningOverlap.put(Frequency.createFrequencyMHZ(2000.0), Frequency.createFrequencyMHZ(171.875));
        tuningOverlap.put(Frequency.createFrequencyMHZ(1000.0), Frequency.createFrequencyMHZ(31.25));
        tuningOverlap.put(Frequency.createFrequencyMHZ(500.0), Frequency.createFrequencyMHZ(31.25));
        MAXTUNINGS = 5;
    }

    public static enum SpectralScanErrors {
        RECEIVERBANDRANGEVIOLATION,
        MAXTUNINGSEXCEEDED,
        ILLEGALRECEIVERBAND,
        SCANPARAMETERSINVALID,
        CALCULATEDSOLUTIONINSUFFICIENT,
        NULLDOCUMENT;

    }

    public class SpectralScanTunings {
        private boolean isTwoSidebandScanSolution = false;
        private List<ArrayList<Frequency>> tunings = new ArrayList<ArrayList<Frequency>>();
        private List<ArrayList<Frequency>> imageTunings = new ArrayList<ArrayList<Frequency>>();

        public Integer getNumberOfTunings() {
            return this.tunings.size();
        }

        public void clearTunings() {
            this.tunings.clear();
        }

        public void addTuning(ArrayList<Frequency> arrayList) {
            this.tunings.add(arrayList);
        }

        public void addImageTuning(ArrayList<Frequency> arrayList) {
            this.imageTunings.add(arrayList);
        }

        public List<ArrayList<Frequency>> getTunings() throws SpectralScanTuningException {
            if (this.getNumberOfTunings() == 0) {
                throw new SpectralScanTuningException("No tunings have been calculated");
            }
            return this.tunings;
        }

        public List<ArrayList<Frequency>> getImageTunings() throws SpectralScanTuningException {
            if (this.getNumberOfTunings() == 0) {
                throw new SpectralScanTuningException("No tunings have been calculated");
            }
            return this.imageTunings;
        }

        public FrequencyRange getAchievedScanRange() throws SpectralScanTuningException {
            List<ArrayList<Frequency>> list;
            boolean bl;
            if (this.getNumberOfTunings() == 0) {
                throw new SpectralScanTuningException("No tunings have been calculated");
            }
            Frequency frequency = (Frequency)SpectralScan.this.getEffectiveBandwidth().divide(2.0);
            Frequency frequency2 = (Frequency)this.tunings.get(0).get(0).minus((AbstractDoubleWithUnit)frequency);
            Frequency frequency3 = (Frequency)this.tunings.get(this.tunings.size() - 1).get(this.tunings.get(0).size() - 1).plus((AbstractDoubleWithUnit)frequency);
            FrequencyRange frequencyRange = new FrequencyRange(frequency2, frequency3);
            try {
                bl = ReceiverBand.isReceiverBandInSet(ReceiverBand.getReceiverBand(frequencyRange), 9, 10);
            }
            catch (ReceiverBand.ReceiverNotFoundException receiverNotFoundException) {
                throw new RuntimeException("Unable to determine receiver band" + receiverNotFoundException.getMessage());
            }
            if (bl && SpectralScan.this.getEffectiveBandwidth().isEqual((AbstractDoubleWithUnit)Frequency.createFrequencyMHZ(1875.0)) && !(list = this.getImageTunings()).isEmpty()) {
                frequency3 = (Frequency)list.get(list.size() - 1).get(list.get(0).size() - 1).plus((AbstractDoubleWithUnit)frequency);
                frequencyRange = new FrequencyRange(frequency2, frequency3);
            }
            return frequencyRange;
        }

        public List<Frequency> getTuning(Integer n) throws SpectralScanTuningException {
            if (n >= this.getNumberOfTunings()) {
                throw new SpectralScanTuningException("Requested tuning exceeds the number of tunings");
            }
            return this.tunings.get(n);
        }

        public List<Frequency> getImageTuning(Integer n) throws SpectralScanTuningException {
            if (n >= this.getNumberOfTunings()) {
                throw new SpectralScanTuningException("Requested tuning exceeds the number of tunings");
            }
            return this.imageTunings.get(n);
        }

        public Integer getNumberOfSPWs() throws SpectralScanTuningException {
            if (this.getNumberOfTunings() == 0) {
                throw new SpectralScanTuningException("No tunings calculated");
            }
            return this.tunings.get(0).size();
        }

        public boolean isTwoSidebandScanSolution() {
            return this.isTwoSidebandScanSolution;
        }

        public void setTwoSidebandScanSolution(boolean bl) {
            this.isTwoSidebandScanSolution = bl;
        }

        public class SpectralScanTuningException
        extends Exception {
            public SpectralScanTuningException(String string) {
                super(string);
            }
        }
    }

    public static class SpectralScanConfiguration {
        private Frequency sidebandGap;
        private Frequency twoSidebandWidthThreshold;

        public String toString() {
            return "SpectralScanConfiguration [sidebandGap=" + (Object)((Object)this.sidebandGap) + ", twoSidebandWidthThreshold=" + (Object)((Object)this.twoSidebandWidthThreshold) + "]";
        }

        public Frequency getSidebandGap() {
            return this.sidebandGap;
        }

        public Frequency getTwoSidebandWidthThreshold() {
            return this.twoSidebandWidthThreshold;
        }

        public void setSidebandGap(Frequency frequency) {
            if (frequency == null) {
                throw new NullPointerException("Illegal argument. The argument cannot be null: sidebandGap");
            }
            this.sidebandGap = frequency;
        }

        public void setTwoSidebandWidthThreshold(Frequency frequency) {
            if (frequency == null) {
                throw new NullPointerException("Illegal argument. The argument cannot be null: twoSidebandWidthThreshold");
            }
            this.twoSidebandWidthThreshold = frequency;
        }

        public SpectralScanConfiguration(Frequency frequency, Frequency frequency2) {
            if (frequency == null) {
                throw new NullPointerException("Illegal argument. The argument cannot be null: sidebandGap");
            }
            if (frequency2 == null) {
                throw new NullPointerException("Illegal argument. The argument cannot be null: twoSidebandWidthThreshold");
            }
            this.sidebandGap = frequency;
            this.twoSidebandWidthThreshold = frequency2;
        }
    }
}

