/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.obsproject;

import alma.entity.xmlbinding.obsproject.TemporalParametersT;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.obsproject.data.TemporalParametersData;
import alma.obsprep.ot.editors.misc.TemporalParametersSummaryTableColumns;
import alma.obsprep.ot.models.misc.SummaryTableColumns;
import alma.obsprep.ot.models.misc.SummaryTableRow;
import alma.valuetypes.Time;
import java.time.DateTimeException;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;

public class TemporalParameters
extends TemporalParametersData
implements SummaryTableRow {
    private SummaryTableColumns summaryTableColumns = new TemporalParametersSummaryTableColumns(this);
    private static final DateTimeFormatter almaDateFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");

    public TemporalParameters(TemporalParametersT temporalParametersT) {
        super(temporalParametersT);
    }

    protected void initAsNew() {
        super.initAsNew();
        this.setAllowedMargin(Time.createTime((double)0.0, (String)Time.UNIT_MIN));
        this.setRepeats(0);
        this.setLSTMin("");
        this.setLSTMax("");
    }

    public static ZonedDateTime convertStringToDate(String string) throws DateTimeParseException {
        return LocalDateTime.parse(string, almaDateFormat).atZone(ZoneOffset.UTC);
    }

    public static String convertDateToString(ZonedDateTime zonedDateTime) throws DateTimeException {
        return zonedDateTime.format(almaDateFormat);
    }

    public ZonedDateTime gettrueStartTimeInDate() {
        String string = this.gettrueStartTime();
        if (null == string || "" == string) {
            return null;
        }
        try {
            return TemporalParameters.convertStringToDate(string);
        }
        catch (DateTimeParseException dateTimeParseException) {
            String string2 = "Unexpected start time format : " + dateTimeParseException.getMessage();
            Log.logger((Object)this).warning(string2);
            return null;
        }
    }

    public void setStartTimeInDate(ZonedDateTime zonedDateTime) {
        String string = TemporalParameters.convertDateToString(zonedDateTime);
        this.setStartTime(string);
    }

    public static ZonedDateTime nowInUTC() {
        return ZonedDateTime.now(ZoneOffset.UTC).withNano(0);
    }

    public ZonedDateTime getStartTimeInDate() {
        ZonedDateTime zonedDateTime = this.gettrueStartTimeInDate();
        if (null == zonedDateTime) {
            this.setStartTimeInDate(TemporalParameters.nowInUTC());
        }
        return zonedDateTime;
    }

    public ZonedDateTime gettrueEndTimeInDate() {
        String string = this.gettrueEndTime();
        if (null == string || "" == string) {
            return null;
        }
        try {
            return TemporalParameters.convertStringToDate(string);
        }
        catch (DateTimeParseException dateTimeParseException) {
            String string2 = "Unexpected end time format : " + dateTimeParseException.getMessage();
            Log.logger((Object)this).warning(string2);
            return null;
        }
    }

    public ZonedDateTime getEndTimeInDate() {
        ZonedDateTime zonedDateTime = this.gettrueEndTimeInDate();
        if (null == zonedDateTime) {
            this.setEndTimeInDate(TemporalParameters.nowInUTC());
        }
        return zonedDateTime;
    }

    public void setEndTimeInDate(ZonedDateTime zonedDateTime) {
        String string = TemporalParameters.convertDateToString(zonedDateTime);
        this.setEndTime(string);
    }

    @Override
    public SummaryTableColumns getSummaryTableColumns() {
        return this.summaryTableColumns;
    }
}

