/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.obsproposal;

import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.bo.obsproposal.TimeAllocationBreakdown;

public abstract class AbstractTimeAllocationStrategy {
    private TimeAllocationBreakdown breakdown;

    public AbstractTimeAllocationStrategy(TimeAllocationBreakdown timeAllocationBreakdown) {
        this.breakdown = timeAllocationBreakdown;
        timeAllocationBreakdown.clearTimeFraction();
    }

    protected ObsProposal getProposal() {
        return this.breakdown.getProposalFeedback().getObsProposal();
    }

    protected TimeAllocationBreakdown getBreakdown() {
        return this.breakdown;
    }

    protected void allocateObservingTimeToExecutives() {
        this.allocate();
        this.testResult();
    }

    protected abstract void allocate();

    protected void testResult() {
        String string;
        TimeAllocationBreakdown timeAllocationBreakdown = this.getBreakdown();
        if (!timeAllocationBreakdown.testExecutives()) {
            string = "Not all executives are listed in the TimeAllocationBreakdown instance.";
            Log.logger((Object)this).warning(string + ":" + timeAllocationBreakdown.toString());
        }
        if (!timeAllocationBreakdown.testTotal()) {
            string = "The total number of time fractions is not equal to 1.0.";
            Log.logger((Object)this).warning(string + ":" + timeAllocationBreakdown.toString());
        }
    }
}

