/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.obsproposal;

import alma.entity.xmlbinding.obsproposal.InvestigatorT;
import alma.obsprep.bo.obsproposal.data.InvestigatorData;
import alma.obsprep.services.userlookup.User;

public class Investigator
extends InvestigatorData {
    private static final String[][] portal2allow2assoc = new String[][]{{"cl", ALLOWEDEXEC_CL, ASSOCIATEDEXEC_CL}, {"ea", ALLOWEDEXEC_EA, ASSOCIATEDEXEC_EA}, {"eu", ALLOWEDEXEC_EU, ASSOCIATEDEXEC_EU}, {"na", ALLOWEDEXEC_NA, ASSOCIATEDEXEC_NA}, {"ea/na", ALLOWEDEXEC_NA_EA, ASSOCIATEDEXEC_EA}, {"other", ALLOWEDEXEC_OTHER, ASSOCIATEDEXEC_OTHER}, {"null", ALLOWEDEXEC_OTHER, ASSOCIATEDEXEC_OTHER}};

    private static String allow4user(String string) {
        string = String.valueOf(string);
        for (String[] stringArray : portal2allow2assoc) {
            if (!string.equals(stringArray[0])) continue;
            return stringArray[1];
        }
        return ALLOWEDEXEC_OTHER;
    }

    private static String assoc4user(String string) {
        string = String.valueOf(string);
        for (String[] stringArray : portal2allow2assoc) {
            if (!string.equals(stringArray[0])) continue;
            return stringArray[2];
        }
        return ASSOCIATEDEXEC_OTHER;
    }

    public Investigator(InvestigatorT investigatorT) {
        super(investigatorT);
    }

    public void initAsNew() {
        super.initAsNew();
        this.setAllowedExec(ALLOWEDEXEC_OTHER);
        this.setAssociatedExec(ASSOCIATEDEXEC_OTHER);
        this.setTelephone("");
        this.setMobile("");
    }

    public void setUserId(String string) {
        super.setUserId(string);
        this.setVerfiedUser(false);
    }

    public static Investigator createInvestigator(User user) {
        Investigator investigator = Investigator.createInvestigator();
        investigator.initializeFromUser(user);
        return investigator;
    }

    private void initializeFromUser(User user) {
        this.updateFromUser(user);
        this.setAssociatedExec(Investigator.assoc4user(user.getExecutive()));
    }

    public void updateFromUser(User user) {
        this.setEMail(user.getEmail());
        this.setFullName(user.getFullName());
        this.setOrganisation(user.getAffiliation());
        this.setOrganisationId(user.getAffiliationId());
        this.setUserId(user.getUid());
        this.setAllowedExec(Investigator.allow4user(user.getExecutive()));
        this.setVerfiedUser(false);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Investigator)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        Investigator investigator = (Investigator)((Object)object);
        return this.getAllowedExec().equals(investigator.getAllowedExec()) && this.getEMail().equals(investigator.getEMail()) && this.getFullName().equals(investigator.getFullName()) && this.getOrganisation().equals(investigator.getOrganisation()) && this.getOrganisationId().equals(investigator.getOrganisationId()) && this.getUserId().equals(investigator.getUserId());
    }

    public int hashCode() {
        int n = 1423;
        n = 31 * n + this.getAllowedExec().hashCode();
        n = 31 * n + this.getEMail().hashCode();
        n = 31 * n + this.getFullName().hashCode();
        n = 31 * n + this.getOrganisation().hashCode();
        n = 31 * n + this.getOrganisationId().hashCode();
        n = 31 * n + this.getUserId().hashCode();
        return n;
    }
}

