/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.obsproposal;

import alma.entity.xmlbinding.obsproposal.ObsProposalRefT;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.observatorycharacteristics.policies.AlmaPolicies;
import alma.obsprep.bo.enumerations.Array;
import alma.obsprep.bo.enumerations.Telescope;
import alma.obsprep.bo.obsproject.AbstractScienceGoal;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproposal.Investigator;
import alma.obsprep.bo.obsproposal.data.ObsProposalData;
import alma.obsprep.services.etc.ObservingTimeCalculator;
import alma.obsprep.services.etc.SourceClusterDetector;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.valuetypes.Time;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;

public class ObsProposal
extends ObsProposalData {
    private static final String year = "((?:(?:[1]{1}\\d{1}\\d{1}\\d{1})|(?:[2]{1}\\d{3})))(?![\\d])";
    private static final String dot = "(\\.)";
    private static final String oneAlphanumeric = "([A-Za-z0-9])";
    private static final String fiveDigits = "(\\d{5}+)";
    private static final String lastChar = "([A-Za-z])";
    public static final String projectRegEx = "((?:(?:[1]{1}\\d{1}\\d{1}\\d{1})|(?:[2]{1}\\d{3})))(?![\\d])(\\.)([A-Za-z0-9])(\\.)(\\d{5}+)(\\.)([A-Za-z])";

    public ObsProposal(alma.entity.xmlbinding.obsproposal.ObsProposal obsProposal) {
        super(obsProposal);
        if (!obsProposal.hasStudentProject()) {
            obsProposal.setStudentProject(false);
        }
    }

    public void initAsNew() {
        super.initAsNew();
        AlmaPolicies almaPolicies = AlmaPolicies.getInstance();
        this.setCycle(almaPolicies.getCycleNumber());
        this.setPrincipalInvestigator(Investigator.createInvestigator());
        this.getProposalFeedback().getTimeAllocationBreakdown();
        if (Telescope.getTelescopeSelection() == Telescope.ESALMA || Telescope.getTelescopeSelection() == Telescope.Cycle2) {
            this.setContinuation(false);
        }
        this.setTitle("");
        this.setStudentProject(false);
    }

    public ObsProposalRefT getReference() {
        ObsProposalRefT obsProposalRefT = super.getReference();
        obsProposalRefT.setDocumentVersion("1");
        return obsProposalRefT;
    }

    public String toTreeString(int n, boolean bl, boolean bl2) {
        return super.getNameOrDefault();
    }

    public String getNameOrDefault() {
        String string;
        String string2 = this.getName();
        if ((string2 == null || string2.trim().length() == 0) && (string = this.getTitle()) != null && string.trim().length() > 0) {
            return string;
        }
        return super.getNameOrDefault();
    }

    public String getTitle() {
        String string = "";
        try {
            ObsProject obsProject = this.getObsProject();
            if (obsProject != null) {
                string = obsProject.getProjectName();
            }
        }
        catch (UnknownEntityException unknownEntityException) {
            // empty catch block
        }
        return string;
    }

    public void setTitle(String string) {
        try {
            ObsProject obsProject = this.getObsProject();
            if (obsProject != null) {
                obsProject.setProjectName(string);
            }
        }
        catch (UnknownEntityException unknownEntityException) {
            // empty catch block
        }
    }

    public Time getTotalRequestedTime() {
        return this.getTotalRequestedTime(Array.ARRAY_12M, true);
    }

    public Time getTotalRequestedTime(Array array, boolean bl) {
        Time time = Time.createTime();
        for (ScienceGoal scienceGoal : this.getAbstractScienceGoalScienceGoal()) {
            Collection<ScienceGoal> collection;
            Time time2 = Time.createTime();
            SourceClusterDetector sourceClusterDetector = new SourceClusterDetector(scienceGoal);
            try {
                collection = sourceClusterDetector.splitScienceGoalIntoSourceClusters();
            }
            catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                throw new WizardSBGenerationException(invalidObsProgramParametersException);
            }
            for (ScienceGoal scienceGoal2 : collection) {
                try {
                    if (array.equals((Object)Array.ARRAY_12M)) {
                        if (scienceGoal2.isStandAloneACA()) {
                            if (bl) {
                                Time time3 = scienceGoal2.getTotalRequestedTime(Array.ARRAY_7M);
                                Time time4 = scienceGoal2.getTotalRequestedTime(Array.ARRAY_TP);
                                assert (time3 != null && time4 != null);
                                time2 = Time.max(time3, time4);
                            }
                        } else {
                            time2 = scienceGoal2.getTotalTimeForSGWithoutACA(false);
                        }
                    } else {
                        time2 = scienceGoal2.getTotalRequestedTime(array);
                    }
                    time.aggregate(time2);
                }
                catch (ObservingTimeCalculator.UnableToCalculateTimeEstimateException unableToCalculateTimeEstimateException) {
                    Log.logger((Object)((Object)this)).warning(unableToCalculateTimeEstimateException.getMessage());
                }
                catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                    Log.logger((Object)((Object)this)).warning(invalidObsProgramParametersException.getMessage());
                }
            }
        }
        return time;
    }

    public Time getTotal12mNonStandardTime() {
        Time time = Time.createTime();
        for (ScienceGoal scienceGoal : this.getAbstractScienceGoalScienceGoal()) {
            Collection<ScienceGoal> collection;
            SourceClusterDetector sourceClusterDetector = new SourceClusterDetector(scienceGoal);
            try {
                collection = sourceClusterDetector.splitScienceGoalIntoSourceClusters();
            }
            catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                throw new WizardSBGenerationException(invalidObsProgramParametersException);
            }
            for (ScienceGoal scienceGoal2 : collection) {
                if (!scienceGoal2.getMode().equals(ScienceGoal.MODE_OTHER)) continue;
                try {
                    Time time2 = scienceGoal2.getTotalTimeForSGWithoutACA(false);
                    time2.convertToUnit(Time.UNIT_H);
                    time.aggregate(time2);
                }
                catch (ObservingTimeCalculator.UnableToCalculateTimeEstimateException unableToCalculateTimeEstimateException) {
                    Log.logger((Object)((Object)this)).warning(unableToCalculateTimeEstimateException.getMessage());
                }
            }
        }
        return time;
    }

    public boolean isToO() {
        String string = this.getProposalTypeCode();
        return string != null && string.equals("T");
    }

    public boolean isVLBI() {
        return StringUtils.equalsIgnoreCase((CharSequence)this.getProposalTypeString().trim(), (CharSequence)"VLBI");
    }

    public boolean isLargeProgram() {
        String string = this.getProposalTypeCode();
        return string != null && string.equals("L");
    }

    public String getProposalTypeString() {
        AlmaPolicies almaPolicies = AlmaPolicies.getInstance();
        String string = super.getProposalTypeString();
        if (StringUtils.equalsIgnoreCase((CharSequence)string.trim(), (CharSequence)"Standard")) {
            String string2 = almaPolicies.getProposalTypeForCode("S");
            this.setProposalTypeString(string2);
            return string2;
        }
        return string;
    }

    public void setProposalTypeString(String string) {
        AlmaPolicies almaPolicies = AlmaPolicies.getInstance();
        if (StringUtils.equalsIgnoreCase((CharSequence)string.trim(), (CharSequence)"Standard")) {
            string = almaPolicies.getProposalTypeForCode("S");
        }
        super.setProposalTypeString(string);
    }

    public void updateLocalReference() {
        AlmaPolicies almaPolicies = AlmaPolicies.getInstance();
        if (StringUtils.equalsIgnoreCase((CharSequence)this.getProposalTypeString().trim(), (CharSequence)"Standard")) {
            this.setProposalTypeString(almaPolicies.getProposalTypeForCode("S"));
        }
    }

    public boolean isACAUsed() {
        for (AbstractScienceGoal abstractScienceGoal : this.getAbstractScienceGoal()) {
            ScienceGoal scienceGoal;
            if (!(abstractScienceGoal instanceof ScienceGoal) || !(scienceGoal = (ScienceGoal)((Object)abstractScienceGoal)).getPerformanceParameters().gettrueUseACA()) continue;
            return true;
        }
        return false;
    }

    public static class VLBIProposalDetectedException
    extends Exception {
        private static final long serialVersionUID = -2007913573548351272L;
    }
}

