/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.obsproposal;

import alma.entity.xmlbinding.obsproposal.ProposalFeedbackT;
import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.enumerations.Array;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproposal.ArrayDataRates;
import alma.obsprep.bo.obsproposal.ArrayTime;
import alma.obsprep.bo.obsproposal.ArrayTimeBreakdown;
import alma.obsprep.bo.obsproposal.DataRateBreakdown;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.bo.obsproposal.ReceiverTimeBreakdown;
import alma.obsprep.bo.obsproposal.TimeAllocationBreakdown;
import alma.obsprep.bo.obsproposal.data.ArrayTimeData;
import alma.obsprep.bo.obsproposal.data.ProposalFeedbackData;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.services.etc.ObservingTimeCalculator;
import alma.obsprep.services.etc.SourceClusterDetector;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.valuetypes.DataRate;
import alma.valuetypes.StorageVolume;
import alma.valuetypes.Time;
import com.google.common.collect.ImmutableList;
import java.util.Collection;

public class ProposalFeedback
extends ProposalFeedbackData {
    private Log.Logger logger = Log.logger((Object)((Object)this));

    public ProposalFeedback(ProposalFeedbackT proposalFeedbackT) {
        super(proposalFeedbackT);
    }

    public ObsProposal getObsProposal() {
        return (ObsProposal)this.getParent();
    }

    protected void initAsNew() {
        super.initAsNew();
        this.setEstimatedTotalIntegrationTime(Time.createTime((double)-999.0, (String)Time.UNIT_H));
    }

    public void fill() throws InvalidObsProgramParametersException {
        this.setEstimatedTotalIntegrationTime(Time.createTime((double)-999.0, (String)Time.UNIT_H));
        this.fillDataRateBreakdown(this.getDataRateBreakdown());
        this.fillTimeAllocationBreakdown(this.getTimeAllocationBreakdown());
        this.fillReceiverTimeBreakdown(this.getReceiverTimeBreakdown());
        this.fillArrayTimeBreakdown(this.getArrayTimeBreakdown());
    }

    private boolean usesTheArray(ScienceGoal scienceGoal, Array array) {
        PerformanceParameters performanceParameters = scienceGoal.getPerformanceParameters();
        switch (array) {
            case ARRAY_12M: {
                return !scienceGoal.isStandAloneACA();
            }
            case ARRAY_7M: {
                return performanceParameters.getUseACA();
            }
            case ARRAY_TP: {
                return performanceParameters.getUseACA() && performanceParameters.getUseTP();
            }
        }
        return false;
    }

    private void fillDataRateBreakdown(DataRateBreakdown dataRateBreakdown) {
        ImmutableList immutableList = ImmutableList.of((Object)ArrayDataRates.ARRAYNAME_TWELVE_M, (Object)ArrayDataRates.ARRAYNAME_SEVEN_M, (Object)ArrayDataRates.ARRAYNAME_TP_ARRAY);
        for (String string : immutableList) {
            ArrayDataRates arrayDataRates = dataRateBreakdown.getArrayDataRates(string);
            DataRate dataRate = arrayDataRates.getEstimatedMaximumDataRate();
            Time time = Time.createTime();
            StorageVolume storageVolume = arrayDataRates.getEstimatedDataVolume();
            dataRate.setContent(0.0);
            arrayDataRates.getEstimatedAverageDataRate().setContent(0.0);
            storageVolume.setContent(0.0);
            Array array = Array.getArray(string);
            boolean bl = this.getObsProposal().isVLBI();
            for (ScienceGoal scienceGoal : this.getObsProposal().getAbstractScienceGoalScienceGoal()) {
                Collection<ScienceGoal> collection;
                DataRate dataRate2 = DataRate.createDataRate((double)0.0, (String)DataRate.UNIT_MB_S);
                if (!this.usesTheArray(scienceGoal, array)) continue;
                SourceClusterDetector sourceClusterDetector = new SourceClusterDetector(scienceGoal);
                try {
                    collection = sourceClusterDetector.splitScienceGoalIntoSourceClusters();
                }
                catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                    throw new WizardSBGenerationException(invalidObsProgramParametersException);
                }
                for (ScienceGoal scienceGoal2 : collection) {
                    try {
                        DataRate dataRate3 = scienceGoal2.getDataRate(array);
                        if (dataRate.isLessThan((AbstractDoubleWithUnit)dataRate3)) {
                            dataRate.setContentAndUnit((ValueUnitPair)dataRate3);
                        }
                        Time time2 = bl ? scienceGoal2.getTotalRequestedTime(array) : scienceGoal2.getTotalRequestedTime(array, true);
                        time.aggregate(time2);
                        dataRate2 = scienceGoal2.getAverageDataRate(array);
                        storageVolume.aggregate(dataRate2.getStorageVolume(time2));
                    }
                    catch (ObservingTimeCalculator.UnableToDetermineInstantaneousDataRateException | InvalidObsProgramParametersException exception) {
                        Log.logger((Object)((Object)this)).warning("Warning Data Rate calculation in Proposal Feedback : " + exception.getMessage());
                    }
                }
                double d = storageVolume.getContentInUnits(StorageVolume.UNIT_MB) / time.getContentInUnits(Time.UNIT_S);
                if (Double.isNaN(d) || Double.isInfinite(d)) {
                    d = 0.0;
                }
                if (Double.isNaN(storageVolume.getContent()) || Double.isInfinite(storageVolume.getContent())) {
                    storageVolume.setContent(0.0);
                }
                arrayDataRates.setEstimatedAverageDataRate(DataRate.createDataRate((double)d, (String)DataRate.UNIT_MB_S));
                Log.logger((Object)((Object)this)).info(arrayDataRates.toString());
            }
        }
    }

    private void fillTimeAllocationBreakdown(TimeAllocationBreakdown timeAllocationBreakdown) {
        timeAllocationBreakdown.allocateTimeToExecutives();
    }

    private void fillReceiverTimeBreakdown(ReceiverTimeBreakdown receiverTimeBreakdown) {
        receiverTimeBreakdown.clearReceiverTime();
        for (ScienceGoal scienceGoal : this.getObsProposal().getAbstractScienceGoalScienceGoal()) {
            Collection<ScienceGoal> collection;
            SourceClusterDetector sourceClusterDetector = new SourceClusterDetector(scienceGoal);
            try {
                collection = sourceClusterDetector.splitScienceGoalIntoSourceClusters();
            }
            catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                throw new WizardSBGenerationException(invalidObsProgramParametersException);
            }
            for (ScienceGoal scienceGoal2 : collection) {
                ReceiverBand receiverBand;
                try {
                    receiverBand = scienceGoal2.getReceiverBand();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.logger.warning(illegalArgumentException.getMessage());
                    continue;
                }
                try {
                    Time time = Time.createTime();
                    if (scienceGoal2.isStandAloneACA()) {
                        Time time2 = scienceGoal2.getTotalRequestedTime(Array.ARRAY_7M);
                        Time time3 = scienceGoal2.getTotalRequestedTime(Array.ARRAY_TP);
                        time = Time.max(time2, time3);
                    } else {
                        time = scienceGoal2.getTotalRequestedTime(Array.ARRAY_12M);
                    }
                    receiverTimeBreakdown.getReceiverTime(receiverBand).getTime().aggregate(time);
                }
                catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                    this.logger.warning(invalidObsProgramParametersException.getMessage());
                }
            }
        }
    }

    private void fillArrayTimeBreakdown(ArrayTimeBreakdown arrayTimeBreakdown) {
        arrayTimeBreakdown.clearArrayTime();
        ArrayTime[] arrayTimeArray = new ArrayTime[5];
        arrayTimeArray[3] = ArrayTime.createArrayTime(ArrayTimeData.ARRAYNAME_TWELVE_M);
        arrayTimeArray[1] = ArrayTime.createArrayTime(ArrayTimeData.ARRAYNAME_SEVEN_M);
        arrayTimeArray[2] = ArrayTime.createArrayTime(ArrayTimeData.ARRAYNAME_TP_ARRAY);
        arrayTimeArray[0] = ArrayTime.createArrayTime(ArrayTimeData.ARRAYNAME_ACA);
        arrayTimeArray[4] = ArrayTime.createArrayTime(ArrayTimeData.ARRAYNAME_ALMA);
        Array array = Array.getArray(ArrayTimeData.ARRAYNAME_TWELVE_M);
        Array array2 = Array.getArray(ArrayTimeData.ARRAYNAME_SEVEN_M);
        Array array3 = Array.getArray(ArrayTimeData.ARRAYNAME_TP_ARRAY);
        for (ScienceGoal scienceGoal : this.getObsProposal().getAbstractScienceGoalScienceGoal()) {
            Collection<ScienceGoal> collection;
            SourceClusterDetector sourceClusterDetector = new SourceClusterDetector(scienceGoal);
            try {
                collection = sourceClusterDetector.splitScienceGoalIntoSourceClusters();
            }
            catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                throw new WizardSBGenerationException(invalidObsProgramParametersException);
            }
            Log.logger((Object)((Object)this)).info("****************** Science Goal: " + scienceGoal.getNameOrDefault());
            for (ScienceGoal scienceGoal2 : collection) {
                try {
                    Time time = Time.createTime();
                    if (!scienceGoal2.isStandAloneACA()) {
                        time = scienceGoal2.getTotalRequestedTime(array);
                        Log.logger((Object)((Object)this)).info("12-m Time: " + time);
                    }
                    Time time2 = scienceGoal2.getTotalRequestedTime(array2);
                    Time time3 = scienceGoal2.getTotalRequestedTime(array3);
                    Time time4 = (Time)time3.plus((AbstractDoubleWithUnit)time2);
                    Time time5 = time3.isGreaterThan((AbstractDoubleWithUnit)time2) ? (Time)time3.plus((AbstractDoubleWithUnit)time) : (Time)time2.plus((AbstractDoubleWithUnit)time);
                    arrayTimeArray[3].getEstimatedTime().aggregate(time);
                    arrayTimeArray[1].getEstimatedTime().aggregate(time2);
                    arrayTimeArray[2].getEstimatedTime().aggregate(time3);
                    arrayTimeArray[4].getEstimatedTime().aggregate(time5);
                    arrayTimeArray[0].getEstimatedTime().aggregate(time4);
                }
                catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                    Log.logger((Object)((Object)this)).warning(invalidObsProgramParametersException.getMessage());
                }
            }
        }
        arrayTimeBreakdown.setArrayTime(arrayTimeArray);
    }
}

