/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.obsproposal;

import alma.entity.xmlbinding.obsproposal.TimeAllocationBreakdownT;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.obsproposal.AbstractTimeAllocationStrategy;
import alma.obsprep.bo.obsproposal.ExecutiveFraction;
import alma.obsprep.bo.obsproposal.ProposalFeedback;
import alma.obsprep.bo.obsproposal.StandardTimeAllocationStrategy;
import alma.obsprep.bo.obsproposal.data.TimeAllocationBreakdownData;
import java.util.ArrayList;
import java.util.Arrays;

public class TimeAllocationBreakdown
extends TimeAllocationBreakdownData {
    private AbstractTimeAllocationStrategy timeAllocStrategy;

    public TimeAllocationBreakdown(TimeAllocationBreakdownT timeAllocationBreakdownT) {
        super(timeAllocationBreakdownT);
    }

    protected void initAsNew() {
        super.initAsNew();
        this.presetAllExecutives();
    }

    private void presetAllExecutives() {
        for (String string : ExecutiveFraction.getKnownNameList()) {
            ExecutiveFraction executiveFraction = ExecutiveFraction.createExecutiveFraction(string);
            int n = this.getExecutiveFractionCount();
            super.addExecutiveFraction(n, executiveFraction);
        }
        this.setExecutiveFraction(ExecutiveFraction.NAME_CL, 1.0);
    }

    public ProposalFeedback getProposalFeedback() {
        return (ProposalFeedback)this.getParent();
    }

    public void clearTimeFraction() {
        for (ExecutiveFraction executiveFraction : this.getExecutiveFraction()) {
            executiveFraction.setTimeFraction(0.0);
        }
    }

    public ExecutiveFraction getExecutiveFraction(String string) {
        int n = this.indexOf(string);
        if (n >= 0) {
            return this.getExecutiveFraction(n);
        }
        Log.logger((Object)((Object)this)).warning("Unknown Executive Name : " + string);
        return null;
    }

    public void setExecutiveFraction(String string, double d) {
        ExecutiveFraction executiveFraction = this.getExecutiveFraction(string);
        if (executiveFraction == null) {
            if (this.testExecutives()) {
                throw new IllegalArgumentException("Invalid Executive Name : " + string);
            }
            super.clearExecutiveFraction();
            this.presetAllExecutives();
        } else {
            executiveFraction.setTimeFraction(d);
        }
    }

    public void addExecutiveFractionValue(String string, double d) {
        if (ExecutiveFraction.NAME_NA_EA.equals(string)) {
            this.addExecutiveFractionValue(ExecutiveFraction.NAME_NA, d / 2.0);
            this.addExecutiveFractionValue(ExecutiveFraction.NAME_EA, d / 2.0);
        } else {
            ExecutiveFraction executiveFraction = this.getExecutiveFraction(string);
            if (executiveFraction == null) {
                if (this.testExecutives()) {
                    throw new IllegalArgumentException("Invalid Executive Name : " + string);
                }
                super.clearExecutiveFraction();
                this.presetAllExecutives();
            } else {
                executiveFraction.addTimeFraction(d);
            }
        }
    }

    public boolean testTotal() {
        double d = 0.0;
        for (ExecutiveFraction executiveFraction : this.getExecutiveFraction()) {
            d += executiveFraction.getTimeFraction();
        }
        return Math.abs(d - 1.0) < 1.0E-5;
    }

    public boolean testExecutives() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(Arrays.asList(ExecutiveFraction.getKnownNameList()));
        if (this.getExecutiveFractionCount() != arrayList.size()) {
            return false;
        }
        for (String string : arrayList) {
            if (this.indexOf(string) != -1) continue;
            return false;
        }
        Object object = this.getExecutiveFraction(ExecutiveFraction.NAME_NA_EA);
        return 0.0 == object.getTimeFraction();
    }

    private int indexOf(String string) {
        ExecutiveFraction[] executiveFractionArray = this.getExecutiveFraction();
        for (int i = 0; i < executiveFractionArray.length; ++i) {
            ExecutiveFraction executiveFraction = executiveFractionArray[i];
            if (!executiveFraction.getName().equals(string)) continue;
            return i;
        }
        return -1;
    }

    public AbstractTimeAllocationStrategy getTimeAllocationStrategy() {
        if (this.timeAllocStrategy == null) {
            this.timeAllocStrategy = new StandardTimeAllocationStrategy(this);
        }
        return this.timeAllocStrategy;
    }

    public void setTimeAllocationStrategy(AbstractTimeAllocationStrategy abstractTimeAllocationStrategy) {
        this.timeAllocStrategy = abstractTimeAllocationStrategy;
    }

    public void allocateTimeToExecutives() {
        this.getTimeAllocationStrategy().allocateObservingTimeToExecutives();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (ExecutiveFraction executiveFraction : this.getExecutiveFraction()) {
            stringBuilder.append(String.format("%s:%.2f,", executiveFraction.getName(), executiveFraction.getTimeFraction()));
        }
        return stringBuilder.toString();
    }
}

