/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.schedblock;

import alma.entity.xmlbinding.schedblock.BaseBandSpecificationT;
import alma.entity.xmlbinding.schedblock.SchedBlockRefT;
import alma.obsprep.bo.annotations.BaseBand;
import alma.obsprep.bo.annotations.SpectralWindowI;
import alma.obsprep.bo.enumerations.NetSideBand;
import alma.obsprep.bo.schedblock.AbstractBaseBandConfig;
import alma.obsprep.bo.schedblock.AbstractCorrelatorConfiguration;
import alma.obsprep.bo.schedblock.AbstractSpectralWindow;
import alma.obsprep.bo.schedblock.FrequencySetup;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.data.BaseBandSpecificationData;
import alma.valuetypes.DataRate;
import alma.valuetypes.Frequency;
import alma.valuetypes.Velocity;
import java.util.Formatter;

public class BaseBandSpecification
extends BaseBandSpecificationData
implements BaseBand {
    public static final double BASEBAND_OFFSET_GHZ = 2.0;
    public static final double OMEGA_S = 4.0;
    public static final double BASEBANDWIDTH_GHZ = 2.0;
    public static final double WEIGHTING_MIN = 0.0;
    public static final double WEIGHTING_MAX = 100.0;
    public static final Frequency basebandWidth = Frequency.createFrequencyGHZ(2.0);
    private Frequency actualBaseBandCenterFrequencySky;
    private final SpectralWindowI[] emptySpectralWindowIArray = new SpectralWindowI[0];
    private final AbstractSpectralWindow[] emptySpectralWindowArray = new AbstractSpectralWindow[0];

    public BaseBandSpecification(BaseBandSpecificationT baseBandSpecificationT) {
        super(baseBandSpecificationT);
    }

    protected void initAsNew() {
        this.setLO2Frequency(Frequency.createFrequencyGHZ(0.0));
        super.initAsNew();
        this.setImageCenterFrequency(Frequency.createFrequencyGHZ(0.0));
    }

    public Frequency getImageCenterFrequency() {
        Frequency frequency = this.gettrueImageCenterFrequency();
        if (frequency == null) {
            frequency = Frequency.createFrequencyGHZ(0.0);
            this.setImageCenterFrequency(frequency);
        }
        return frequency;
    }

    public FrequencySetup getFrequencySetup() {
        FrequencySetup frequencySetup = (FrequencySetup)this.getParent();
        return frequencySetup == null ? null : frequencySetup;
    }

    public SpectralSpec getSpectralSpec() {
        FrequencySetup frequencySetup = this.getFrequencySetup();
        return frequencySetup == null ? null : frequencySetup.getSpectralSpec();
    }

    public AbstractBaseBandConfig findBaseBandConfig() {
        SpectralSpec spectralSpec = this.getSpectralSpec();
        if (spectralSpec == null) {
            return null;
        }
        AbstractCorrelatorConfiguration abstractCorrelatorConfiguration = spectralSpec.gettrueAbstractCorrelatorConfiguration();
        if (abstractCorrelatorConfiguration == null) {
            return null;
        }
        for (AbstractBaseBandConfig abstractBaseBandConfig : abstractCorrelatorConfiguration.getBaseBandConfig()) {
            if (abstractBaseBandConfig.getBaseBandSpecification() != this) continue;
            return abstractBaseBandConfig;
        }
        return null;
    }

    @Override
    public int getBaseBandIndex() {
        FrequencySetup frequencySetup = this.getFrequencySetup();
        if (frequencySetup != null) {
            for (int i = 0; i < frequencySetup.getBaseBandSpecificationCount(); ++i) {
                if (this != frequencySetup.getBaseBandSpecification(i)) continue;
                return i;
            }
        }
        return -1;
    }

    public int getBaseBandNameIndex() {
        return BaseBandSpecification.getBaseBandNameIndex(this.getBaseBandName());
    }

    public static int getBaseBandNameIndex(String string) {
        for (int i = 0; i < knownBaseBandNameList.length; ++i) {
            if (!string.equals(knownBaseBandNameList[i])) continue;
            return i;
        }
        return -1;
    }

    public Frequency getActualBaseBandCenterFrequencySky() {
        if (this.actualBaseBandCenterFrequencySky == null) {
            this.actualBaseBandCenterFrequencySky = Frequency.createFrequency();
        }
        return this.actualBaseBandCenterFrequencySky;
    }

    public Frequency getActualBaseBandCenterFrequencyRest() {
        Frequency frequency = this.getActualBaseBandCenterFrequencySky();
        if (FrequencySetup.DOPPLERREFERENCE_TOPO == this.getSpectralSpec().getFrequencySetup().getDopplerReference()) {
            return frequency;
        }
        return this.getSourceVelocity().reverseShift(frequency);
    }

    public Velocity getSourceVelocity() {
        SpectralSpec spectralSpec = this.getSpectralSpec();
        return spectralSpec == null ? Velocity.createVelocity() : spectralSpec.getSourceVelocity();
    }

    public int getPolarizationProductsCount() {
        throw new RuntimeException("PolarizationProduct is not an attribute of BaseBandConfig any more!");
    }

    public int getNumChannels() {
        return 8192 / this.getPolarizationProductsCount();
    }

    public Frequency getLO1Frequency() {
        SpectralSpec spectralSpec = this.getSpectralSpec();
        return spectralSpec == null ? null : spectralSpec.getLO1Frequency();
    }

    public Frequency[] getLOFrequencies() {
        SpectralSpec spectralSpec = this.getSpectralSpec();
        if (spectralSpec == null) {
            return null;
        }
        Frequency frequency = spectralSpec.getLO1Frequency();
        Frequency frequency2 = this.getLO2Frequency();
        return new Frequency[]{frequency, frequency2};
    }

    public Frequency getSkyFrequency(Frequency frequency, NetSideBand netSideBand) {
        Frequency[] frequencyArray = this.getLOFrequencies();
        if (frequencyArray == null) {
            return null;
        }
        return netSideBand.getSkyFrequency(frequency, frequencyArray[0], frequencyArray[1]);
    }

    public Frequency getSkyFrequencyLSB(Frequency frequency) {
        Frequency[] frequencyArray = this.getLOFrequencies();
        if (frequencyArray == null) {
            return null;
        }
        return NetSideBand.LSB.getSkyFrequency(frequency, frequencyArray[0], frequencyArray[1]);
    }

    public Frequency getSkyFrequencyUSB(Frequency frequency) {
        Frequency[] frequencyArray = this.getLOFrequencies();
        if (frequencyArray == null) {
            return null;
        }
        return NetSideBand.USB.getSkyFrequency(frequency, frequencyArray[0], frequencyArray[1]);
    }

    @Override
    public Frequency getCenterFrequencySky() {
        Frequency frequency = this.getCenterFrequency();
        if (FrequencySetup.DOPPLERREFERENCE_TOPO == this.getSpectralSpec().getFrequencySetup().getDopplerReference()) {
            return frequency;
        }
        return this.getSourceVelocity().dopplerShift(frequency);
    }

    @Override
    public Frequency mid() {
        return this.getCenterFrequency();
    }

    public Frequency getMinFrequency() {
        return this.min();
    }

    @Override
    public Frequency min() {
        double d = this.getCenterFrequency().getContentInGHz();
        double d2 = this.getBandwidth().getContentInGHz();
        return Frequency.createFrequencyGHZ(d - d2 / 2.0);
    }

    public Frequency getMaxFrequency() {
        return this.max();
    }

    @Override
    public Frequency max() {
        double d = this.getCenterFrequency().getContentInGHz();
        double d2 = this.getBandwidth().getContentInGHz();
        return Frequency.createFrequencyGHZ(d + d2 / 2.0);
    }

    @Override
    public Frequency getBandwidth() {
        return this.range();
    }

    @Override
    public Frequency range() {
        return basebandWidth;
    }

    @Override
    public AbstractBaseBandConfig getBaseBandConfig() {
        return this.findBaseBandConfig();
    }

    @Override
    public BaseBandSpecification getBaseBandSpecification() {
        return this;
    }

    public SchedBlockRefT getEntityPartReference() {
        SchedBlockRefT schedBlockRefT = super.getEntityPartReference();
        schedBlockRefT.setDocumentVersion("1");
        return schedBlockRefT;
    }

    @Override
    public SpectralWindowI[] getSpectralWindow() {
        AbstractBaseBandConfig abstractBaseBandConfig = this.getBaseBandConfig();
        if (abstractBaseBandConfig == null) {
            return this.emptySpectralWindowIArray;
        }
        return abstractBaseBandConfig.getSpectralWindow();
    }

    @Override
    public SpectralWindowI getSpectralWindow(int n) {
        AbstractBaseBandConfig abstractBaseBandConfig = this.getBaseBandConfig();
        if (abstractBaseBandConfig == null) {
            return null;
        }
        return abstractBaseBandConfig.getSpectralWindow(n);
    }

    @Override
    public AbstractSpectralWindow[] getSingleSpectralWindow() {
        AbstractBaseBandConfig abstractBaseBandConfig = this.getBaseBandConfig();
        if (abstractBaseBandConfig == null) {
            return this.emptySpectralWindowArray;
        }
        return abstractBaseBandConfig.getSingleSpectralWindow();
    }

    @Override
    public AbstractSpectralWindow getSingleSpectralWindow(int n) {
        AbstractBaseBandConfig abstractBaseBandConfig = this.getBaseBandConfig();
        if (abstractBaseBandConfig == null) {
            return null;
        }
        return abstractBaseBandConfig.getSingleSpectralWindow(n);
    }

    @Override
    public int getSingleSpectralWindowCount() {
        AbstractBaseBandConfig abstractBaseBandConfig = this.getBaseBandConfig();
        if (abstractBaseBandConfig == null) {
            return 0;
        }
        return abstractBaseBandConfig.getSingleSpectralWindowCount();
    }

    @Override
    public int getSpectralWindowCount() {
        AbstractBaseBandConfig abstractBaseBandConfig = this.getBaseBandConfig();
        if (abstractBaseBandConfig == null) {
            return 0;
        }
        return abstractBaseBandConfig.getSpectralWindowCount();
    }

    @Override
    public void format(Formatter formatter, String string) {
        formatter.format("%s%s@%h%n", string, this.getClass().getSimpleName(), this.hashCode());
        string = string + "\t";
        formatter.format("%sIndex                      = %d%n", string, this.getBaseBandIndex() + 1);
    }

    @Override
    public DataRate getInstantaneousDataRate() {
        AbstractBaseBandConfig abstractBaseBandConfig = this.getBaseBandConfig();
        if (abstractBaseBandConfig == null) {
            return DataRate.createDataRate();
        }
        return abstractBaseBandConfig.getInstantaneousDataRate();
    }
}

