/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.schedblock;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.obsprep.bo.schedblock.CorrConfigMode;
import alma.valuetypes.Frequency;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class ConfigModeComparator
implements Comparator<CorrConfigMode> {
    protected List<Column> priority;

    public ConfigModeComparator() {
        this(Column.MODE);
    }

    public ConfigModeComparator(List<Column> list) {
        this.priority = list;
    }

    public ConfigModeComparator(Column column) {
        this.priority = Arrays.asList(column);
    }

    public ConfigModeComparator(Column[] columnArray) {
        this.priority = Arrays.asList(columnArray);
    }

    @Override
    public int compare(CorrConfigMode corrConfigMode, CorrConfigMode corrConfigMode2) {
        Iterator<Column> iterator = this.priority.iterator();
        while (iterator.hasNext()) {
            int n = this.compare(iterator.next(), corrConfigMode, corrConfigMode2);
            if (n == 0) continue;
            return n;
        }
        return 0;
    }

    private int compare(Column column, CorrConfigMode corrConfigMode, CorrConfigMode corrConfigMode2) {
        switch (column) {
            case MODE: {
                int n = corrConfigMode.getMode();
                int n2 = corrConfigMode2.getMode();
                return (n - n2) / Math.abs(n - n2);
            }
            case CHANNELS: {
                int n = corrConfigMode.getNominalChannels();
                int n3 = corrConfigMode2.getNominalChannels();
                return (n - n3) / Math.abs(n - n3);
            }
            case BANDWIDTH: {
                Frequency frequency = corrConfigMode.getNominalBandwidth();
                Frequency frequency2 = corrConfigMode2.getNominalBandwidth();
                return frequency.compareTo((AbstractDoubleWithUnit)frequency2);
            }
            case RESOLUTION: {
                Frequency frequency = corrConfigMode.getResolution();
                Frequency frequency3 = corrConfigMode2.getResolution();
                return frequency.compareTo((AbstractDoubleWithUnit)frequency3);
            }
        }
        return 0;
    }

    public static enum Column {
        MODE,
        BANDWIDTH,
        RESOLUTION,
        CHANNELS;

    }
}

