/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.schedblock;

import alma.obsprep.bo.schedblock.ConfigModeDecoder;
import java.util.ArrayList;
import java.util.TreeMap;
import java.util.TreeSet;

public class ConfigModeDecoderImpl
implements ConfigModeDecoder {
    static ArrayList<EmbededCorrConfigMode> m_table;
    static TreeMap<Integer, EmbededCorrConfigMode> modeMap;
    static TreeSet<Integer> knownModesSet;
    static TreeSet<Integer> knownNominalChannelsSet;
    static TreeSet<Integer> knownEffectiveChannelsSet;
    static TreeSet<Double> knownNominalBandwidthsSet;
    static TreeSet<Double> knownEffectiveBandwidthsSet;
    static TreeSet<Double> knownResolutionsSet;
    private long[] knownChannels = null;
    private int[] knownModes = null;
    private float[] knownNominalBandwidths = null;

    public ConfigModeDecoderImpl() {
        this.setup();
    }

    private void setup() {
        m_table = new ArrayList();
        m_table.add(new EmbededCorrConfigMode(0, 0.0, 0, null, false, null, null));
        m_table.add(new EmbededCorrConfigMode(1, 2000.0, 8192, 1992.1875, 8160, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.98));
        m_table.add(new EmbededCorrConfigMode(2, 1000.0, 8192, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.97));
        m_table.add(new EmbededCorrConfigMode(3, 1000.0, 4096, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.98));
        m_table.add(new EmbededCorrConfigMode(4, 500.0, 8192, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.96));
        m_table.add(new EmbededCorrConfigMode(5, 500.0, 4096, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.97));
        m_table.add(new EmbededCorrConfigMode(6, 500.0, 2048, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.98));
        m_table.add(new EmbededCorrConfigMode(7, 250.0, 8192, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.94));
        m_table.add(new EmbededCorrConfigMode(8, 250.0, 4096, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.96));
        m_table.add(new EmbededCorrConfigMode(9, 250.0, 2048, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.97));
        m_table.add(new EmbededCorrConfigMode(10, 250.0, 1024, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.98));
        m_table.add(new EmbededCorrConfigMode(11, 125.0, 8192, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.91));
        m_table.add(new EmbededCorrConfigMode(12, 125.0, 4096, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.94));
        m_table.add(new EmbededCorrConfigMode(13, 125.0, 2048, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.96));
        m_table.add(new EmbededCorrConfigMode(14, 125.0, 1024, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.97));
        m_table.add(new EmbededCorrConfigMode(1014, 125.0, 512, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.97));
        m_table.add(new EmbededCorrConfigMode(15, 62.5, 8192, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.87));
        m_table.add(new EmbededCorrConfigMode(16, 62.5, 4096, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.91));
        m_table.add(new EmbededCorrConfigMode(17, 62.5, 2048, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.94));
        m_table.add(new EmbededCorrConfigMode(18, 62.5, 1024, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.96));
        m_table.add(new EmbededCorrConfigMode(1018, 62.5, 512, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.96));
        m_table.add(new EmbededCorrConfigMode(1118, 62.5, 256, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.96));
        m_table.add(new EmbededCorrConfigMode(19, 2000.0, 8192, 1992.1875, 8160, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_Y, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.98));
        m_table.add(new EmbededCorrConfigMode(20, 1000.0, 8192, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_Y, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.97));
        m_table.add(new EmbededCorrConfigMode(21, 1000.0, 4096, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_Y, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.98));
        m_table.add(new EmbededCorrConfigMode(22, 500.0, 8192, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_Y, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.96));
        m_table.add(new EmbededCorrConfigMode(23, 500.0, 4096, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_Y, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.97));
        m_table.add(new EmbededCorrConfigMode(24, 500.0, 2048, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_Y, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.98));
        m_table.add(new EmbededCorrConfigMode(25, 250.0, 8192, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_Y, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.94));
        m_table.add(new EmbededCorrConfigMode(26, 250.0, 4096, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_Y, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.96));
        m_table.add(new EmbededCorrConfigMode(27, 250.0, 2048, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_Y, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.97));
        m_table.add(new EmbededCorrConfigMode(28, 250.0, 1024, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_Y, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.98));
        m_table.add(new EmbededCorrConfigMode(29, 125.0, 8192, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_Y, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.91));
        m_table.add(new EmbededCorrConfigMode(30, 125.0, 4096, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_Y, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.94));
        m_table.add(new EmbededCorrConfigMode(31, 125.0, 2048, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_Y, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.96));
        m_table.add(new EmbededCorrConfigMode(32, 125.0, 1024, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_Y, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.97));
        m_table.add(new EmbededCorrConfigMode(33, 62.5, 8192, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_Y, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.87));
        m_table.add(new EmbededCorrConfigMode(34, 62.5, 4096, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_Y, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.91));
        m_table.add(new EmbededCorrConfigMode(35, 62.5, 2048, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_Y, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.94));
        m_table.add(new EmbededCorrConfigMode(36, 62.5, 1024, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_Y, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.96));
        m_table.add(new EmbededCorrConfigMode(37, 2000.0, 4096, 1992.1875, 4080, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_DOUBLE, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.99));
        m_table.add(new EmbededCorrConfigMode(38, 1000.0, 4096, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_DOUBLE, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.98));
        m_table.add(new EmbededCorrConfigMode(1038, 1000.0, 2048, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_DOUBLE, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.98));
        m_table.add(new EmbededCorrConfigMode(39, 500.0, 4096, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_DOUBLE, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.97));
        m_table.add(new EmbededCorrConfigMode(40, 500.0, 2048, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_DOUBLE, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.98));
        m_table.add(new EmbededCorrConfigMode(1040, 500.0, 1024, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_DOUBLE, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.98));
        m_table.add(new EmbededCorrConfigMode(41, 250.0, 4096, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_DOUBLE, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.96));
        m_table.add(new EmbededCorrConfigMode(42, 250.0, 2048, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_DOUBLE, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.97));
        m_table.add(new EmbededCorrConfigMode(43, 250.0, 1024, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_DOUBLE, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.98));
        m_table.add(new EmbededCorrConfigMode(1043, 250.0, 512, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_DOUBLE, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.98));
        m_table.add(new EmbededCorrConfigMode(44, 125.0, 4096, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_DOUBLE, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.94));
        m_table.add(new EmbededCorrConfigMode(45, 125.0, 2048, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_DOUBLE, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.96));
        m_table.add(new EmbededCorrConfigMode(46, 125.0, 1024, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_DOUBLE, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.97));
        m_table.add(new EmbededCorrConfigMode(47, 125.0, 512, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_DOUBLE, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.98));
        m_table.add(new EmbededCorrConfigMode(1047, 125.0, 256, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_DOUBLE, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.98));
        m_table.add(new EmbededCorrConfigMode(48, 62.5, 4096, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_DOUBLE, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.91));
        m_table.add(new EmbededCorrConfigMode(49, 62.5, 2048, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_DOUBLE, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.94));
        m_table.add(new EmbededCorrConfigMode(50, 62.5, 1024, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_DOUBLE, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.96));
        m_table.add(new EmbededCorrConfigMode(51, 62.5, 512, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_DOUBLE, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.97));
        m_table.add(new EmbededCorrConfigMode(1051, 62.5, 256, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_DOUBLE, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.97));
        m_table.add(new EmbededCorrConfigMode(1151, 62.5, 128, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_DOUBLE, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.97));
        m_table.add(new EmbededCorrConfigMode(52, 2000.0, 2048, 1992.1875, 2040, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_FULL, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.99));
        m_table.add(new EmbededCorrConfigMode(53, 1000.0, 2048, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_FULL, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.99));
        m_table.add(new EmbededCorrConfigMode(54, 500.0, 2048, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_FULL, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.98));
        m_table.add(new EmbededCorrConfigMode(55, 250.0, 2048, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_FULL, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.97));
        m_table.add(new EmbededCorrConfigMode(56, 250.0, 1024, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_FULL, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.98));
        m_table.add(new EmbededCorrConfigMode(57, 125.0, 2048, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_FULL, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.96));
        m_table.add(new EmbededCorrConfigMode(58, 125.0, 1024, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_FULL, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.97));
        m_table.add(new EmbededCorrConfigMode(59, 125.0, 512, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_FULL, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.98));
        m_table.add(new EmbededCorrConfigMode(60, 62.5, 2048, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_FULL, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.94));
        m_table.add(new EmbededCorrConfigMode(61, 62.5, 1024, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_FULL, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.96));
        m_table.add(new EmbededCorrConfigMode(62, 62.5, 512, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_FULL, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.97));
        m_table.add(new EmbededCorrConfigMode(63, 62.5, 256, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_FULL, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.98));
        m_table.add(new EmbededCorrConfigMode(64, 2000.0, 4096, ConfigModeDecoder.eBits.BITS_2x2, true, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.99));
        m_table.add(new EmbededCorrConfigMode(65, 1000.0, 4096, ConfigModeDecoder.eBits.BITS_2x2, true, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.98));
        m_table.add(new EmbededCorrConfigMode(66, 500.0, 4096, ConfigModeDecoder.eBits.BITS_2x2, true, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.97));
        m_table.add(new EmbededCorrConfigMode(67, 250.0, 4096, ConfigModeDecoder.eBits.BITS_2x2, true, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.96));
        m_table.add(new EmbededCorrConfigMode(68, 125.0, 4096, ConfigModeDecoder.eBits.BITS_2x2, true, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.94));
        m_table.add(new EmbededCorrConfigMode(69, 62.5, 4096, ConfigModeDecoder.eBits.BITS_2x2, true, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.91));
        m_table.add(new EmbededCorrConfigMode(70, 31.25, 8192, ConfigModeDecoder.eBits.BITS_2x2, true, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.81));
        m_table.add(new EmbededCorrConfigMode(71, 31.25, 4096, ConfigModeDecoder.eBits.BITS_2x2, true, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88));
        m_table.add(new EmbededCorrConfigMode(72, 31.25, 2048, ConfigModeDecoder.eBits.BITS_2x2, true, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.91));
        m_table.add(new EmbededCorrConfigMode(73, 31.25, 1024, ConfigModeDecoder.eBits.BITS_2x2, true, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88));
        m_table.add(new EmbededCorrConfigMode(74, 2000.0, 4096, ConfigModeDecoder.eBits.BITS_2x2, true, ConfigModeDecoder.ePolarization.POLZ_SINGLE_Y, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.99));
        m_table.add(new EmbededCorrConfigMode(75, 1000.0, 4096, ConfigModeDecoder.eBits.BITS_2x2, true, ConfigModeDecoder.ePolarization.POLZ_SINGLE_Y, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.98));
        m_table.add(new EmbededCorrConfigMode(76, 500.0, 4096, ConfigModeDecoder.eBits.BITS_2x2, true, ConfigModeDecoder.ePolarization.POLZ_SINGLE_Y, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.97));
        m_table.add(new EmbededCorrConfigMode(77, 250.0, 4096, ConfigModeDecoder.eBits.BITS_2x2, true, ConfigModeDecoder.ePolarization.POLZ_SINGLE_Y, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.96));
        m_table.add(new EmbededCorrConfigMode(78, 125.0, 4096, ConfigModeDecoder.eBits.BITS_2x2, true, ConfigModeDecoder.ePolarization.POLZ_SINGLE_Y, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.94));
        m_table.add(new EmbededCorrConfigMode(79, 62.5, 4096, ConfigModeDecoder.eBits.BITS_2x2, true, ConfigModeDecoder.ePolarization.POLZ_SINGLE_Y, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.91));
        m_table.add(new EmbededCorrConfigMode(80, 31.25, 8192, ConfigModeDecoder.eBits.BITS_2x2, true, ConfigModeDecoder.ePolarization.POLZ_SINGLE_Y, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.81));
        m_table.add(new EmbededCorrConfigMode(81, 31.25, 4096, ConfigModeDecoder.eBits.BITS_2x2, true, ConfigModeDecoder.ePolarization.POLZ_SINGLE_Y, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88));
        m_table.add(new EmbededCorrConfigMode(82, 31.25, 2048, ConfigModeDecoder.eBits.BITS_2x2, true, ConfigModeDecoder.ePolarization.POLZ_SINGLE_Y, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.91));
        m_table.add(new EmbededCorrConfigMode(83, 31.25, 1024, ConfigModeDecoder.eBits.BITS_2x2, true, ConfigModeDecoder.ePolarization.POLZ_SINGLE_Y, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88));
        m_table.add(new EmbededCorrConfigMode(84, 1000.0, 2048, ConfigModeDecoder.eBits.BITS_2x2, true, ConfigModeDecoder.ePolarization.POLZ_DOUBLE, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.99));
        m_table.add(new EmbededCorrConfigMode(85, 500.0, 2048, ConfigModeDecoder.eBits.BITS_2x2, true, ConfigModeDecoder.ePolarization.POLZ_DOUBLE, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.98));
        m_table.add(new EmbededCorrConfigMode(86, 250.0, 2048, ConfigModeDecoder.eBits.BITS_2x2, true, ConfigModeDecoder.ePolarization.POLZ_DOUBLE, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.97));
        m_table.add(new EmbededCorrConfigMode(87, 125.0, 2048, ConfigModeDecoder.eBits.BITS_2x2, true, ConfigModeDecoder.ePolarization.POLZ_DOUBLE, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.96));
        m_table.add(new EmbededCorrConfigMode(88, 62.5, 2048, ConfigModeDecoder.eBits.BITS_2x2, true, ConfigModeDecoder.ePolarization.POLZ_DOUBLE, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.94));
        m_table.add(new EmbededCorrConfigMode(89, 31.25, 4096, ConfigModeDecoder.eBits.BITS_2x2, true, ConfigModeDecoder.ePolarization.POLZ_DOUBLE, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.87));
        m_table.add(new EmbededCorrConfigMode(90, 31.25, 2048, ConfigModeDecoder.eBits.BITS_2x2, true, ConfigModeDecoder.ePolarization.POLZ_DOUBLE, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88));
        m_table.add(new EmbededCorrConfigMode(91, 31.25, 1024, ConfigModeDecoder.eBits.BITS_2x2, true, ConfigModeDecoder.ePolarization.POLZ_DOUBLE, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.94));
        m_table.add(new EmbededCorrConfigMode(92, 31.25, 512, ConfigModeDecoder.eBits.BITS_2x2, true, ConfigModeDecoder.ePolarization.POLZ_DOUBLE, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88));
        m_table.add(new EmbededCorrConfigMode(93, 1000.0, 1024, ConfigModeDecoder.eBits.BITS_2x2, true, ConfigModeDecoder.ePolarization.POLZ_FULL, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.99));
        m_table.add(new EmbededCorrConfigMode(94, 500.0, 1024, ConfigModeDecoder.eBits.BITS_2x2, true, ConfigModeDecoder.ePolarization.POLZ_FULL, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.99));
        m_table.add(new EmbededCorrConfigMode(95, 250.0, 1024, ConfigModeDecoder.eBits.BITS_2x2, true, ConfigModeDecoder.ePolarization.POLZ_FULL, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.98));
        m_table.add(new EmbededCorrConfigMode(96, 125.0, 1024, ConfigModeDecoder.eBits.BITS_2x2, true, ConfigModeDecoder.ePolarization.POLZ_FULL, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.97));
        m_table.add(new EmbededCorrConfigMode(97, 62.5, 1024, ConfigModeDecoder.eBits.BITS_2x2, true, ConfigModeDecoder.ePolarization.POLZ_FULL, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.96));
        m_table.add(new EmbededCorrConfigMode(98, 31.25, 2048, ConfigModeDecoder.eBits.BITS_2x2, true, ConfigModeDecoder.ePolarization.POLZ_FULL, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.91));
        m_table.add(new EmbededCorrConfigMode(99, 31.25, 1024, ConfigModeDecoder.eBits.BITS_2x2, true, ConfigModeDecoder.ePolarization.POLZ_FULL, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88));
        m_table.add(new EmbededCorrConfigMode(100, 31.25, 512, ConfigModeDecoder.eBits.BITS_2x2, true, ConfigModeDecoder.ePolarization.POLZ_FULL, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.96));
        m_table.add(new EmbededCorrConfigMode(101, 31.25, 256, ConfigModeDecoder.eBits.BITS_2x2, true, ConfigModeDecoder.ePolarization.POLZ_FULL, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88));
        m_table.add(new EmbededCorrConfigMode(102, 2000.0, 2048, ConfigModeDecoder.eBits.BITS_4x4, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88));
        m_table.add(new EmbededCorrConfigMode(103, 1000.0, 2048, ConfigModeDecoder.eBits.BITS_4x4, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88));
        m_table.add(new EmbededCorrConfigMode(104, 500.0, 2048, ConfigModeDecoder.eBits.BITS_4x4, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88));
        m_table.add(new EmbededCorrConfigMode(105, 250.0, 2048, ConfigModeDecoder.eBits.BITS_4x4, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88));
        m_table.add(new EmbededCorrConfigMode(106, 125.0, 2048, ConfigModeDecoder.eBits.BITS_4x4, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88));
        m_table.add(new EmbededCorrConfigMode(107, 62.5, 2048, ConfigModeDecoder.eBits.BITS_4x4, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88));
        m_table.add(new EmbededCorrConfigMode(108, 2000.0, 2048, ConfigModeDecoder.eBits.BITS_4x4, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_Y, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88));
        m_table.add(new EmbededCorrConfigMode(109, 1000.0, 2048, ConfigModeDecoder.eBits.BITS_4x4, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_Y, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88));
        m_table.add(new EmbededCorrConfigMode(110, 500.0, 2048, ConfigModeDecoder.eBits.BITS_4x4, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_Y, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88));
        m_table.add(new EmbededCorrConfigMode(111, 250.0, 2048, ConfigModeDecoder.eBits.BITS_4x4, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_Y, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88));
        m_table.add(new EmbededCorrConfigMode(112, 125.0, 2048, ConfigModeDecoder.eBits.BITS_4x4, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_Y, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88));
        m_table.add(new EmbededCorrConfigMode(113, 62.5, 2048, ConfigModeDecoder.eBits.BITS_4x4, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_Y, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88));
        m_table.add(new EmbededCorrConfigMode(114, 1000.0, 1024, ConfigModeDecoder.eBits.BITS_4x4, false, ConfigModeDecoder.ePolarization.POLZ_DOUBLE, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88));
        m_table.add(new EmbededCorrConfigMode(115, 500.0, 1024, ConfigModeDecoder.eBits.BITS_4x4, false, ConfigModeDecoder.ePolarization.POLZ_DOUBLE, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88));
        m_table.add(new EmbededCorrConfigMode(116, 250.0, 1024, ConfigModeDecoder.eBits.BITS_4x4, false, ConfigModeDecoder.ePolarization.POLZ_DOUBLE, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88));
        m_table.add(new EmbededCorrConfigMode(117, 125.0, 1024, ConfigModeDecoder.eBits.BITS_4x4, false, ConfigModeDecoder.ePolarization.POLZ_DOUBLE, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88));
        m_table.add(new EmbededCorrConfigMode(118, 62.5, 1024, ConfigModeDecoder.eBits.BITS_4x4, false, ConfigModeDecoder.ePolarization.POLZ_DOUBLE, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88));
        m_table.add(new EmbededCorrConfigMode(119, 125.0, 512, ConfigModeDecoder.eBits.BITS_4x4, false, ConfigModeDecoder.ePolarization.POLZ_FULL, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88));
        m_table.add(new EmbededCorrConfigMode(120, 62.5, 512, ConfigModeDecoder.eBits.BITS_4x4, false, ConfigModeDecoder.ePolarization.POLZ_FULL, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88));
        m_table.add(new EmbededCorrConfigMode(121, 1000.0, 1024, ConfigModeDecoder.eBits.BITS_4x4, true, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88));
        m_table.add(new EmbededCorrConfigMode(122, 500.0, 1024, ConfigModeDecoder.eBits.BITS_4x4, true, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88));
        m_table.add(new EmbededCorrConfigMode(123, 250.0, 1024, ConfigModeDecoder.eBits.BITS_4x4, true, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88));
        m_table.add(new EmbededCorrConfigMode(124, 125.0, 1024, ConfigModeDecoder.eBits.BITS_4x4, true, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88));
        m_table.add(new EmbededCorrConfigMode(125, 62.5, 1024, ConfigModeDecoder.eBits.BITS_4x4, true, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88));
        m_table.add(new EmbededCorrConfigMode(126, 31.25, 2048, ConfigModeDecoder.eBits.BITS_4x4, true, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88));
        m_table.add(new EmbededCorrConfigMode(127, 1000.0, 1024, ConfigModeDecoder.eBits.BITS_4x4, true, ConfigModeDecoder.ePolarization.POLZ_SINGLE_Y, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88));
        m_table.add(new EmbededCorrConfigMode(128, 500.0, 1024, ConfigModeDecoder.eBits.BITS_4x4, true, ConfigModeDecoder.ePolarization.POLZ_SINGLE_Y, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88));
        m_table.add(new EmbededCorrConfigMode(129, 250.0, 1024, ConfigModeDecoder.eBits.BITS_4x4, true, ConfigModeDecoder.ePolarization.POLZ_SINGLE_Y, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88));
        m_table.add(new EmbededCorrConfigMode(130, 125.0, 1024, ConfigModeDecoder.eBits.BITS_4x4, true, ConfigModeDecoder.ePolarization.POLZ_SINGLE_Y, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88));
        m_table.add(new EmbededCorrConfigMode(131, 62.5, 1024, ConfigModeDecoder.eBits.BITS_4x4, true, ConfigModeDecoder.ePolarization.POLZ_SINGLE_Y, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88));
        m_table.add(new EmbededCorrConfigMode(132, 31.25, 2048, ConfigModeDecoder.eBits.BITS_4x4, true, ConfigModeDecoder.ePolarization.POLZ_SINGLE_Y, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88));
        m_table.add(new EmbededCorrConfigMode(133, 500.0, 512, ConfigModeDecoder.eBits.BITS_4x4, true, ConfigModeDecoder.ePolarization.POLZ_DOUBLE, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88));
        m_table.add(new EmbededCorrConfigMode(134, 250.0, 512, ConfigModeDecoder.eBits.BITS_4x4, true, ConfigModeDecoder.ePolarization.POLZ_DOUBLE, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88));
        m_table.add(new EmbededCorrConfigMode(135, 125.0, 512, ConfigModeDecoder.eBits.BITS_4x4, true, ConfigModeDecoder.ePolarization.POLZ_DOUBLE, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88));
        m_table.add(new EmbededCorrConfigMode(136, 62.5, 512, ConfigModeDecoder.eBits.BITS_4x4, true, ConfigModeDecoder.ePolarization.POLZ_DOUBLE, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88));
        m_table.add(new EmbededCorrConfigMode(137, 31.25, 1024, ConfigModeDecoder.eBits.BITS_4x4, false, ConfigModeDecoder.ePolarization.POLZ_DOUBLE, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88));
        m_table.add(new EmbededCorrConfigMode(138, 62.5, 256, ConfigModeDecoder.eBits.BITS_4x4, true, ConfigModeDecoder.ePolarization.POLZ_FULL, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88));
        m_table.add(new EmbededCorrConfigMode(139, 31.25, 512, ConfigModeDecoder.eBits.BITS_4x4, false, ConfigModeDecoder.ePolarization.POLZ_FULL, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88));
        m_table.add(new EmbededCorrConfigMode(140, 2000.0, 64, ConfigModeDecoder.eBits.BITS_3x3, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TDM, 0.88));
        m_table.add(new EmbededCorrConfigMode(141, 2000.0, 64, ConfigModeDecoder.eBits.BITS_3x3, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_Y, ConfigModeDecoder.eFilterMode.FILTER_TDM, 0.88));
        m_table.add(new EmbededCorrConfigMode(142, 2000.0, 128, 1937.5, 124, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_DOUBLE, ConfigModeDecoder.eFilterMode.FILTER_TDM, 0.99));
        m_table.add(new EmbededCorrConfigMode(143, 2000.0, 64, 1937.5, 62, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_FULL, ConfigModeDecoder.eFilterMode.FILTER_TDM, 0.99));
        m_table.add(new EmbededCorrConfigMode(144, 2000.0, 256, 1937.5, 248, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TDM, 0.99));
        m_table.add(new EmbededCorrConfigMode(145, 2000.0, 256, 1937.5, 248, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_Y, ConfigModeDecoder.eFilterMode.FILTER_TDM, 0.99));
        modeMap = new TreeMap();
        for (EmbededCorrConfigMode embededCorrConfigMode : m_table) {
            modeMap.put(embededCorrConfigMode.mode, embededCorrConfigMode);
        }
        knownModesSet = new TreeSet();
        knownNominalChannelsSet = new TreeSet();
        knownEffectiveChannelsSet = new TreeSet();
        knownNominalBandwidthsSet = new TreeSet();
        knownEffectiveBandwidthsSet = new TreeSet();
        knownResolutionsSet = new TreeSet();
        for (EmbededCorrConfigMode embededCorrConfigMode : m_table) {
            if (embededCorrConfigMode.mode == 0) continue;
            knownModesSet.add(embededCorrConfigMode.mode);
            knownNominalChannelsSet.add(embededCorrConfigMode.channels);
            knownEffectiveChannelsSet.add(embededCorrConfigMode.getEffectiveChannels());
            knownNominalBandwidthsSet.add(embededCorrConfigMode.bandWidth);
            knownEffectiveBandwidthsSet.add(embededCorrConfigMode.getEffectiveBandwidth());
            knownResolutionsSet.add(embededCorrConfigMode.getResolutionMHz());
        }
    }

    @Override
    public double correlatorPercentage(int[] nArray) throws ConfigModeDecoder.ConfigModeException {
        return 0.0;
    }

    @Override
    public int findMode(float f, long l, ConfigModeDecoder.eBits eBits2, boolean bl, ConfigModeDecoder.ePolarization ePolarization2, ConfigModeDecoder.eFilterMode eFilterMode2) throws ConfigModeDecoder.ConfigModeException {
        for (EmbededCorrConfigMode embededCorrConfigMode : m_table) {
            if (l != (long)embededCorrConfigMode.channels || eBits2 != embededCorrConfigMode.bits || bl != embededCorrConfigMode.overSampled || eFilterMode2 != embededCorrConfigMode.filter || !(Math.abs((double)(f * 1000.0f) - embededCorrConfigMode.bandWidth) < 1.0E-5) || ePolarization2 != embededCorrConfigMode.polarizationProducts) continue;
            return embededCorrConfigMode.mode;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("BW=" + f * 1000.0f + "MHz,").append("CH=" + l + ",").append("bits=" + (Object)((Object)eBits2) + ",").append("OS=" + bl + ",").append("PP=" + (Object)((Object)ePolarization2) + ",").append("filter=" + (Object)((Object)eFilterMode2));
        throw new ConfigModeDecoder.ConfigModeException("Unsupported combination : " + stringBuffer.toString());
    }

    private EmbededCorrConfigMode getCorrConfigMode(int n) {
        return modeMap.get(n);
    }

    @Override
    public ConfigModeDecoder.eBits getBits(int n) throws ConfigModeDecoder.ConfigModeException {
        this.checkMode(n);
        return this.getCorrConfigMode((int)n).bits;
    }

    @Override
    public long getChannels(int n) throws ConfigModeDecoder.ConfigModeException {
        return this.getChannels(n, false);
    }

    @Override
    public long getChannels(int n, boolean bl) throws ConfigModeDecoder.ConfigModeException {
        this.checkMode(n);
        return bl ? (long)this.getCorrConfigMode((int)n).acaChProfChannels : (long)this.getCorrConfigMode((int)n).channels;
    }

    @Override
    public float getEffectiveBandwidthGHz(int n) throws ConfigModeDecoder.ConfigModeException {
        return this.getEffectiveBandwidthGHz(n, false);
    }

    public float getEffectiveBandwidthGHz(int n, boolean bl) throws ConfigModeDecoder.ConfigModeException {
        this.checkMode(n);
        return bl ? (float)this.getCorrConfigMode(n).getACAChProfEffectiveBandwidth() / 1000.0f : (float)this.getCorrConfigMode(n).getEffectiveBandwidth() / 1000.0f;
    }

    @Override
    public float getNominalBandwidthGHz(int n) throws ConfigModeDecoder.ConfigModeException {
        return this.getNominalBandwidthGHz(n, false);
    }

    @Override
    public float getNominalBandwidthGHz(int n, boolean bl) throws ConfigModeDecoder.ConfigModeException {
        this.checkMode(n);
        return bl ? (float)(this.getCorrConfigMode((int)n).acaChProfBandWidth / 1000.0) : (float)(this.getCorrConfigMode((int)n).bandWidth / 1000.0);
    }

    @Override
    public float getEffectiveResolutionGHz(int n) throws ConfigModeDecoder.ConfigModeException {
        this.checkMode(n);
        return (float)this.getCorrConfigMode(n).getResolutionMHz() / 1000.0f;
    }

    @Override
    public ConfigModeDecoder.eFilterMode getFilterMode(int n) throws ConfigModeDecoder.ConfigModeException {
        this.checkMode(n);
        return this.getCorrConfigMode((int)n).filter;
    }

    @Override
    public ConfigModeDecoder.ePolarization getPolarizationProducts(int n) throws ConfigModeDecoder.ConfigModeException {
        this.checkMode(n);
        return this.getCorrConfigMode((int)n).polarizationProducts;
    }

    @Override
    public boolean isOversampled(int n) throws ConfigModeDecoder.ConfigModeException {
        this.checkMode(n);
        return this.getCorrConfigMode((int)n).overSampled;
    }

    @Override
    public double getBLEfficiency(int n) throws ConfigModeDecoder.ConfigModeException {
        this.checkMode(n);
        return this.getCorrConfigMode(n).getBLEfficiency();
    }

    @Override
    public double getACAEfficiency(int n) throws ConfigModeDecoder.ConfigModeException {
        this.checkMode(n);
        return this.getCorrConfigMode(n).getACAEfficiency();
    }

    @Override
    public long[] getKnownChannels() {
        TreeSet<Integer> treeSet = knownNominalChannelsSet;
        if (this.knownChannels == null) {
            this.knownChannels = new long[treeSet.size()];
            int n = 0;
            for (Integer n2 : treeSet) {
                this.knownChannels[n++] = n2.intValue();
            }
        }
        return this.knownChannels;
    }

    @Override
    public int[] getKnownModes() {
        TreeSet<Integer> treeSet = knownModesSet;
        if (this.knownModes == null) {
            this.knownModes = new int[treeSet.size()];
            int n = 0;
            for (Integer n2 : treeSet) {
                this.knownModes[n++] = n2;
            }
        }
        return this.knownModes;
    }

    @Override
    public float[] getKnownNominalBandwidths() {
        TreeSet<Double> treeSet = knownNominalBandwidthsSet;
        if (this.knownNominalBandwidths == null) {
            this.knownNominalBandwidths = new float[treeSet.size()];
            int n = 0;
            for (Double d : treeSet) {
                this.knownNominalBandwidths[n++] = d.floatValue();
            }
        }
        return this.knownNominalBandwidths;
    }

    private void checkMode(int n) throws ConfigModeDecoder.ConfigModeException {
        if (n > 0 && knownModesSet.contains(n)) {
            return;
        }
        throw new ConfigModeDecoder.ConfigModeException("Unknown mode : " + n);
    }

    private class EmbededCorrConfigMode {
        private static final double CORR_CONFIG_MODE_TFB_DROPOFF_FRACTION = 16.0;
        int mode;
        double bandWidth;
        int channels;
        double acaChProfBandWidth;
        int acaChProfChannels;
        ConfigModeDecoder.eBits bits;
        boolean overSampled;
        ConfigModeDecoder.ePolarization polarizationProducts;
        ConfigModeDecoder.eFilterMode filter;
        double bl_eff = 0.88;
        double aca_eff;

        private EmbededCorrConfigMode(int n, double d, int n2, double d2, int n3, ConfigModeDecoder.eBits eBits2, boolean bl, ConfigModeDecoder.ePolarization ePolarization2, ConfigModeDecoder.eFilterMode eFilterMode2, double d3) {
            this.mode = n;
            this.bandWidth = d;
            this.channels = n2;
            this.acaChProfBandWidth = d2;
            this.acaChProfChannels = n3;
            this.bits = eBits2;
            this.overSampled = bl;
            this.polarizationProducts = ePolarization2;
            this.filter = eFilterMode2;
            this.aca_eff = d3;
        }

        private EmbededCorrConfigMode(int n, double d, int n2, ConfigModeDecoder.eBits eBits2, boolean bl, ConfigModeDecoder.ePolarization ePolarization2, ConfigModeDecoder.eFilterMode eFilterMode2, double d2) {
            this(n, d, n2, d, n2, eBits2, bl, ePolarization2, eFilterMode2, d2);
        }

        private EmbededCorrConfigMode(int n, double d, int n2, ConfigModeDecoder.eBits eBits2, boolean bl, ConfigModeDecoder.ePolarization ePolarization2, ConfigModeDecoder.eFilterMode eFilterMode2) {
            this(n, d, n2, eBits2, bl, ePolarization2, eFilterMode2, 0.88);
        }

        public double getEffectiveBandwidth() {
            if (this.filter == ConfigModeDecoder.eFilterMode.FILTER_TFB) {
                return this.bandWidth * 0.9375;
            }
            return this.bandWidth;
        }

        public double getACAChProfEffectiveBandwidth() {
            if (this.filter == ConfigModeDecoder.eFilterMode.FILTER_TFB) {
                return this.acaChProfBandWidth * 0.9375;
            }
            return this.acaChProfBandWidth;
        }

        public int getEffectiveChannels() {
            if (this.filter == ConfigModeDecoder.eFilterMode.FILTER_TFB) {
                return (int)((double)this.channels * 0.9375);
            }
            return this.channels;
        }

        public int getACAChProfEffectiveChannels() {
            if (this.filter == ConfigModeDecoder.eFilterMode.FILTER_TFB) {
                return (int)((double)this.acaChProfChannels * 0.9375);
            }
            return this.acaChProfChannels;
        }

        public double getResolutionMHz() {
            return this.bandWidth / (double)this.channels;
        }

        public double getACAEfficiency() {
            return this.aca_eff;
        }

        public double getBLEfficiency() {
            return this.bl_eff;
        }
    }
}

