/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.schedblock;

import alma.entity.xmlbinding.schedblock.FrequencySetupT;
import alma.obsprep.bo.annotations.BaseBand;
import alma.obsprep.bo.annotations.BaseBandHolder;
import alma.obsprep.bo.schedblock.BaseBandSpecification;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.data.BaseBandSpecificationData;
import alma.obsprep.bo.schedblock.data.FrequencySetupData;
import alma.valuetypes.Frequency;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Formatter;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;

public class FrequencySetup
extends FrequencySetupData
implements BaseBandHolder {
    private static TreeSet<String> knownNameSet = null;
    private static ArrayList<String> knownNameArray = null;

    public FrequencySetup(FrequencySetupT frequencySetupT) {
        super(frequencySetupT);
        String string = this.getReceiverBand();
        if (string == null || ReceiverBand.getReceiverBand(string) == null) {
            this.setReceiverBand(RECEIVERBAND_ALMA_RB_03);
        }
    }

    protected void initAsNew() {
        super.initAsNew();
        this.setLO1Frequency(Frequency.createFrequencyGHZ(0.0));
        this.setFloog(Frequency.createFrequencyGHZ(0.0));
    }

    public SpectralSpec getSpectralSpec() {
        SpectralSpec spectralSpec = (SpectralSpec)this.getParent();
        return spectralSpec == null ? null : spectralSpec;
    }

    public BaseBandSpecification addNewBaseBandSpecification() {
        return this.addNewBaseBandSpecification(this.getBaseBandSpecificationCount());
    }

    public BaseBandSpecification addNewBaseBandSpecification(int n) {
        BaseBandSpecification baseBandSpecification = BaseBandSpecification.createBaseBandSpecification();
        this.addBaseBandSpecification(n, baseBandSpecification);
        return baseBandSpecification;
    }

    public void addBaseBandSpecification(int n, BaseBandSpecification baseBandSpecification) {
        boolean bl = false;
        String string = baseBandSpecification.getBaseBandName();
        if (string == null) {
            bl = true;
        } else {
            for (BaseBandSpecification baseBandSpecification2 : this.getBaseBandSpecification()) {
                if (!string.equals(baseBandSpecification2.getBaseBandName())) continue;
                bl = true;
                break;
            }
        }
        if (bl) {
            baseBandSpecification.setBaseBandName(this.getOneName());
        }
        super.addBaseBandSpecification(n, baseBandSpecification);
        SpectralSpec spectralSpec = this.getSpectralSpec();
        if (spectralSpec != null) {
            baseBandSpecification.setFrequencySwitching(spectralSpec.getSwitchingType() == SpectralSpec.SWITCHINGTYPE_FREQUENCY_SWITCHING);
        }
    }

    private static TreeSet<String> getKnownNameSet() {
        return knownNameSet;
    }

    private static ArrayList<String> getKnownNameArray() {
        return knownNameArray;
    }

    private String getOneName() {
        int n = this.getBaseBandSpecificationCount();
        if (n == 0) {
            return FrequencySetup.getKnownNameSet().first();
        }
        if (n == FrequencySetup.getKnownNameSet().size()) {
            return null;
        }
        TreeSet<String> treeSet = new TreeSet<String>();
        treeSet.addAll(FrequencySetup.getKnownNameSet());
        for (BaseBandSpecification baseBandSpecification : this.getBaseBandSpecification()) {
            String string = baseBandSpecification.getBaseBandName();
            treeSet.remove(string);
        }
        return (String)treeSet.first();
    }

    public Set<Integer> getUsedBaseBandIndexSet() {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (BaseBandSpecification baseBandSpecification : this.getBaseBandSpecification()) {
            hashSet.add(FrequencySetup.getBaseBandNameIndex(baseBandSpecification.getBaseBandName()));
        }
        return hashSet;
    }

    public static int getBaseBandNameIndex(String string) {
        return FrequencySetup.getKnownNameArray().indexOf(string);
    }

    public String[] getSideBandPreferences() {
        String[] stringArray = new String[SpectralSpec.maxBaseBandCount()];
        for (BaseBandSpecification baseBandSpecification : this.getBaseBandSpecification()) {
            stringArray[baseBandSpecification.getBaseBandIndex()] = baseBandSpecification.getSideBandPreference();
        }
        return stringArray;
    }

    public void setSideBandPreferences(String[] stringArray) {
        int n = 0;
        for (BaseBandSpecification baseBandSpecification : this.getBaseBandSpecification()) {
            String string;
            if (!(BaseBandSpecificationData.SIDEBANDPREFERENCE_NONE.equals(string = stringArray[n++]) || BaseBandSpecificationData.SIDEBANDPREFERENCE_LSB.equals(string) || BaseBandSpecificationData.SIDEBANDPREFERENCE_USB.equals(string))) {
                String string2 = "";
                for (String string3 : stringArray) {
                    string2 = string2 + string3 + ", ";
                }
                throw new IllegalArgumentException("Illegal SideBandPreferences : " + string2);
            }
            baseBandSpecification.setSideBandPreference(string);
        }
    }

    public double[] getWeightingValues() {
        int n;
        double[] dArray = new double[SpectralSpec.maxBaseBandCount()];
        for (n = 0; n < dArray.length; ++n) {
            dArray[n] = 0.0;
        }
        for (n = 0; n < this.getBaseBandSpecificationCount(); ++n) {
            dArray[n] = this.getBaseBandSpecification(n).getWeighting();
        }
        return dArray;
    }

    public void setTransitionName(String string) {
        if (string == null) {
            super.setTransitionName("");
        } else {
            String string2 = string.replaceAll("\\W", "_");
            super.setTransitionName(string2);
        }
    }

    @Override
    public BaseBand[] getBaseBand() {
        return this.getBaseBandSpecification();
    }

    @Override
    public BaseBand getBaseBand(int n) {
        return this.getBaseBandSpecification(n);
    }

    @Override
    public int getBaseBandCount() {
        return this.getBaseBandSpecificationCount();
    }

    @Override
    public void format(Formatter formatter, String string) {
        formatter.format("%s%s@%h%n", string, this.getClass().getSimpleName(), this.hashCode());
        for (BaseBandSpecification baseBandSpecification : this.getBaseBandSpecification()) {
            baseBandSpecification.format(formatter, string + "\t");
        }
    }

    static {
        knownNameArray = new ArrayList<String>(Arrays.asList(BaseBandSpecification.getKnownBaseBandNameList()));
        knownNameSet = new TreeSet();
        knownNameSet.addAll(Arrays.asList(BaseBandSpecification.getKnownBaseBandNameList()));
    }
}

