/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.schedblock;

import alma.entity.xmlbinding.schedblock.ObservingParametersT;
import alma.obsprep.bo.annotations.AddableToSubSBCollection;
import alma.obsprep.bo.annotations.AttachableToTarget;
import alma.obsprep.bo.annotations.BOWithSpecificName;
import alma.obsprep.bo.annotations.ObsUnitSetComponent;
import alma.obsprep.bo.obsproject.ObsUnitSet;
import alma.obsprep.bo.schedblock.AmplitudeCalParameters;
import alma.obsprep.bo.schedblock.AtmosphericCalParameters;
import alma.obsprep.bo.schedblock.BandpassCalParameters;
import alma.obsprep.bo.schedblock.CheckSourceCalParameters;
import alma.obsprep.bo.schedblock.DelayCalParameters;
import alma.obsprep.bo.schedblock.FocusCalParameters;
import alma.obsprep.bo.schedblock.HolographyParameters;
import alma.obsprep.bo.schedblock.OpticalPointingParameters;
import alma.obsprep.bo.schedblock.PhaseCalParameters;
import alma.obsprep.bo.schedblock.PointingCalParameters;
import alma.obsprep.bo.schedblock.PolarizationCalParameters;
import alma.obsprep.bo.schedblock.RadiometricPointingParameters;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.ScienceParameters;
import alma.obsprep.bo.schedblock.SidebandRatioCalParameters;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.bo.schedblock.data.ObservingParametersData;
import alma.obsprep.ot.actions.AddInteractor;
import alma.obsprep.ot.editors.misc.ObservingParametersSummaryTableColumns;
import alma.obsprep.ot.models.misc.SummaryTableColumns;
import alma.obsprep.ot.models.misc.SummaryTableRow;
import java.util.ArrayList;

public abstract class ObservingParameters
extends ObservingParametersData
implements AddableToSubSBCollection,
AttachableToTarget,
BOWithSpecificName,
SummaryTableRow {
    protected SummaryTableColumns summaryTableColumns = new ObservingParametersSummaryTableColumns(this);

    public ObservingParameters(ObservingParametersT observingParametersT) {
        super(observingParametersT);
    }

    public boolean isScienceParameters() {
        return this instanceof ScienceParameters;
    }

    public boolean isCalibratorParameters() {
        boolean bl = this.isPhaseCalParameters() || this.isPointingCalParameters() || this.isCheckSourceCalParameters() || this.isSidebandRatioCalParameters() || this.isAmplitudeCalParameters() || this.isPolarizationCalParameters() || this.isFocusCalParameters() || this.isBandpassCalParameters();
        return bl;
    }

    public boolean isPhaseCalParameters() {
        return this instanceof PhaseCalParameters;
    }

    public boolean isPointingCalParameters() {
        return this instanceof PointingCalParameters;
    }

    public boolean isAmplitudeCalParameters() {
        return this instanceof AmplitudeCalParameters;
    }

    public boolean isPolarizationCalParameters() {
        return this instanceof PolarizationCalParameters;
    }

    public boolean isFocusCalParameters() {
        return this instanceof FocusCalParameters;
    }

    public boolean isAtmosphericCalParameters() {
        return this instanceof AtmosphericCalParameters;
    }

    public boolean isCheckSourceCalParameters() {
        return this instanceof CheckSourceCalParameters;
    }

    public boolean isDelayCalParameters() {
        return this instanceof DelayCalParameters;
    }

    public boolean isSidebandRatioCalParameters() {
        return this instanceof SidebandRatioCalParameters;
    }

    public boolean isBandpassCalParameters() {
        return this instanceof BandpassCalParameters;
    }

    public boolean isOpticalPointingParameters() {
        return this instanceof OpticalPointingParameters;
    }

    public boolean isRadiometricPointingParameters() {
        return this instanceof RadiometricPointingParameters;
    }

    public boolean isHolographyParameters() {
        return this instanceof HolographyParameters;
    }

    public AddInteractor.ObjectType whatType() {
        return null;
    }

    @Override
    public void attachTo(Target target) {
        target.addObservingParameters(this);
    }

    @Override
    public void detachFrom(Target target) {
        target.removeObservingParameters(this);
    }

    @Override
    public Target[] getTargetList() {
        SchedBlock schedBlock = (SchedBlock)this.getParent();
        if (schedBlock == null) {
            return new Target[0];
        }
        ArrayList<Target> arrayList = new ArrayList<Target>();
        for (Target target : schedBlock.getTarget()) {
            for (ObservingParameters observingParameters : target.getObservingParameters()) {
                if (observingParameters != this) continue;
                arrayList.add(target);
            }
        }
        return arrayList.toArray(new Target[arrayList.size()]);
    }

    @Override
    public int getUsedCount() {
        Target[] targetArray = this.getTargetList();
        if (targetArray == null) {
            return 0;
        }
        return targetArray.length;
    }

    @Override
    public ObsUnitSet getContainingObsUnitSet() {
        ObsUnitSetComponent obsUnitSetComponent = (ObsUnitSetComponent)this.getParent();
        return obsUnitSetComponent.getContainingObsUnitSet();
    }

    @Override
    public SummaryTableColumns getSummaryTableColumns() {
        return this.summaryTableColumns;
    }

    public String summaryDescription() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.format("%10s ", this.getName()));
        return stringBuffer.toString();
    }

    public String getSummaryName() {
        String string = this.whatType().toString();
        if (string != null) {
            int n = string.indexOf(32);
            if (n >= 0) {
                string = string.substring(0, n);
            }
        } else {
            string = this.getClass().getSimpleName();
            int n = string.indexOf("Parameters");
            if (n >= 0) {
                string = string.substring(0, n);
            }
        }
        return string;
    }

    public abstract int getSummaryPriority();
}

