/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.schedblock;

import alma.common.calibratorCatalogue.calQueryParameters.types.CalibrationUseType;
import alma.entity.xmlbinding.schedblock.QuerySourceT;
import alma.obsprep.bo.obsproject.IQuerySource;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.data.QuerySourceData;
import alma.valuetypes.Angle;
import alma.valuetypes.Flux;
import alma.valuetypes.Frequency;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.Time;

public class QuerySource
extends QuerySourceData
implements IQuerySource {
    private TargetParameters keyTargetParameters;

    public QuerySource(QuerySourceT querySourceT) {
        super(querySourceT);
    }

    protected void initAsNew() {
        super.initAsNew();
        this.setUse(CalibrationUseType.UNDEFINED.toString());
        this.setMinFrequency(Frequency.createFrequencyGHZ(0.0));
        this.setMaxFrequency(Frequency.createFrequencyGHZ(0.0));
        this.setMinFlux(Flux.createFlux((double)0.0, (String)Flux.UNIT_JY));
        this.setMaxFlux(Flux.createFlux((double)0.0, (String)Flux.UNIT_JY));
        this.setMinTimeSinceObserved(Time.createTime((double)0.0, (String)Time.UNIT_D));
        this.setMaxTimeSinceObserved(Time.createTime((double)0.0, (String)Time.UNIT_D));
    }

    public void setSearchFrequenciesFromSB(SchedBlock schedBlock) {
        SpectralSpec[] spectralSpecArray = schedBlock.getSpectralSpec();
        if (spectralSpecArray.length > 0) {
            SpectralSpec spectralSpec = spectralSpecArray[0];
            ReceiverBand receiverBand = spectralSpec.getReceiverBand();
            double d = receiverBand.getRFMin();
            double d2 = receiverBand.getRFMax();
            this.setMinFrequency(Frequency.createFrequencyGHZ(d));
            this.setMaxFrequency(Frequency.createFrequencyGHZ(d2));
        }
    }

    public static QuerySource createQuerySource(alma.obsprep.bo.obsproject.QuerySource querySource) {
        QuerySource querySource2 = QuerySource.createQuerySource();
        Object object = querySource.gettrueMaxFlux();
        if (object != null) {
            querySource2.setMaxFlux((Flux)((Object)object));
        }
        if ((object = querySource.gettrueMaxFrequency()) != null) {
            querySource2.setMaxFrequency((Frequency)((Object)object));
        }
        if ((object = querySource.gettrueMaxTimeSinceObserved()) != null) {
            querySource2.setMaxTimeSinceObserved((Time)object);
        }
        if ((object = querySource.gettrueMinFlux()) != null) {
            querySource2.setMinFlux((Flux)((Object)object));
        }
        if ((object = querySource.gettrueMinFrequency()) != null) {
            querySource2.setMinFrequency((Frequency)((Object)object));
        }
        if ((object = querySource.gettrueMinTimeSinceObserved()) != null) {
            querySource2.setMinTimeSinceObserved((Time)object);
        }
        if ((object = querySource.gettrueQueryCenter()) != null) {
            querySource2.setQueryCenter((SkyCoordinates)object);
        }
        if ((object = querySource.gettrueSearchRadius()) != null) {
            querySource2.setSearchRadius((Angle)((Object)object));
        }
        if ((object = querySource.getKeyTargetParameters()) != null) {
            querySource2.setKeyTargetParameters((TargetParameters)object);
        }
        querySource2.setMaxSources(querySource.getMaxSources());
        String string = querySource.gettrueUse();
        if (string != null) {
            querySource2.setUse(string);
        }
        return querySource2;
    }

    public void setKeyTargetParameters(TargetParameters targetParameters) {
        this.keyTargetParameters = targetParameters;
    }

    public TargetParameters getKeyTargetParameters() {
        return this.keyTargetParameters;
    }
}

