/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.schedblock;

import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;

public class Range {
    private double minimum;
    private double maximum;
    private double range;

    public Range(double d, double d2) {
        this.minimum = d;
        this.maximum = d2;
        this.range = d2 - d;
    }

    public double max() {
        return this.maximum;
    }

    public double min() {
        return this.minimum;
    }

    public double range() {
        return this.range;
    }

    public double mid() {
        return (this.minimum + this.maximum) / 2.0;
    }

    public Range minus(double d) {
        return new Range(this.minimum - d, this.maximum - d);
    }

    public Range plus(double d) {
        return new Range(this.minimum + d, this.maximum + d);
    }

    public String toString() {
        return "[ " + this.minimum + " : " + this.maximum + " ]";
    }

    public boolean inRange(double d) {
        return this.min() <= d && d <= this.max();
    }

    public double clip(double d) {
        double d2 = d;
        if (d < this.min()) {
            d = this.min();
        }
        if (d > this.max()) {
            d = this.max();
        }
        return d;
    }

    public double normalise(double d) {
        while (d < this.min()) {
            d += this.range();
        }
        while (d > this.max()) {
            d -= this.range();
        }
        return d;
    }

    public boolean intersects(Range range) {
        if (this.max() < range.min()) {
            return false;
        }
        return !(range.max() < this.min());
    }

    public Range intersection(Range range) {
        if (this.intersects(range)) {
            return new Range(Math.max(this.min(), range.min()), Math.min(this.max(), range.max()));
        }
        return null;
    }

    public boolean contains(Range range) {
        if (this.max() < range.max()) {
            return false;
        }
        return !(this.min() > range.min());
    }

    public static List<Integer> partition(List<Range> list) {
        int n;
        int n2 = list.size();
        Vector<Integer> vector = new Vector<Integer>();
        if (n2 == 0) {
            return vector;
        }
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        for (n = 0; n < n2; ++n) {
            treeSet.add(n);
        }
        vector.add(0);
        for (n = 1; n < n2; ++n) {
            TreeSet<Integer> treeSet2 = new TreeSet<Integer>();
            treeSet2.addAll(treeSet);
            for (int i = 0; i < n; ++i) {
                if (!list.get(i).intersects(list.get(n))) continue;
                treeSet2.remove(vector.get(i));
            }
            vector.add((Integer)treeSet2.first());
        }
        return vector;
    }

    public static List<Integer> partitionCollections(List<Collection<Range>> list) {
        int n;
        int n2 = list.size();
        Vector<Integer> vector = new Vector<Integer>();
        if (n2 == 0) {
            return vector;
        }
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        for (n = 0; n < n2; ++n) {
            treeSet.add(n);
        }
        vector.add(0);
        for (n = 1; n < n2; ++n) {
            TreeSet<Integer> treeSet2 = new TreeSet<Integer>();
            treeSet2.addAll(treeSet);
            Collection<Range> collection = list.get(n);
            for (int i = 0; i < n; ++i) {
                Collection<Range> collection2 = list.get(i);
                if (!Range.overlap(collection2, collection)) continue;
                treeSet2.remove(vector.get(i));
            }
            vector.add((Integer)treeSet2.first());
        }
        return vector;
    }

    private static boolean overlap(Collection<Range> collection, Collection<Range> collection2) {
        for (Range range : collection) {
            for (Range range2 : collection2) {
                if (!range.intersects(range2)) continue;
                return true;
            }
        }
        return false;
    }
}

