/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.schedblock;

import alma.entity.xmlbinding.obsproject.types.ControlBlockTArrayRequestedType;
import alma.entity.xmlbinding.schedblock.SchedBlockRefT;
import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.bo.Copier;
import alma.hla.runtime.obsprep.bo.CopyException;
import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.annotations.ObsUnitSetComponent;
import alma.obsprep.bo.obsproject.AbstractScienceGoal;
import alma.obsprep.bo.obsproject.ControlBlock;
import alma.obsprep.bo.obsproject.ObsUnitControl;
import alma.obsprep.bo.obsproject.ObsUnitSet;
import alma.obsprep.bo.obsproject.Preconditions;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.UnitDependencies;
import alma.obsprep.bo.schedblock.AbstractInstrumentSpec;
import alma.obsprep.bo.schedblock.AmplitudeCalParameters;
import alma.obsprep.bo.schedblock.AtmosphericCalParameters;
import alma.obsprep.bo.schedblock.BandpassCalParameters;
import alma.obsprep.bo.schedblock.CheckSourceCalParameters;
import alma.obsprep.bo.schedblock.DelayCalParameters;
import alma.obsprep.bo.schedblock.FieldSource;
import alma.obsprep.bo.schedblock.FocusCalParameters;
import alma.obsprep.bo.schedblock.HolographyParameters;
import alma.obsprep.bo.schedblock.ObsProcedure;
import alma.obsprep.bo.schedblock.ObservingGroup;
import alma.obsprep.bo.schedblock.ObservingParameters;
import alma.obsprep.bo.schedblock.OpticalCameraSpec;
import alma.obsprep.bo.schedblock.OpticalPointingParameters;
import alma.obsprep.bo.schedblock.OrderedTarget;
import alma.obsprep.bo.schedblock.PhaseCalParameters;
import alma.obsprep.bo.schedblock.PointingCalParameters;
import alma.obsprep.bo.schedblock.PolarizationCalParameters;
import alma.obsprep.bo.schedblock.RadiometricPointingParameters;
import alma.obsprep.bo.schedblock.ReservationParameters;
import alma.obsprep.bo.schedblock.SchedBlockControl;
import alma.obsprep.bo.schedblock.SchedulingConstraints;
import alma.obsprep.bo.schedblock.ScienceParameters;
import alma.obsprep.bo.schedblock.SidebandRatioCalParameters;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.bo.schedblock.TemporalConstraints;
import alma.obsprep.bo.schedblock.data.SchedBlockData;
import alma.obsprep.ot.actions.AddInteractor;
import alma.obsprep.services.generator.refactored.ObsType;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGenerationContext;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGeneratorTemplate;
import alma.obsprep.util.GUIUtilities;
import alma.valuetypes.KeywordValue;
import alma.valuetypes.Time;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;

public class SchedBlock
extends SchedBlockData
implements ObsUnitSetComponent {
    public static final String NODE_LABEL_BL = "[12m Array SB]";
    public static final String NODE_LABEL_ACA = "[ACA SB]";
    public static final String NODE_LABEL_12m = "[12m Array SB]";
    public static final String NODE_LABEL_12m_COMPACT = "[12m Compact Array SB]";
    public static final String NODE_LABEL_7m = "[7m Array SB]";
    public static final String NODE_LABEL_TP = "[TP Array SB]";
    private SBGenerationContext sbGenerationContext;
    public static final Set<String> DELETABLE_STATES = new HashSet<String>();
    private static final Set<String> RENAMEABLE_STATES;

    public SchedBlock(alma.entity.xmlbinding.schedblock.SchedBlock schedBlock) {
        super(schedBlock);
    }

    public synchronized SchedBlock deepCopy() throws CopyException {
        SchedBlock schedBlock = super.deepCopy();
        if (this.sbGenerationContext != null) {
            schedBlock.sbGenerationContext = this.sbGenerationContext.deepCopy();
        }
        List<Target> list = schedBlock.getAllTargets(ScienceParameters.scienceParametersFilter);
        List<Target> list2 = this.getAllTargets(ScienceParameters.scienceParametersFilter);
        for (int i = 0; i < list2.size(); ++i) {
            ScienceParameters scienceParameters;
            Target target = list2.get(i);
            Target target2 = list.get(i);
            try {
                scienceParameters = target.getFirstScienceParameters().orElseThrow(Target.UnableToFindScienceParametersException);
            }
            catch (Exception exception) {
                throw new CopyException("Unable to copy schedblock: cannot find science parameters");
            }
            if (scienceParameters.getTPRasterData().isPresent()) {
                ScienceParameters scienceParameters2;
                try {
                    scienceParameters2 = target2.getFirstScienceParameters().orElseThrow(Target.UnableToFindScienceParametersException);
                }
                catch (Exception exception) {
                    throw new CopyException("Unable to copy schedblock: cannot find science parameters");
                }
                scienceParameters2.setTPRasterData(scienceParameters.getTPRasterData().get().deepCopy());
            }
            target2.getFieldSource().setTargetParameters(target.getFieldSource().getTargetParameters());
        }
        return schedBlock;
    }

    protected void initAsNew() {
        super.initAsNew();
        this.setName("SchedBlock");
        this.setObsProcedure(ObsProcedure.createObsProcedure());
        this.setObsUnitControl(ObsUnitControl.createObsUnitControl());
        this.setPreconditions(Preconditions.createPreconditions());
        this.setSchedBlockControl(SchedBlockControl.createSchedBlockControl());
        this.setSchedulingConstraints(SchedulingConstraints.createSchedulingConstraints());
        this.setModeName("Expert Mode");
        this.setModeType(MODETYPE_EXPERT);
        this.setStandardMode(false);
        this.setUnitDependencies(UnitDependencies.createUnitDependencies());
    }

    protected void initEntityReferencesFrom(IBusinessObject iBusinessObject, Copier copier) throws CopyException {
        super.initEntityReferencesFrom(iBusinessObject, copier);
        this.setSBStatus(null);
        this.setStatus(STATUS_NEWPHASE2);
    }

    void setEntityID(String string) {
        alma.entity.xmlbinding.schedblock.SchedBlock schedBlock = this.getCastorObject();
        schedBlock.getSchedBlockEntity().setEntityId(string);
    }

    public String briefDescription() {
        StringBuffer stringBuffer = new StringBuffer(this.getNameOrDefault());
        String string = this.getObsUnitControl().getArrayRequested();
        if (ObsUnitControl.ARRAYREQUESTED_TWELVE_M.equals(string)) {
            stringBuffer.append("[12m Array SB]");
        } else if (ObsUnitControl.ARRAYREQUESTED_SEVEN_M.equals(string)) {
            stringBuffer.append(NODE_LABEL_7m);
        } else if (ObsUnitControl.ARRAYREQUESTED_ACA.equals(string)) {
            stringBuffer.append(NODE_LABEL_ACA);
        } else if (ObsUnitControl.ARRAYREQUESTED_TP_ARRAY.equals(string)) {
            stringBuffer.append(NODE_LABEL_TP);
        }
        return stringBuffer.toString();
    }

    public String toTreeString(int n, boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toTreeString(n, bl, bl2));
        String string = this.getObsUnitControl().getArrayRequested();
        if (ObsUnitControl.ARRAYREQUESTED_TWELVE_M.equals(string)) {
            stringBuffer.append("[12m Array SB]");
        } else if (ObsUnitControl.ARRAYREQUESTED_SEVEN_M.equals(string)) {
            stringBuffer.append(NODE_LABEL_7m);
        } else if (ObsUnitControl.ARRAYREQUESTED_ACA.equals(string)) {
            stringBuffer.append(NODE_LABEL_ACA);
        } else if (ObsUnitControl.ARRAYREQUESTED_TP_ARRAY.equals(string)) {
            stringBuffer.append(NODE_LABEL_TP);
        }
        return stringBuffer.toString();
    }

    public boolean contains(Target target) {
        for (Target target2 : this.getTarget()) {
            if (!target2.equals(target)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(SpectralSpec spectralSpec) {
        for (SpectralSpec spectralSpec2 : this.getSpectralSpec()) {
            if (!spectralSpec2.equals(spectralSpec)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(ObservingParameters observingParameters) {
        for (ObservingParameters observingParameters2 : this.getObservingParameters()) {
            if (!observingParameters2.equals(observingParameters)) continue;
            return true;
        }
        return false;
    }

    public boolean isForBL() {
        return this.getObsUnitControl().getArrayRequested() == ControlBlock.ARRAYREQUESTED_TWELVE_M;
    }

    public boolean isForACA() {
        return !this.isForBL();
    }

    public Target createTarget() {
        Target target = Target.createTarget();
        this.addTarget(target);
        return target;
    }

    public ObservingGroup createObservingGroup() {
        ObservingGroup observingGroup = ObservingGroup.createObservingGroup();
        this.addObservingGroup(observingGroup);
        int n = this.getObservingGroupCount();
        observingGroup.setIndex(n++);
        observingGroup.updateName();
        return observingGroup;
    }

    public TemporalConstraints createTemporalConstraints() {
        TemporalConstraints temporalConstraints = TemporalConstraints.createTemporalConstraints();
        this.addTemporalConstraints(temporalConstraints);
        return temporalConstraints;
    }

    public FieldSource createFieldSource() {
        FieldSource fieldSource = FieldSource.createFieldSource();
        this.addFieldSource(fieldSource);
        return fieldSource;
    }

    public SpectralSpec createSpectralSpec() {
        if (this.hasACASpectralSpec()) {
            return this.createSpectralSpecWithACACorrelatorConfiguration();
        }
        if (this.hasBLSpectralSpec()) {
            return this.createSpectralSpecWithBLCorrelatorConfiguration();
        }
        if (this.isForBL()) {
            return this.createSpectralSpecWithBLCorrelatorConfiguration();
        }
        return this.createSpectralSpecWithACACorrelatorConfiguration();
    }

    public SpectralSpec createSpectralSpecWithBLCorrelatorConfiguration() {
        SpectralSpec spectralSpec = SpectralSpec.createSpectralSpecWithBLCorrelatorConfiguration();
        this.addSpectralSpec(spectralSpec);
        return spectralSpec;
    }

    public SpectralSpec createSpectralSpecWithACACorrelatorConfiguration() {
        SpectralSpec spectralSpec = SpectralSpec.createSpectralSpecWithACACorrelatorConfiguration();
        this.addSpectralSpec(spectralSpec);
        return spectralSpec;
    }

    public SpectralSpec addNewACASpectralSpec() {
        if (this.hasBLSpectralSpec()) {
            this.mixedCorrWarning();
            return null;
        }
        SpectralSpec spectralSpec = SpectralSpec.createSpectralSpecWithACACorrelatorConfiguration();
        super.addSpectralSpec(spectralSpec);
        return spectralSpec;
    }

    public SpectralSpec addNewBLSpectralSpec() {
        if (this.hasACASpectralSpec()) {
            this.mixedCorrWarning();
            return null;
        }
        SpectralSpec spectralSpec = SpectralSpec.createSpectralSpecWithBLCorrelatorConfiguration();
        super.addSpectralSpec(spectralSpec);
        return spectralSpec;
    }

    public SpectralSpec addNewSLDSpectralSpec() {
        SpectralSpec spectralSpec = SpectralSpec.createSpectralSpecWithSquareLawSetup();
        super.addSpectralSpec(spectralSpec);
        return spectralSpec;
    }

    public List<Target> getScienceTargets() {
        ArrayList<Target> arrayList = new ArrayList<Target>();
        for (Target target : this.getTarget()) {
            if (!target.hasScienceParameters()) continue;
            arrayList.add(target);
        }
        return arrayList;
    }

    private void mixedCorrWarning() {
        GUIUtilities.warning(null, "Mixing 12mArray and ACA spectral specs in an SB is not allowed.");
        Log.logger((Object)this).warning("Mixing 12mArray and ACA spectral specs in an SB is not allowed.");
    }

    public void addSpectralSpec(SpectralSpec spectralSpec) {
        if (spectralSpec.isACASpectralSpec() && this.hasBLSpectralSpec() || spectralSpec.isBLSpectralSpec() && this.hasACASpectralSpec()) {
            this.mixedCorrWarning();
            return;
        }
        super.addSpectralSpec(spectralSpec);
    }

    public OpticalCameraSpec createOpticalCameraSpec() {
        OpticalCameraSpec opticalCameraSpec = OpticalCameraSpec.createOpticalCameraSpec();
        this.addOpticalCameraSpec(opticalCameraSpec);
        return opticalCameraSpec;
    }

    public ScienceParameters createScienceParameters() {
        ScienceParameters scienceParameters = ScienceParameters.createScienceParameters();
        this.addObservingParameters((ObservingParameters)((Object)scienceParameters));
        return scienceParameters;
    }

    public PhaseCalParameters createPhaseCalParameters() {
        PhaseCalParameters phaseCalParameters = PhaseCalParameters.createPhaseCalParameters();
        this.addObservingParameters((ObservingParameters)((Object)phaseCalParameters));
        return phaseCalParameters;
    }

    public PointingCalParameters createPointingCalParameters() {
        PointingCalParameters pointingCalParameters = PointingCalParameters.createPointingCalParameters();
        this.addObservingParameters((ObservingParameters)((Object)pointingCalParameters));
        return pointingCalParameters;
    }

    public AmplitudeCalParameters createAmplitudeCalParameters() {
        AmplitudeCalParameters amplitudeCalParameters = AmplitudeCalParameters.createAmplitudeCalParameters();
        this.addObservingParameters((ObservingParameters)((Object)amplitudeCalParameters));
        return amplitudeCalParameters;
    }

    public PolarizationCalParameters createPolarizationCalParameters() {
        PolarizationCalParameters polarizationCalParameters = PolarizationCalParameters.createPolarizationCalParameters();
        this.addObservingParameters((ObservingParameters)((Object)polarizationCalParameters));
        return polarizationCalParameters;
    }

    public FocusCalParameters createFocusCalParameters() {
        FocusCalParameters focusCalParameters = FocusCalParameters.createFocusCalParameters();
        this.addObservingParameters((ObservingParameters)((Object)focusCalParameters));
        return focusCalParameters;
    }

    public AtmosphericCalParameters createAtmosphericCalParameters() {
        AtmosphericCalParameters atmosphericCalParameters = AtmosphericCalParameters.createAtmosphericCalParameters();
        this.addObservingParameters((ObservingParameters)((Object)atmosphericCalParameters));
        return atmosphericCalParameters;
    }

    public DelayCalParameters createDelayCalParameters() {
        DelayCalParameters delayCalParameters = DelayCalParameters.createDelayCalParameters();
        this.addObservingParameters((ObservingParameters)((Object)delayCalParameters));
        return delayCalParameters;
    }

    public CheckSourceCalParameters createCheckSourceCalParameters() {
        CheckSourceCalParameters checkSourceCalParameters = CheckSourceCalParameters.createCheckSourceCalParameters();
        this.addObservingParameters((ObservingParameters)((Object)checkSourceCalParameters));
        return checkSourceCalParameters;
    }

    public SidebandRatioCalParameters createSidebandRatioCalParameters() {
        SidebandRatioCalParameters sidebandRatioCalParameters = SidebandRatioCalParameters.createSidebandRatioCalParameters();
        this.addObservingParameters((ObservingParameters)((Object)sidebandRatioCalParameters));
        return sidebandRatioCalParameters;
    }

    public BandpassCalParameters createBandpassCalParameters() {
        BandpassCalParameters bandpassCalParameters = BandpassCalParameters.createBandpassCalParameters();
        this.addObservingParameters((ObservingParameters)((Object)bandpassCalParameters));
        return bandpassCalParameters;
    }

    public OpticalPointingParameters createOpticalPointingParameters() {
        OpticalPointingParameters opticalPointingParameters = OpticalPointingParameters.createOpticalPointingParameters();
        this.addObservingParameters((ObservingParameters)((Object)opticalPointingParameters));
        return opticalPointingParameters;
    }

    public RadiometricPointingParameters createRadiometricPointingParameters() {
        RadiometricPointingParameters radiometricPointingParameters = RadiometricPointingParameters.createRadiometricPointingParameters();
        this.addObservingParameters((ObservingParameters)((Object)radiometricPointingParameters));
        return radiometricPointingParameters;
    }

    public HolographyParameters createHolographyParameters() {
        HolographyParameters holographyParameters = HolographyParameters.createHolographyParameters();
        this.addObservingParameters((ObservingParameters)((Object)holographyParameters));
        return holographyParameters;
    }

    public ReservationParameters createReservationParameters() {
        ReservationParameters reservationParameters = ReservationParameters.createReservationParameters();
        this.addObservingParameters((ObservingParameters)((Object)reservationParameters));
        return reservationParameters;
    }

    public ObservingParameters createObservingParameters(AddInteractor.ObjectType objectType) {
        if (objectType == AddInteractor.ObjectType.SCIENCEPARAMETERS) {
            return this.createScienceParameters();
        }
        if (objectType == AddInteractor.ObjectType.PHASECALPARAMETERS) {
            return this.createPhaseCalParameters();
        }
        if (objectType == AddInteractor.ObjectType.POINTINGCALPARAMETERS) {
            return this.createPointingCalParameters();
        }
        if (objectType == AddInteractor.ObjectType.AMPLITUDECALPARAMETERS) {
            return this.createAmplitudeCalParameters();
        }
        if (objectType == AddInteractor.ObjectType.POLARIZATIONCALPARAMETERS) {
            return this.createPolarizationCalParameters();
        }
        if (objectType == AddInteractor.ObjectType.FOCUSCALPARAMETERS) {
            return this.createFocusCalParameters();
        }
        if (objectType == AddInteractor.ObjectType.DELAYCALPARAMETERS) {
            return this.createDelayCalParameters();
        }
        if (objectType == AddInteractor.ObjectType.CHECKSOURCECALPARAMETERS) {
            return this.createCheckSourceCalParameters();
        }
        if (objectType == AddInteractor.ObjectType.SIDEBANDRATIOCALPARAMETERS) {
            return this.createSidebandRatioCalParameters();
        }
        if (objectType == AddInteractor.ObjectType.ATMOSPHERICCALPARAMETERS) {
            return this.createAtmosphericCalParameters();
        }
        if (objectType == AddInteractor.ObjectType.BANDPASSCALPARAMETERS) {
            return this.createBandpassCalParameters();
        }
        if (objectType == AddInteractor.ObjectType.OPTICALPOINTINGPARAMETERS) {
            return this.createOpticalPointingParameters();
        }
        if (objectType == AddInteractor.ObjectType.RADIOMETRICPOINTINGPARAMETERS) {
            return this.createRadiometricPointingParameters();
        }
        if (objectType == AddInteractor.ObjectType.HOLOGRAPHYPARAMETERS) {
            return this.createHolographyParameters();
        }
        return null;
    }

    public ObservingParameters[] getObservingParameters(AddInteractor.ObjectType objectType) {
        if (objectType == AddInteractor.ObjectType.SCIENCEPARAMETERS) {
            return this.getObservingParametersScienceParameters();
        }
        if (objectType == AddInteractor.ObjectType.PHASECALPARAMETERS) {
            return this.getObservingParametersPhaseCalParameters();
        }
        if (objectType == AddInteractor.ObjectType.POINTINGCALPARAMETERS) {
            return this.getObservingParametersPointingCalParameters();
        }
        if (objectType == AddInteractor.ObjectType.AMPLITUDECALPARAMETERS) {
            return this.getObservingParametersAmplitudeCalParameters();
        }
        if (objectType == AddInteractor.ObjectType.POLARIZATIONCALPARAMETERS) {
            return this.getObservingParametersPolarizationCalParameters();
        }
        if (objectType == AddInteractor.ObjectType.FOCUSCALPARAMETERS) {
            return this.getObservingParametersFocusCalParameters();
        }
        if (objectType == AddInteractor.ObjectType.DELAYCALPARAMETERS) {
            return this.getObservingParametersDelayCalParameters();
        }
        if (objectType == AddInteractor.ObjectType.CHECKSOURCECALPARAMETERS) {
            return this.getObservingParametersCheckSourceCalParameters();
        }
        if (objectType == AddInteractor.ObjectType.SIDEBANDRATIOCALPARAMETERS) {
            return this.getObservingParametersSidebandRatioCalParameters();
        }
        if (objectType == AddInteractor.ObjectType.ATMOSPHERICCALPARAMETERS) {
            return this.getObservingParametersAtmosphericCalParameters();
        }
        if (objectType == AddInteractor.ObjectType.BANDPASSCALPARAMETERS) {
            return this.getObservingParametersBandpassCalParameters();
        }
        if (objectType == AddInteractor.ObjectType.OPTICALPOINTINGPARAMETERS) {
            return this.getObservingParametersOpticalPointingParameters();
        }
        if (objectType == AddInteractor.ObjectType.RADIOMETRICPOINTINGPARAMETERS) {
            return this.getObservingParametersRadiometricPointingParameters();
        }
        if (objectType == AddInteractor.ObjectType.HOLOGRAPHYPARAMETERS) {
            return this.getObservingParametersHolographyParameters();
        }
        return new ObservingParameters[0];
    }

    public int getObservingParametersCount(AddInteractor.ObjectType objectType) {
        if (objectType == AddInteractor.ObjectType.SCIENCEPARAMETERS) {
            return this.getObservingParametersScienceParametersCount();
        }
        if (objectType == AddInteractor.ObjectType.PHASECALPARAMETERS) {
            return this.getObservingParametersPhaseCalParametersCount();
        }
        if (objectType == AddInteractor.ObjectType.POINTINGCALPARAMETERS) {
            return this.getObservingParametersPointingCalParametersCount();
        }
        if (objectType == AddInteractor.ObjectType.AMPLITUDECALPARAMETERS) {
            return this.getObservingParametersAmplitudeCalParametersCount();
        }
        if (objectType == AddInteractor.ObjectType.POLARIZATIONCALPARAMETERS) {
            return this.getObservingParametersPolarizationCalParametersCount();
        }
        if (objectType == AddInteractor.ObjectType.FOCUSCALPARAMETERS) {
            return this.getObservingParametersFocusCalParametersCount();
        }
        if (objectType == AddInteractor.ObjectType.DELAYCALPARAMETERS) {
            return this.getObservingParametersDelayCalParametersCount();
        }
        if (objectType == AddInteractor.ObjectType.CHECKSOURCECALPARAMETERS) {
            return this.getObservingParametersCheckSourceCalParametersCount();
        }
        if (objectType == AddInteractor.ObjectType.SIDEBANDRATIOCALPARAMETERS) {
            return this.getObservingParametersSidebandRatioCalParametersCount();
        }
        if (objectType == AddInteractor.ObjectType.ATMOSPHERICCALPARAMETERS) {
            return this.getObservingParametersAtmosphericCalParametersCount();
        }
        if (objectType == AddInteractor.ObjectType.BANDPASSCALPARAMETERS) {
            return this.getObservingParametersBandpassCalParametersCount();
        }
        if (objectType == AddInteractor.ObjectType.OPTICALPOINTINGPARAMETERS) {
            return this.getObservingParametersOpticalPointingParametersCount();
        }
        if (objectType == AddInteractor.ObjectType.RADIOMETRICPOINTINGPARAMETERS) {
            return this.getObservingParametersRadiometricPointingParametersCount();
        }
        if (objectType == AddInteractor.ObjectType.HOLOGRAPHYPARAMETERS) {
            return this.getObservingParametersHolographyParametersCount();
        }
        return 0;
    }

    public List<KeywordValue> getExpertParameterList() {
        ArrayList<KeywordValue> arrayList = new ArrayList<KeywordValue>();
        for (int i = 0; i < this.getExpertParameterCount(); ++i) {
            arrayList.add(this.getExpertParameter(i));
        }
        return arrayList;
    }

    public Target findTargetById(String string) {
        for (int i = 0; i < this.getTargetCount(); ++i) {
            Target target = this.getTarget(i);
            if (!target.getEntityPartId().equals(string)) continue;
            return target;
        }
        return null;
    }

    public FieldSource findFieldSource(String string) {
        for (int i = 0; i < this.getFieldSourceCount(); ++i) {
            FieldSource fieldSource = this.getFieldSource(i);
            if (!fieldSource.getEntityPartId().equals(string)) continue;
            return fieldSource;
        }
        return null;
    }

    public SpectralSpec findSpectralSpec(String string) {
        for (int i = 0; i < this.getSpectralSpecCount(); ++i) {
            SpectralSpec spectralSpec = this.getSpectralSpec(i);
            if (!spectralSpec.getEntityPartId().equals(string)) continue;
            return spectralSpec;
        }
        return null;
    }

    public OpticalCameraSpec findOpticalCameraSpec(String string) {
        for (int i = 0; i < this.getOpticalCameraSpecCount(); ++i) {
            OpticalCameraSpec opticalCameraSpec = this.getOpticalCameraSpec(i);
            if (!opticalCameraSpec.getEntityPartId().equals(string)) continue;
            return opticalCameraSpec;
        }
        return null;
    }

    public AbstractInstrumentSpec findInstrumentSpec(String string) {
        Object object = this.findSpectralSpec(string);
        if (object != null) {
            return object;
        }
        object = this.findOpticalCameraSpec(string);
        if (object != null) {
            return object;
        }
        return null;
    }

    public ObservingParameters findObservingParameters(String string) {
        for (ObservingParameters observingParameters : this.getObservingParameters()) {
            if (!observingParameters.getEntityPartId().equals(string)) continue;
            return observingParameters;
        }
        return null;
    }

    public ScienceParameters findObservingParametersScienceParameters(String string) {
        ScienceParameters scienceParameters = null;
        ObservingParameters observingParameters = this.findObservingParameters(string);
        if (observingParameters != null && observingParameters.isScienceParameters()) {
            scienceParameters = (ScienceParameters)((Object)observingParameters);
        }
        return scienceParameters;
    }

    public PhaseCalParameters findObservingParametersPhaseCalParameters(String string) {
        PhaseCalParameters phaseCalParameters = null;
        ObservingParameters observingParameters = this.findObservingParameters(string);
        if (observingParameters != null && observingParameters.isPhaseCalParameters()) {
            phaseCalParameters = (PhaseCalParameters)((Object)observingParameters);
        }
        return phaseCalParameters;
    }

    public AmplitudeCalParameters findObservingParametersAmplitudeCalParameters(String string) {
        AmplitudeCalParameters amplitudeCalParameters = null;
        ObservingParameters observingParameters = this.findObservingParameters(string);
        if (observingParameters != null && observingParameters.isAmplitudeCalParameters()) {
            amplitudeCalParameters = (AmplitudeCalParameters)((Object)observingParameters);
        }
        return amplitudeCalParameters;
    }

    public AtmosphericCalParameters findObservingParametersAtmosphericCalParameters(String string) {
        AtmosphericCalParameters atmosphericCalParameters = null;
        ObservingParameters observingParameters = this.findObservingParameters(string);
        if (observingParameters != null && observingParameters.isAtmosphericCalParameters()) {
            atmosphericCalParameters = (AtmosphericCalParameters)((Object)observingParameters);
        }
        return atmosphericCalParameters;
    }

    public DelayCalParameters findObservingParametersDelayCalParameters(String string) {
        DelayCalParameters delayCalParameters = null;
        ObservingParameters observingParameters = this.findObservingParameters(string);
        if (observingParameters != null && observingParameters.isDelayCalParameters()) {
            delayCalParameters = (DelayCalParameters)((Object)observingParameters);
        }
        return delayCalParameters;
    }

    public CheckSourceCalParameters findObservingParametersCheckSourceCalParameters(String string) {
        CheckSourceCalParameters checkSourceCalParameters = null;
        ObservingParameters observingParameters = this.findObservingParameters(string);
        if (observingParameters != null && observingParameters.isCheckSourceCalParameters()) {
            checkSourceCalParameters = (CheckSourceCalParameters)((Object)observingParameters);
        }
        return checkSourceCalParameters;
    }

    public SidebandRatioCalParameters findObservingParametersSidebandRatioCalParameters(String string) {
        SidebandRatioCalParameters sidebandRatioCalParameters = null;
        ObservingParameters observingParameters = this.findObservingParameters(string);
        if (observingParameters != null && observingParameters.isSidebandRatioCalParameters()) {
            sidebandRatioCalParameters = (SidebandRatioCalParameters)((Object)observingParameters);
        }
        return sidebandRatioCalParameters;
    }

    public PointingCalParameters findObservingParametersPointingCalParameters(String string) {
        PointingCalParameters pointingCalParameters = null;
        ObservingParameters observingParameters = this.findObservingParameters(string);
        if (observingParameters != null && observingParameters.isPointingCalParameters()) {
            pointingCalParameters = (PointingCalParameters)((Object)observingParameters);
        }
        return pointingCalParameters;
    }

    public PolarizationCalParameters findObservingParametersPolarizationCalParameters(String string) {
        PolarizationCalParameters polarizationCalParameters = null;
        ObservingParameters observingParameters = this.findObservingParameters(string);
        if (observingParameters != null && observingParameters.isPolarizationCalParameters()) {
            polarizationCalParameters = (PolarizationCalParameters)((Object)observingParameters);
        }
        return polarizationCalParameters;
    }

    public FocusCalParameters findObservingParametersFocusCalParameters(String string) {
        FocusCalParameters focusCalParameters = null;
        ObservingParameters observingParameters = this.findObservingParameters(string);
        if (observingParameters != null && observingParameters.isFocusCalParameters()) {
            focusCalParameters = (FocusCalParameters)((Object)observingParameters);
        }
        return focusCalParameters;
    }

    public BandpassCalParameters findObservingParametersBandpassCalParameters(String string) {
        BandpassCalParameters bandpassCalParameters = null;
        ObservingParameters observingParameters = this.findObservingParameters(string);
        if (observingParameters != null && observingParameters.isBandpassCalParameters()) {
            bandpassCalParameters = (BandpassCalParameters)((Object)observingParameters);
        }
        return bandpassCalParameters;
    }

    public OpticalPointingParameters findObservingParametersOpticalPointingParameters(String string) {
        OpticalPointingParameters opticalPointingParameters = null;
        ObservingParameters observingParameters = this.findObservingParameters(string);
        if (observingParameters != null && observingParameters.isOpticalPointingParameters()) {
            opticalPointingParameters = (OpticalPointingParameters)((Object)observingParameters);
        }
        return opticalPointingParameters;
    }

    public RadiometricPointingParameters findObservingParametersRadiometricPointingParameters(String string) {
        RadiometricPointingParameters radiometricPointingParameters = null;
        ObservingParameters observingParameters = this.findObservingParameters(string);
        if (observingParameters != null && observingParameters.isRadiometricPointingParameters()) {
            radiometricPointingParameters = (RadiometricPointingParameters)((Object)observingParameters);
        }
        return radiometricPointingParameters;
    }

    public HolographyParameters findObservingParametersHolographyParameters(String string) {
        HolographyParameters holographyParameters = null;
        ObservingParameters observingParameters = this.findObservingParameters(string);
        if (observingParameters != null && observingParameters.isHolographyParameters()) {
            holographyParameters = (HolographyParameters)((Object)observingParameters);
        }
        return holographyParameters;
    }

    public ObservingParameters[] findObservingParameters(String[] stringArray) {
        if (stringArray == null) {
            return new ObservingParameters[0];
        }
        ObservingParameters[] observingParametersArray = new ObservingParameters[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            observingParametersArray[i] = this.findObservingParameters(stringArray[i]);
        }
        return observingParametersArray;
    }

    public void removeInstrumentSpec(AbstractInstrumentSpec abstractInstrumentSpec) {
        this.removeInstrumentSpec(abstractInstrumentSpec.getEntityPartId());
    }

    private void removeInstrumentSpec(String string) {
        if (this.findSpectralSpec(string) != null) {
            this.removeSpectralSpec(string);
        }
        if (this.findOpticalCameraSpec(string) != null) {
            this.removeOpticalCameraSpec(string);
        }
    }

    private void removeSpectralSpec(String string) {
        this.removeSpectralSpec(this.findSpectralSpec(string));
    }

    private void removeOpticalCameraSpec(String string) {
        this.removeOpticalCameraSpec(this.findOpticalCameraSpec(string));
    }

    public boolean removeObservingParameters(String string) {
        try {
            return this.removeObservingParameters(this.findObservingParameters(string));
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    public boolean removeTarget(Target target) {
        for (ObservingGroup observingGroup : this.getObservingGroup()) {
            observingGroup.deleteOrderedTarget(target.getEntityPartId());
        }
        return super.removeTarget(target);
    }

    public void refreshObservingGroupIndices() {
        for (int i = 0; i < this.getObservingGroupCount(); ++i) {
            this.getObservingGroup(i).setIndex(i + 1);
        }
    }

    public boolean removeObservingGroup(ObservingGroup observingGroup) {
        boolean bl = super.removeObservingGroup(observingGroup);
        this.refreshObservingGroupIndices();
        return bl;
    }

    public void deleteObservingGroup(int n) {
        this.removeObservingGroup(this.getObservingGroup(n));
        this.refreshObservingGroupIndices();
    }

    public void moveOrderedTargetUpOneRow(int n) {
        ObservingGroup[] observingGroupArray = this.getObservingGroup();
        try {
            ObservingGroup observingGroup;
            ObservingGroup observingGroup2 = observingGroupArray[n - 1];
            observingGroupArray[n - 1] = observingGroup = observingGroupArray[n];
            observingGroupArray[n] = observingGroup2;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.setObservingGroup(observingGroupArray);
        this.refreshObservingGroupIndices();
    }

    public void moveOrderedTargetDownOneRow(int n) {
        ObservingGroup[] observingGroupArray = this.getObservingGroup();
        try {
            ObservingGroup observingGroup;
            ObservingGroup observingGroup2 = observingGroupArray[n];
            observingGroupArray[n] = observingGroup = observingGroupArray[n + 1];
            observingGroupArray[n + 1] = observingGroup2;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.setObservingGroup(observingGroupArray);
        this.refreshObservingGroupIndices();
    }

    public int getInstrumentSpecCount() {
        int n = this.getSpectralSpecCount() + this.getOpticalCameraSpecCount();
        return n;
    }

    public AbstractInstrumentSpec[] getInstrumentSpec() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (SpectralSpec object : this.getSpectralSpec()) {
            arrayList.add(object);
        }
        for (OpticalCameraSpec opticalCameraSpec : this.getOpticalCameraSpec()) {
            arrayList.add(opticalCameraSpec);
        }
        return arrayList.toArray(new AbstractInstrumentSpec[arrayList.size()]);
    }

    public String[] getObservingParametersIdList() {
        ObservingParameters[] observingParametersArray = this.getObservingParameters();
        String[] stringArray = new String[observingParametersArray.length];
        for (int i = 0; i < observingParametersArray.length; ++i) {
            stringArray[i] = observingParametersArray[i].getEntityPartId();
        }
        return stringArray;
    }

    public int getTargetCountWithOpticalPointingParameters() {
        int n = 0;
        for (int i = 0; i < this.getTargetCount(); ++i) {
            if (!this.getTarget(i).hasOpticalPointingParameters()) continue;
            ++n;
        }
        return n;
    }

    public int getTargetCountWithRadiometricPointingParameters() {
        int n = 0;
        for (int i = 0; i < this.getTargetCount(); ++i) {
            if (!this.getTarget(i).hasRadiometricPointingParameters()) continue;
            ++n;
        }
        return n;
    }

    public int getTargetCountWithScienceParameters() {
        int n = 0;
        for (int i = 0; i < this.getTargetCount(); ++i) {
            if (!this.getTarget(i).hasScienceParameters()) continue;
            ++n;
        }
        return n;
    }

    public Target[] getTargets(ObsType obsType) {
        HashSet<Target> hashSet = new HashSet<Target>();
        block13: for (Target target : this.getTarget()) {
            switch (obsType) {
                case AMPLITUDE: {
                    if (!target.hasAmplitudeCalParameters()) continue block13;
                    hashSet.add(target);
                    continue block13;
                }
                case CHECKSOURCE: {
                    if (!target.hasCheckSourceCalParameters()) continue block13;
                    hashSet.add(target);
                    continue block13;
                }
                case BANDPASS: {
                    if (!target.hasBandpassCalParameters()) continue block13;
                    hashSet.add(target);
                    continue block13;
                }
                case ATMOSPHERIC: {
                    if (!target.hasAtmosphericCalParameters()) continue block13;
                    hashSet.add(target);
                    continue block13;
                }
                case DELAY: {
                    if (!target.hasDelayCalParameters()) continue block13;
                    hashSet.add(target);
                    continue block13;
                }
                case FOCUS: {
                    if (!target.hasFocusCalParameters()) continue block13;
                    hashSet.add(target);
                    continue block13;
                }
                case PHASE: {
                    if (!target.hasPhaseCalParameters()) continue block13;
                    hashSet.add(target);
                    continue block13;
                }
                case POINTING: {
                    if (!target.hasPointingCalParameters()) continue block13;
                    hashSet.add(target);
                    continue block13;
                }
                case POLARIZATION: {
                    if (!target.hasPolarizationCalParameters()) continue block13;
                    hashSet.add(target);
                    continue block13;
                }
                case SIDEBANDRATIO: {
                    if (!target.hasSidebandRatioCalParameters()) continue block13;
                    hashSet.add(target);
                    continue block13;
                }
                case SCIENCE: {
                    if (!target.hasScienceParameters()) continue block13;
                    hashSet.add(target);
                    continue block13;
                }
                default: {
                    return null;
                }
            }
        }
        return hashSet.toArray(new Target[hashSet.size()]);
    }

    public boolean hasBLSpectralSpec() {
        for (SpectralSpec spectralSpec : this.getSpectralSpec()) {
            if (!spectralSpec.isBLSpectralSpec()) continue;
            return true;
        }
        return false;
    }

    public boolean hasACASpectralSpec() {
        for (SpectralSpec spectralSpec : this.getSpectralSpec()) {
            if (!spectralSpec.isACASpectralSpec()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ObsUnitSet getContainingObsUnitSet() {
        return (ObsUnitSet)this.getParent();
    }

    public SchedBlockRefT getReference() {
        SchedBlockRefT schedBlockRefT = super.getReference();
        schedBlockRefT.setDocumentVersion("1");
        return schedBlockRefT;
    }

    public Time getScienceTargetIntegrationTime() {
        ScienceParameters[] scienceParametersArray = this.getObservingParametersScienceParameters();
        if (scienceParametersArray.length != 1) {
            String string = "Can not tell the integration time for this SchedBlock " + this.getName() + " because the number of ScienceParameters is " + scienceParametersArray.length;
            Log.logger((Object)this).warning(string);
            return Time.createTime();
        }
        ScienceParameters scienceParameters = scienceParametersArray[0];
        return scienceParameters.getIntegrationTime().getTime();
    }

    public boolean isRenameable() {
        return RENAMEABLE_STATES.contains(this.getStatus());
    }

    public boolean isDeletable() {
        return DELETABLE_STATES.contains(this.getStatus());
    }

    public boolean setExpertParameter(String string, String string2) {
        KeywordValue[] keywordValueArray;
        for (KeywordValue keywordValue : keywordValueArray = this.getExpertParameter()) {
            if (!keywordValue.getKeyword().equals(string)) continue;
            keywordValue.setValue(string2);
            return true;
        }
        return false;
    }

    public String generateName(ScienceGoal scienceGoal) {
        String string;
        Target target = this.getSchedulingConstraints().getRepresentativeTarget();
        FieldSource fieldSource = null;
        if (SchedBlockData.MODETYPE_OBSERVATORY.equals(this.getModeType())) {
            string = StringUtils.substringBefore((String)this.getName(), (String)"_");
        } else {
            if (target != null) {
                fieldSource = target.getFieldSource();
            }
            string = null == fieldSource ? "Unknown" : StringUtils.left((String)fieldSource.getSourceName(), (int)8);
        }
        string = string + "_1_";
        String string2 = this.getObsUnitControl().getArrayRequested();
        String string3 = "";
        if (string2.equals(ControlBlockTArrayRequestedType.TWELVE_M.toString())) {
            boolean bl = false;
            if (scienceGoal != null) {
                try {
                    bl = scienceGoal.isSolarScienceGoal();
                }
                catch (UnknownEntityException unknownEntityException) {
                    Log.logger(SchedBlock.class).warning("Unable to determine if a solar SG");
                }
            }
            string3 = bl ? "INT" : (this.is12mCompactArraySB() ? "TM2" : (this.is12mExtendedArraySB() ? "TM1" : "TM1"));
        } else if (string2.equals(ControlBlockTArrayRequestedType.SEVEN_M.toString())) {
            string3 = "7M";
        } else if (string2.equals(ControlBlockTArrayRequestedType.TP_ARRAY.toString())) {
            string3 = "TP";
        } else if (string2.equals(ControlBlockTArrayRequestedType.ACA.toString())) {
            string3 = "AC";
        }
        SchedulingConstraints schedulingConstraints = this.getSchedulingConstraints();
        string = string + StringUtils.right((String)schedulingConstraints.getRepresentativeReceiverBand(), (int)2) + "_" + string3;
        Log.logger((Object)this).fine("Generated SB name is: " + string + " for " + this.getEntityID());
        return string;
    }

    public boolean is12mExtendedArraySB() {
        return this.getObsUnitControl().getArrayRequested().equals(ControlBlockTArrayRequestedType.TWELVE_M.toString()) && this.sbGenerationContext.getSBType().equals((Object)SBGeneratorTemplate.SchedBlockType.TWELVEMEXTENDEDCONFIGURATION);
    }

    public boolean isTotalPowerAmpcalSB() {
        return this.getObsUnitControl().getArrayRequested().equals(ControlBlockTArrayRequestedType.TP_ARRAY.toString()) && this.sbGenerationContext.getSBType().equals((Object)SBGeneratorTemplate.SchedBlockType.TPAMPCAL);
    }

    public boolean isACA7mArraySB() {
        return this.getObsUnitControl().getArrayRequested().equals(ControlBlockTArrayRequestedType.SEVEN_M.toString()) && this.sbGenerationContext.getSBType().equals((Object)SBGeneratorTemplate.SchedBlockType.ACA7M);
    }

    public boolean isTotalPowerScienceSB() {
        return this.getObsUnitControl().getArrayRequested().equals(ControlBlockTArrayRequestedType.TP_ARRAY.toString()) && this.sbGenerationContext.getSBType().equals((Object)SBGeneratorTemplate.SchedBlockType.TPSCIENCE);
    }

    public boolean is12mCompactArraySB() {
        return this.getObsUnitControl().getArrayRequested().equals(ControlBlockTArrayRequestedType.TWELVE_M.toString()) && this.sbGenerationContext.getSBType().equals((Object)SBGeneratorTemplate.SchedBlockType.TWELVEMCOMPACTCONFIGURATION);
    }

    public AbstractScienceGoal getParentScienceGoal() throws UnableToFindParentScienceGoalException {
        for (BusinessObject businessObject = this.getParent(); businessObject != null && businessObject instanceof ObsUnitSet; businessObject = businessObject.getParent()) {
            ObsUnitSet obsUnitSet = (ObsUnitSet)businessObject;
            AbstractScienceGoal abstractScienceGoal = obsUnitSet.getGeneratingScienceGoal();
            if (abstractScienceGoal == null) continue;
            return abstractScienceGoal;
        }
        throw new UnableToFindParentScienceGoalException();
    }

    public void setObsUnitSet(ObsUnitSet obsUnitSet) {
        super.setObsUnitSet(obsUnitSet);
    }

    public ObsUnitSet getObsUnitSet() {
        return super.getObsUnitSet();
    }

    public ObsUnitSet gettrueObsUnitSet() {
        return super.gettrueObsUnitSet();
    }

    public SBGenerationContext getSbGenerationContext() {
        return this.sbGenerationContext;
    }

    public void setSbGenerationContext(SBGenerationContext sBGenerationContext) {
        this.sbGenerationContext = sBGenerationContext;
    }

    public List<Target> getAllTargets(Optional<Predicate<Target>> optional) {
        ArrayList<Target> arrayList = new ArrayList<Target>();
        for (ObservingGroup observingGroup : this.getObservingGroup()) {
            for (OrderedTarget orderedTarget : observingGroup.getOrderedTarget()) {
                Target target2 = orderedTarget.getTarget();
                if (!optional.orElse(target -> true).test(target2)) continue;
                arrayList.add(target2);
            }
        }
        return arrayList;
    }

    static {
        DELETABLE_STATES.add(STATUS_NEWPHASE1);
        DELETABLE_STATES.add(STATUS_NEWPHASE2);
        DELETABLE_STATES.add(STATUS_PHASE1SUBMITTED);
        DELETABLE_STATES.add(STATUS_PHASE2SUBMITTED);
        DELETABLE_STATES.add(STATUS_BROKEN);
        RENAMEABLE_STATES = new HashSet<String>();
        RENAMEABLE_STATES.add(STATUS_NEWPHASE1);
        RENAMEABLE_STATES.add(STATUS_NEWPHASE2);
        RENAMEABLE_STATES.add(STATUS_PHASE2SUBMITTED);
    }

    public static class UnableToFindParentScienceGoalException
    extends Exception {
        private static final long serialVersionUID = 7510621913133122950L;
    }
}

