/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.schedblock;

import alma.entity.xmlbinding.schedblock.SpectralSpecT;
import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.bo.Copier;
import alma.hla.runtime.obsprep.bo.CopyException;
import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.annotations.BOWithSpecificName;
import alma.obsprep.bo.annotations.BaseBand;
import alma.obsprep.bo.annotations.BaseBandHolder;
import alma.obsprep.bo.annotations.ObsUnitSetComponent;
import alma.obsprep.bo.annotations.SpatialPartOfSpectralSpecDocument;
import alma.obsprep.bo.annotations.SpectralSpecDocument;
import alma.obsprep.bo.annotations.SpectralWindowI;
import alma.obsprep.bo.enumerations.CorrPolarization;
import alma.obsprep.bo.enumerations.CorrelatorType;
import alma.obsprep.bo.obsproject.AbstractScienceGoal;
import alma.obsprep.bo.obsproject.ObsUnitSet;
import alma.obsprep.bo.obsproject.ObservatoryGoal;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.schedblock.ACABaseBandConfig;
import alma.obsprep.bo.schedblock.ACACorrelatorConfiguration;
import alma.obsprep.bo.schedblock.AbstractBaseBandConfig;
import alma.obsprep.bo.schedblock.AbstractCorrelatorConfiguration;
import alma.obsprep.bo.schedblock.BLBaseBandConfig;
import alma.obsprep.bo.schedblock.BLCorrelatorConfiguration;
import alma.obsprep.bo.schedblock.BaseBandSpecification;
import alma.obsprep.bo.schedblock.DataRateChangeEvent;
import alma.obsprep.bo.schedblock.DataRateChangeListener;
import alma.obsprep.bo.schedblock.DataRateNode;
import alma.obsprep.bo.schedblock.FrequencySetup;
import alma.obsprep.bo.schedblock.LOsolutionsAdaptor;
import alma.obsprep.bo.schedblock.ObservingGroup;
import alma.obsprep.bo.schedblock.Range;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.SquareLawSetup;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.bo.schedblock.data.ACACorrelatorConfigurationData;
import alma.obsprep.bo.schedblock.data.SpectralSpecData;
import alma.obsprep.ot.editors.misc.SpectralSpecSummaryTableColumns;
import alma.obsprep.ot.gui.toplevel.ObservingToolGui;
import alma.obsprep.services.experts.CorrelatorExpert;
import alma.obsprep.services.experts.spectralline.SpectralLine;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.MinTuningsCalculator;
import alma.obsprep.util.GUIUtilities;
import alma.valuetypes.DataRate;
import alma.valuetypes.Frequency;
import alma.valuetypes.Velocity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class SpectralSpec
extends SpectralSpecData
implements SpectralSpecDocument,
BOWithSpecificName,
DataRateNode {
    public static final int MAX_BASE_BAND = 4;
    private static final Frequency TWO_GHZ = Frequency.createFrequencyGHZ(2.0);
    private final Log.Logger logger = Log.logger((Object)this);
    private final LOsolutionsAdaptor configurator = new LOsolutionsAdaptor(this);
    private Velocity sourceVelocity;
    private boolean suspendDataChangeNotifier = false;
    private final ArrayList<DataRateChangeListener> dataRateChangeListeners = new ArrayList();
    private final List<SpectralLine> overlayLines = new ArrayList<SpectralLine>();

    public SpectralSpec(SpectralSpecT spectralSpecT) {
        super(spectralSpecT);
        this.summaryTableColumns = new SpectralSpecSummaryTableColumns(this);
    }

    @Override
    public SpectralSpec getSpectralSpec() {
        return this;
    }

    public void initAsNew() {
        super.initAsNew();
        this.setReceiverType(RECEIVERTYPE_TSB);
        this.setSwitchingType(SWITCHINGTYPE_NO_SWITCHING);
    }

    protected void initAttribsAndPartsFrom(IBusinessObject iBusinessObject, Copier copier) throws CopyException {
        super.initAttribsAndPartsFrom(iBusinessObject, copier);
        SpectralSpec spectralSpec = (SpectralSpec)iBusinessObject;
        AbstractCorrelatorConfiguration abstractCorrelatorConfiguration = spectralSpec.gettrueAbstractCorrelatorConfiguration();
        AbstractCorrelatorConfiguration abstractCorrelatorConfiguration2 = this.gettrueAbstractCorrelatorConfiguration();
        if (abstractCorrelatorConfiguration != null) {
            FrequencySetup frequencySetup = spectralSpec.gettrueFrequencySetup();
            FrequencySetup frequencySetup2 = this.gettrueFrequencySetup();
            if (frequencySetup != null) {
                BaseBandSpecification[] baseBandSpecificationArray = frequencySetup.getBaseBandSpecification();
                BaseBandSpecification[] baseBandSpecificationArray2 = frequencySetup2.getBaseBandSpecification();
                block0: for (int i = 0; i < abstractCorrelatorConfiguration.getBaseBandConfigCount(); ++i) {
                    AbstractBaseBandConfig abstractBaseBandConfig = abstractCorrelatorConfiguration.getBaseBandConfig(i);
                    abstractCorrelatorConfiguration2.getBaseBandConfig(i);
                    BaseBandSpecification baseBandSpecification = abstractBaseBandConfig.getBaseBandSpecification();
                    for (int j = 0; j < baseBandSpecificationArray2.length; ++j) {
                        if (baseBandSpecification != baseBandSpecificationArray[j]) continue;
                        BaseBandSpecification baseBandSpecification2 = baseBandSpecificationArray2[j];
                        abstractCorrelatorConfiguration2.getBaseBandConfig(i).setBaseBandSpecification(baseBandSpecification2);
                        continue block0;
                    }
                }
            }
        }
    }

    public void setSourceVelocity(Velocity velocity) {
        this.sourceVelocity = velocity;
    }

    public Velocity getSourceVelocity() {
        if (this.sourceVelocity == null) {
            this.sourceVelocity = Velocity.createVelocity();
        }
        return this.sourceVelocity;
    }

    public SchedBlock getSchedBlock() {
        SchedBlock schedBlock = (SchedBlock)this.getParent();
        return schedBlock == null ? null : schedBlock;
    }

    public String toTreeString(int n, boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getNameOrDefault());
        if (this.isACASpectralSpec()) {
            stringBuffer.append("[ACA SB]");
        } else if (this.isBLSpectralSpec()) {
            stringBuffer.append("[12m Array SB]");
        }
        stringBuffer.append(" (");
        int n2 = this.getBaseBandCount();
        if (n2 == 1) {
            stringBuffer.append("1 BBC");
        } else {
            stringBuffer.append(n2);
            stringBuffer.append(" BBCs");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public boolean isACASpectralSpec() {
        AbstractCorrelatorConfiguration abstractCorrelatorConfiguration = this.getAbstractCorrelatorConfiguration();
        return abstractCorrelatorConfiguration != null && abstractCorrelatorConfiguration.getCorrelatorType() == CorrelatorType.ACA;
    }

    public boolean isBLSpectralSpec() {
        AbstractCorrelatorConfiguration abstractCorrelatorConfiguration = this.getAbstractCorrelatorConfiguration();
        return abstractCorrelatorConfiguration != null && abstractCorrelatorConfiguration.getCorrelatorType() == CorrelatorType.BL;
    }

    public boolean isPureTDM() {
        for (AbstractBaseBandConfig abstractBaseBandConfig : this.getBaseBandConfig()) {
            if (1 != abstractBaseBandConfig.getSpectralWindowCount()) {
                return false;
            }
            for (SpectralWindowI spectralWindowI : abstractBaseBandConfig.getSpectralWindow()) {
                if (TWO_GHZ.isEqual((AbstractDoubleWithUnit)spectralWindowI.getEffectiveBandwidth())) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isSpatial() {
        return false;
    }

    public ReceiverBand getReceiverBand() {
        String string = this.getFrequencySetup().getReceiverBand();
        return ReceiverBand.getReceiverBand(string);
    }

    public Frequency getLO1Frequency() {
        return this.getFrequencySetup().getLO1Frequency();
    }

    public void setLO1Frequency(Frequency frequency) {
        this.getFrequencySetup().setLO1Frequency(frequency);
    }

    public double calculateIntermediateFrequency() {
        FrequencySetup frequencySetup = this.getFrequencySetup();
        ReceiverBand receiverBand = ReceiverBand.getReceiverBand(frequencySetup.getReceiverBand());
        frequencySetup.getRestFrequency().getContentInGHz();
        new Range(receiverBand.getRFMin(), receiverBand.getRFMax());
        Range range = new Range(receiverBand.getIFMin(), receiverBand.getIFMax());
        double d = BaseBandSpecification.basebandWidth.getContentInGHz();
        range = this.isLSB() ? new Range(range.mid() - 2.0, range.mid() - 2.0 + d) : new Range(range.mid() + 2.0 - d, range.mid() + 2.0);
        return range.mid();
    }

    public int getBaseBandConfigCount() {
        return this.getBaseBandCount();
    }

    public Frequency getAdjustedLO2Frequency(int n) {
        BaseBandSpecification baseBandSpecification = this.getBaseBandSpecification(n);
        return baseBandSpecification.getLO2Frequency();
    }

    public double calculateBaseband() {
        double d = BaseBandSpecification.basebandWidth.getContentInGHz();
        Range range = new Range(4.0 - d, 4.0);
        return range.mid();
    }

    public boolean calculateCorrelatorSetup(Velocity velocity) {
        return this.calculateCorrelatorSetup(velocity, false);
    }

    public boolean calculateCorrelatorSetup(Velocity velocity, boolean bl) {
        return this.calculateCorrelatorSetup(velocity, bl, 0);
    }

    public ObservingToolGui.FeedbackInfo getFeedbackInfo() {
        return this.configurator.getFeedbackInfo();
    }

    public boolean isLSB() {
        Range range;
        FrequencySetup frequencySetup = this.getFrequencySetup();
        ReceiverBand receiverBand = ReceiverBand.getReceiverBand(frequencySetup.getReceiverBand());
        double d = frequencySetup.getRestFrequency().getContentInGHz();
        return d < (range = new Range(receiverBand.getRFMin(), receiverBand.getRFMax())).mid();
    }

    public static SpectralSpec createSpectralSpecWithBLCorrelatorConfiguration() {
        SpectralSpec spectralSpec = SpectralSpec.createSpectralSpec();
        BLCorrelatorConfiguration bLCorrelatorConfiguration = BLCorrelatorConfiguration.createBLCorrelatorConfiguration();
        spectralSpec.setCorrelatorConfiguration((AbstractCorrelatorConfiguration)((Object)bLCorrelatorConfiguration));
        return spectralSpec;
    }

    public static SpectralSpec createSpectralSpecWithACACorrelatorConfiguration() {
        SpectralSpec spectralSpec = SpectralSpec.createSpectralSpec();
        ACACorrelatorConfiguration aCACorrelatorConfiguration = ACACorrelatorConfiguration.createACACorrelatorConfiguration();
        spectralSpec.setCorrelatorConfiguration((AbstractCorrelatorConfiguration)((Object)aCACorrelatorConfiguration));
        return spectralSpec;
    }

    public static SpectralSpec createSpectralSpecWithSquareLawSetup() {
        SpectralSpec spectralSpec = SpectralSpec.createSpectralSpec();
        SquareLawSetup squareLawSetup = SquareLawSetup.createSquareLawSetup();
        spectralSpec.setSquareLawSetup(squareLawSetup);
        return spectralSpec;
    }

    public AbstractCorrelatorConfiguration getCorrelatorConfiguration() {
        return this.getAbstractCorrelatorConfiguration();
    }

    public CorrelatorExpert getCorrelatorExpert() {
        AbstractCorrelatorConfiguration abstractCorrelatorConfiguration = this.getCorrelatorConfiguration();
        if (abstractCorrelatorConfiguration instanceof ACACorrelatorConfigurationData) {
            return CorrelatorExpert.getInstance(CorrelatorType.ACA);
        }
        return CorrelatorExpert.getInstance(CorrelatorType.BL);
    }

    public void setCorrelatorConfiguration(AbstractCorrelatorConfiguration abstractCorrelatorConfiguration) {
        this.setAbstractCorrelatorConfiguration(abstractCorrelatorConfiguration);
        this.dataRateChanged();
    }

    public ObsUnitSet getContainingObsUnitSet() {
        ObsUnitSetComponent obsUnitSetComponent = (ObsUnitSetComponent)this.getParent();
        return obsUnitSetComponent.getContainingObsUnitSet();
    }

    @Override
    public void setName(String string) {
        if (string == null) {
            super.setName("");
        } else {
            String string2 = string.replaceAll("[^\\x00-\\x7f]", "_");
            super.setName(string2);
        }
    }

    public void setReceiverBandName(String string) {
        this.getFrequencySetup().setReceiverBand(string);
    }

    public void setTransitionName(String string) {
        this.getFrequencySetup().setTransitionName(string);
    }

    public void setRestFrequency(Frequency frequency) {
        this.getFrequencySetup().setRestFrequency(frequency);
    }

    @Override
    public SpatialPartOfSpectralSpecDocument getSpatialPartOfSpectralSpecDocument() {
        return null;
    }

    public String getReceiverBandName() {
        return this.getFrequencySetup().getReceiverBand();
    }

    public String getTransitionName() {
        return this.getFrequencySetup().getTransitionName();
    }

    public Frequency getRestFrequency() {
        return this.getFrequencySetup().getRestFrequency();
    }

    public void addDataRateChangeListener(DataRateChangeListener dataRateChangeListener) {
        if (!this.dataRateChangeListeners.contains(dataRateChangeListener)) {
            this.dataRateChangeListeners.add(dataRateChangeListener);
        }
    }

    public void removeDataRateChangeListener(DataRateChangeListener dataRateChangeListener) {
        this.dataRateChangeListeners.remove(dataRateChangeListener);
    }

    @Override
    public DataRate getInstantaneousDataRate() {
        if (this.hasCorrelatorConfiguration()) {
            return this.getCorrelatorConfiguration().getInstantaneousDataRate();
        }
        return DataRate.createDataRate();
    }

    @Override
    public void dataRateChanged(DataRateChangeEvent dataRateChangeEvent) {
        this.dataRateChanged();
    }

    public void suspendDataRateChangeNotifier() {
        this.suspendDataChangeNotifier = true;
    }

    public void activateDataRateChangeNotifier() {
        this.suspendDataChangeNotifier = false;
    }

    private void dataRateChanged() {
        if (this.suspendDataChangeNotifier) {
            return;
        }
        for (DataRateChangeListener dataRateChangeListener : this.dataRateChangeListeners) {
            dataRateChangeListener.dataRateChanged(new DataRateChangeEvent(this));
        }
    }

    @Override
    public DataRateNode getParentDataRateNode() {
        return this;
    }

    public static int maxBaseBandCount() {
        return 4;
    }

    public AbstractBaseBandConfig addNewBaseBandConfig() {
        if (this.hasCorrelatorConfiguration()) {
            return (AbstractBaseBandConfig)this.addNewBaseBand();
        }
        Log.logger((Object)this).warning("Can not add a BaseBandConfig to a SpectralSpec without CorrelatorConfiguration.");
        return null;
    }

    public BaseBand addNewBaseBand() {
        return this.addNewBaseBand(this.getBaseBandCount(), false);
    }

    public BaseBand addNewBaseBand(int n, boolean bl) {
        if (n >= SpectralSpec.maxBaseBandCount()) {
            throw new IllegalArgumentException("index must be less than " + SpectralSpec.maxBaseBandCount());
        }
        FrequencySetup frequencySetup = this.getFrequencySetup();
        BaseBandSpecification baseBandSpecification = frequencySetup.addNewBaseBandSpecification(n);
        if (baseBandSpecification == null) {
            GUIUtilities.error(null, "Could not add BaseBandSpecification to this FrequencySetup");
        }
        if (this.hasCorrelatorConfiguration()) {
            AbstractCorrelatorConfiguration abstractCorrelatorConfiguration = this.getCorrelatorConfiguration();
            AbstractBaseBandConfig abstractBaseBandConfig = abstractCorrelatorConfiguration.addNewBaseBandConfig(n);
            abstractBaseBandConfig.setBaseBandSpecification(baseBandSpecification);
            if (bl) {
                CorrelatorType correlatorType = CorrelatorType.BL;
                if (abstractBaseBandConfig.isACA()) {
                    correlatorType = CorrelatorType.ACA;
                    ((ACABaseBandConfig)((Object)abstractBaseBandConfig)).setPolnProducts(CorrPolarization.DOUBLE.polnProducts);
                }
                CorrelatorExpert correlatorExpert = CorrelatorExpert.getInstance(correlatorType);
                CorrPolarization corrPolarization = CorrPolarization.DOUBLE;
                SpectralWindowI spectralWindowI = abstractBaseBandConfig.addNewSpectralWindow();
                spectralWindowI.setCorrConfigMode(correlatorExpert.getContinuumMode(corrPolarization));
                spectralWindowI.adjustCenterFrequency();
                spectralWindowI.publishCorrConfigMode();
            }
            return abstractBaseBandConfig;
        }
        return baseBandSpecification;
    }

    public void removeBaseBand(BaseBand baseBand) {
        BaseBandSpecification baseBandSpecification = baseBand.getBaseBandSpecification();
        AbstractBaseBandConfig abstractBaseBandConfig = baseBand.getBaseBandConfig();
        if (abstractBaseBandConfig != null) {
            abstractBaseBandConfig.setBaseBandSpecification(null);
        }
        this.getFrequencySetup().removeBaseBandSpecification(baseBandSpecification);
        if (this.hasCorrelatorConfiguration()) {
            AbstractCorrelatorConfiguration abstractCorrelatorConfiguration = this.getCorrelatorConfiguration();
            abstractCorrelatorConfiguration.primitiveRemoveBaseBandConfig(abstractBaseBandConfig);
        }
    }

    public void clearBaseBand() {
        if (this.hasCorrelatorConfiguration()) {
            AbstractCorrelatorConfiguration abstractCorrelatorConfiguration = this.getCorrelatorConfiguration();
            abstractCorrelatorConfiguration.clearBaseBandConfig();
        }
        this.getFrequencySetup().clearBaseBandSpecification();
    }

    public boolean hasSquareLawSetup() {
        return this.gettrueSquareLawSetup() != null;
    }

    public boolean hasCorrelatorConfiguration() {
        return this.gettrueAbstractCorrelatorConfiguration() != null;
    }

    public BaseBandSpecification[] getBaseBandSpecification() {
        return this.getFrequencySetup().getBaseBandSpecification();
    }

    public BaseBandSpecification getBaseBandSpecification(int n) {
        return this.getFrequencySetup().getBaseBandSpecification(n);
    }

    public int getBaseBandCount() {
        return this.getFrequencySetup().getBaseBandSpecificationCount();
    }

    public BaseBandHolder getBaseBandHolder() {
        if (this.hasCorrelatorConfiguration()) {
            return this.getCorrelatorConfiguration();
        }
        return this.getFrequencySetup();
    }

    public BaseBand[] getBaseBand() {
        return this.getBaseBandHolder().getBaseBand();
    }

    public BaseBand getBaseBand(int n) {
        return this.getBaseBandHolder().getBaseBand(n);
    }

    public AbstractBaseBandConfig getBaseBandConfig(int n) {
        if (this.hasCorrelatorConfiguration()) {
            return (AbstractBaseBandConfig)this.getBaseBand(n);
        }
        return null;
    }

    public List<AbstractBaseBandConfig> getBaseBandConfig() {
        ArrayList<AbstractBaseBandConfig> arrayList = new ArrayList<AbstractBaseBandConfig>();
        for (int i = 0; i < this.getBaseBandConfigCount(); ++i) {
            arrayList.add(this.getBaseBandConfig(i));
        }
        return arrayList;
    }

    public void setOverlayLines(List<SpectralLine> list) {
        this.overlayLines.clear();
        if (list != null) {
            this.overlayLines.addAll(list);
        }
    }

    public List<SpectralLine> getOverlayLines() {
        return Collections.unmodifiableList(this.overlayLines);
    }

    public Frequency getFilteredSpectralWindow(FilteringCriteria filteringCriteria) throws IncompleteCorrelatorSetupFoundException {
        Object object;
        Frequency object2 = null;
        if (!this.hasCorrelatorConfiguration()) {
            throw new IncompleteCorrelatorSetupFoundException("No correlator configuration attached to spectral spec.");
        }
        ArrayList<AbstractDoubleWithUnit> arrayList = new ArrayList<AbstractDoubleWithUnit>();
        AbstractCorrelatorConfiguration abstractCorrelatorConfiguration = this.getAbstractCorrelatorConfiguration();
        Frequency frequency = Frequency.createFrequencyGHZ(1.0);
        if (abstractCorrelatorConfiguration instanceof BLCorrelatorConfiguration) {
            object = (BLCorrelatorConfiguration)((Object)abstractCorrelatorConfiguration);
            for (BLBaseBandConfig bLBaseBandConfig : object.getBLBaseBandConfig()) {
                for (SpectralWindowI spectralWindowI : bLBaseBandConfig.getBLSpectralWindow()) {
                    arrayList.add(((Frequency)bLBaseBandConfig.getCenterFrequencySky().minus((AbstractDoubleWithUnit)frequency)).plus(spectralWindowI.getCenterFrequency().minus((AbstractDoubleWithUnit)TWO_GHZ)));
                }
            }
        } else if (abstractCorrelatorConfiguration instanceof ACACorrelatorConfiguration) {
            object = (ACACorrelatorConfiguration)((Object)abstractCorrelatorConfiguration);
            for (ACABaseBandConfig aCABaseBandConfig : object.getACABaseBandConfig()) {
                for (SpectralWindowI spectralWindowI : aCABaseBandConfig.getACASpectralWindow()) {
                    arrayList.add(((Frequency)aCABaseBandConfig.getCenterFrequencySky().minus((AbstractDoubleWithUnit)frequency)).plus(spectralWindowI.getCenterFrequency().minus((AbstractDoubleWithUnit)TWO_GHZ)));
                }
            }
        } else {
            throw new WizardSBGenerationException("Unknown correlator type " + abstractCorrelatorConfiguration.getClass());
        }
        block8: for (Frequency frequency2 : arrayList) {
            if (object2 == null) {
                object2 = frequency2;
                continue;
            }
            Frequency frequency3 = frequency2;
            switch (filteringCriteria) {
                case HIGHESTFREQUENCY: {
                    if (!frequency3.isGreaterThan((AbstractDoubleWithUnit)object2)) continue block8;
                    object2 = frequency3.deepCopy();
                    continue block8;
                }
                case LOWESTFREQUENCY: {
                    if (!frequency3.isLessThan((AbstractDoubleWithUnit)object2)) continue block8;
                    object2 = frequency3.deepCopy();
                    continue block8;
                }
            }
            throw new RuntimeException("Unknown filter type " + (Object)((Object)filteringCriteria));
        }
        if (object2 == null) {
            throw new IncompleteCorrelatorSetupFoundException("No spectral windows were found in the correlator setup");
        }
        return object2;
    }

    public TargetParameters searchForKeyTargetParametersForThisTuningGroup() throws UnableToDetermineDopplerTargetException, SpectralSpecAncestorIsAnObservatoryGoalException, NoAbstractScienceGoalFoundAsParentException {
        Object object;
        AbstractScienceGoal abstractScienceGoal = null;
        SpectralSpec spectralSpec = this;
        while (!((spectralSpec = spectralSpec.getParent()) instanceof ObsUnitSet && (abstractScienceGoal = ((ObsUnitSet)(object = (ObsUnitSet)((Object)spectralSpec))).getGeneratingScienceGoal()) != null || spectralSpec == null)) {
        }
        if (spectralSpec == null || abstractScienceGoal == null) {
            throw new NoAbstractScienceGoalFoundAsParentException("Unable to determine parent abstract science goal for spectral spec " + this.getName());
        }
        if (abstractScienceGoal instanceof ScienceGoal) {
            Object object2;
            object = (ScienceGoal)((Object)abstractScienceGoal);
            Collection<MinTuningsCalculator.TuningResult> collection = null;
            try {
                object2 = ((ScienceGoal)object).getLo1Tunings();
                if (((Optional)object2).isPresent()) {
                    collection = ((Optional)object2).get();
                } else {
                    collection = MinTuningsCalculator.getLO1Tunings((ScienceGoal)object);
                    ((ScienceGoal)object).setLo1Tunings(Optional.of(collection));
                }
            }
            catch (MinTuningsCalculator.UnableToCalculateMinNumberOfTunings unableToCalculateMinNumberOfTunings) {
                Log.logger(SpectralSpec.class).warning("Unable to determine min tunings: " + unableToCalculateMinNumberOfTunings.getMessage());
                throw new UnableToDetermineDopplerTargetException(unableToCalculateMinNumberOfTunings.getMessage());
            }
            assert (collection != null);
            if (collection.size() == 1) {
                return ((ScienceGoal)object).getKeyTargetParameters();
            }
            object2 = null;
            Velocity velocity = null;
            for (Target spatialDocument : this.getTargetList()) {
                if (!spatialDocument.hasScienceParameters() || spatialDocument.getFieldSource() == null) continue;
                velocity = spatialDocument.getFieldSource().getSourceVelocity().deepCopy();
                object2 = spatialDocument.getFieldSource().getSourceName();
                break;
            }
            if (velocity == null || object2 == null) {
                throw new UnableToDetermineDopplerTargetException("Unable to determine source velocity or name when establishing key target parameters");
            }
            for (MinTuningsCalculator.TuningResult tuningResult : collection) {
                for (TargetParameters targetParameters : tuningResult.getTargets()) {
                    if (!targetParameters.getSourceVelocity().getCenterVelocity().isEqual((AbstractDoubleWithUnit)velocity.getCenterVelocity())) continue;
                    return tuningResult.getKeyTarget();
                }
            }
        } else if (abstractScienceGoal instanceof ObservatoryGoal) {
            throw new SpectralSpecAncestorIsAnObservatoryGoalException();
        }
        throw new UnableToDetermineDopplerTargetException("Unable to determine key target parameters for spectral spec. : " + this.getName());
    }

    public List<Target> getObservingGroupDopplerTargetForSpectralSpec() throws NoAbstractScienceGoalFoundAsParentException, SpectralSpecAncestorIsAnObservatoryGoalException {
        Object object;
        SpectralSpec spectralSpec = this;
        AbstractScienceGoal abstractScienceGoal = null;
        while (!((spectralSpec = spectralSpec.getParent()) instanceof ObsUnitSet && (abstractScienceGoal = ((ObsUnitSet)(object = (ObsUnitSet)((Object)spectralSpec))).getGeneratingScienceGoal()) != null || spectralSpec == null)) {
        }
        if (abstractScienceGoal != null && abstractScienceGoal instanceof ObservatoryGoal) {
            throw new SpectralSpecAncestorIsAnObservatoryGoalException();
        }
        object = new ArrayList();
        for (Target target : this.getTargetList()) {
            if (!target.hasScienceParameters()) continue;
            for (ObservingGroup observingGroup : target.getObservingGroupList()) {
                if (observingGroup.getMainTarget() == null || object.contains(observingGroup.getMainTarget())) continue;
                object.add(observingGroup.getMainTarget());
            }
        }
        return object;
    }

    public boolean calculateCorrelatorSetup(Velocity velocity, boolean bl, int n) {
        FrequencySetup frequencySetup = this.getFrequencySetup();
        return this.configurator.calculate(velocity, frequencySetup.getSideBandPreferences(), bl, n);
    }

    public static enum SideBand {
        USB,
        LSB;


        public static int size() {
            return 2;
        }

        public boolean isUpper() {
            return this == USB;
        }

        public boolean isLower() {
            return this == LSB;
        }
    }

    public static enum FilteringCriteria {
        LOWESTFREQUENCY,
        HIGHESTFREQUENCY;

    }

    public class IncompleteCorrelatorSetupFoundException
    extends Exception {
        public IncompleteCorrelatorSetupFoundException(String string) {
            super(string);
        }
    }

    public class UnableToDetermineDopplerTargetException
    extends Exception {
        public UnableToDetermineDopplerTargetException(String string) {
            super(string);
        }
    }

    public class SpectralSpecAncestorIsAnObservatoryGoalException
    extends Exception {
    }

    public class NoAbstractScienceGoalFoundAsParentException
    extends Exception {
        public NoAbstractScienceGoalFoundAsParentException(String string) {
            super(string);
        }
    }
}

