/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.schedblock;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.obsprep.bo.annotations.SpectralWindowI;
import alma.obsprep.bo.enumerations.SideBandUse;
import alma.obsprep.bo.obsproject.ExpectedSpectralLine;
import alma.obsprep.bo.schedblock.AbstractBaseBandConfig;
import alma.obsprep.bo.schedblock.AbstractSpectralWindow;
import alma.obsprep.bo.schedblock.ChannelAverageRegion;
import alma.obsprep.bo.schedblock.CorrConfigMode;
import alma.obsprep.bo.schedblock.SpectralLine;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.SpectralWindowBand;
import alma.obsprep.bo.schedblock.SpectralWindowPairChannelAverageRegionManager;
import alma.obsprep.bo.schedblock.UnknownScalingFactorException;
import alma.valuetypes.DataRate;
import alma.valuetypes.Frequency;
import alma.valuetypes.Velocity;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public abstract class SpectralWindowPair
implements SpectralWindowI {
    protected AbstractBaseBandConfig bbc;
    private AbstractSpectralWindow windowLSB;
    private AbstractSpectralWindow windowUSB;
    private SpectralWindowPairChannelAverageRegionManager carManager = new SpectralWindowPairChannelAverageRegionManager();

    public SpectralWindowPair(AbstractBaseBandConfig abstractBaseBandConfig) {
        this.bbc = abstractBaseBandConfig;
    }

    public abstract SpectralWindowPair getNewInstance(AbstractBaseBandConfig var1);

    public SpectralWindowPair createCopy() {
        SpectralWindowPair spectralWindowPair = this.getNewInstance(this.bbc);
        spectralWindowPair.setSpectralWindows(this.windowLSB.deepCopy(), this.windowUSB.deepCopy());
        spectralWindowPair.setCenterFrequency(this.windowLSB.getCenterFrequency());
        return spectralWindowPair;
    }

    @Override
    public AbstractSpectralWindow getLSB() {
        return this.windowLSB;
    }

    @Override
    public AbstractSpectralWindow getUSB() {
        return this.windowUSB;
    }

    public void setSpectralWindows(AbstractSpectralWindow abstractSpectralWindow, AbstractSpectralWindow abstractSpectralWindow2) {
        this.windowLSB = abstractSpectralWindow;
        this.windowUSB = abstractSpectralWindow2;
        this.refreshChannelAverageRegionManager();
    }

    public String toString() {
        return this.detailString();
    }

    public String detailString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getSimpleName() + "@" + this.hashCode());
        stringBuffer.append(", use=" + (Object)((Object)this.getSideBandUse()));
        stringBuffer.append("\n");
        stringBuffer.append("\t" + this.windowLSB.toString() + "\n");
        stringBuffer.append("\t" + this.windowUSB.toString());
        return stringBuffer.toString();
    }

    @Override
    public Frequency getCenterFrequency() {
        return this.windowLSB.getCenterFrequency();
    }

    @Override
    public void setCenterFrequency(Frequency frequency) {
        this.windowLSB.setCenterFrequency(frequency);
        this.windowUSB.setCenterFrequency(frequency);
    }

    @Override
    public Frequency getDesiredCenterFrequency() {
        return this.windowLSB.getDesiredCenterFrequency();
    }

    @Override
    public void setDesiredCenterFrequency(Frequency frequency) {
        this.windowLSB.setDesiredCenterFrequency(frequency);
        this.windowUSB.setDesiredCenterFrequency(frequency);
    }

    @Override
    public void adjustCenterFrequency() {
        this.windowLSB.adjustCenterFrequency();
    }

    @Override
    public String getSpectralWindowName() {
        return this.windowLSB.getName() + " / " + this.windowUSB.getName();
    }

    @Override
    public Frequency getRestFrequencyLSB() {
        return this.windowLSB.getRestFrequencyLSB();
    }

    @Override
    public Frequency getRestFrequencyUSB() {
        return this.windowLSB.getRestFrequencyUSB();
    }

    @Override
    public Frequency getSkyFrequencyLSB() {
        return this.windowLSB.getSkyFrequencyLSB();
    }

    @Override
    public Frequency getSkyFrequencyUSB() {
        return this.windowLSB.getSkyFrequencyUSB();
    }

    @Override
    public Frequency getNominalBandwidth() {
        return this.windowLSB.getNominalBandwidth();
    }

    @Override
    public int getNominalNumberOfChannels() {
        return this.windowLSB.getNominalNumberOfChannels();
    }

    @Override
    public Frequency getEffectiveBandwidth() {
        return this.windowLSB.getEffectiveBandwidth();
    }

    @Override
    public int getEffectiveNumberOfChannels() {
        return this.windowLSB.getEffectiveNumberOfChannels();
    }

    @Override
    public Frequency getResolution() {
        return this.windowLSB.getResolution();
    }

    @Override
    public Frequency getEffectiveResolution() throws UnknownScalingFactorException {
        return this.windowLSB.getEffectiveResolution();
    }

    @Override
    public void setBandParameters(Frequency frequency, int n, SpectralWindowBand.ChannelType channelType) {
        this.windowLSB.setBandParameters(frequency, n, channelType);
        this.windowUSB.setBandParameters(frequency, n, channelType);
    }

    @Override
    public void setBandParameters(Frequency frequency, Frequency frequency2, SpectralWindowBand.ChannelType channelType) {
        this.windowLSB.setBandParameters(frequency, frequency2, channelType);
        this.windowUSB.setBandParameters(frequency, frequency2, channelType);
    }

    @Override
    public void updateSpectralWindowBand() {
        this.windowLSB.updateSpectralWindowBand();
        this.windowUSB.updateSpectralWindowBand();
    }

    @Override
    public String getPolnProducts() {
        return this.windowLSB.getPolnProducts();
    }

    @Override
    public void setPolnProducts(String string) {
        this.windowLSB.setPolnProducts(string);
        this.windowUSB.setPolnProducts(string);
    }

    @Override
    public int getSpectralAveragingFactor() {
        return this.windowLSB.getSpectralAveragingFactor();
    }

    public int getSpectralAveragingFactorUSB() {
        return this.windowUSB.getSpectralAveragingFactor();
    }

    public int getSpectralAveragingFactorLSB() {
        return this.windowLSB.getSpectralAveragingFactor();
    }

    @Override
    public void setSpectralAveragingFactor(int n) {
        this.windowLSB.setSpectralAveragingFactor(n);
        this.windowUSB.setSpectralAveragingFactor(n);
    }

    public void setSpectralAveragingFactorLSB(int n) {
        this.windowLSB.setSpectralAveragingFactor(n);
    }

    public void setSpectralAveragingFactorUSB(int n) {
        this.windowUSB.setSpectralAveragingFactor(n);
    }

    @Override
    public String getWindowFunction() {
        return this.windowLSB.getWindowFunction();
    }

    @Override
    public void setWindowFunction(String string) {
        this.windowLSB.setWindowFunction(string);
        this.windowUSB.setWindowFunction(string);
    }

    public void setCorrConfigMode(int n) {
        this.windowLSB.setCorrConfigMode(n);
        this.windowUSB.setCorrConfigMode(n);
    }

    @Override
    public void setCorrConfigMode(CorrConfigMode corrConfigMode) {
        this.windowLSB.setCorrConfigMode(corrConfigMode);
        this.windowUSB.setCorrConfigMode(corrConfigMode);
    }

    @Override
    public CorrConfigMode getCorrConfigMode() {
        return this.windowLSB.getCorrConfigMode();
    }

    @Override
    public void publishCorrConfigMode() {
        this.windowLSB.publishCorrConfigMode();
        this.windowUSB.publishCorrConfigMode();
    }

    @Override
    public Frequency getOmegaIF2() {
        Frequency frequency = this.getCenterFrequency();
        Frequency frequency2 = (Frequency)frequency.minus((AbstractDoubleWithUnit)centerFrequencyOffset);
        return (Frequency)omega_s.minus((AbstractDoubleWithUnit)frequency2);
    }

    @Override
    public final boolean isPair() {
        return true;
    }

    @Override
    public int getSpectralWindowIndex() {
        return this.bbc.findSpectralWindow(this);
    }

    @Override
    public AbstractSpectralWindow getSingleSpectralWindow() {
        return this.windowLSB;
    }

    @Override
    public DataRate getInstantaneousDataRate() {
        DataRate dataRate = this.windowLSB.getInstantaneousDataRate();
        DataRate dataRate2 = this.windowUSB.getInstantaneousDataRate();
        return (DataRate)dataRate.plus((AbstractDoubleWithUnit)dataRate2);
    }

    @Override
    public Set<CorrConfigMode> getApplicableModeSet() {
        return this.windowLSB.getApplicableModeSet();
    }

    @Override
    public boolean changeSideBandUse(SideBandUse sideBandUse) {
        if (this.isValidSideBandUseChoice(sideBandUse)) {
            this.windowLSB.setUseThisSpectralWindow(sideBandUse.usesLSB());
            this.windowUSB.setUseThisSpectralWindow(sideBandUse.usesUSB());
            return true;
        }
        return false;
    }

    @Override
    public SideBandUse getSideBandUse() {
        return SideBandUse.getSideBandUse(this.windowLSB.getUseThisSpectralWindow(), this.windowUSB.getUseThisSpectralWindow());
    }

    @Override
    public boolean isValidSideBandUseChoice(SideBandUse sideBandUse) {
        return this.isValidSideBandUseChoice(sideBandUse, null);
    }

    @Override
    public boolean isValidSideBandUseChoice(SideBandUse sideBandUse, Velocity velocity) {
        switch (sideBandUse) {
            case SIDEBANDUSE_NONE: {
                return false;
            }
        }
        return true;
    }

    @Override
    public void updateSideband() {
        this.changeSideBandUse(this.getSideBandUse());
    }

    @Override
    public void updateSideband(Velocity velocity) {
        this.updateSideband();
    }

    @Override
    public int getChannelAverageRegionCount() {
        return this.carManager.count();
    }

    @Override
    public ChannelAverageRegion getChannelAverageRegion(int n) {
        return this.carManager.get(n);
    }

    @Override
    public void addChannelAverageRegion(int n, ChannelAverageRegion channelAverageRegion) {
        this.carManager.add(n, channelAverageRegion);
        this.updateChannelAverageRegion(SpectralSpec.SideBand.LSB);
        this.updateChannelAverageRegion(SpectralSpec.SideBand.USB);
    }

    @Override
    public boolean removeChannelAverageRegion(ChannelAverageRegion channelAverageRegion) {
        boolean bl = this.carManager.remove(channelAverageRegion);
        this.updateChannelAverageRegion(SpectralSpec.SideBand.LSB);
        this.updateChannelAverageRegion(SpectralSpec.SideBand.USB);
        return bl;
    }

    public void setChannelAverageRegionUse(int n, SideBandUse sideBandUse) {
        this.carManager.setSideBandUse(n, sideBandUse);
        this.updateChannelAverageRegion(SpectralSpec.SideBand.LSB);
        this.updateChannelAverageRegion(SpectralSpec.SideBand.USB);
    }

    public void setAllChannelAverageRegionUseToBoth() {
        for (int i = 0; i < this.carManager.count(); ++i) {
            this.carManager.setSideBandUse(i, SideBandUse.SIDEBANDUSE_BOTH);
        }
        this.updateChannelAverageRegion(SpectralSpec.SideBand.LSB);
        this.updateChannelAverageRegion(SpectralSpec.SideBand.USB);
    }

    public SideBandUse getChannelAverageRegionUse(int n) {
        return this.carManager.getSideBandUse(n);
    }

    private void updateChannelAverageRegion(SpectralSpec.SideBand sideBand) {
        AbstractSpectralWindow abstractSpectralWindow = sideBand == SpectralSpec.SideBand.LSB ? this.windowLSB : this.windowUSB;
        abstractSpectralWindow.clearChannelAverageRegion();
        for (int i = 0; i < this.carManager.count(); ++i) {
            if (!this.carManager.getSideBandUse(i).uses(sideBand)) continue;
            abstractSpectralWindow.addChannelAverageRegion(this.carManager.get(i));
        }
    }

    private void refreshChannelAverageRegionManager() {
        SpectralWindowPairChannelAverageRegionManager spectralWindowPairChannelAverageRegionManager = new SpectralWindowPairChannelAverageRegionManager(this.windowLSB.getChannelAverageRegion(), SpectralSpec.SideBand.LSB);
        SpectralWindowPairChannelAverageRegionManager spectralWindowPairChannelAverageRegionManager2 = new SpectralWindowPairChannelAverageRegionManager(this.windowUSB.getChannelAverageRegion(), SpectralSpec.SideBand.USB);
        this.carManager = SpectralWindowPairChannelAverageRegionManager.merge(spectralWindowPairChannelAverageRegionManager, spectralWindowPairChannelAverageRegionManager2);
    }

    @Override
    public void addExpectedRestFrequencySpectralLine(ExpectedSpectralLine expectedSpectralLine, SpectralSpec.SideBand sideBand) {
        AbstractSpectralWindow abstractSpectralWindow;
        if (expectedSpectralLine == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: line");
        }
        if (sideBand == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: sideband");
        }
        if (StringUtils.isEmpty((CharSequence)expectedSpectralLine.getSpatalogId())) {
            throw new IllegalArgumentException("Parameter line does not have a SID");
        }
        AbstractSpectralWindow abstractSpectralWindow2 = abstractSpectralWindow = sideBand.equals((Object)SpectralSpec.SideBand.LSB) ? this.windowLSB : this.windowUSB;
        if (abstractSpectralWindow == null) {
            return;
        }
        Optional<SpectralLine> optional = Arrays.stream(abstractSpectralWindow.getSpectralLine()).filter(spectralLine -> spectralLine.getSpatalogId().equals(expectedSpectralLine.getSpatalogId())).findFirst();
        if (!optional.isPresent()) {
            SpectralLine spectralLine2 = SpectralLine.createSpectralLine();
            spectralLine2.setSpatalogId(expectedSpectralLine.getSpatalogId());
            spectralLine2.setRestFrequency(expectedSpectralLine.getRestFrequency().deepCopy());
            spectralLine2.setTransition(expectedSpectralLine.getTransition());
            abstractSpectralWindow.addSpectralLine(spectralLine2);
        }
    }
}

