/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.schedblock;

import alma.entity.xmlbinding.schedblock.TargetT;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.annotations.AddableToSubSBCollection;
import alma.obsprep.bo.annotations.AttachableToTarget;
import alma.obsprep.bo.annotations.ObsUnitSetComponent;
import alma.obsprep.bo.annotations.SpatialDocument;
import alma.obsprep.bo.annotations.SpatialPartOfSpatialDocument;
import alma.obsprep.bo.annotations.SpatialPartOfSpectralSpecDocument;
import alma.obsprep.bo.annotations.SpectralSpecDocument;
import alma.obsprep.bo.annotations.TargetContext;
import alma.obsprep.bo.obsproject.ObsUnitSet;
import alma.obsprep.bo.schedblock.AbstractInstrumentSpec;
import alma.obsprep.bo.schedblock.AmplitudeCalParameters;
import alma.obsprep.bo.schedblock.AtmosphericCalParameters;
import alma.obsprep.bo.schedblock.BandpassCalParameters;
import alma.obsprep.bo.schedblock.CheckSourceCalParameters;
import alma.obsprep.bo.schedblock.DelayCalParameters;
import alma.obsprep.bo.schedblock.FieldSource;
import alma.obsprep.bo.schedblock.FocusCalParameters;
import alma.obsprep.bo.schedblock.ObservingGroup;
import alma.obsprep.bo.schedblock.ObservingParameters;
import alma.obsprep.bo.schedblock.OpticalCameraSpec;
import alma.obsprep.bo.schedblock.OpticalPointingParameters;
import alma.obsprep.bo.schedblock.OrderedTarget;
import alma.obsprep.bo.schedblock.PhaseCalParameters;
import alma.obsprep.bo.schedblock.PointingCalParameters;
import alma.obsprep.bo.schedblock.PolarizationCalParameters;
import alma.obsprep.bo.schedblock.RadiometricPointingParameters;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.ScienceParameters;
import alma.obsprep.bo.schedblock.SidebandRatioCalParameters;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.data.TargetData;
import alma.obsprep.ot.actions.AddInteractor;
import alma.obsprep.ot.editors.misc.TargetSummaryTableColumns;
import alma.obsprep.ot.models.misc.SummaryTableColumns;
import alma.obsprep.ot.models.misc.SummaryTableRow;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.valuetypes.Frequency;
import alma.valuetypes.Velocity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.TreeSet;
import java.util.function.Supplier;

public class Target
extends TargetData
implements AddableToSubSBCollection,
ObsUnitSetComponent,
SpectralSpecDocument,
SpatialDocument,
TargetContext,
SummaryTableRow {
    public static final Supplier<? extends Exception> UnableToFindScienceParametersException = () -> new WizardSBGenerationException("Unable to find science parameters in target");
    protected SummaryTableColumns summaryTableColumns = new TargetSummaryTableColumns(this);
    private final List<Integer> intendedObservingGroupList = new ArrayList<Integer>();
    public static final String OBSMODE_SINGLE = "Single Field per Target";
    public static final String OBSMODE_STANDARD_MOSAIC = "Standard Offset Mosaic";
    public static final String OBSMODE_OTF_INTERFEROMETRIC_MOSAIC = "OTF Interferometric Mosaic";

    public String toString() {
        String string = "Target: " + this.getFieldSource().getSourceName();
        Optional<ScienceParameters> optional = this.getFirstScienceParameters();
        if (optional.isPresent()) {
            ScienceParameters scienceParameters = this.getFirstScienceParameters().get();
            string = string + " ITOS " + scienceParameters.getIntegrationTime().getSecs() + " subscan duration " + scienceParameters.getSubScanDuration();
        }
        return string;
    }

    public Target(TargetT targetT) {
        super(targetT);
    }

    @Override
    public SpectralSpec getSpectralSpec() {
        try {
            return (SpectralSpec)((Object)this.getAbstractInstrumentSpec());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public OpticalCameraSpec getOpticalCameraSpec() {
        try {
            return (OpticalCameraSpec)((Object)this.getAbstractInstrumentSpec());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setSpectralSpec(SpectralSpec spectralSpec) {
        this.setAbstractInstrumentSpec((AbstractInstrumentSpec)((Object)spectralSpec));
    }

    public void setOpticalCameraSpec(OpticalCameraSpec opticalCameraSpec) {
        this.setAbstractInstrumentSpec((AbstractInstrumentSpec)((Object)opticalCameraSpec));
    }

    public List<AttachableToTarget> attachedObjects() {
        ArrayList<AttachableToTarget> arrayList = new ArrayList<AttachableToTarget>();
        SchedBlock schedBlock = (SchedBlock)this.getParent();
        if (schedBlock == null) {
            return arrayList;
        }
        this.addToCollection(arrayList, this.getFieldSource());
        this.addToCollection(arrayList, this.getAbstractInstrumentSpec());
        this.addToCollection(arrayList, this.getObservingParameters());
        return arrayList;
    }

    public String toTreeString(int n, boolean bl, boolean bl2) {
        String string;
        String string2;
        FieldSource fieldSource = this.getFieldSource();
        if (fieldSource == null) {
            string2 = this.getNameOrDefault();
            string = "";
        } else {
            string2 = this.getFieldSource().getSourceName();
            if (string2.equals("")) {
                string2 = this.getNameOrDefault();
            }
            string = this.getFieldSource().getName();
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isRepresentativeTarget()) {
            stringBuffer.append("[R] ");
        }
        boolean bl3 = false;
        SchedBlock schedBlock = this.getSchedBlock();
        StringBuffer stringBuffer2 = new StringBuffer();
        if (schedBlock != null) {
            for (ObservingGroup observingGroup : schedBlock.getObservingGroup()) {
                Target target = observingGroup.getMainTarget();
                if (target == null || !target.equals(this)) continue;
                stringBuffer2.append(observingGroup.getIndex());
                bl3 = true;
            }
        } else {
            Log.logger(Target.class).warning("Unable to find SB associated with target: " + string2);
        }
        if (bl3) {
            stringBuffer.append("[D" + stringBuffer2 + "] ");
        }
        stringBuffer.append(string2);
        stringBuffer.append(" ");
        stringBuffer.append(string);
        if (!bl2) {
            stringBuffer.append(this.briefDescription());
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - void declaration
     */
    public String briefDescription() {
        if (this.getObservingParametersCount() == 0) {
            return "";
        }
        TreeSet<ObservingParameters> treeSet = new TreeSet<ObservingParameters>((observingParameters, observingParameters2) -> observingParameters.getSummaryPriority() - observingParameters2.getSummaryPriority());
        for (ObservingParameters observingParameters3 : this.getObservingParameters()) {
            treeSet.add(observingParameters3);
        }
        String string = " (";
        StringBuilder stringBuilder = new StringBuilder();
        for (ObservingParameters observingParameters3 : treeSet) {
            void var2_4;
            stringBuilder.append((String)var2_4);
            stringBuilder.append(observingParameters3.getSummaryName());
            String string2 = ", ";
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    public boolean isSpectral() {
        return this.getObservingParametersCount() != 0 && this.getFieldSource() != null && this.getAbstractInstrumentSpec() != null;
    }

    public boolean isSpatial() {
        return this.getObservingParametersCount() != 0 && this.getFieldSource() != null && this.getAbstractInstrumentSpec() != null;
    }

    public boolean isRepresentativeTarget() {
        SchedBlock schedBlock = this.getSchedBlock();
        return this == schedBlock.getSchedulingConstraints().getRepresentativeTarget();
    }

    public boolean isOpticalPointingTarget() {
        AbstractInstrumentSpec abstractInstrumentSpec = this.getAbstractInstrumentSpec();
        return abstractInstrumentSpec != null && abstractInstrumentSpec.isOpticalCameraSpec();
    }

    public boolean isRadiometricPointingTarget() {
        return false;
    }

    public Velocity getSourceVelocity() {
        return this.getFieldSource().getSourceVelocity();
    }

    public SchedBlock getSchedBlock() {
        SchedBlock schedBlock = (SchedBlock)this.getParent();
        return schedBlock;
    }

    public ObservingParameters getObservingParameters(AddInteractor.ObjectType objectType) {
        int n = this.getObservingParametersCount(objectType);
        switch (objectType) {
            case SCIENCEPARAMETERS: {
                return n > 0 ? this.getScienceParametersList()[0] : null;
            }
            case PHASECALPARAMETERS: {
                return n > 0 ? this.getPhaseCalParametersList()[0] : null;
            }
            case POINTINGCALPARAMETERS: {
                return n > 0 ? this.getPointingCalParametersList()[0] : null;
            }
            case AMPLITUDECALPARAMETERS: {
                return n > 0 ? this.getAmplitudeCalParametersList()[0] : null;
            }
            case POLARIZATIONCALPARAMETERS: {
                return n > 0 ? this.getPolarizationCalParametersList()[0] : null;
            }
            case FOCUSCALPARAMETERS: {
                return n > 0 ? this.getFocusCalParametersList()[0] : null;
            }
            case ATMOSPHERICCALPARAMETERS: {
                return n > 0 ? this.getAtmosphericCalParametersList()[0] : null;
            }
            case DELAYCALPARAMETERS: {
                return n > 0 ? this.getDelayCalParametersList()[0] : null;
            }
            case CHECKSOURCECALPARAMETERS: {
                return n > 0 ? this.getCheckSourceCalParametersList()[0] : null;
            }
            case SIDEBANDRATIOCALPARAMETERS: {
                return n > 0 ? this.getSidebandRatioCalParametersList()[0] : null;
            }
            case BANDPASSCALPARAMETERS: {
                return n > 0 ? this.getBandpassCalParametersList()[0] : null;
            }
            case OPTICALPOINTINGPARAMETERS: {
                return n > 0 ? this.getOpticalPointingParametersList()[0] : null;
            }
            case RADIOMETRICPOINTINGPARAMETERS: {
                return n > 0 ? this.getRadiometricPointingParametersList()[0] : null;
            }
        }
        throw new RuntimeException("Unknown parameter type : " + (Object)((Object)objectType));
    }

    public int getObservingParametersCount(AddInteractor.ObjectType objectType) {
        switch (objectType) {
            case SCIENCEPARAMETERS: {
                return this.getScienceParametersList().length;
            }
            case PHASECALPARAMETERS: {
                return this.getPhaseCalParametersList().length;
            }
            case POINTINGCALPARAMETERS: {
                return this.getPointingCalParametersList().length;
            }
            case AMPLITUDECALPARAMETERS: {
                return this.getAmplitudeCalParametersList().length;
            }
            case POLARIZATIONCALPARAMETERS: {
                return this.getPolarizationCalParametersList().length;
            }
            case FOCUSCALPARAMETERS: {
                return this.getFocusCalParametersList().length;
            }
            case ATMOSPHERICCALPARAMETERS: {
                return this.getAtmosphericCalParametersList().length;
            }
            case DELAYCALPARAMETERS: {
                return this.getDelayCalParametersList().length;
            }
            case CHECKSOURCECALPARAMETERS: {
                return this.getCheckSourceCalParametersList().length;
            }
            case SIDEBANDRATIOCALPARAMETERS: {
                return this.getSidebandRatioCalParametersList().length;
            }
            case BANDPASSCALPARAMETERS: {
                return this.getBandpassCalParametersList().length;
            }
            case OPTICALPOINTINGPARAMETERS: {
                return this.getOpticalPointingParametersList().length;
            }
            case RADIOMETRICPOINTINGPARAMETERS: {
                return this.getRadiometricPointingParametersList().length;
            }
        }
        throw new RuntimeException("Unknown parameter type : " + (Object)((Object)objectType));
    }

    public AbstractInstrumentSpec getInstrumentSpec() {
        Object object = this.getSpectralSpec();
        if (object == null) {
            object = this.getOpticalCameraSpec();
        }
        return object;
    }

    public Optional<ScienceParameters> getFirstScienceParameters() {
        for (ObservingParameters observingParameters : this.getObservingParameters()) {
            try {
                return Optional.of((ScienceParameters)((Object)observingParameters));
            }
            catch (ClassCastException classCastException) {
            }
        }
        return Optional.empty();
    }

    public Optional<AmplitudeCalParameters> getFirstAmplitudeCalParameters() {
        for (ObservingParameters observingParameters : this.getObservingParameters()) {
            try {
                return Optional.of((AmplitudeCalParameters)((Object)observingParameters));
            }
            catch (ClassCastException classCastException) {
            }
        }
        return Optional.empty();
    }

    public Optional<CheckSourceCalParameters> getFirstCheckSourceCalParameters() {
        for (ObservingParameters observingParameters : this.getObservingParameters()) {
            try {
                return Optional.of((CheckSourceCalParameters)((Object)observingParameters));
            }
            catch (ClassCastException classCastException) {
            }
        }
        return Optional.empty();
    }

    public Optional<BandpassCalParameters> getFirstBandpassCalParameters() {
        for (ObservingParameters observingParameters : this.getObservingParameters()) {
            try {
                return Optional.of((BandpassCalParameters)((Object)observingParameters));
            }
            catch (ClassCastException classCastException) {
            }
        }
        return Optional.empty();
    }

    public Optional<DelayCalParameters> getFirstDelayCalParameters() {
        for (ObservingParameters observingParameters : this.getObservingParameters()) {
            try {
                return Optional.of((DelayCalParameters)((Object)observingParameters));
            }
            catch (ClassCastException classCastException) {
            }
        }
        return Optional.empty();
    }

    public Optional<PhaseCalParameters> getFirstPhaseCalParameters() {
        for (ObservingParameters observingParameters : this.getObservingParameters()) {
            try {
                return Optional.of((PhaseCalParameters)((Object)observingParameters));
            }
            catch (ClassCastException classCastException) {
            }
        }
        return Optional.empty();
    }

    public Optional<PointingCalParameters> getFirstPointCalParameters() {
        for (ObservingParameters observingParameters : this.getObservingParameters()) {
            try {
                return Optional.of((PointingCalParameters)((Object)observingParameters));
            }
            catch (ClassCastException classCastException) {
            }
        }
        return Optional.empty();
    }

    public Optional<PolarizationCalParameters> getFirstPolarizationCalParameters() {
        for (ObservingParameters observingParameters : this.getObservingParameters()) {
            try {
                return Optional.of((PolarizationCalParameters)((Object)observingParameters));
            }
            catch (ClassCastException classCastException) {
            }
        }
        return Optional.empty();
    }

    public ScienceParameters[] getScienceParametersList() {
        ArrayList<ScienceParameters> arrayList = new ArrayList<ScienceParameters>();
        for (ObservingParameters observingParameters : this.getObservingParameters()) {
            try {
                arrayList.add((ScienceParameters)((Object)observingParameters));
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return arrayList.toArray(new ScienceParameters[arrayList.size()]);
    }

    public Collection<ScienceParameters> getScienceParametersCollection() {
        ArrayList<ScienceParameters> arrayList = new ArrayList<ScienceParameters>();
        for (ObservingParameters observingParameters : this.getObservingParameters()) {
            try {
                arrayList.add((ScienceParameters)((Object)observingParameters));
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return arrayList;
    }

    public boolean hasScienceParameters() {
        for (ObservingParameters observingParameters : this.getObservingParameters()) {
            if (!observingParameters.isScienceParameters()) continue;
            return true;
        }
        return false;
    }

    public static boolean isTargetWithScienceParameters(Object object) {
        return object instanceof Target && ((Target)object).hasScienceParameters();
    }

    public PhaseCalParameters[] getPhaseCalParametersList() {
        ArrayList<PhaseCalParameters> arrayList = new ArrayList<PhaseCalParameters>();
        for (ObservingParameters observingParameters : this.getObservingParameters()) {
            try {
                arrayList.add((PhaseCalParameters)((Object)observingParameters));
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return arrayList.toArray(new PhaseCalParameters[arrayList.size()]);
    }

    public boolean hasPhaseCalParameters() {
        for (ObservingParameters observingParameters : this.getObservingParameters()) {
            if (!observingParameters.isPhaseCalParameters()) continue;
            return true;
        }
        return false;
    }

    public AmplitudeCalParameters[] getAmplitudeCalParametersList() {
        ArrayList<AmplitudeCalParameters> arrayList = new ArrayList<AmplitudeCalParameters>();
        for (ObservingParameters observingParameters : this.getObservingParameters()) {
            try {
                arrayList.add((AmplitudeCalParameters)((Object)observingParameters));
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return arrayList.toArray(new AmplitudeCalParameters[arrayList.size()]);
    }

    public boolean hasAmplitudeCalParameters() {
        for (ObservingParameters observingParameters : this.getObservingParameters()) {
            if (!observingParameters.isAmplitudeCalParameters()) continue;
            return true;
        }
        return false;
    }

    public PointingCalParameters[] getPointingCalParametersList() {
        ArrayList<PointingCalParameters> arrayList = new ArrayList<PointingCalParameters>();
        for (ObservingParameters observingParameters : this.getObservingParameters()) {
            try {
                arrayList.add((PointingCalParameters)((Object)observingParameters));
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return arrayList.toArray(new PointingCalParameters[arrayList.size()]);
    }

    public boolean hasPointingCalParameters() {
        for (ObservingParameters observingParameters : this.getObservingParameters()) {
            if (!observingParameters.isPointingCalParameters()) continue;
            return true;
        }
        return false;
    }

    public PolarizationCalParameters[] getPolarizationCalParametersList() {
        ArrayList<PolarizationCalParameters> arrayList = new ArrayList<PolarizationCalParameters>();
        for (ObservingParameters observingParameters : this.getObservingParameters()) {
            try {
                arrayList.add((PolarizationCalParameters)((Object)observingParameters));
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return arrayList.toArray(new PolarizationCalParameters[arrayList.size()]);
    }

    public boolean hasPolarizationCalParameters() {
        for (ObservingParameters observingParameters : this.getObservingParameters()) {
            if (!observingParameters.isPolarizationCalParameters()) continue;
            return true;
        }
        return false;
    }

    public FocusCalParameters[] getFocusCalParametersList() {
        ArrayList<FocusCalParameters> arrayList = new ArrayList<FocusCalParameters>();
        for (ObservingParameters observingParameters : this.getObservingParameters()) {
            try {
                arrayList.add((FocusCalParameters)((Object)observingParameters));
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return arrayList.toArray(new FocusCalParameters[arrayList.size()]);
    }

    public boolean hasFocusCalParameters() {
        for (ObservingParameters observingParameters : this.getObservingParameters()) {
            if (!observingParameters.isFocusCalParameters()) continue;
            return true;
        }
        return false;
    }

    public boolean hasHolographyParameters() {
        for (ObservingParameters observingParameters : this.getObservingParameters()) {
            if (!observingParameters.isHolographyParameters()) continue;
            return true;
        }
        return false;
    }

    public AtmosphericCalParameters[] getAtmosphericCalParametersList() {
        ArrayList<AtmosphericCalParameters> arrayList = new ArrayList<AtmosphericCalParameters>();
        for (ObservingParameters observingParameters : this.getObservingParameters()) {
            try {
                arrayList.add((AtmosphericCalParameters)((Object)observingParameters));
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return arrayList.toArray(new AtmosphericCalParameters[arrayList.size()]);
    }

    public boolean hasAtmosphericCalParameters() {
        for (ObservingParameters observingParameters : this.getObservingParameters()) {
            if (!observingParameters.isAtmosphericCalParameters()) continue;
            return true;
        }
        return false;
    }

    public CheckSourceCalParameters[] getCheckSourceCalParametersList() {
        ArrayList<CheckSourceCalParameters> arrayList = new ArrayList<CheckSourceCalParameters>();
        for (ObservingParameters observingParameters : this.getObservingParameters()) {
            try {
                arrayList.add((CheckSourceCalParameters)((Object)observingParameters));
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return arrayList.toArray(new CheckSourceCalParameters[arrayList.size()]);
    }

    public DelayCalParameters[] getDelayCalParametersList() {
        ArrayList<DelayCalParameters> arrayList = new ArrayList<DelayCalParameters>();
        for (ObservingParameters observingParameters : this.getObservingParameters()) {
            try {
                arrayList.add((DelayCalParameters)((Object)observingParameters));
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return arrayList.toArray(new DelayCalParameters[arrayList.size()]);
    }

    public boolean hasDelayCalParameters() {
        for (ObservingParameters observingParameters : this.getObservingParameters()) {
            if (!observingParameters.isDelayCalParameters()) continue;
            return true;
        }
        return false;
    }

    public boolean hasCheckSourceCalParameters() {
        for (ObservingParameters observingParameters : this.getObservingParameters()) {
            if (!observingParameters.isCheckSourceCalParameters()) continue;
            return true;
        }
        return false;
    }

    public SidebandRatioCalParameters[] getSidebandRatioCalParametersList() {
        ArrayList<SidebandRatioCalParameters> arrayList = new ArrayList<SidebandRatioCalParameters>();
        for (ObservingParameters observingParameters : this.getObservingParameters()) {
            try {
                arrayList.add((SidebandRatioCalParameters)((Object)observingParameters));
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return arrayList.toArray(new SidebandRatioCalParameters[arrayList.size()]);
    }

    public boolean hasSidebandRatioCalParameters() {
        for (ObservingParameters observingParameters : this.getObservingParameters()) {
            if (!observingParameters.isSidebandRatioCalParameters()) continue;
            return true;
        }
        return false;
    }

    public BandpassCalParameters[] getBandpassCalParametersList() {
        ArrayList<BandpassCalParameters> arrayList = new ArrayList<BandpassCalParameters>();
        for (ObservingParameters observingParameters : this.getObservingParameters()) {
            try {
                arrayList.add((BandpassCalParameters)((Object)observingParameters));
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return arrayList.toArray(new BandpassCalParameters[arrayList.size()]);
    }

    public boolean hasBandpassCalParameters() {
        for (ObservingParameters observingParameters : this.getObservingParameters()) {
            if (!observingParameters.isBandpassCalParameters()) continue;
            return true;
        }
        return false;
    }

    public OpticalPointingParameters[] getOpticalPointingParametersList() {
        ArrayList<OpticalPointingParameters> arrayList = new ArrayList<OpticalPointingParameters>();
        for (ObservingParameters observingParameters : this.getObservingParameters()) {
            try {
                arrayList.add((OpticalPointingParameters)((Object)observingParameters));
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return arrayList.toArray(new OpticalPointingParameters[arrayList.size()]);
    }

    public boolean hasOpticalPointingParameters() {
        for (ObservingParameters observingParameters : this.getObservingParameters()) {
            if (!observingParameters.isOpticalPointingParameters()) continue;
            return true;
        }
        return false;
    }

    public boolean hasTheParameters(ObservingParameters observingParameters) {
        for (ObservingParameters observingParameters2 : this.getObservingParameters()) {
            if (observingParameters2 != observingParameters) continue;
            return true;
        }
        return false;
    }

    public RadiometricPointingParameters[] getRadiometricPointingParametersList() {
        ArrayList<RadiometricPointingParameters> arrayList = new ArrayList<RadiometricPointingParameters>();
        for (ObservingParameters observingParameters : this.getObservingParameters()) {
            try {
                arrayList.add((RadiometricPointingParameters)((Object)observingParameters));
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return arrayList.toArray(new RadiometricPointingParameters[arrayList.size()]);
    }

    public boolean hasRadiometricPointingParameters() {
        for (ObservingParameters observingParameters : this.getObservingParameters()) {
            if (!observingParameters.isRadiometricPointingParameters()) continue;
            return true;
        }
        return false;
    }

    public void addScienceParameters(ScienceParameters scienceParameters) {
        this.addObservingParameters((ObservingParameters)((Object)scienceParameters));
    }

    public void addDelayCalParameters(DelayCalParameters delayCalParameters) {
        this.addObservingParameters((ObservingParameters)((Object)delayCalParameters));
    }

    public void addCheckSourceCalParameters(CheckSourceCalParameters checkSourceCalParameters) {
        this.addObservingParameters((ObservingParameters)((Object)checkSourceCalParameters));
    }

    public void addSidebandRatioCalParameters(SidebandRatioCalParameters sidebandRatioCalParameters) {
        this.addObservingParameters((ObservingParameters)((Object)sidebandRatioCalParameters));
    }

    public void addPhaseCalParameters(PhaseCalParameters phaseCalParameters) {
        this.addObservingParameters((ObservingParameters)((Object)phaseCalParameters));
    }

    public void addAmplitudeCalParameters(AmplitudeCalParameters amplitudeCalParameters) {
        this.addObservingParameters((ObservingParameters)((Object)amplitudeCalParameters));
    }

    public void addAtmosphericCalParameters(AtmosphericCalParameters atmosphericCalParameters) {
        this.addObservingParameters((ObservingParameters)((Object)atmosphericCalParameters));
    }

    public void addPointingCalParameters(PointingCalParameters pointingCalParameters) {
        this.addObservingParameters((ObservingParameters)((Object)pointingCalParameters));
    }

    public void addPolarizationCalParameters(PolarizationCalParameters polarizationCalParameters) {
        this.addObservingParameters((ObservingParameters)((Object)polarizationCalParameters));
    }

    public void addFocusCalParameters(FocusCalParameters focusCalParameters) {
        this.addObservingParameters((ObservingParameters)((Object)focusCalParameters));
    }

    public void addBandpassCalParameters(BandpassCalParameters bandpassCalParameters) {
        this.addObservingParameters((ObservingParameters)((Object)bandpassCalParameters));
    }

    public void addOpticalPointingParameters(OpticalPointingParameters opticalPointingParameters) {
        this.addObservingParameters((ObservingParameters)((Object)opticalPointingParameters));
    }

    public void addRadiometricPointingParameters(RadiometricPointingParameters radiometricPointingParameters) {
        this.addObservingParameters((ObservingParameters)((Object)radiometricPointingParameters));
    }

    @Override
    public ObsUnitSet getContainingObsUnitSet() {
        ObsUnitSetComponent obsUnitSetComponent = (ObsUnitSetComponent)this.getParent();
        return obsUnitSetComponent.getContainingObsUnitSet();
    }

    @Override
    public SpatialPartOfSpectralSpecDocument getSpatialPartOfSpectralSpecDocument() {
        return this.getFieldSource();
    }

    @Override
    public SpatialPartOfSpatialDocument getSpatialPartOfSpatialDocument() {
        return this.getFieldSource();
    }

    @Override
    public Frequency getSingleFrequency() {
        SchedBlock schedBlock = this.getSchedBlock();
        if (schedBlock == null) {
            return null;
        }
        return schedBlock.getSchedulingConstraints().getRepresentativeFrequency();
    }

    @Override
    public String getSingleFrequencySource() {
        SchedBlock schedBlock = this.getSchedBlock();
        if (schedBlock == null) {
            return null;
        }
        return schedBlock.getSchedulingConstraints().getNameOrDefault() + ":representativeFrequency";
    }

    public Integer[] getIntendedObservingGroupList() {
        Collections.sort(this.intendedObservingGroupList);
        return this.intendedObservingGroupList.toArray(new Integer[0]);
    }

    public void clearIntendedObservingGroupList() {
        this.intendedObservingGroupList.clear();
    }

    public void addToIntendedObservingGroupList(Integer n) {
        this.intendedObservingGroupList.add(n);
    }

    public ObservingGroup[] getObservingGroupList() {
        SchedBlock schedBlock = (SchedBlock)this.getParent();
        if (schedBlock == null) {
            return null;
        }
        ArrayList<ObservingGroup> arrayList = new ArrayList<ObservingGroup>();
        for (ObservingGroup observingGroup : schedBlock.getObservingGroup()) {
            for (OrderedTarget orderedTarget : observingGroup.getOrderedTarget()) {
                if (orderedTarget.getTarget() != this) continue;
                arrayList.add(observingGroup);
            }
        }
        return arrayList.toArray(new ObservingGroup[arrayList.size()]);
    }

    public int getUsedCount() {
        ObservingGroup[] observingGroupArray = this.getObservingGroupList();
        if (observingGroupArray == null) {
            return 0;
        }
        return observingGroupArray.length;
    }

    @Override
    public SummaryTableColumns getSummaryTableColumns() {
        return this.summaryTableColumns;
    }
}

