/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.guiutil.jsky.catalog.astrocat;

import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.guiutil.jsky.catalog.astrocat.AlmaAstroCatXML;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Vector;
import jsky.catalog.BasicQueryArgs;
import jsky.catalog.Catalog;
import jsky.catalog.CatalogDirectory;
import jsky.catalog.FieldDesc;
import jsky.catalog.FieldDescAdapter;
import jsky.catalog.HTMLQueryResultHandler;
import jsky.catalog.QueryArgs;
import jsky.catalog.QueryResult;
import jsky.catalog.SearchCondition;
import jsky.catalog.TablePlotSymbol;
import jsky.catalog.TableQueryResult;
import jsky.catalog.URLQueryResult;
import jsky.catalog.astrocat.AstroCatConfig;
import jsky.catalog.astrocat.AstroCatTable;
import jsky.catalog.astrocat.AstroCatalog;
import jsky.coords.CoordinateRadius;
import jsky.coords.Coordinates;
import jsky.coords.DMS;
import jsky.coords.HMS;
import jsky.coords.WorldCoords;
import jsky.util.NameValue;
import jsky.util.Resources;
import jsky.util.StringUtil;
import jsky.util.gui.ProgressBarFilterInputStream;
import jsky.util.gui.ProgressPanel;

public class AlmaAstroCatalog
extends AstroCatalog {
    static final String OBJECT = "Object";
    static final String NAME_SERVER = "Name Server";
    static final String RA = "RA";
    static final String DEC = "Dec";
    static final String EQUINOX = "Equinox";
    static final String RADIUS = "Radius";
    static final String MIN_RADIUS = "Min Radius";
    static final String MAX_RADIUS = "Max Radius";
    static final String SIZE = "Size";
    static final String WIDTH = "Width";
    static final String HEIGHT = "Height";
    static final String SELECT = "Select";
    static final String MAX_OBJECTS = "Max Objects";
    private static final String J2000 = "2000";
    private static final String B1950 = "1950";
    private static NameValue[] _equinoxOptions = new NameValue[]{new NameValue("J2000", (Object)"2000"), new NameValue("B1950", (Object)"1950")};
    private URL _url;
    private CatalogDirectory _parent;
    private String _id;
    private String _name;
    private String _description;
    private String _docURL;
    private String _type = "catalog";
    private String _protocol;
    private String _host;
    private int _port = 80;
    private String _path;
    private String _handlerClass;
    private FieldDesc[] _paramDesc;
    private FieldDesc[] _dummyParamDesc;
    private TablePlotSymbol[] _symbols;
    private boolean _symbolsEdited = false;
    private HTMLQueryResultHandler _htmlQueryResultHandler;
    private ProgressPanel _progressPanel;
    private boolean _isCatalog = false;
    private boolean _isImageServer = false;

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public URL getURL() {
        return this._url;
    }

    public void setURL(URL uRL) {
        this._url = uRL;
    }

    public CatalogDirectory getParent() {
        return this._parent;
    }

    public void setParent(CatalogDirectory catalogDirectory) {
        this._parent = catalogDirectory;
    }

    public Catalog[] getPath() {
        if (this._parent == null) {
            return null;
        }
        return this._parent.getPath((Catalog)this);
    }

    public String toString() {
        return this.getName();
    }

    public void setId(String string) {
        this._id = string;
    }

    public String getId() {
        return this._id;
    }

    public void setName(String string) {
        this._name = string;
    }

    public String getName() {
        return this._name;
    }

    public void setDescription(String string) {
        this._description = string;
    }

    public String getDescription() {
        return this._description;
    }

    public void setDocURL(String string) {
        this._docURL = string;
    }

    public URL getDocURL() {
        try {
            return new URL(this._docURL);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setType(String string) {
        this._type = string;
        this._isCatalog = this._type.equals("catalog") || this._type.equals("archive") || this._type.equals("local");
        this._isImageServer = this._type.equals("imagesvr");
    }

    public String getType() {
        return this._type;
    }

    public void setProtocol(String string) {
        this._protocol = string;
    }

    public String getProtocol() {
        return this._protocol;
    }

    public void setHost(String string) {
        this._host = string;
    }

    public String getHost() {
        return this._host;
    }

    public void setPort(int n) {
        this._port = n;
    }

    public int getPort() {
        return this._port;
    }

    public void setURLPath(String string) {
        this._path = string;
    }

    public String getURLPath() {
        return this._path;
    }

    public void setParams(FieldDesc[] fieldDescArray) {
        this._paramDesc = fieldDescArray;
    }

    public void setSymbols(TablePlotSymbol[] tablePlotSymbolArray) {
        this._symbols = tablePlotSymbolArray;
    }

    public void setSymbolsEdited(boolean bl) {
        this._symbolsEdited = bl;
    }

    public boolean isSymbolsEdited() {
        return this._symbolsEdited;
    }

    public void saveSymbolConfig() {
        AstroCatConfig.getConfigFile().save();
    }

    public void setHandlerClass(String string) {
        this._handlerClass = string;
    }

    public String getHandlerClass() {
        return this._handlerClass;
    }

    public String getTitle() {
        return this._name;
    }

    public int getNumParams() {
        if (this._dummyParamDesc == null) {
            this._initSearchParameters();
        }
        return this._dummyParamDesc.length;
    }

    public FieldDesc getParamDesc(int n) {
        if (this._dummyParamDesc == null) {
            this._initSearchParameters();
        }
        return this._dummyParamDesc[n];
    }

    public FieldDesc getParamDesc(String string) {
        if (this._dummyParamDesc == null) {
            this._initSearchParameters();
        }
        for (int i = 0; i < this._dummyParamDesc.length; ++i) {
            if (this._dummyParamDesc[i] == null || !this._dummyParamDesc[i].getName().equals(string)) continue;
            return this._dummyParamDesc[i];
        }
        return null;
    }

    public int getNumSymbols() {
        if (this._symbols == null) {
            return 0;
        }
        return this._symbols.length;
    }

    public TablePlotSymbol getSymbolDesc(int n) {
        return this._symbols[n];
    }

    public TablePlotSymbol[] getSymbols() {
        return this._symbols;
    }

    public void setRegionArgs(QueryArgs queryArgs, CoordinateRadius coordinateRadius) {
        Coordinates coordinates = coordinateRadius.getCenterPosition();
        String string = (String)queryArgs.getParamValue(EQUINOX);
        double d = this._getEquinox(queryArgs);
        WorldCoords worldCoords = (WorldCoords)coordinates;
        String[] stringArray = worldCoords.format(d);
        queryArgs.setParamValue(RA, (Object)stringArray[0]);
        queryArgs.setParamValue(DEC, (Object)stringArray[1]);
        queryArgs.setParamValue(EQUINOX, (Object)string);
        queryArgs.setParamValue(RADIUS, coordinateRadius.getMaxRadius());
        queryArgs.setParamValue(MIN_RADIUS, coordinateRadius.getMinRadius());
        queryArgs.setParamValue(MAX_RADIUS, coordinateRadius.getMaxRadius());
        queryArgs.setParamValue(SIZE, coordinateRadius.getWidth());
        queryArgs.setParamValue(WIDTH, coordinateRadius.getWidth());
        queryArgs.setParamValue(HEIGHT, coordinateRadius.getHeight());
    }

    public boolean isLocal() {
        return this._type != null && this._type.equalsIgnoreCase("local") || this._protocol != null && this._protocol.equals("file");
    }

    public boolean isImageServer() {
        return this._type != null && this._type.equalsIgnoreCase("imagesvr");
    }

    public QueryResult query(QueryArgs queryArgs) throws IOException {
        if (this._dummyParamDesc == null) {
            this._initSearchParameters();
        }
        if (this._protocol == null || this._protocol.equalsIgnoreCase("http") || this._protocol.equalsIgnoreCase("https")) {
            return this._httpQuery(queryArgs);
        }
        throw new RuntimeException("Query not supported for this catalog type: " + this._protocol + ":" + this._type);
    }

    private void _setQueryRegion(QueryArgs queryArgs, SearchCondition[] searchConditionArray) throws IOException {
        WorldCoords worldCoords;
        double d;
        Object object;
        if (queryArgs.getRegion() != null || searchConditionArray == null || searchConditionArray.length == 0) {
            return;
        }
        String string = (String)queryArgs.getParamValue(OBJECT);
        if (string == null || string.length() == 0) {
            object = (String)queryArgs.getParamValue(RA);
            String string2 = (String)queryArgs.getParamValue(DEC);
            if (object == null || string2 == null) {
                return;
            }
            d = this._getEquinox(queryArgs);
            worldCoords = new WorldCoords((String)object, string2, d, true);
        } else {
            object = queryArgs.getParamValue(NAME_SERVER);
            if (!(object instanceof Catalog)) {
                throw new RuntimeException("No name server was specified");
            }
            worldCoords = this._resolveObjectName(string, (Catalog)object);
        }
        if (this._isCatalog) {
            if (this._findParamByType(this._paramDesc, "radius") != null) {
                object = (Double)queryArgs.getParamValue(RADIUS);
                double d2 = object == null ? 15.0 : (Double)object;
                queryArgs.setRegion(new CoordinateRadius((Coordinates)worldCoords, d2));
            } else {
                Double d3 = (Double)queryArgs.getParamValue(MIN_RADIUS);
                double d4 = d3 == null ? 0.0 : d3;
                Double d5 = (Double)queryArgs.getParamValue(MAX_RADIUS);
                d = d5 == null ? 15.0 : d5;
                queryArgs.setRegion(new CoordinateRadius((Coordinates)worldCoords, d4, d));
            }
        } else if (this._isImageServer) {
            if (this._findParamByType(this._paramDesc, "size") != null) {
                object = (Double)queryArgs.getParamValue(SIZE);
                double d6 = object == null ? 15.0 : (Double)object;
                double d7 = Math.sqrt(2.0 * d6 * d6) / 2.0;
                queryArgs.setRegion(new CoordinateRadius((Coordinates)worldCoords, d7, d6, d6));
            } else {
                Double d8 = (Double)queryArgs.getParamValue(WIDTH);
                double d9 = d8 == null ? 0.0 : d8;
                Double d10 = (Double)queryArgs.getParamValue(HEIGHT);
                d = d10 == null ? 15.0 : d10;
                double d11 = Math.sqrt(d9 * d9 + d * d) / 2.0;
                queryArgs.setRegion(new CoordinateRadius((Coordinates)worldCoords, d11, d9, d));
            }
        }
    }

    private double _getEquinox(QueryArgs queryArgs) {
        String string = (String)queryArgs.getParamValue(EQUINOX);
        if (string.equals(B1950)) {
            return 1950.0;
        }
        return 2000.0;
    }

    private WorldCoords _resolveObjectName(String string, Catalog catalog) throws IOException {
        Coordinates coordinates;
        BasicQueryArgs basicQueryArgs = new BasicQueryArgs(catalog);
        basicQueryArgs.setId(string);
        QueryResult queryResult = catalog.query((QueryArgs)basicQueryArgs);
        if (queryResult instanceof TableQueryResult && (coordinates = ((TableQueryResult)queryResult).getCoordinates(0)) instanceof WorldCoords) {
            return (WorldCoords)coordinates;
        }
        throw new RuntimeException("Unexpected result from " + catalog.toString());
    }

    protected void _setMaxRows(QueryArgs queryArgs, SearchCondition[] searchConditionArray) {
        if (queryArgs.getMaxRows() != 0 || searchConditionArray == null || searchConditionArray.length == 0) {
            return;
        }
        Integer n = (Integer)queryArgs.getParamValue(MAX_OBJECTS);
        if (n != null) {
            queryArgs.setMaxRows(n.intValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QueryResult _httpQuery(QueryArgs queryArgs) throws IOException {
        QueryResult queryResult;
        block9: {
            URLConnection uRLConnection;
            ProgressBarFilterInputStream progressBarFilterInputStream;
            block7: {
                URLQueryResult uRLQueryResult;
                block8: {
                    URL uRL = this._getQueryUrl(queryArgs);
                    if (Log.logger((Object)((Object)this)).finest()) {
                        Log.logger((Object)((Object)this)).finest("URL = " + uRL.toString().replaceAll("%", "%%"));
                    }
                    if (this._type.equals("imagesvr")) {
                        return new URLQueryResult(uRL);
                    }
                    if (this._progressPanel == null) {
                        this._progressPanel = ProgressPanel.makeProgressPanel((String)"Downloading query results");
                    }
                    progressBarFilterInputStream = null;
                    try {
                        uRLConnection = this._progressPanel.openConnection(uRL);
                        String string = uRLConnection.getContentType();
                        if (string == null || !string.equals("text/html")) break block7;
                        uRLQueryResult = new URLQueryResult(uRL);
                        if (progressBarFilterInputStream == null) break block8;
                    }
                    catch (Throwable throwable) {
                        if (progressBarFilterInputStream != null) {
                            this._progressPanel.stopLoggingInputStream(progressBarFilterInputStream);
                        }
                        this._progressPanel.stop();
                        throw throwable;
                    }
                    this._progressPanel.stopLoggingInputStream(progressBarFilterInputStream);
                }
                this._progressPanel.stop();
                return uRLQueryResult;
            }
            InputStream inputStream = uRLConnection.getInputStream();
            progressBarFilterInputStream = this._progressPanel.getLoggedInputStream(inputStream, uRLConnection.getContentLength());
            queryResult = this._makeQueryResult((InputStream)progressBarFilterInputStream, queryArgs);
            if (progressBarFilterInputStream == null) break block9;
            this._progressPanel.stopLoggingInputStream(progressBarFilterInputStream);
        }
        this._progressPanel.stop();
        return queryResult;
    }

    private String _getBaseUrl() {
        if (this._host == null || this._protocol == null) {
            return this._path;
        }
        String string = this._protocol + "://" + this._host;
        if (this._port != 80) {
            string = string + ":" + this._port;
        }
        if (this._path != null) {
            string = string + this._path;
        }
        return string;
    }

    private URL _getQueryUrl(QueryArgs queryArgs) throws MalformedURLException, IOException {
        String string = this._getBaseUrl();
        SearchCondition[] searchConditionArray = queryArgs.getConditions();
        if (!this._centerPosRadiusSearchSupported()) {
            if (searchConditionArray != null && searchConditionArray.length != 0) {
                for (int i = 0; i < searchConditionArray.length; ++i) {
                    String string2 = i == 0 ? "?" : "&";
                    string = string + string2 + searchConditionArray[i].toString();
                }
            }
        } else {
            this._setQueryRegion(queryArgs, searchConditionArray);
            this._setMaxRows(queryArgs, searchConditionArray);
            if (this._paramDesc != null && this._paramDesc.length != 0) {
                for (int i = 0; i < this._paramDesc.length; ++i) {
                    String string3 = this._getParamValue(this._paramDesc[i], queryArgs);
                    if (string3 == null || string3.length() == 0) continue;
                    String string4 = i == 0 ? "?" : "&";
                    string = string + string4 + this._paramDesc[i].getId() + "=" + string3;
                }
            }
        }
        string = StringUtil.replace((String)string, (String)" ", (String)"%20");
        return new URL(string);
    }

    private String _getParamValue(FieldDesc fieldDesc, QueryArgs queryArgs) {
        for (int i = 0; i < this._dummyParamDesc.length; ++i) {
            if (this._dummyParamDesc[i] != fieldDesc) continue;
            Object object = queryArgs.getParamValue(i);
            if (object != null) {
                return object.toString();
            }
            return null;
        }
        CoordinateRadius coordinateRadius = queryArgs.getRegion();
        if (coordinateRadius == null) {
            return null;
        }
        WorldCoords worldCoords = (WorldCoords)coordinateRadius.getCenterPosition();
        String string = fieldDesc.getType();
        String string2 = fieldDesc.getUnits();
        String string3 = fieldDesc.getFormat();
        if (string.equalsIgnoreCase("radec")) {
            return this._getRADec(worldCoords.getRA(), worldCoords.getDec(), string3);
        }
        if (string.equalsIgnoreCase("radecdeg")) {
            return this._getRADecDeg(worldCoords.getRA(), worldCoords.getDec(), string3);
        }
        if (string.equalsIgnoreCase("ra")) {
            return this._getRA(worldCoords.getRA(), string3);
        }
        if (string.equalsIgnoreCase("dec")) {
            return this._getDec(worldCoords.getDec(), string3);
        }
        if (string.equalsIgnoreCase("radius")) {
            return String.valueOf(this._getValueInUnits(coordinateRadius.getMaxRadius(), "arcmin", string2));
        }
        if (string.equalsIgnoreCase("minradius")) {
            return String.valueOf(this._getValueInUnits(coordinateRadius.getMinRadius(), "arcmin", string2));
        }
        if (string.equalsIgnoreCase("maxradius")) {
            return String.valueOf(this._getValueInUnits(coordinateRadius.getMaxRadius(), "arcmin", string2));
        }
        if (string.equalsIgnoreCase("width") || string.equalsIgnoreCase("size")) {
            return String.valueOf((int)this._getValueInUnits(coordinateRadius.getWidth(), "arcmin", string2));
        }
        if (string.equalsIgnoreCase("height")) {
            return String.valueOf((int)this._getValueInUnits(coordinateRadius.getHeight(), "arcmin", string2));
        }
        return null;
    }

    private String _getRA(HMS hMS, String string) {
        String string2 = hMS.toString();
        if (string == null || string.length() == 0) {
            return string2;
        }
        if (string.startsWith("h+m+s")) {
            return StringUtil.replace((String)string2, (String)":", (String)"+");
        }
        if (string.startsWith("h m s")) {
            return StringUtil.replace((String)string2, (String)":", (String)" ");
        }
        return string2;
    }

    private String _getRADeg(HMS hMS, String string) {
        String string2 = String.format("%4.3f", hMS.getVal() * 15.0);
        return string2;
    }

    private String _getDec(DMS dMS, String string) {
        String string2 = dMS.toString();
        if (string == null || string.length() == 0) {
            return string2;
        }
        if (string.endsWith("d+m+s")) {
            return StringUtil.replace((String)string2, (String)":", (String)"+");
        }
        if (string.endsWith("d m s")) {
            return StringUtil.replace((String)string2, (String)":", (String)" ");
        }
        return string2;
    }

    private String _getDecDeg(DMS dMS, String string) {
        String string2 = String.format("%4.3f", dMS.getVal());
        return string2;
    }

    private String _getRADec(HMS hMS, DMS dMS, String string) {
        String string2 = this._getRA(hMS, string) + " " + this._getDec(dMS, string);
        if (string == null || string.length() == 0) {
            return string2;
        }
        if (string.equals("h+m+s d+m+s")) {
            return StringUtil.replace((String)string2, (String)" ", (String)"%2b");
        }
        return string2;
    }

    private String _getRADecDeg(HMS hMS, DMS dMS, String string) {
        String string2 = this._getRADeg(hMS, string) + "," + this._getDecDeg(dMS, string);
        if (string == null || string.length() == 0) {
            return string2;
        }
        if (string.equals("h+m+s d+m+s")) {
            return StringUtil.replace((String)string2, (String)" ", (String)"%2b");
        }
        return string2;
    }

    private double _getValueInUnits(double d, String string, String string2) {
        if (string == null || string.length() == 0 || string2 == null || string2.length() == 0) {
            return d;
        }
        if (string.startsWith("arcmin")) {
            if (string2.startsWith("arcsec")) {
                return d * 60.0;
            }
            if (string2.startsWith("arcmin")) {
                return d;
            }
            if (string2.startsWith("deg")) {
                return d / 4.0;
            }
            if (string2.startsWith("hour")) {
                return d / 60.0;
            }
        } else if (string.startsWith("arcsec")) {
            if (string2.startsWith("arcsec")) {
                return d;
            }
            if (string2.startsWith("arcmin")) {
                return d / 60.0;
            }
            if (string2.startsWith("deg")) {
                return d / 240.0;
            }
            if (string2.startsWith("hour")) {
                return d / 3600.0;
            }
        } else if (string.startsWith("deg")) {
            if (string2.startsWith("arcsec")) {
                return d * 240.0;
            }
            if (string2.startsWith("arcmin")) {
                return d * 4.0;
            }
            if (string2.startsWith("deg")) {
                return d;
            }
            if (string2.startsWith("hour")) {
                return d / 15.0;
            }
        } else if (string.startsWith("hours")) {
            if (string2.startsWith("arcsec")) {
                return d * 3600.0;
            }
            if (string2.startsWith("arcmin")) {
                return d * 60.0;
            }
            if (string2.startsWith("deg")) {
                return d * 15.0;
            }
            if (string2.startsWith("hour")) {
                return d;
            }
        } else {
            System.out.println("Warning: unrecognized units: '" + string + "'");
        }
        System.out.println("Warning: unrecognized units: '" + string2 + "'");
        return d;
    }

    private boolean _centerPosRadiusSearchSupported() {
        if (this._isCatalog || this._isImageServer) {
            boolean bl = false;
            boolean bl2 = false;
            for (int i = 0; i < this._paramDesc.length; ++i) {
                String string = this._paramDesc[i].getType();
                if (string == null || string.length() == 0) continue;
                if (string.equalsIgnoreCase("radec") || string.equalsIgnoreCase("ra") || string.equalsIgnoreCase("radecdeg")) {
                    bl = true;
                } else if (string.equalsIgnoreCase("radius") || string.equalsIgnoreCase("minradius") || string.equalsIgnoreCase("maxradius") || string.equalsIgnoreCase("size") || string.equalsIgnoreCase("width") || string.equalsIgnoreCase("height")) {
                    bl2 = true;
                }
                if (!bl || !bl2) continue;
                return true;
            }
        }
        return false;
    }

    private QueryResult _makeQueryResult(InputStream inputStream, QueryArgs queryArgs) throws IOException {
        AstroCatTable astroCatTable = new AstroCatTable((AstroCatalog)this, inputStream, queryArgs);
        return astroCatTable;
    }

    private void _initSearchParameters() {
        this._checkForDetailedCatalogDesc();
        if (!this._centerPosRadiusSearchSupported()) {
            this._dummyParamDesc = this._paramDesc;
            return;
        }
        Vector<Object> vector = new Vector<Object>(10, 10);
        if (this._isCatalog || this._isImageServer) {
            FieldDescAdapter fieldDescAdapter = new FieldDescAdapter(OBJECT);
            fieldDescAdapter.setDescription("Enter the name of the object");
            vector.add(fieldDescAdapter);
            fieldDescAdapter = new FieldDescAdapter(NAME_SERVER);
            fieldDescAdapter.setDescription("Select the name server to use to resolve the object name");
            List list = AstroCatConfig.getConfigFile().getNameServers();
            NameValue[] nameValueArray = new NameValue[list.size()];
            for (int i = 0; i < nameValueArray.length; ++i) {
                Catalog catalog = (Catalog)list.get(i);
                nameValueArray[i] = new NameValue(catalog.getName(), (Object)catalog);
            }
            fieldDescAdapter.setOptions(nameValueArray);
            vector.add(fieldDescAdapter);
            fieldDescAdapter = new FieldDescAdapter(RA);
            fieldDescAdapter.setIsRA(true);
            fieldDescAdapter.setDescription("Right Ascension in the selected equinox, format: hh:mm:ss.sss");
            vector.add(fieldDescAdapter);
            fieldDescAdapter = new FieldDescAdapter(DEC);
            fieldDescAdapter.setDescription("Declination in the selected equinox, format: dd:mm:ss.sss");
            fieldDescAdapter.setIsDec(true);
            vector.add(fieldDescAdapter);
            fieldDescAdapter = new FieldDescAdapter(EQUINOX);
            fieldDescAdapter.setDescription("Equinox of RA and Dec");
            fieldDescAdapter.setOptions(_equinoxOptions);
            vector.add(fieldDescAdapter);
            if (this._isCatalog) {
                if (this._findParamByType(this._paramDesc, "radius") != null) {
                    fieldDescAdapter = new FieldDescAdapter(MAX_RADIUS);
                    fieldDescAdapter.setDescription("The radius from the center coordinates in arcmin");
                    fieldDescAdapter.setFieldClass(Double.class);
                    fieldDescAdapter.setUnits("arcmin");
                    vector.add(fieldDescAdapter);
                } else {
                    if (this._findParamByType(this._paramDesc, "minradius") != null) {
                        fieldDescAdapter = new FieldDescAdapter(MIN_RADIUS);
                        fieldDescAdapter.setDescription("The minimum radius from the center coordinates in arcmin");
                        fieldDescAdapter.setFieldClass(Double.class);
                        fieldDescAdapter.setUnits("arcmin");
                        vector.add(fieldDescAdapter);
                    }
                    if (this._findParamByType(this._paramDesc, "maxradius") != null) {
                        fieldDescAdapter = new FieldDescAdapter(MAX_RADIUS);
                        fieldDescAdapter.setDescription("The maximum radius from the center coordinates in arcmin");
                        fieldDescAdapter.setFieldClass(Double.class);
                        fieldDescAdapter.setUnits("arcmin");
                        vector.add(fieldDescAdapter);
                    }
                }
            } else if (this._isImageServer) {
                if (this._findParamByType(this._paramDesc, "size") != null) {
                    fieldDescAdapter = new FieldDescAdapter(SIZE);
                    fieldDescAdapter.setDescription("The requested size (width or height) about the center coordinates in arcmin");
                    fieldDescAdapter.setFieldClass(Double.class);
                    fieldDescAdapter.setUnits("arcmin");
                    vector.add(fieldDescAdapter);
                } else {
                    if (this._findParamByType(this._paramDesc, "width") != null) {
                        fieldDescAdapter = new FieldDescAdapter(WIDTH);
                        fieldDescAdapter.setDescription("The width about the center coordinates in arcmin");
                        fieldDescAdapter.setFieldClass(Double.class);
                        fieldDescAdapter.setUnits("arcmin");
                        vector.add(fieldDescAdapter);
                    }
                    if (this._findParamByType(this._paramDesc, "height") != null) {
                        fieldDescAdapter = new FieldDescAdapter(HEIGHT);
                        fieldDescAdapter.setDescription("The height about the center coordinates in arcmin");
                        fieldDescAdapter.setFieldClass(Double.class);
                        fieldDescAdapter.setUnits("arcmin");
                        vector.add(fieldDescAdapter);
                    }
                }
            }
            if (this._isCatalog && this._findParamByType(this._paramDesc, "maxobjects") == null && this._findParamByType(this._paramDesc, "maxrows") == null) {
                fieldDescAdapter = new FieldDescAdapter(MAX_OBJECTS);
                fieldDescAdapter.setDescription("The maximum number of objects to return");
                fieldDescAdapter.setFieldClass(Integer.class);
                fieldDescAdapter.setDefaultValue((Object)new Integer(1000));
                vector.add(fieldDescAdapter);
            }
        }
        for (int i = 0; i < this._paramDesc.length; ++i) {
            if (this._isPosRadiusParam(this._paramDesc[i])) continue;
            vector.add(this._paramDesc[i]);
        }
        this._dummyParamDesc = new FieldDescAdapter[vector.size()];
        vector.toArray(this._dummyParamDesc);
    }

    private boolean _isPosRadiusParam(FieldDesc fieldDesc) {
        String string = fieldDesc.getType();
        if (string != null && string.length() != 0) {
            return string.equals("radec") || string.equalsIgnoreCase("radecdeg") || string.equalsIgnoreCase("ra") || string.equalsIgnoreCase("dec") || string.equalsIgnoreCase("equinox") || string.equalsIgnoreCase("epoch") || string.equalsIgnoreCase("nameserver") || string.equalsIgnoreCase("radius") || string.equalsIgnoreCase("minradius") || string.equalsIgnoreCase("maxradius") || string.equalsIgnoreCase("size") || string.equalsIgnoreCase("width") || string.equalsIgnoreCase("height");
        }
        return false;
    }

    private FieldDesc _findParamByType(FieldDesc[] fieldDescArray, String string) {
        for (int i = 0; i < fieldDescArray.length; ++i) {
            if (!string.equalsIgnoreCase(fieldDescArray[i].getType())) continue;
            return fieldDescArray[i];
        }
        return null;
    }

    private void _checkForDetailedCatalogDesc() {
        if (this._paramDesc == null && this._path != null && this._path.endsWith(".xml") && !this._type.equals("directory")) {
            try {
                Object object;
                Object object2;
                String string = this._getBaseUrl();
                Object object3 = new URL(this._url, string);
                String string2 = ((URL)object3).getFile();
                if (string2 != null && !((File)(object2 = new File(string2))).exists() && (object = Resources.getResource((String)("conf/" + this._path))) != null) {
                    object3 = object;
                }
                object2 = new AlmaAstroCatXML();
                object2.parse((URL)object3);
                object = ((AlmaAstroCatXML)((Object)object2)).getCatalogs();
                if (object.size() != 1) {
                    throw new RuntimeException("Expected a single catalog description in: " + object3);
                }
                AlmaAstroCatalog almaAstroCatalog = (AlmaAstroCatalog)((Object)object.get(0));
                this._url = object3;
                this._id = almaAstroCatalog._id;
                this._name = almaAstroCatalog._name;
                this._description = almaAstroCatalog._description;
                this._docURL = almaAstroCatalog._docURL;
                this._type = almaAstroCatalog._type;
                this._protocol = almaAstroCatalog._protocol;
                this._host = almaAstroCatalog._host;
                this._port = almaAstroCatalog._port;
                this._path = almaAstroCatalog._path;
                this._handlerClass = almaAstroCatalog._handlerClass;
                this._paramDesc = almaAstroCatalog._paramDesc;
                if (this._symbols == null) {
                    this._symbols = almaAstroCatalog._symbols;
                }
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }
}

