/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.guiutil.jsky.navigator;

import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.guiutil.jsky.InvalidFormatFileException;
import alma.obsprep.guiutil.jsky.image.graphics.AlmaDivaImageGraphics;
import alma.obsprep.guiutil.jsky.navigator.AlmaNavigator;
import alma.obsprep.guiutil.jsky.navigator.AlmaNavigatorImageDisplayPanel;
import alma.obsprep.guiutil.jsky.navigator.AlmaNavigatorManager;
import alma.obsprep.util.GUIUtilities;
import alma.obsprep.util.astro.SkyPoint;
import alma.valuetypes.SkyCoordinates;
import diva.canvas.CanvasPane;
import diva.canvas.GraphicsPane;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jsky.coords.CoordinateConverter;
import jsky.graphics.CanvasGraphics;
import jsky.image.ImageProcessor;
import jsky.image.fits.codec.FITSImage;
import jsky.image.graphics.ImageFigureGroup;
import jsky.image.gui.DivaGraphicsImageDisplay;
import jsky.image.gui.MainImageDisplay;
import jsky.navigator.NavigatorImageDisplay;
import jsky.navigator.NavigatorPane;
import nom.tam.fits.Header;
import org.apache.commons.lang.StringUtils;

public class AlmaNavigatorImageDisplay
extends NavigatorImageDisplay {
    private MainImageDisplay.CoordSystemType imageCoordSystem = MainImageDisplay.CoordSystemType.UNKNOWN;
    private AlmaNavigatorImageDisplayPanel imagePanel = null;
    private boolean imageLoaded = false;
    private String filename = null;
    private FITSImage fitsImage = null;
    private List<ChangeListener> imageSetListenerList = new ArrayList<ChangeListener>();

    public AlmaNavigatorImageDisplay() {
        this.setName("SpatialVisualEditor.ImageDisplay");
    }

    public void addImageFileLoadedListener(ChangeListener changeListener) {
        this.imageSetListenerList.add(changeListener);
    }

    public void setImageDisplayPanel(AlmaNavigatorImageDisplayPanel almaNavigatorImageDisplayPanel) {
        this.imagePanel = almaNavigatorImageDisplayPanel;
    }

    protected void makeNavigatorFrame() {
        super.setNavigator(AlmaNavigatorManager.create());
        ((AlmaNavigator)this.getNavigator()).setImageDisplay(this);
    }

    protected CanvasGraphics makeCanvasGraphics() {
        super.makeCanvasGraphics();
        AlmaDivaImageGraphics almaDivaImageGraphics = new AlmaDivaImageGraphics((DivaGraphicsImageDisplay)this);
        NavigatorPane navigatorPane = new NavigatorPane();
        this.setCanvasPane((CanvasPane)navigatorPane);
        almaDivaImageGraphics.setGraphicsPane((GraphicsPane)navigatorPane);
        return almaDivaImageGraphics;
    }

    public void setFilename(String string) {
        this.setFilename(string, true);
    }

    private Map<String, Double> fetchCDMatrix() {
        Double d;
        Double d2;
        Double d3;
        Double d4;
        HashMap<String, Double> hashMap = new HashMap<String, Double>();
        Object object = this.fitsImage.getKeywordValue("CD1_1");
        Object object2 = this.fitsImage.getKeywordValue("CD1_2");
        Object object3 = this.fitsImage.getKeywordValue("CD2_1");
        Object object4 = this.fitsImage.getKeywordValue("CD2_2");
        if (object == null || object2 == null || object3 == null || object4 == null) {
            return null;
        }
        try {
            d4 = Double.parseDouble(object.toString());
        }
        catch (NumberFormatException numberFormatException) {
            d4 = 0.0;
        }
        try {
            d3 = Double.parseDouble(object2.toString());
        }
        catch (NumberFormatException numberFormatException) {
            d3 = 0.0;
        }
        try {
            d2 = Double.parseDouble(object3.toString());
        }
        catch (NumberFormatException numberFormatException) {
            d2 = 0.0;
        }
        try {
            d = Double.parseDouble(object4.toString());
        }
        catch (NumberFormatException numberFormatException) {
            d = 0.0;
        }
        hashMap.put("CD11", d4);
        hashMap.put("CD12", d3);
        hashMap.put("CD21", d2);
        hashMap.put("CD22", d);
        return hashMap;
    }

    public boolean getImageFlipped() {
        Map<String, Double> map = this.fetchCDMatrix();
        if (map == null) {
            return false;
        }
        Double d = map.get("CD11");
        Double d2 = map.get("CD12");
        Double d3 = map.get("CD21");
        Double d4 = map.get("CD22");
        boolean bl = false;
        double d5 = d * d4 - d2 * d3;
        bl = !(Math.signum(d5) < 0.0);
        return bl;
    }

    public double getImageRotation() {
        Map<String, Double> map = this.fetchCDMatrix();
        double d = 0.0;
        if (map == null) {
            d = this.fitsImage.getKeywordValue("CROTA1", 0.0);
            if (d == 0.0) {
                d = this.fitsImage.getKeywordValue("CROTA2", 0.0);
            }
        } else {
            Double d2 = map.get("CD11");
            Double d3 = map.get("CD12");
            Double d4 = map.get("CD21");
            Double d5 = map.get("CD22");
            double d6 = Math.signum(d2 * d5 - d3 * d4);
            d = Math.toDegrees(Math.atan(d6 * d3 / d5));
        }
        return d;
    }

    private boolean loadFile(String string) throws InvalidFormatFileException {
        String string2 = null;
        try {
            int n = -1;
            Header header = null;
            this.fitsImage = new FITSImage(string);
            for (int i = 0; i < this.fitsImage.getNumHDUs(); ++i) {
                this.fitsImage.setHDU(i);
                header = this.fitsImage.getHeader();
                try {
                    n = header.getIntValue("BITPIX");
                    break;
                }
                catch (Exception exception) {
                    continue;
                }
            }
            if (n == -1) {
                return false;
            }
            header.addValue("DATAMAX", 0.0, "");
            header.addValue("DATAMIN", 0.0, "");
            header.addValue("DATAMEAN", Double.NaN, "");
            super.setFilename(string);
            this.initFITSImage(this.fitsImage);
            this.setImage(this.fitsImage);
        }
        catch (Exception exception) {
            try {
                this.setImage((PlanarImage)JAI.create((String)"fileload", (Object)string));
            }
            catch (Exception exception2) {
                this.blankImage(0.0, 0.0);
                if (string2 != null) {
                    throw new InvalidFormatFileException(string2);
                }
                return false;
            }
        }
        if (this.getWCS() == null) {
            this.clear();
            return false;
        }
        this.imageCoordSystem = this.getImageCoordSystemType(this.fitsImage);
        return true;
    }

    public void setFilename(String string, boolean bl) {
        if (string == null) {
            this.filename = null;
            this.setImageLoaded(false);
            ChangeEvent changeEvent = new ChangeEvent((Object)this);
            Iterator<ChangeListener> iterator = this.imageSetListenerList.iterator();
            while (iterator.hasNext()) {
                iterator.next().stateChanged(changeEvent);
            }
            return;
        }
        String string2 = null;
        boolean bl2 = true;
        try {
            bl2 = this.loadFile(string);
        }
        catch (InvalidFormatFileException invalidFormatFileException) {
            bl2 = false;
            string2 = invalidFormatFileException.getMessage();
        }
        if (!bl2) {
            if (string2 == null) {
                string2 = "This file is not available in the spatial visual editor : " + string;
            }
            GUIUtilities.warning(null, string2);
            Log.logger((Object)((Object)this)).warning(string2);
            this.setImageLoaded(false);
            this.filename = null;
            return;
        }
        this.filename = string;
        if (super.getFilename() == null || !super.getFilename().equals(string)) {
            super.setFilename(string);
        }
        this.setImageLoaded(true);
        if (this.imagePanel != null) {
            if (bl) {
                this.imagePanel.defaultCenter();
            }
            this.imagePanel.finishImageSet();
        }
        ChangeEvent changeEvent = new ChangeEvent((Object)this);
        for (ChangeListener changeListener : this.imageSetListenerList) {
            changeListener.stateChanged(changeEvent);
        }
    }

    protected void updateTitle() {
    }

    public String getFilename() {
        return this.filename;
    }

    public void setImageLoaded(boolean bl) {
        this.imageLoaded = bl;
    }

    public boolean isImageLoaded() {
        return this.imageLoaded;
    }

    public boolean isWcsSet() {
        CoordinateConverter coordinateConverter = this.getCoordinateConverter();
        boolean bl = coordinateConverter != null && coordinateConverter.isWCS();
        return bl && this.isImageLoaded();
    }

    public String loadImageFile(String string) {
        if (string.equals(this.filename)) {
            return string;
        }
        FITSImage fITSImage = null;
        try {
            fITSImage = new FITSImage(string);
            this.setImage(fITSImage);
        }
        catch (Exception exception) {
            try {
                this.setImage((PlanarImage)JAI.create((String)"fileload", (Object)string));
            }
            catch (Exception exception2) {
                Log.logger((Object)((Object)this)).warning(exception.getMessage());
                return null;
            }
        }
        assert (fITSImage != null);
        this.initWCS();
        ImageProcessor imageProcessor = this.getImageProcessor();
        imageProcessor.update();
        this.setImageLoaded(true);
        this.setFilename(string, false);
        this.imageCoordSystem = this.getImageCoordSystemType(fITSImage);
        return string;
    }

    public MainImageDisplay.CoordSystemType getCoordSystem() {
        return this.imageCoordSystem;
    }

    private MainImageDisplay.CoordSystemType getImageCoordSystemType(FITSImage fITSImage) {
        if (fITSImage == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: loadedFITSImage");
        }
        String[] stringArray = fITSImage.getKeywords();
        if (stringArray == null) {
            Log.logger(AlmaNavigatorImageDisplay.class).warning("Unable to determine keywords");
            return MainImageDisplay.CoordSystemType.UNKNOWN;
        }
        for (String string : stringArray) {
            Object object;
            if (!StringUtils.startsWith((String)string, (String)"CTYPE") || (object = fITSImage.getKeywordValue(string)) == null) continue;
            String string2 = (String)object;
            if (StringUtils.contains((String)string2, (String)"GLON") || StringUtils.contains((String)string2, (String)"GLAT")) {
                return MainImageDisplay.CoordSystemType.GALACTIC;
            }
            if (!StringUtils.contains((String)string2, (String)"RA") && !StringUtils.contains((String)string2, (String)"DEC")) continue;
            return MainImageDisplay.CoordSystemType.EQUATORIAL;
        }
        Log.logger(AlmaNavigatorImageDisplay.class).warning("Unable to determine coordinate system - assuming equitorial");
        return MainImageDisplay.CoordSystemType.EQUATORIAL;
    }

    public void clear() {
        super.clear();
        this.setImageLoaded(false);
    }

    public void eraseImage() {
        this.clear();
        this.setFilename(null);
    }

    public void translateFigureTo(ImageFigureGroup imageFigureGroup, SkyCoordinates skyCoordinates) {
        Point2D.Double double_ = new Point2D.Double();
        SkyPoint skyPoint = this.imageCoordSystem.equals((Object)MainImageDisplay.CoordSystemType.GALACTIC) ? skyCoordinates.getAbsoluteSkyPointInGalacticDeg() : skyCoordinates.getAbsoluteSkyPointInJ2000Deg();
        double_.setLocation(skyPoint);
        try {
            this.getCoordinateConverter().worldToScreenCoords(double_, false);
        }
        catch (RuntimeException runtimeException) {
            return;
        }
        double d = double_.getX() - imageFigureGroup.getBounds().getCenterX();
        double d2 = double_.getY() - imageFigureGroup.getBounds().getCenterY();
        imageFigureGroup.translate(d, d2);
    }

    protected void transformGraphics() {
    }

    protected void updateImage(PlanarImage planarImage) {
        this.imagePanel.clearGraphics();
        super.updateImage(planarImage);
        this.imagePanel.reloadPatterns();
    }
}

