/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.guiutil.mvc;

import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.ModelChangeSubscriber;
import alma.obsprep.guiutil.mvc.ModelStatusSubscriber;
import alma.obsprep.ot.gui.toplevel.DialogId;
import alma.obsprep.util.GUIUtilities;
import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Level;

public class Controller {
    public static final DialogId unexpectedErrorDialog = new DialogId("Editor.UnexpectedError");
    static String unexpectedmsg = "<html>The OT has encountered an unexpected error: It is recommended that you save your project to a new file and restart the OT.<br/> Please report this to the helpdesk along with description of what you were doing and if possible a copy of the project you<br/> were working on and a copy of your $HOME/.almaot directory. Sorry for the inconvenience</html>";
    private Model model;
    private Collection<ModelChangeSubscriber> changeSubscribers;
    private Collection<ModelStatusSubscriber> statusSubscribers;

    public Controller(Model model) {
        this.model = model;
        this.changeSubscribers = new HashSet<ModelChangeSubscriber>();
        this.statusSubscribers = new HashSet<ModelStatusSubscriber>();
    }

    public Model getModel() {
        return this.model;
    }

    public void subscribe(ModelChangeSubscriber modelChangeSubscriber) {
        if (modelChangeSubscriber == null) {
            throw new IllegalArgumentException("subscriber == null");
        }
        if (!this.changeSubscribers.contains(modelChangeSubscriber)) {
            this.changeSubscribers.add(modelChangeSubscriber);
        }
    }

    public void subscribe(ModelStatusSubscriber modelStatusSubscriber) {
        if (modelStatusSubscriber == null) {
            throw new IllegalArgumentException("subscriber == null");
        }
        if (!this.statusSubscribers.contains(modelStatusSubscriber)) {
            this.statusSubscribers.add(modelStatusSubscriber);
        }
        this.subscribe((ModelChangeSubscriber)modelStatusSubscriber);
    }

    public void unsubscribe(ModelChangeSubscriber modelChangeSubscriber) {
        this.changeSubscribers.remove(modelChangeSubscriber);
    }

    public void unsubscribe(ModelStatusSubscriber modelStatusSubscriber) {
        this.statusSubscribers.remove(modelStatusSubscriber);
        this.changeSubscribers.remove(modelStatusSubscriber);
    }

    public void modelChanged(FieldID fieldID, Object object) {
        try {
            for (ModelChangeSubscriber modelChangeSubscriber : this.changeSubscribers) {
                modelChangeSubscriber.modelChanged(this.model, fieldID, object);
            }
        }
        catch (RuntimeException runtimeException) {
            String string = unexpectedmsg;
            Log.logger((Object)this).log(Level.SEVERE, string, (Throwable)runtimeException);
            GUIUtilities.error(unexpectedErrorDialog, string, runtimeException);
            throw runtimeException;
        }
    }

    public void widgetUpdated(Editor editor, FieldID fieldID, Object object) {
        Object object2 = null;
        try {
            object2 = editor.widgetUpdated(fieldID, object);
            object2 = this.model.update(editor, fieldID, object2);
            this.modelChanged(fieldID, object2);
        }
        catch (RuntimeException runtimeException) {
            String string = unexpectedmsg;
            Log.logger((Object)this).log(Level.SEVERE, string, (Throwable)runtimeException);
            GUIUtilities.error(unexpectedErrorDialog, string, runtimeException);
            throw runtimeException;
        }
    }

    public void widgetModified(Editor editor, FieldID fieldID, Object object) {
        Object object2 = null;
        try {
            object2 = editor.widgetModified(fieldID, object);
            object2 = this.model.update(editor, fieldID, object2);
            this.modelChanged(fieldID, object2);
        }
        catch (RuntimeException runtimeException) {
            String string = unexpectedmsg;
            Log.logger((Object)this).log(Level.SEVERE, string, (Throwable)runtimeException);
            GUIUtilities.error(null, string, runtimeException);
            throw runtimeException;
        }
    }

    public void widgetChanged(Editor editor, FieldID fieldID, Object object) {
    }

    public void widgetInvalid(Editor editor, FieldID fieldID, Object object) {
    }

    public void fieldInvalid(FieldID fieldID, String string) {
        for (ModelStatusSubscriber modelStatusSubscriber : this.statusSubscribers) {
            modelStatusSubscriber.fieldInvalid(this.model, fieldID, string);
        }
    }

    public void fieldValid(FieldID fieldID) {
        for (ModelStatusSubscriber modelStatusSubscriber : this.statusSubscribers) {
            modelStatusSubscriber.fieldValid(this.model, fieldID);
        }
    }
}

