/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.guiutil.mvc;

import alma.obsprep.guiutil.mvc.Controller;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.ModelChangeSubscriber;
import alma.obsprep.guiutil.mvc.ModelStatusSubscriber;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class Model
implements Iterable<Model> {
    private Controller controller;
    protected boolean modelInTransitionState = false;
    protected Object document;
    private List<Model> subModels = new ArrayList<Model>();
    private Model parentModel;

    public Model(Object object) {
        this.document = object;
        this.controller = new Controller(this);
    }

    public Controller getController() {
        return this.controller;
    }

    public Object getDocument() {
        return this.document;
    }

    public abstract void publish();

    public void publish(FieldID fieldID, Object object) {
        this.controller.modelChanged(fieldID, object);
    }

    public void fieldInvalid(FieldID fieldID, String string) {
        this.controller.fieldInvalid(fieldID, string);
    }

    public void fieldValid(FieldID fieldID) {
        this.controller.fieldValid(fieldID);
    }

    public void setDocument(Object object) {
        this.document = object;
        this.publish();
    }

    public void setonlyDocument(Object object) {
        this.document = object;
    }

    public void subscribe(ModelChangeSubscriber modelChangeSubscriber) {
        Controller controller = this.getController();
        controller.subscribe(modelChangeSubscriber);
    }

    public void subscribe(ModelStatusSubscriber modelStatusSubscriber) {
        Controller controller = this.getController();
        controller.subscribe(modelStatusSubscriber);
    }

    public void unsubscribe(ModelChangeSubscriber modelChangeSubscriber) {
        Controller controller = this.getController();
        controller.unsubscribe(modelChangeSubscriber);
    }

    public void unsubscribe(ModelStatusSubscriber modelStatusSubscriber) {
        Controller controller = this.getController();
        controller.unsubscribe(modelStatusSubscriber);
    }

    public abstract Object update(Editor var1, FieldID var2, Object var3);

    public Object get(FieldID fieldID) {
        String string = "Method get(FieldID) must be overridden in class " + this.getClass().getName();
        throw new RuntimeException(string);
    }

    public Model submodel(int n) {
        return this.subModels.get(n);
    }

    public List<Model> getSubModels() {
        return this.subModels;
    }

    public boolean registerSubModel(Model model) {
        if (this.subModels.contains(model)) {
            return false;
        }
        model.setParentModel(this);
        return this.subModels.add(model);
    }

    public boolean forgetSubModel(Model model) {
        model.setParentModel(null);
        return this.subModels.remove(model);
    }

    @Override
    public Iterator<Model> iterator() {
        return this.subModels.iterator();
    }

    public Model getParentModel() {
        return this.parentModel;
    }

    public void setParentModel(Model model) {
        this.parentModel = model;
    }

    public void rsubscribe(ModelChangeSubscriber modelChangeSubscriber) {
        this.subscribe(modelChangeSubscriber);
        for (Model model : this.subModels) {
            model.rsubscribe(modelChangeSubscriber);
        }
    }

    public final boolean isModelInTransitionState() {
        return this.modelInTransitionState;
    }

    public final void setModelInTransitionState(boolean bl) {
        this.modelInTransitionState = bl;
    }
}

