/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.guiutil.mvc.verifiers;

import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.OutOfRangeAndIsZeroException;
import alma.obsprep.guiutil.mvc.OutOfRangeException;
import alma.obsprep.guiutil.mvc.verifiers.Verifier;
import javax.swing.JTextField;

public class DoubleVerifier
extends Verifier {
    protected double max = Double.MAX_VALUE;
    protected double min = Double.MIN_VALUE;
    protected boolean incMin = true;
    protected boolean incMax = true;
    private static final String FORMATERROR = "Value must be a number";
    protected double[] minMaxPairs = null;

    public DoubleVerifier(Editor editor, JTextField jTextField) {
        super(editor, jTextField);
    }

    public DoubleVerifier(Editor editor, JTextField jTextField, double d, double d2) {
        this(editor, jTextField, d, d2, true, true);
    }

    public DoubleVerifier(Editor editor, JTextField jTextField, double d, double d2, boolean bl, boolean bl2) {
        this(editor, jTextField);
        DoubleVerifier.checkMinMax(d, d2);
        this.min = d;
        this.max = d2;
        this.incMin = bl;
        this.incMax = bl2;
    }

    public void setMinMax(double d, double d2, boolean bl, boolean bl2) {
        DoubleVerifier.checkMinMax(d, d2);
        this.min = d;
        this.max = d2;
        this.incMin = bl;
        this.incMax = bl2;
    }

    public DoubleVerifier(Editor editor, JTextField jTextField, boolean bl, boolean bl2, double ... dArray) {
        this(editor, jTextField);
        this.incMin = bl;
        this.incMax = bl2;
        if (dArray.length % 2 != 0) {
            throw new IllegalArgumentException("Missing parameter: Unmatched min/max pair");
        }
        for (int i = 0; i < dArray.length; i += 2) {
            DoubleVerifier.checkMinMax(dArray[i], dArray[i + 1]);
        }
        this.minMaxPairs = dArray;
    }

    public DoubleVerifier(Editor editor, JTextField jTextField, double ... dArray) {
        this(editor, jTextField, true, true, dArray);
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    @Override
    public Object validate(JTextField jTextField) throws OutOfRangeException, NumberFormatException {
        double d = this.minMaxPairs == null ? DoubleVerifier.parseDouble((Object)jTextField.getText(), this.min, this.max, this.incMin, this.incMax) : DoubleVerifier.parseDouble((Object)jTextField.getText(), this.incMin, this.incMax, this.minMaxPairs);
        return new Double(d);
    }

    public static double parseDouble(Object object) throws NumberFormatException {
        double d = 0.0;
        try {
            d = DoubleVerifier.parseDouble(object, -1.7976931348623157E308, Double.MAX_VALUE);
        }
        catch (OutOfRangeException outOfRangeException) {
            String string;
            if (object.getClass() == String.class && ((string = (String)object).endsWith(String.format("%f", Double.POSITIVE_INFINITY)) || string.endsWith(String.format("%f", Double.NaN)))) {
                return d;
            }
            outOfRangeException.printStackTrace();
        }
        return d;
    }

    public static double parseDouble(Object object, double d, double d2, boolean bl, boolean bl2) throws OutOfRangeException, NumberFormatException {
        boolean bl3;
        double d3;
        Object object2;
        DoubleVerifier.checkMinMax(d, d2);
        if (object.getClass().isAssignableFrom(Number.class)) {
            object2 = (Number)object;
            d3 = ((Number)object2).doubleValue();
        } else {
            object2 = object.toString().trim();
            try {
                d3 = Double.parseDouble((String)object2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new NumberFormatException(FORMATERROR);
            }
        }
        if (bl && bl2) {
            bl3 = d <= d3 && d3 <= d2;
        } else if (bl && !bl2) {
            bl3 = d <= d3 && d3 < d2;
        } else if (!bl && bl2) {
            bl3 = d < d3 && d3 <= d2;
        } else {
            boolean bl4 = bl3 = d < d3 && d3 < d2;
        }
        if (!bl3) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Value must be between ").append(String.format("%6.3g", d)).append(bl ? " (" : " (not ").append("included) and ").append(String.format("%6.3g", d2)).append(bl2 ? " (" : " (not ").append("included)");
            if (d3 == 0.0) {
                throw new OutOfRangeAndIsZeroException(stringBuffer.toString());
            }
            throw new OutOfRangeException(stringBuffer.toString());
        }
        return d3;
    }

    public static double parseDouble(Object object, double d, double d2) throws OutOfRangeException, NumberFormatException {
        return DoubleVerifier.parseDouble(object, d, d2, true, true);
    }

    public static double parseDouble(Object object, boolean bl, boolean bl2, double ... dArray) throws OutOfRangeException, NumberFormatException {
        int n;
        double d;
        Object object2;
        for (int i = 0; i < dArray.length; i += 2) {
            DoubleVerifier.checkMinMax(dArray[i], dArray[i + 1]);
        }
        if (object.getClass().isAssignableFrom(Number.class)) {
            object2 = (Number)object;
            d = ((Number)object2).doubleValue();
        } else {
            object2 = object.toString().trim();
            try {
                d = Double.parseDouble((String)object2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new NumberFormatException(FORMATERROR);
            }
        }
        boolean bl3 = false;
        if (bl && bl2) {
            for (n = 0; n < dArray.length; n += 2) {
                bl3 = bl3 || dArray[n] <= d && d <= dArray[n + 1];
            }
        } else if (bl && !bl2) {
            for (n = 0; n < dArray.length; n += 2) {
                bl3 = bl3 || dArray[n] <= d && d < dArray[n + 1];
            }
        } else if (!bl && bl2) {
            for (n = 0; n < dArray.length; n += 2) {
                bl3 = bl3 || dArray[n] < d && d <= dArray[n + 1];
            }
        } else {
            for (n = 0; n < dArray.length; n += 2) {
                bl3 = bl3 || dArray[n] < d && d < dArray[n + 1];
            }
        }
        if (!bl3) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Value must be in the range ");
            for (int i = 0; i < dArray.length; i += 2) {
                stringBuffer.append("[").append(String.format("%7.6g", dArray[i])).append("-").append(String.format("%7.6g", dArray[i + 1])).append("]");
                if (i >= dArray.length - 1) continue;
                stringBuffer.append(", ");
            }
            if (bl && bl2) {
                stringBuffer.append(" (inclusive)");
            } else if (bl && !bl2) {
                stringBuffer.append(" (lower bounds included, upper bounds not included)");
            } else if (!bl && bl2) {
                stringBuffer.append(" (lower bounds not included, upper bounds included)");
            } else {
                stringBuffer.append(" (not inclusive)");
            }
            throw new OutOfRangeException(stringBuffer.toString());
        }
        return d;
    }

    public static double parseDouble(Object object, double ... dArray) throws OutOfRangeException, NumberFormatException {
        return DoubleVerifier.parseDouble(object, true, true, dArray);
    }
}

