/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.guiutil.mvc.widgets;

import alma.obsprep.guiutil.mvc.View;
import alma.obsprep.ot.models.sciencegoals.UISelectableEnumerationInterface;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class OTButtonGroup
extends JPanel {
    private ButtonGroup buttonGroup = null;
    private Box box = null;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;

    public OTButtonGroup(String[] stringArray, int n, String[] stringArray2) {
        super(new BorderLayout());
        this.buttonGroup = new ButtonGroup();
        if (n == 0) {
            this.box = Box.createHorizontalBox();
        } else if (n == 1) {
            this.box = Box.createVerticalBox();
        } else {
            throw new IllegalArgumentException("Invalid layout " + n);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            JRadioButton jRadioButton = new JRadioButton(stringArray[i]);
            jRadioButton.setFocusPainted(false);
            if (stringArray2 != null) {
                jRadioButton.setToolTipText(stringArray2[i]);
            }
            jRadioButton.setActionCommand(stringArray[i]);
            this.buttonGroup.add(jRadioButton);
            this.box.add(jRadioButton);
        }
        this.add(this.box);
    }

    public OTButtonGroup(String[] stringArray, int n) {
        this(stringArray, n, (String[])null);
    }

    public OTButtonGroup(String[] stringArray) {
        this(stringArray, 0, (String[])null);
    }

    public OTButtonGroup(String[] stringArray, int n, int n2) {
        int n3 = n;
        this.buttonGroup = new ButtonGroup();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        n3 = this.getBestGridColumnSize(stringArray.length, n);
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 1; i <= stringArray.length; ++i) {
                String string = "<html><body width=\"" + Integer.toString(n2) + "\">" + stringArray[i - 1] + "</body></html>";
                JRadioButton jRadioButton = new JRadioButton(string);
                jRadioButton.setFocusPainted(false);
                jRadioButton.setActionCommand(stringArray[i - 1]);
                this.buttonGroup.add(jRadioButton);
                this.add((Component)jRadioButton, gridBagConstraints);
                if (i % n3 == 0) {
                    ++gridBagConstraints.gridy;
                    gridBagConstraints.gridx = 0;
                    continue;
                }
                ++gridBagConstraints.gridx;
            }
        }
    }

    public <T extends Enum<T>> OTButtonGroup(T[] TArray, int n, String[] stringArray) {
        super(new BorderLayout());
        this.buttonGroup = new ButtonGroup();
        if (n == 0) {
            this.box = Box.createHorizontalBox();
        } else if (n == 1) {
            this.box = Box.createVerticalBox();
        } else {
            throw new IllegalArgumentException("Invalid layout " + n);
        }
        for (int i = 0; i < TArray.length; ++i) {
            String string = ((UISelectableEnumerationInterface)TArray[i]).getUILabel();
            if (string == null) {
                string = ((UISelectableEnumerationInterface)TArray[i]).getBOMapping();
            }
            if (string == null) {
                throw new IllegalArgumentException();
            }
            JRadioButton jRadioButton = new JRadioButton(string);
            if (stringArray != null) {
                jRadioButton.setToolTipText(stringArray[i]);
            }
            jRadioButton.setFocusPainted(false);
            jRadioButton.setActionCommand(string);
            jRadioButton.putClientProperty(View.BO_MAPPING_CLIENT_PROPERTY, ((UISelectableEnumerationInterface)TArray[i]).getBOMapping());
            jRadioButton.putClientProperty("UIMapping", ((UISelectableEnumerationInterface)TArray[i]).getUILabel());
            this.buttonGroup.add(jRadioButton);
            this.box.add(jRadioButton);
        }
        this.add(this.box);
    }

    private int getBestGridColumnSize(int n, int n2) {
        int[] nArray = new int[]{0, 0, 0};
        int[][] nArray2 = new int[n2][3];
        int n3 = n2;
        int n4 = 0;
        while (n3 > 0) {
            int n5 = n3;
            int n6 = n % n5;
            int n7 = n / n5 + (n6 > 0 ? 1 : 0);
            int n8 = n6 == 0 ? n5 : n6;
            nArray2[n4][0] = n5;
            nArray2[n4][1] = n7;
            nArray2[n4][2] = n8;
            --n3;
            ++n4;
        }
        nArray[0] = n2;
        nArray[1] = n / n2 + (n % n2 > 0 ? 1 : 0);
        nArray[2] = n % n2;
        for (n3 = 0; n3 < n2; ++n3) {
            if (nArray2[n3][1] > nArray[1] || nArray2[n3][2] <= nArray[2]) continue;
            nArray[0] = nArray2[n3][0];
            nArray[1] = nArray2[n3][1];
            nArray[2] = nArray2[n3][2];
        }
        return nArray[0];
    }

    public void add(JRadioButton jRadioButton) {
        jRadioButton.setActionCommand(jRadioButton.getText());
        this.box.add(jRadioButton);
        this.buttonGroup.add(jRadioButton);
    }

    public void addActionListener(ActionListener actionListener) {
        Enumeration<AbstractButton> enumeration = this.buttonGroup.getElements();
        while (enumeration.hasMoreElements()) {
            JRadioButton jRadioButton = (JRadioButton)enumeration.nextElement();
            jRadioButton.addActionListener(actionListener);
        }
    }

    public void removeActionListener(ActionListener actionListener) {
        Enumeration<AbstractButton> enumeration = this.buttonGroup.getElements();
        while (enumeration.hasMoreElements()) {
            JRadioButton jRadioButton = (JRadioButton)enumeration.nextElement();
            jRadioButton.removeActionListener(actionListener);
        }
    }

    public JRadioButton find(String string) {
        Enumeration<AbstractButton> enumeration = this.buttonGroup.getElements();
        while (enumeration.hasMoreElements()) {
            JRadioButton jRadioButton = (JRadioButton)enumeration.nextElement();
            if (!jRadioButton.getActionCommand().equals(string)) continue;
            return jRadioButton;
        }
        return null;
    }

    public JRadioButton findButtonWithBOMapping(String string) {
        Enumeration<AbstractButton> enumeration = this.buttonGroup.getElements();
        while (enumeration.hasMoreElements()) {
            JRadioButton jRadioButton = (JRadioButton)enumeration.nextElement();
            String string2 = (String)jRadioButton.getClientProperty(View.BO_MAPPING_CLIENT_PROPERTY);
            if (string2 == null || !string2.equals(string)) continue;
            return jRadioButton;
        }
        return null;
    }

    public void setSelectedItem(String string) {
        JRadioButton jRadioButton = this.find(string);
        if (jRadioButton == null) {
            throw new IllegalArgumentException("not found: " + string);
        }
        jRadioButton.setSelected(true);
    }

    public boolean setButtonName(String string, String string2) {
        JRadioButton jRadioButton = this.find(string);
        if (jRadioButton == null) {
            return false;
        }
        jRadioButton.setName(string2);
        return true;
    }

    @Override
    public void setEnabled(boolean bl) {
        Enumeration<AbstractButton> enumeration = this.buttonGroup.getElements();
        while (enumeration.hasMoreElements()) {
            JRadioButton jRadioButton = (JRadioButton)enumeration.nextElement();
            jRadioButton.setEnabled(bl);
        }
    }

    @Override
    public void setFocusable(boolean bl) {
        Enumeration<AbstractButton> enumeration = this.buttonGroup.getElements();
        while (enumeration.hasMoreElements()) {
            JRadioButton jRadioButton = (JRadioButton)enumeration.nextElement();
            jRadioButton.setFocusable(bl);
        }
    }

    public String[] getAllItems() {
        String[] stringArray = new String[this.buttonGroup.getButtonCount()];
        Enumeration<AbstractButton> enumeration = this.buttonGroup.getElements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            JRadioButton jRadioButton = (JRadioButton)enumeration.nextElement();
            stringArray[n++] = jRadioButton.getActionCommand();
        }
        return stringArray;
    }

    public String getSelectedItem() {
        ButtonModel buttonModel = this.buttonGroup.getSelection();
        if (buttonModel == null) {
            throw new IllegalStateException("no selected buttons");
        }
        String string = buttonModel.getActionCommand();
        return string;
    }

    public void clearSelection() {
        this.buttonGroup.clearSelection();
    }

    @Override
    public void setForeground(Color color) {
        if (this.buttonGroup == null) {
            return;
        }
        Enumeration<AbstractButton> enumeration = this.buttonGroup.getElements();
        while (enumeration.hasMoreElements()) {
            JRadioButton jRadioButton = (JRadioButton)enumeration.nextElement();
            jRadioButton.setForeground(color);
        }
    }

    @Override
    public void setToolTipText(String string) {
        Enumeration<AbstractButton> enumeration = this.buttonGroup.getElements();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement().setToolTipText(string);
        }
    }

    public void setToolTipText(String[] stringArray) {
        if (stringArray == null || stringArray.length != this.buttonGroup.getButtonCount()) {
            throw new IllegalArgumentException("Number of tooltips must match number of buttons!");
        }
        Enumeration<AbstractButton> enumeration = this.buttonGroup.getElements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement().setToolTipText(stringArray[n++]);
        }
    }

    public ButtonGroup getButtonGroup() {
        return this.buttonGroup;
    }
}

